/*
 * Distributed V Kernel - Copyright (c) 1981 by David Cheriton.
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Inter-process communication primitives
 * Send, Receive, Reply, Forward, ReceiveSpecific.
 * The internal routines are called KSend, KReceive, etc.
 *
 */
/* #define DEBUG 1 */
/* #define GROUP_DEBUG 1 */
/* #define DEBUG_CHECK 1 */

#include <Vcopy.h>
#include "process.h"
#include "groupipc.h"
#include "ipc.h"
#include "ikc.h"

extern Process *Active, *MapToPd(), *FindSender(), *Alienate();
extern SyncQueue Delayq;
extern Process *FindSuspendPd();
extern ProcessId KernelServerPid;

int CheckFrozenSender();

#define KERNEL_SERVER_ID 	(LOCAL_KERNEL_PROCESS_PID & ~GROUP_ID_BIT)
#define KERNEL_SERVER_MASK 	(GROUP_ID_BIT | 0xffff)

ProcessId KSend( pd )
    register Process *pd;
  /*
   * Send a message to the process specified by pd->blocked_on.
   */
  {
    register Process *receiver;
    register MsgStruct *msg = &pd->msg;
#ifdef DEBUG
register int *i = (int *)&pd->msg;

if ((pd->blocked_on & 0xffff) == 0x4001) {
char s[2];
s[1] = 0;
s[0] = i[2]&0xff;
printx("%s", s);
}
else {
printx("KSend(%x) -> %x: %x %x %x %x %x %x %x %x\n",
pd->pid, pd->blocked_on, i[0], i[1], i[2], i[3], i[4], i[5], i[6], i[7]);
}
#endif
    pd->state = AWAITING_REPLY;
    /* Start a new message transaction unless message was forwarded.
     * First: increment segNo and oldSeqNo to indicate new transaction.
     * Then dequeue all old reply messages.
     * Finally, set the segment access permissions granted by the sender
     * from the message contents.
     */
    if ( pd->forwarder == pd->pid )
      {
	pd->seqNo = ++pd->oldSeqNo; /* oldSeqNo is now the generator. */

	/* Release all queued reply messages. */
	if( pd->replyq.head != NULL ) FreeReplyBuffers( pd );

        /* Check if there is segment associated with this message */
        if ( msg->sysCode & SEGMENT_PRESENT ) /* READ or WRITE bit on. */
          {
            pd->dataSegmentPro = (unsigned char)((msg->sysCode)>>8);
            pd->dataSegmentPtr = (Unspec *) msg->segmentPtr;
            pd->dataSegmentSize = msg->segmentSize;
	    /* Indicate no copy in progress. */
	    if(SegOutsideTeamSpace(pd,pd->dataSegmentPtr,pd->dataSegmentSize))
	      {
	        msg->sysCode = BAD_ADDRESS;
	        pd->blocked_on = 0;
	        Addready( pd );
	        return;
	      }
          }
        else
          {
            pd->dataSegmentSize = 0;
          }
      }
    /* Set segmentSize and Ptr to indicate segment portion to append.
     * Note: the following uses the message contents rather than the
     * dataSegmentPtr and dataSegmentSize so it will work as a result
     * of forwarding the process as well as the normal send.  
     */
    if( (msg->sysCode&READ_BIT) && (msg->segmentSize != 0 ) )
      {
	pd->segmentPtr = (Unspec *) msg->segmentPtr;
	pd->segmentSize = min(msg->segmentSize,MAX_APPENDED_SEGMENT);
      }
    else
      {
	pd->segmentSize = 0;
      }

    /* Free any local aliens that aren't replies or datagrams. */
    if ( pd->pdFlags & LOCAL_ALIENS_PRESENT )
      {
	ScavengeAliens( pd->pid );
	pd->pdFlags &= ~LOCAL_ALIENS_PRESENT;
      }

    if( !MAP_TO_RPD(receiver, pd->blocked_on) )
      {
/*	if (((pd->blocked_on & (~LOGICAL_HOST_PART)) == LKERNEL_SERVER_GROUP)
	    &&
            ((PidLhn(pd->blocked_on) == 0) || Local(pd->blocked_on)))
	  {
	    pd->blocked_on = KernelServerPid;
	    MAP_TO_RPD(receiver, pd->blocked_on);
	  }
	else
	  {*/
	    /* Send to device server is moved to NonLocalSend */
	    /* for convenience of message-register stuff. */
	    /* Note: group ids are considered to be non-local. */
	    NonLocalSend( pd );
	    return;
/*	  }*/
      }
/*    if( (pd->userNumber != receiver->userNumber) &&
	(receiver->userNumber != SYSTEM_USER) )
      {
	msg->sysCode = NO_PERMISSION;
 	pd->blocked_on = 0;
	Addready( pd );
	return;
      }
*/
    DeliverMsg( receiver, pd );
  }

DeferDelivery( sender, receiver )
register Process *sender, *receiver;
  {
    register Process *tmppd;
    register SystemCode code = sender->msg.sysCode;

    /* We have attepmted to deliver a message that is a datagram and/or
     * conditional to a process that isn't currently receive blocked.
     */
    if (code & COND_DELIVERY_BIT)
      {
	/* This is a conditional delivery, and the receiver isn't ready. */
	if (code & DATAGRAM_SEND_BIT)
	  {
	    /* Datagrams just don't get through */
	    if( AlienProcess(sender) ) FreeAlien( sender );
	    else
		Addready( sender );
	    return;
	  }

	/* Not a datagram, so either send a nAck or ready the process. */
	sender->msg.sysCode = MSG_NOT_DELIVERED;
	if( AlienProcess(sender) )
	  {
	    if ( IsGroupId(sender->forwarder) )
		FreeAlien( sender );
	    else
		SendnAck( sender );
	  }
	else
	  {
	    ReturnPid(sender,0);
	    Addready( sender );
	  }
	return;
      }

    /* This is a datagram, but the receiver isn't waiting. */
    if ( !AlienProcess(sender) )
      {
	tmppd = Alienate(&sender->packetType);
	Addready( sender );		/* The sender doesn't block */
	if (tmppd == NULL) return;	/* If no aliens are available, leave */
	sender = tmppd;
      }
    EnqueueMsg( sender, receiver, tmppd );
  }

DeliverMsg( receiver, pd )
    register Process *receiver, *pd;
  /* Deliver the message in pd->msg to the specified receiver. */
  /* This is also called by the group ipc code. */
  {
    ProcessId KReceiveSpecific();
    register Process *prev;
    Team *oldteam;

    pd->link = NULL;
    /* Look for receiver in Delay queue and receive-blked, then remove */
    Lockq( &Delayq );
    if( (receiver->state != RECEIVE_BLKED) || 
        (receiver->queuePtr != &Delayq) ||
	(receiver->pdFlags & FROZEN) )
      {
depart:
	Unlockq( &Delayq );
	if( pd->msg.sysCode & (COND_DELIVERY_BIT|DATAGRAM_SEND_BIT) )
	    DeferDelivery( pd, receiver );
	else
	    EnqueueMsg( pd, receiver, prev );
	return;
      }
    prev = (Process *) &Delayq;
    while( prev->link != receiver )
      {
	prev = prev->link;
#ifdef DEBUG_CHECK
	if( prev == NULL )
	  {
	    printx("DeliverMsg: receiver not in delay queue!\n" );
	    goto depart;
	  }
#endif
      }
    /* Found receiver in delayq; now unlink. */
    if( (prev->link=receiver->link) != NULL ) /* Unlink from Delayq */
	prev->link->timeout_count += receiver->timeout_count;
    receiver->queuePtr = NULL;
    Unlockq( &Delayq );

    /* Can we deliver this message immediately ?
     * We can if:
     *    (a) we'll accept any message and none are in the unreceived queue;
     * or (b) we're waiting for a message from this process;
     * or (c) we're waiting for a message from this group.
     *
     * We miss the case where a message from a group is already on the
     * receiver's message queue. Oh well.
     */
    if ( !( ((receiver->blocked_on == 0) && (receiver->next_sender == NULL)) ||
    	    ( receiver->blocked_on == pd->pid ) ||
	    ( IsGroupId(receiver->blocked_on) &&
	      (receiver->forwarder == pd->blocked_on)) ))
      {
	/* We can't read this message right now. For efficiency ready
	 * processes that sent datagrams before re-blocking the receiver.
	 */
	if (pd->msg.sysCode & (DATAGRAM_SEND_BIT|COND_DELIVERY_BIT))
	    DeferDelivery( pd, receiver );
	else
	    EnqueueMsg( pd, receiver,prev );

	/* Reset receiver. This may cause a message to be read. */
	KReceiveSpecific( receiver );
	return;
      }

    /* Deliver the message and associated segment, if any */
    
    Copy_msg( &receiver->msg, &pd->msg );

    receiver->dataSegmentSize = min(pd->segmentSize,receiver->dataSegmentSize);
    if( receiver->dataSegmentSize != 0 )
      {
        /* Cause receiver to copy from our segment */
        receiver->remoteSegmentPtr = pd->segmentPtr;
        CopyFromSegment( receiver, pd );
      }
      
    ReturnPid( receiver, pd->pid );
    ReturnSegmentSize( receiver, receiver->dataSegmentSize );

    /* Store the sending pd at the head of the receiver's msgq. Discard
     * datagrams (which can't be replied to).
     */
    if( pd->msg.sysCode & DATAGRAM_SEND_BIT )
      {
#ifdef DEBUG
        printx("Discarding datagram from %x\n", pd->pid );
#endif
         if( AlienProcess( pd ) ) FreeAlien( pd ); else Addready( pd );
      }
    else
      {
        EnqueueMsgAtFront(pd, receiver);
      }

    Addready( receiver );
  }

ProcessId KReceiveSpecific( pd )
    register Process *pd;
  /* 
   * Receive a message from the process specified by
   * pd->blocked_on.
   * Note: this is executed as its own finish-up function to check
   * if message has been received, and to offload the DeliverMsg routine.
   */
  {
    register ProcessId pid;
    register short msg_flag;
    register Process *sender, *prev;
    Team *oldteam;

    pid = pd->blocked_on;

    if (pd->pdFlags & FROZEN)
      {
	goto KRS_block;
      }

    if ((pd->dataSegmentSize != 0) && BadUserPtr(pd->dataSegmentPtr))
      {
	ReturnPid( pd, 0 );
	Addready( pd );
	return(0);
      }

    /* Search the processes msgq for an unreceived message from the
     * pid that we are waiting to hear from. The pd representing the
     * new message becomes the head of the receiver's msgq.
     */
    Lockq( &(pd->msgq) );
    prev = NULL;
    if ( (sender = pd->next_sender) == NULL) goto KRS_NotFound;
    
    if ( pid != 0 )	/* If we'll accept anything take the next_sender */
        if ( IsGroupId( pid ) )
	    while ( sender->forwarder != pid )
	      {
		prev = sender;
		sender = sender->link;
		if ( sender == NULL ) goto KRS_NotFound;
  	      }
	else
	    while ( sender->pid != pid )
	      {
		prev = sender;
		sender = sender->link;
		if ( sender == NULL ) goto KRS_NotFound;
              }

    /* Receive the message */
    Copy_msg( &pd->msg, &sender->msg );
    ReturnPid( pd, sender->pid );
    ReturnSegmentSize( pd, 0 );

    /* Adjust the receiver's msgq:
     * 	Semantics insure that if this is a datagram, than the sender is
     *  a (possibly local) alien. In order to link around the alien pd
     *	we may have to retraverse the queue to find the previous list
     *	entry.
     *	For normal sends we want to make sure that the pd is after the
     *	next_sender ptr. We either advance the pointer (if the sender
     *	is the next_sender) or we link around the pd and move it to the
     *	head of the msgq.
     */
    if (sender->msg.sysCode & DATAGRAM_SEND_BIT)
      {
	if ( prev == NULL )
	  { /* Because sender is the next_sender, we have to set prev here. */
	    pd->next_sender = sender->link;
	    prev = (Process *) &pd->msgq.head;
	    while (prev->link != sender) prev = prev->link;
	  }
	prev->link = sender->link;	/* Link around sender*/
	if (sender->link == NULL)  pd->msgq.tail = prev;
	sender->link = NULL;
	sender->queuePtr = NULL;
	FreeAlien(sender);
      }
    else if ( prev == NULL ) /* sender is the next_sender */
	pd->next_sender = sender->link;
    else
      {
        /* Link around sender, then put sender at the head of the msgq */
	if ((prev->link = sender->link) == NULL ) pd->msgq.tail = prev;
	sender->link = pd->msgq.head;
	pd->msgq.head = sender;
      }

    Unlockq( &(pd->msgq) );

    Addready( pd );
    return;

KRS_NotFound:
    /* An appropriate message was not found on our msgq. Make sure that
     * the pid that we are blocked on is valid, then block for a while.
     * If we are waiting for a group send make sure that there are valid
     * group members.
     */
    Unlockq( &(pd->msgq) );
     
    if ( pid == 0 ) goto KRS_block;
    
    if ( Local( pid ) )
      {
	if ( MAP_TO_RPD(sender, pid) )
	    goto KRS_block;
	else
	    goto KRS_nonexistent;
      }
    
    if ( IsGroupId( pid ) )
      {
	/* Blocked on a group */
	if ( GetGroupMember(pid, 0) ) goto KRS_block;
        if ( LocalGroup( pid ) ) goto KRS_nonexistent;
      }

    /* We are either blocked on a remote process or on a group that has
     * no local members. See if the pid is valid somewhere in the V-domain.
     */
    pd->state = RECEIVE_BLKED;
    pd->seqNo = ++pd->oldSeqNo;	/* New transaction # for probe/breathOfLife */
    NonLocalReceiveSpecific( pd );
    return( pid );
	
KRS_nonexistent:
    ReturnPid( pd, 0 );
    pd->msg.sysCode = NONEXISTENT_PROCESS;
    Addready( pd );
    return( 0 );
     
KRS_block:
    /* Check periodically for messages. This may be preemtped by DeliverMsg */
    pd->state = RECEIVE_BLKED;
    pd->timeout_func = (Unspec (*)()) KReceiveSpecific;
    pd->timeout_count = CLICKS_PER_SEC/4; /* Fix - drc */
    DelayProcess( pd );
    return;
  }

ProcessId KReply( active )
   register Process *active;
  /*
   * Return a reply message and a segment to the specified process.
   */
  {
    register Process *sender, *prev;
    
    Lockq( &(active->msgq) );
    prev = (Process *) &(active->msgq.head);
    while( ((sender = prev->link) != active->next_sender) )
      {
	if( sender->pid == active->blocked_on ) goto handle_reply;
	prev = sender;
      }

    Unlockq( &(active->msgq) );
    ReturnPid( active, 0 );
    Addready( active );
    return; /* Sender not found */
handle_reply:
    if( (prev->link = sender->link) == NULL ) active->msgq.tail = prev;
    Unlockq( &(active->msgq) );
    sender->queuePtr = NULL;
    sender->link = NULL;

/*
    if( active->msg.sysCode & ANONYMOUS_REPLY_BIT )
	sender->blocked_on = sender->forwarder;
*/
    if( active->msg.sysCode & REPLY_SEGMENT_BIT )
      {
	active->segmentSize = active->msg.segmentSize;
	active->remoteSegmentPtr = (Unspec *) active->msg.segmentPtr;	
	active->msg.sysCode &= ~REPLY_SEGMENT_BIT;
      }
    else
	active->segmentSize = 0;
    ReturnPid( active, active->blocked_on );

    if( AlienProcess(sender) || (sender->pdFlags & FROZEN) )
      {
	/* Replies to a group send get handled as a nonlocal reply.
	   Ditto for replies to suspended processes (that must therefore be
	   queued). */
	NonLocalReplyWithSegment( sender, active );
	return( active->blocked_on );
      }
    active->msg.sysCode &= ~IMMEDIATE_REPLY_BIT;
    Copy_msg( &sender->msg, &active->msg );
    if( active->segmentSize != 0 )
     {
	/* This restriction will be removed with redesign of IPC */
	if( (active->segmentSize > MAX_APPENDED_SEGMENT) ||
		(CopyToSegment(active, sender) != OK) )
	  {
	    sender->msg.sysCode = BAD_REPLY_SEGMENT;
	  }
      }

    ReturnPid( sender, active->pid );
    ReturnSegmentSize( sender, active->segmentSize );
    Addready( sender );
    Addready( active );
    return( active->blocked_on );
  }

ProcessId KGetReply( active )
    register Process *active;
  /* Get a reply to a message, normally the second or further
   * replies to a group send.
   * Input parameters: active->returnMessage, active->timeout_count
   * At this point, this does not handle segments.
   */
  {
    register Process *replierpd, *p;

#ifdef undef
What does this do ? When is it used ?
    if (active->blocked_on == 0) /* Cheap form of delaying */
	{ReturnPid(active, 0);DelayProcess(active); return;}
#endif

    Lockq( &(active->replyq) );
    if( ( (replierpd = active->replyq.head) == NULL ) ||
	( replierpd->state == 0 ) ) /* No reply waiting. */
      {
#ifdef GROUP_DEBUG
	printx("GetReply: no replies: wait %d clicks\n", active->timeout_count );
#endif
	active->state = AWAITING_REPLY;
	Unlockq( &(active->replyq) );
	if( active->timeout_count == 0 )
	  {
	    Addready( active );
	    ReturnPid( active, 0 ); /* Return zero if we time out */
	    return;
	  }
	ReturnPid( active, 0 ); /* Return zero if we time out */
	active->timeout_func = (Unspec (*)()) Addready;
	DelayProcess( active );
	return; /* Not used. */
      }
    replierpd->state = 0;
    if ( ( (p = replierpd->link) != NULL ) && (p->state != 0) )
        {
	    active->replyq.head = p;
	    active->replyq.tail->link = replierpd;
	    active->replyq.tail = replierpd;
	    replierpd->link = NULL;
	}
    Unlockq( &(active->replyq) );
#ifdef GROUP_DEBUG
    printx("GetReply: return message from %x\n", active->blocked_on );
#endif
    Copy_msg( &active->msg, &replierpd->msg );
    ReturnPid( active, replierpd->pid );
    Addready( active );
    return;
  }

ProcessId KForward( pd )
   register Process *pd;
    /* Cause pd to forward the process specified by pd->blocked_on
     * to the process specified by pd->forwarder with message
     * pd->msg providing the former is awaiting reply from pd.
     */
  {
    register Process *sender, *prev;
    register MsgStruct *msg;

    Lockq( &(pd->msgq) );
    prev = (Process *) &(pd->msgq.head);
    while( (sender=prev->link) != pd->next_sender )
      {
	if( sender->pid == pd->blocked_on ) goto handle_forward;
	prev = sender;
      }
    Unlockq( &(pd->msgq) );
    pd->msg.sysCode = NOT_AWAITINGREPLY;
    Addready( pd );
    ReturnPid( pd, 0 );
    return( 0 ); /* Sender not found */
handle_forward:
    if( (prev->link = sender->link) == NULL )
	pd->msgq.tail = prev;
    Unlockq( &(pd->msgq) );
    sender->queuePtr = NULL;
    Copy_msg( &sender->msg, &pd->msg );
    if( AlienProcess(sender) )
      {
	sender->forwarder = pd->forwarder; /* Used as a "forwarded to" field. */
	Addready( pd );
	ReturnPid( pd, pd->forwarder );
	return( NonLocalForward(sender) );
      }
    msg = &sender->msg;
    if(  msg->sysCode & SEGMENT_PRESENT )
      {
	register unsigned diff;
	register unsigned char segProtect;

	segProtect = (unsigned char)((msg->sysCode&SEGMENT_PRESENT)>>8);
	diff = ((unsigned)msg->segmentPtr) - (unsigned)sender->dataSegmentPtr;

	if( ((segProtect|sender->dataSegmentPro) != sender->dataSegmentPro) ||
	   ((unsigned) msg->segmentPtr < (unsigned) sender->dataSegmentPtr) ||
	   ((unsigned) msg->segmentPtr >
		(unsigned)sender->dataSegmentPtr + sender->dataSegmentSize) ||
		(msg->segmentSize > sender->dataSegmentSize - diff ) )
          {
	    msg->sysCode = BAD_FORWARD;
	    Addready( sender );
	    Addready( pd );
	    ReturnPid( pd, 0 );
	    return( 0 );
	  }
      }
    if (sender->pdFlags & MSG_FLAG) ReturnPid(sender, pd->forwarder);
    sender->forwarder =  sender->blocked_on;
    sender->blocked_on = pd->forwarder;
    sender->seqNo = sender->oldSeqNo;
    /* Forward by executing KSend on this process. */
    KSend( sender );
    Addready( pd );
    ReturnPid( pd, pd->forwarder );
    return( pd->forwarder );
  }

SystemCode KCopyTo( requestor, dest_pid, dest, src, bytes )
    register Process *requestor;
    ProcessId dest_pid; 
    register Unspec *dest;
    register Unspec *src;
    unsigned bytes;
  /* Copy bytes bytes from src in the requestor process's space to
   * dest in the space of dest_pid, providing it is awaiting reply
   * from the requestor process.
   */
  {
    register Process *pd, *alien;
    register SystemCode r;

    if( SegOutsideTeamSpace(requestor, src, bytes) )
      {
	Addready( requestor );
	return( BAD_BUFFER );
      }

    requestor->blocked_on = dest_pid;
    requestor->dataSegmentPtr = src; /* Access to address space. */
    requestor->dataSegmentSize = bytes;
    requestor->dataSegmentPro = READ_ACCESS;
    requestor->remoteSegmentPtr = dest;
    /* Set up parameters for copy processing */
    requestor->segmentPtr = src;
    requestor->segmentSize = bytes;

    if( !MAP_TO_RPD(pd, dest_pid) ) 
      {
        return( NonLocalCopyTo(requestor) );
      }
    if ((pd->pdFlags & SUSPEND_FLAG) &&
        (pd->blocked_on != requestor->pid))
      {
	pd = FindSuspendPd(dest_pid);
      }
    if (pd->pdFlags & FROZEN)	/* NOTE: we don't allow copy-to's by the
				   team owner under any circumstances since
				   that will change the l.host state.  
				   We DO allow copy-from's.  That's necessary 
				   to implement the final copy stage of 
				   migration. */
      {
	/* Trying to copy to a suspended process.  Defer. */
	requestor->state = MOVETO_BLKED;
	requestor->timeout_func = (Unspec (*)()) CheckFrozenSender;
	requestor->timeout_count = FROZEN_SENDER_CHECK_PERIOD;
	DelayProcess(requestor);
	return;
      }

    r = OK;
    if ( pd->team->owner != requestor->pid )
      {
	if ( pd->blocked_on == requestor->pid )
	  {
	    if ( pd->state != AWAITING_REPLY ) r = NOT_AWAITINGREPLY;
	  }
	else if ( !IsGroupId( pd->blocked_on ) ||
	          ( ( alien = FindSender( requestor, pd->pid ) ) == NULL ) ||
	          ( pd->blocked_on != alien->forwarder ) ) r = NO_PERMISSION;
      }
    if ( r == OK ) r = CopyToSegment( requestor, pd );
    Addready( requestor );
    return( r );
  }

doCopyTo( pd )
register Process *pd;
  {
    register CopyReq *req = (CopyReq *) &pd->msg;
    register SystemCode r;

    r = KCopyTo(pd,req->remotePid,req->remoteAddr,req->localAddr,req->bytes);
    if (r != NO_REPLY)
	req->sysCode = r;
    else
	req->sysCode = OK;	/* Assume that it will work */
    return( NO_REPLY );		/* We, not the KS, will deal with this */
  }

SystemCode CopyTo( src_pid, dest, src, bytes ) 
    ProcessId src_pid; 
    register Unspec *dest, *src;
    unsigned bytes;
  {
    return( KCopyTo( Active, src_pid, dest, src, bytes ) );
  }

SystemCode KCopyFrom( requestor, src_pid, dest, src, bytes ) 
    register Process *requestor;
    ProcessId src_pid; 
    register Unspec *dest, *src;
    unsigned bytes;
  /* Copy bytes bytes from src in the src_pid process's space to
   * dest in the space of requestor process, providing src_pid is awaiting reply
   * from the requestor process.
   */
  {
    register Process *pd;
    register SystemCode r;
    Process *alien;

    if( SegOutsideTeamSpace(requestor, dest, bytes) )
      {
	Addready( requestor );
	return( BAD_BUFFER );
      }
    requestor->blocked_on = src_pid;
    requestor->dataSegmentPtr = (Unspec *) dest;
    requestor->dataSegmentSize = bytes;
    requestor->dataSegmentPro = WRITE_ACCESS;
    requestor->remoteSegmentPtr = (Unspec *) src;

    if( !MAP_TO_RPD(pd, src_pid) ) return( NonLocalCopyFrom(requestor) );
    if ((pd->pdFlags & SUSPEND_FLAG) &&
        (pd->blocked_on != requestor->pid))
      {
	pd = FindSuspendPd(src_pid);
      }
    if ((pd->pdFlags & FROZEN) && (pd->team->owner != requestor->pid))
      {
	/* Trying to copy from a suspended process.  Defer. */
	requestor->state = MOVEFROM_BLKED;
	requestor->timeout_func = (Unspec (*)()) CheckFrozenSender;
	requestor->timeout_count = FROZEN_SENDER_CHECK_PERIOD;
	DelayProcess(requestor);
	return;
      }

    r = OK;
    if ( pd->team->owner != requestor->pid )
      {
	if ( pd->blocked_on == requestor->pid )
	  {
	    if ( pd->state != AWAITING_REPLY ) r = NOT_AWAITINGREPLY;
	  }
	else if ( !IsGroupId( pd->blocked_on ) ||
	          ( ( alien = FindSender( requestor, pd->pid ) ) == NULL ) ||
	          ( pd->blocked_on != alien->forwarder ) ) r = NO_PERMISSION;
      }
    if ( r == OK ) r = CopyFromSegment( requestor, pd );
    Addready( requestor );
    return( r );
  }

doCopyFrom( pd )
register Process *pd;
  {
    register CopyReq *req = (CopyReq *) &pd->msg;
    register SystemCode r;
    

    r = KCopyFrom(pd,req->remotePid,req->localAddr,req->remoteAddr,req->bytes);
    if (r != NO_REPLY)
	req->sysCode = r;
    else
	req->sysCode = OK;	/* Assume that it will work */
    return( NO_REPLY );		/* We, not the KS, will deal with this */
  }

SystemCode CopyFrom( src_pid, dest, src, bytes ) 
    ProcessId src_pid; 
    register Unspec *dest, *src;
    unsigned bytes;
  {
    return( KCopyFrom( Active, src_pid, dest, src, bytes ) );
  }

/* The next two routines copy segments about.  They are subtly dependent
 * on the memory mapping hardware used and really should be elsewhere.
 */

CopyFromSegment( copier, copiee )  register Process *copier, *copiee;

    /* Copy from the address space of copiee starting at
     * copier->remoteSegmentPtr to copier->dataSegmentPtr,
     * copier->dataSegmentSize bytes, providing
     * this fits into the segment specified by copiee->dataSegmentPtr
     * and copiee->dataSegmentSize and copiee->dataSegmentPro provides
     * read access.
     * It is assumed that copiee has been  checked to be awaiting reply or
     * that copier is the team owner of copiee.
     */
  {
    register Unspec *src;
    register Unspec *dest;
    register unsigned bytes;
    Team *oldteam;

    src = copier->remoteSegmentPtr;
    dest = copier->dataSegmentPtr;
    bytes = copier->dataSegmentSize;

     if( AlienProcess(copiee) && !Local(copiee->pid) )
      {
	/* Read the appended segment form the ethernet interface */
	oldteam = GetAddressableTeam();
	SetAddressableTeam(copier->team);
	ReadDataPacket( copier, copiee->remoteSegmentPtr );
	SetAddressableTeam(oldteam);
	return( OK );
      }

    if (copiee->team->owner == copier->pid)
      {
	if (SegOutsideTeamSpace(copiee, src, bytes))
	  {
	    return(BAD_ADDRESS);
	  }
      }
    else
      {
	if( ((copiee->dataSegmentPro & READ_ACCESS) == 0) )
	  {
	    return( NOT_READABLE );
	  }
    
	if( (unsigned)src < (unsigned)copiee->dataSegmentPtr ||
	    (unsigned)src+bytes >
		(unsigned)copiee->dataSegmentPtr + copiee->dataSegmentSize ||
	    (unsigned)src+bytes < (unsigned)src )
	  {
	    return( NO_PERMISSION );
	  }
      }

    if( copiee->team == copier->team ) /* Straight copy */
      {
	oldteam = GetAddressableTeam();
	SetAddressableTeam(copier->team);
        Copy( dest, src , bytes );
        SetAddressableTeam(oldteam);
      }
    else  /* Inter-team copy */
      {
        InterTeamCopy(dest,copier->team, src,copiee->team, bytes);
      }

    return( OK );
  }

CopyToSegment( copier, copiee )  register Process *copier, *copiee;

    /* Copy to the address space of copiee starting at
     * copier->remoteSegmentPtr from copier->segmentPtr,
     * copier->segmentSize bytes, providing
     * this fits into the segment specified by copiee->dataSegmentPtr
     * and copiee->dataSegmentSize and copiee->dataSegmentPro provides
     * write access.
     * It is assumed that copiee has been checked to be awaiting reply or
     * that copier is the team owner of copiee.
     */
  {
    register Unspec *src;
    register Unspec *dest;
    register unsigned bytes;
    Team *oldteam;

    dest = copier->remoteSegmentPtr;
    src = copier->segmentPtr;
    bytes = copier->segmentSize;

    if (copiee->team->owner == copier->pid)
      {
	if (SegOutsideTeamSpace(copiee, dest, bytes))
	  {
	    return(BAD_ADDRESS);
	  }
      }
    else
      {
	if( ((copiee->dataSegmentPro & WRITE_ACCESS) == 0) )
	    return( NOT_WRITEABLE );
    
	if( (unsigned)dest < (unsigned)copiee->dataSegmentPtr ||
	    (unsigned)dest+bytes >
		(unsigned)copiee->dataSegmentPtr + copiee->dataSegmentSize ||
	    (unsigned)dest+bytes < (unsigned)dest )
	  {
	    return( NO_PERMISSION );
	  }
      }

    if( copiee->team == copier->team ) /* Straight copy */
      {
	oldteam = GetAddressableTeam();
	SetAddressableTeam(copier->team);
        Copy( dest, src, bytes );
	SetAddressableTeam(oldteam);
      }
    else  /* Inter-team copy */
      {
        InterTeamCopy(dest,copiee->team, src,copier->team, bytes);
      }

    return( OK );
  }


CheckFrozenSender(pd)
    Process *pd;
  {
    /*
     * Timeout function for deferred local copy operations.
     * Checks to see if sender is still alive; readies deferred copier if not.
     * Checks to see if the sender is unfrozen and does the deferred copy
     * operation if so.
     */
    Process *sender;

    if (!MAP_TO_RPD(sender, pd->blocked_on))
      {
	pd->msg.sysCode = NONEXISTENT_PROCESS;
	Addready(pd);
	return;
      }

    if (sender->pdFlags & FROZEN)
      {
	pd->timeout_func = (Unspec (*)()) CheckFrozenSender;
	pd->timeout_count = FROZEN_SENDER_CHECK_PERIOD;
	DelayProcess(pd);
	return;
      }

    /* Do the (local) copy operation now. */
    ExecuteDeferredCopyOp(pd);
  }
