/*
 * Distributed V Kernel - Copyright (c) 1983 by Stanford University.
 *
 * Internal header file for inter kernel communication.
 *
 */

/* Conventional retransmission periods and max retransmissions. */
/* Individual operations are free to choose other values if appropriate. */

#define SEND_RETRANS_PERIOD	(CLICKS_PER_SEC/2) /* Very long */
#define SEND_ACKED_RETRANS_PERIOD	(CLICKS_PER_SEC) /* Very, Very long */
#define COPY_RETRANS_PERIOD	(CLICKS_PER_SEC/4)/* For CopyTo and CopyFrom */
#define MAX_RETRANSMISSIONS	4		   /* Lots of them */
#define FROZEN_SENDER_CHECK_PERIOD (CLICKS_PER_SEC/4) 
				/* For deferred local copy operations. */

/* This is used in the kp->packetType field to indicate if kPacket
 * is embedded in an alien process descriptor.  It is also used
 * to flag to the network driver that the alien descriptor is still
 * free to use.  I.e., if IKC level uses this descriptor, it is turned off.
 */
#define ALIEN_EMBEDDED	0x4000

#define MAX_SEQNO	0xffff
#define DUPLICATE_SUPPRESSION_DIST	(((MAX_SEQNO - 1) / 2) + 1)
