/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * Circular character buffer routines
 */

#define CBUFF_SIZE 32
#define CBUFF_EMPTY -1


typedef struct
  {
    char *cbuffInPtr;	/* characters inserted here */
    char *cbuffOutPtr;	/* characters removed here */
    char buffer[CBUFF_SIZE];
  }
CircularBuffer;


/*
 * Get a character from buffer buff
 * Return CBUFF_EMPTY if buffer empty.
 */
#define CbuffGet( buff )						\
  (									\
    /* Check if buffer is empty */					\
    (buff)->cbuffInPtr == (buff)->cbuffOutPtr ? 			\
	CBUFF_EMPTY :							\
        /* Be sure out pointer is normalized */				\
	  (								\
	    (buff)->cbuffOutPtr >= &((buff)->buffer[CBUFF_SIZE]) ?	\
	        (buff)->cbuffOutPtr = &((buff)->buffer[0]) :		\
	        0,							\
	    *((buff)->cbuffOutPtr++)					\
	  )								\
  )


/*
 * Put a character into buffer buff
 * Flush the buffer if it overflows.
 */
#define CbuffPut( buff, char )						\
  (									\
    /* Be sure in pointer is normalized */				\
      (									\
	(buff)->cbuffInPtr >= &((buff)->buffer[CBUFF_SIZE]) ?		\
	    (buff)->cbuffInPtr = &((buff)->buffer[0]) :			\
	    0								\
      ),								\
    /* Insert character */						\
    *((buff)->cbuffInPtr++) = (char)					\
  )


/*
 * Discard accumulated characters in buffer.
 */
#define CbuffFlush( buff )						\
    (buff)->cbuffInPtr = (buff)->cbuffOutPtr = &((buff)->buffer[0])

/*
 * Initialize a buffer
 */
#define CbuffInit( buff ) CbuffFlush( buff )

/*
 * Return the number of characters in the buffer.
 */
#define CbuffSize( buff ) \
    (((buff)->cbuffInPtr - (buff)->cbuffOutPtr + CBUFF_SIZE) % CBUFF_SIZE)
