
typedef unsigned char uschar;

/* definitions for Xylogics 450 controller */

#define P_DEVADDR	0xEE40	/* Multibus I/O space address of controller */
#define DEVADDR		(P_DEVADDR - P_MBIO_WINDOW + V_MBIO_WINDOW)

#define	RRlow(devaddr)	*(uschar*)(DEVADDR + 1)
#define	RRhigh(devaddr)	*(uschar*)(DEVADDR + 0)
#define	ARlow(devaddr)	*(uschar*)(DEVADDR + 3)
#define	ARhigh(devaddr)	*(uschar*)(DEVADDR + 2)
#define	CSR(devaddr)	*(uschar*)(DEVADDR + 5)
#define	CRUR(devaddr)	*(uschar*)(DEVADDR + 4)
#define GBSY		0x80
#define ERR		0x40
#define DERR 		0x20
#define IPND		0x10
#define ADRM		0x08    /* set means 24-bit addressing */
#define AREQ		0x04
#define AACK		0x02
#define DRDY		0x01		

/* command codes */

#define NORMAL  	0xD0 /* auto-update, data relocation, int. enable */
#define NOOP		0x00
#define WRITE   	0x01
#define	READ		0x02
#define WRITEH		0x03
#define READH		0x04
#define SEEK		0x05
#define RESET		0x06
#define FORMAT  	0x07
#define READ_MISC	0x08
#define READ_STAT	0x09
#define WRITE_MISC	0x0A
#define SET_DRIVE	0x0B
#define SELF_TEST	0x0C
#define MAINT_LOAD	0x0E
#define MAINT_DUMP	0x0F

#define INT_MODE	0x4E /* int. on each IOPB, seek retry, ecc */
#define CLR_INT		0x10 /* interrupt bit to be cleared after ea. command */
#define CLR_ERR		0x40 /* error bit         "          "                */

/* status codes */

#define SUCCESS         0x00 /* status byte 2 will be 0 if no error */
#define DONE_MASK	0x01 /* mask status byte 1 to obtain done status */
#define ERROR_MASK	0x80 /* mask status byte 1 to obtain error status */
#define DRIVE_NOT_READY 0x16 /* error code that most likely indicates that the
                              *   specified drive does not exist */


#define THROT   0x17    /* word transfers, 128 burst DMA, interleave 3:1 */
                        /* Note that the interleave factor is only significant
                         *   during format and read/write header data (which
                         *   are not done in the driver, so its setting
                         *   here is inmaterial.
                         */

#define MAX_NUMBER_DRIVES 4   /* maximum number of disk drives */
#define SECSIZE 	512

/* account for the fact that the storage server uses blocks twice as big (1k)
 * as used by the disk.
 */
#define BLOCK_FACTOR	2	

#define SUN2_DISK_MAX_BYTES	64*SECSIZE*BLOCK_FACTOR
                                /* 256K is max. for DVMA so don't want to hog */
#define SUN1_DISK_MAX_BYTES   	16*SECSIZE*BLOCK_FACTOR
			        /* this corresponds to the size of the buffer
                                 * that will be allocated by invoking 
                                 * AllocateMultibusMemory at powerup.
                                 * Only valid when not using DVMA.
                                 */
#ifdef SUN2
#define DISK_MAX_BYTES   SUN2_DISK_MAX_BYTES  
#else
#define DISK_MAX_BYTES   SUN1_DISK_MAX_BYTES
#endif 



typedef struct  {
        uschar imode;
        uschar comm;
        uschar stat2;
        uschar stat1;
        uschar drive;
        uschar throt;
        uschar sect;
        uschar head;
        uschar cylh;
        uschar cyll;
        uschar scnth;
        uschar scntl;
        uschar datah;
        uschar datal;
        uschar datarh;
        uschar datarl;
        uschar res;
        uschar hdofst;
        uschar nioph;
        uschar niopl;
        uschar eccml;
        uschar eccmh;
        uschar eccah;
        uschar eccal;

        } Iopb;


/* disk drive parameters - needed by XylBuild() */

typedef struct  {
        unsigned nhead;   /* number of heads on the drive */
        unsigned nsect;   /* number of sectors per track */
        } DiskParameters;
