/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 *  Kernel trap handler for process-invoked traps.
 *  Changes to this file need to be coordinated with
 *  the C kernel trap definitions for programs.
 */
#include "asmprocess.h"  /* Defines offsets for assembly language. */
#include "process.h"

Process  *Active;  /* Remove when the trap-handler does not need it. */
extern ProcessId ReturnMessage();

typedef int (*PFI)();			/* Ptr to fn (returning int)   */
extern int				/* Internal names of functions */
	KForward(),
	GetPid(),
	CopyFrom(),
	CopyTo(),
	ReceiveSpecific(),
	KSend(),
	ReceiveWithSegment();
	KReply();
	KGetReply();

Forward_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_Forward_trap");
    asm("Asm_Forward_trap:");
    asm("	orw #/0300,sr");
    Kabort("Forward trap called !");
  }

GetPid_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_GetPid_trap");
    asm("Asm_GetPid_trap:");
    asm("	orw #/0300,sr");
    Kabort("GetPid trap called !");
  }

CopyFrom_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_CopyFrom_trap");
    asm("Asm_CopyFrom_trap:");
    asm("	orw #/0300,sr");
    Kabort("CopyFrom trap called !");
  }

CopyTo_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_CopyTo_trap");
    asm("Asm_CopyTo_trap:");
    asm("	orw #/0300,sr");
    Kabort("CopyFrom trap called !");
  }

ReceiveSpecific_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_ReceiveSpecific_trap");
    asm("Asm_ReceiveSpecific_trap:");
    asm("	orw #/0300,sr");
    Kabort("ReceiveSpecific trap called !");
  }

ReceiveWithSegment_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_ReceiveWithSegment_trap");
    asm("Asm_ReceiveWithSegment_trap:");
    asm("	orw #/0300,sr");
    Kabort("ReceiveWithSegment trap called !");
  }

/* ReplyWithSegment trap is modified to save all parameters in the active
 * PD and invoke KReply with a single parameter, namely Active.
 */
ReplyWithSegment_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_ReplyWithSegment_trap");
    asm("Asm_ReplyWithSegment_trap:");
    asm("	orw #/0300,sr");
    Kabort("ReplyWithSegment trap called !");
  }


/* Send trap is modified to save all parameters in the active PD and
 * invoke KSend with a single parameter, namely Active.
 */
Send_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_Send_trap");
    asm("Asm_Send_trap:");
    asm("	orw #/0300,sr");
    Kabort("Send trap called !");
  }

/* GetReply trap saves all parameters in the active
 * PD and invokes KGetReply with a single parameter, namely Active.
 */
GetReply_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_GetReply_trap");
    asm("Asm_GetReply_trap:");
    asm("	orw	#/0300, sr" );
    Kabort("GetReply trap called !");
  }
