/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Motorola 68000 dependent timer functions.
 *
 * Timer is set to interrupt at 100 Hz.
 *
 * For SMI Model 100 workstations the timer interrupts every 2 ms rather than
 * every 10 ms so that the mouse can be correctly polled.  Normal Vkernel
 * interrupt chores are performed every 5th interrupt.
 * - Marvin Theimer 2/83.
 */

#include "Vexceptions.h"
#include "interrupt.h"
#include "dm.h"
#include "timer.h"
#include "mouse.h"
#include "Vquerykernel.h"

/* Imports */
extern short MouseType, ConsoleInputDevice;

/* Private */
static int IntrptCount = -5;		/* Used to count number of 2 ms
					   interrupts since last 10 ms
					   interrupt. */

unsigned long GenerateRandomNumber()
  {
    return( K_ticks() );
  }

/* Interrupt service routine that calls machine-independent routine
 * on each interrupt. Assumes no need to disable interrupts because
 * no higher priority interrupt unblocks processes.
 */
Call_inthandler(Ms_Timer_interrupt); /* Macro expansion to interrupt-invoked
				   * C call to Ms_Timer_interrupt
				   */
Ms_Timer_interrupt()
  {
    extern short KernelInterrupted;

    ACK_TIMER_INT;

    if (MouseType == PRF_SMI100_MOUSE)
      {
        SmiMouseInterrupt();
	if (++IntrptCount < 0) return;
	IntrptCount = -5;
      }

    if ( ConsoleInputDevice == PRF_SMI100_KEYBOARD ||
         ConsoleInputDevice == PRF_SMI120_KEYBOARD )
      {
	SMIKeyboardPoll();
      }

    if (MouseEvent)
      {
	CheckMouseReader();
      }

    Timer_interrupt();
  }


Init_timer()
  /*
   * Perform the required initialization for the timer.
   */
  {
    extern int Asm_Ms_Timer_interrupt();
#ifdef SUN2
    register int (**int_vec)() = (int(**)()) INT5;
#else /* Sun-1 or 1.5 */
    register int (**int_vec)() = (int(**)()) INT6;
#endif SUN2

    *int_vec =  Asm_Ms_Timer_interrupt; /* Plug interrupt location */

    /* Initialize the AMD Am9513 Timer */
    TCSetModeLoad( TIMInter, KTimerMode, KTimerCount );
    TMRLoadCmd(TCArmCnt(TSCountSelect(TIMInter)));
  }
