/* Fake file. only purpose is to determine the offsets of fields within
 The process descriptor for assembly routines.
 */
#define MC68010
#include "process.h"

#define OutputAsm(name, pdfield)\
  printf("    asm(\"%s = %d\");\n", name, (unsigned long)(pdfield))
    

main()
  /* Write to standard output the header field for various PD offsets.
   * and such like.
   */
  {
    register Process *pd = 0;

    OutputAsm("_LINK", &pd->link);
    OutputAsm("_NEXT_PD", &pd->nextPd);
    OutputAsm("_FATHER", &pd->father);
    OutputAsm("_BROTHER", &pd->brother);
    OutputAsm("_SON", &pd->son);
    OutputAsm("_LOCALPID", &pd->localPid);
    OutputAsm("_PD_FLAGS", &pd->pdFlags);
    OutputAsm("_STATE", &pd->state);
    OutputAsm("_PRIORITY", &pd->priority);
    OutputAsm("_TEAM", &pd->team);
    OutputAsm("_NEXT_SENDER", &pd->next_sender);
    OutputAsm("_MSGQ_HEAD", &pd->msgq.head);
    OutputAsm("_MSGQ_TAIL", &pd->msgq.tail);
    OutputAsm("_MSGQ_LOCK", &pd->msgq.lock);
    OutputAsm("_OLD_SEQ_NO", &pd->oldSeqNo);
    OutputAsm("_NUM_TRANS", &pd->numTrans);
    OutputAsm("_DATA_SEG_PRO", &pd->dataSegmentPro);
    OutputAsm("_DATA_SEG_PTR", &pd->dataSegmentPtr);
    OutputAsm("_DATA_SEG_SIZE", &pd->dataSegmentSize);
    OutputAsm("_DATA_EXPECTED", &pd->dataExpected);
    OutputAsm("_REMOTE_SEGMENT_PTR", &pd->remoteSegmentPtr);
    OutputAsm("_QUEUE_PTR", &pd->queuePtr);
    OutputAsm("_REC_BUF_SIZE_PTR", &pd->recBufSizePtr);
    OutputAsm("_FINISHUP", &pd->finish_up);
    OutputAsm("_RETURN_MSG", &pd->returnMessage);
    OutputAsm("_SEGMENT_PTR", &pd->segmentPtr);
    OutputAsm("_SEGMENT_SIZE", &pd->segmentSize);
    OutputAsm("_CURRENT_SEGMENT_PTR", &pd->currentSegmentPtr);
    OutputAsm("_PACKET_TYPE", &pd->packetType);
    OutputAsm("_SEQ_NO", &pd->seqNo);
    OutputAsm("_PID", &pd->pid);
    OutputAsm("_BLOCKED_ON", &pd->blocked_on);
    OutputAsm("_FORWARDER", &pd->forwarder);
    OutputAsm("_USER_NUMBER", &pd->userNumber);
    OutputAsm("_LENGTH", &pd->length);
    OutputAsm("_LOCAL_ADDRESS", &pd->localaddress);
    OutputAsm("_REMOTE_ADDRESS", &pd->remoteaddress);
    OutputAsm("_MSG", &pd->msg);
    OutputAsm("_END_MSG", ((long) &pd->msg) + sizeof(MsgStruct));
    OutputAsm("_TRAP_PARAMS", &(pd->trap_params[0]));
    OutputAsm("_TIMEOUT_FUNC", &pd->timeout_func);
    OutputAsm("_TIMEOUT_COUNT", &pd->timeout_count);
    OutputAsm("_PROCESSOR_STATE", &pd->proc_state);
    OutputAsm("_D0", &(pd->proc_state.regs[0]));
    OutputAsm("_D1", &(pd->proc_state.regs[1]));
    OutputAsm("_D2", &(pd->proc_state.regs[2]));
    OutputAsm("_D3", &(pd->proc_state.regs[3]));
    OutputAsm("_D4", &(pd->proc_state.regs[4]));
    OutputAsm("_D5", &(pd->proc_state.regs[5]));
    OutputAsm("_D6", &(pd->proc_state.regs[6]));
    OutputAsm("_D7", &(pd->proc_state.regs[7]));
    OutputAsm("_A0", &(pd->proc_state.regs[8]));
    OutputAsm("_A1", &(pd->proc_state.regs[9]));
    OutputAsm("_A2", &(pd->proc_state.regs[10]));
    OutputAsm("_A3", &(pd->proc_state.regs[11]));
    OutputAsm("_A4", &(pd->proc_state.regs[12]));
    OutputAsm("_A5", &(pd->proc_state.regs[13]));
    OutputAsm("_A6", &(pd->proc_state.regs[14]));
    OutputAsm("_FP", &(pd->proc_state.regs[14]));
    OutputAsm("_A7", &(pd->proc_state.regs[15]));
    OutputAsm("_USP", &(pd->proc_state.regs[15]));
    OutputAsm("_FRAME", &(pd->proc_state.frame));
    OutputAsm("_SR", &(pd->proc_state.frame.sr));
    OutputAsm("_PC", &(pd->proc_state.frame.pc));
    OutputAsm("_FORMAT_OFFSET", (&(pd->proc_state.frame.pc))+1);
    OutputAsm("_PER_PROCESS", &pd->proc_state.perProcess);
    OutputAsm("_PER_PROCESS_LOC", &pd->proc_state.perProcessLoc);
#ifdef undef
/* where is this ? */
    OutputAsm("_CONTEXT", &pd->proc_state.context);
#endif
    OutputAsm("_DECAY_RATE", &pd->decayRate);
    OutputAsm("_DECAY_TIME", &pd->decayTime);
  }
