/*
 * V Kernel - Copyright (c) 1981 by David Cheriton.
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1984 Stanford University.
 *
 *  Message Kernel trap handler.
 *  These traps need to agree with those defined in msgreg.c
 *  in the C run-time library.
 */
#include "process.h"
#include "asmprocess.h"

extern Process *Active;
extern SyncQueue Readyq;
extern Unspec a0;

extern int Addready();
extern NonLocalSend();

/* Convention: a6 always points to the active PD - in assembly code. */

SendReg_trap()		/* Trap 0 */
  {
    extern Unspec d0;
    register Processor_state *state;
    register Process *pd;

    asm("	.text");
    asm("	.globl	Asm_SendReg_trap");
    asm("Asm_SendReg_trap:");

    asm("	orw	#/0300,sr");
    asm("	movl	Active, a6");
    /* Save user SP as register A7--kernel SP not saved */
    asm("	movl    usp,a4");
    asm("	movl    a4,a6@(_USP)");
    asm("	movw    sp@,a6@(_SR)");
    asm("	movl    sp@(2),a6@(_PC)");

    asm("	moveml	#/0003, a6@(_TRAP_PARAMS)");
    asm("	movl	d0, a6@(_BLOCKED_ON)" );
    asm("	movl	a6@(_PID), a6@(_FORWARDER)");
    asm("	orb	#2, a6@(_PD_FLAGS)");	/* Set the MSG_FLAG */

    asm("	lea	a6@(_MSG), a5" );
    asm("	moveml	#/07F8, a5@" );		/* Save message in PD */
    asm("	movl	a6, sp@-" );		/* pointer to pd is argument */
    
    asm("	jbsr	KSend" );
    asm("	addql	#4, sp" );
    asm("	orw     #/0700,sr");
    asm("	jmp     ActivateReadyqHead");
  }    

ReceiveReg_trap()		/* Trap 2 */
  {
    asm("	.text");
    asm("	.globl	Asm_ReceiveReg_trap");
    asm("Asm_ReceiveReg_trap:");

    asm("	orw	#/0300, sr	");
    asm("	movl	Active, a6	");
    asm("	movl	usp, a5		");
    asm("	movl    a5, a6@(_USP)	");
    asm("	movw    sp@,a6@(_SR)");
    asm("	movl    sp@(2), a6@(_PC)");

    asm("	moveml	#/0003, a6@(_TRAP_PARAMS)");
    asm("	movl	d0, a6@(_BLOCKED_ON)");
    asm("	movl	d2, a6@(_DATA_SEG_SIZE)");
    asm("	movl	a4, a6@(_DATA_SEG_PTR)");
    asm("	movb	#0, a6@(_NUM_TRANS)");
    asm("	orb	#2, a6@(_PD_FLAGS)");

    asm("	movl	a6, sp@-	");
    asm("	jbsr	KReceiveSpecific");
    asm("	addql	#4, sp		");
    asm("	orw     #/0700,sr	");
    asm("	jmp     ActivateReadyqHead");
  }

ReplyWithSeg_trap()		/* Trap 3 */
  {
    extern Unspec d0;
    register Processor_state *state;
    register Process *pd;

    asm("	.text");
    asm("	.globl	Asm_ReplyWithSeg_trap");
    asm("Asm_ReplyWithSeg_trap:");

    asm("	orw	#/0300, sr");
    asm("	movl	Active, a6");
    asm("	movl	usp, a5");
    asm("	movl    a5, a6@(_USP)");
    asm("	movw    sp@,a6@(_SR)");
    asm("	movl    sp@(2), a6@(_PC)");

    asm("	moveml	#/0003, a6@(_TRAP_PARAMS)");
    asm("	movl	d1, a6@(_BLOCKED_ON)" );
    asm("	movl	a3, a6@(_SEGMENT_PTR)" );
    
    asm("	lea	a6@(_MSG), a5" );
    asm("	moveml	#/07F8, a5@" );		/* Save message in PD */
    asm("	orb	#2, a6@(_PD_FLAGS)");	/* Set the MSG_FLAG */

    asm("	movl	a6, sp@-" );		/* pointer to pd is argument */
    asm("	jbsr	KReply" );
    asm("	addql	#4, sp" );
    asm("	orw     #/0700,sr");
    asm("	jmp     ActivateReadyqHead");
  }    

ForwardReg_trap()		/* Trap ??? */
  {
    asm("	.text");
    asm("	.globl	Asm_ForwardReg_trap");
    asm("Asm_ForwardReg_trap:");

    asm("	orw	#/0300, sr");
    asm("	movl	Active, a6");
    asm("	movl	usp, a5");
    asm("	movl    a5, a6@(_USP)");
    asm("	movw    sp@,a6@(_SR)");
    asm("	movl    sp@(2), a6@(_PC)");

    asm("	moveml	#/0003, a6@(_TRAP_PARAMS)");
    asm("	movl	d0, a6@(_FORWARDER)" );
    asm("	movl	d1, a6@(_BLOCKED_ON)" );
    asm("	lea	a6@(_MSG), a5" );
    asm("	moveml	#/07F8, a5@" );
    asm("	orb	#2, a6@(_PD_FLAGS)");

    asm("	movl	a6, sp@-" );
    asm("	jbsr	KForward" );
    asm("	addql	#4, sp" );
    asm("	orw     #/0700,sr");
    asm("	jmp     ActivateReadyqHead");
  }

GetReplyReg_trap()
  {
    asm("	.text");
    asm("	.globl	Asm_GetReplyReg_trap");
    asm("Asm_GetReplyReg_trap:");
    asm("	orw	#/0300, sr" );
    asm("	movl	Active, a6" );
    asm("	movl	usp, a5" );
    asm("	movl	a5, a6@(_USP)" );
    asm("	movw    sp@,a6@(_SR)");
    asm("	movl	sp@(2), a6@(_PC)" );

    asm("	moveml	#/0003, a6@(_TRAP_PARAMS)");
    asm("	movl	d1, a6@(_TIMEOUT_COUNT)" ); /* One argument in d1 */

    asm("	orb	#2, a6@(_PD_FLAGS)");
    asm("	movl	a6, sp@-" );
    asm("	jbsr	KGetReply");
    asm("	addql	#4, sp");
    asm("	orw	#/0700, sr");
    asm("	jmp	ActivateReadyqHead");
  }
