/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Motorola 68000 dependent timer functions.
 *
 * Timer is set to interrupt at 100 Hz.
 *
 * For SMI Model 100 workstations the timer interrupts every 2 ms rather than
 * every 10 ms so that the mouse can be correctly polled.  Normal Vkernel
 * interrupt chores are performed every 5th interrupt.
 * - Marvin Theimer 2/83.
 */

#include "Vexceptions.h"
#include "interrupt.h"
#include "dm.h"
#include "intersil7170.h"
#include "mouse.h"
#include "Vquerykernel.h"
#include "memory.h"

/* Imports */
extern short ConsoleInputDevice;

unsigned long GenerateRandomNumber()
  {
    return( K_ticks() );
  }

/* Interrupt service routine that calls machine-independent routine
 * on each interrupt. Assumes no need to disable interrupts because
 * no higher priority interrupt unblocks processes.
 */
Call_inthandler(Ms_Timer_interrupt); /* Macro expansion to interrupt-invoked
				   * C call to Ms_Timer_interrupt
				   */
/* Imports */
extern short MouseType, ConsoleInputDevice;

union
  {
    InterruptRegister r;
    unsigned char u;
  }
TimerMask;

Ms_Timer_interrupt()
  {
    register unsigned char value;

    value = *(unsigned char *) V_INTERRUPT_REG;
    value &= ~(TimerMask.u);
    *(unsigned char *) V_INTERRUPT_REG = value;
    value |= TimerMask.u;
    *(unsigned char *) V_INTERRUPT_REG = value;

    if ( ConsoleInputDevice == PRF_SMI100_KEYBOARD ||
         ConsoleInputDevice == PRF_SMI120_KEYBOARD ) SMIKeyboardPoll();

    if (MouseEvent) CheckMouseReader();

    Timer_interrupt();
  }


Init_timer()
  /*
   * Perform the required initialization for the timer.
   */
  {
    unsigned char value;
    extern int Asm_Ms_Timer_interrupt();
    register int (**int_vec)() = (int(**)()) (INT5 + VECTOR_BASE);

    TimerMask.u = 0;
    TimerMask.r.enableInt5 = 1;
    
    *int_vec =  Asm_Ms_Timer_interrupt; /* Plug interrupt location */
    
    value = *(unsigned char *) V_INTERRUPT_REG;
    value |= TimerMask.u;
    *(unsigned char *) V_INTERRUPT_REG = value;
  }
