
typedef unsigned char uschar;

/* definitions for SMD-2181 controller */

#define P_DEVADDR	0x200	/* Multibus I/O space address of controller */
#define DEVADDR		(P_DEVADDR - P_MBIO_WINDOW + V_MBIO_WINDOW)

#define	R0(devaddr)	*(uschar*)(DEVADDR + 1)
#define	R1(devaddr)	*(uschar*)(DEVADDR + 0)
#define	R2(devaddr)	*(uschar*)(DEVADDR + 3)
#define	R3(devaddr)	*(uschar*)(DEVADDR + 2)
#define	GO		0x01
#define	CLR_INT		0x02
#define CLR_AND_GO      0x03
#define	BUSY_INT   	0x01
#define	COMPLETE	0x02

#define BUS             0x20    /* transfers are word mode */
/* command codes */

#define	READ	0x81
#define	WRITE	0x82
#define	VERIFY	0x83
#define	FORMAT	0x84
#define	MAP	0x85
#define	SWITCH	0x86
#define	INIT	0x87
#define	RESTORE	0x89
#define	SEEK	0x8A
#define	ZERO	0x8B
#define	SPINDWN	0x8C
#define	RESET	0x8F

/* status codes */

#define	SUCCESS	0x80
#define	DBUSY	0x81
#define	ERROR	0x82


#define NCYL    810     /* cylinders per unit  */
#define NTRACKS 10      /* tracks per cylinder */
#define NHEAD   10
#define NSECT   18      /* sectors per track   */
#define SECSIZE 1024
#define UNIT    0
#define NUM_BLOCKS       NCYL * NTRACKS * NSECT

#ifdef SUN2
#define DISK_MAX_BYTES   128*SECSIZE  
                                /* 256K is max. for DVMA so don't want to hog */
#define DMA_CNT 0	        /* 0 means 256 here */


#else /* not Sun-2 */
#define DISK_MAX_BYTES   16*SECSIZE
			        /* this corresponds to the size of the buffer
                                 * that is allocated by invoking 
                                 * AllocateMultibusMemory at powerup.
                                 * Only valid when not using DVMA.
                                 */
#define DMA_CNT 16              /* the Interphase controller has a bug that
                                 * prevents it from giving up the bus when it
                                 * should.  Seems to cause problems in Sun-1
                                 * configuration.
                                 */
#endif SUN2



typedef struct  {
        uschar cmd_opt;
        uschar cmd;
        uschar error;
        uschar status;
        uschar head;
        uschar unit;
        uschar cyl_lsb;
        uschar cyl_msb;
        uschar sector_lsb;
        uschar sector_msb;
        uschar sectcnt_lsb;
        uschar sectcnt_msb;
        uschar buffaddr_xmb;
        uschar dmacnt;
        uschar buffaddr_lsb;
        uschar buffaddr_msb;
        uschar ioaddr_lsb;
        uschar ioaddr_msb;
        uschar reladdr_lsb;
        uschar reladdr_msb;
        uschar linkaddr_xmb;
        uschar dummy;         /* reserved */
        uschar linkaddr_lsb;
        uschar linkaddr_msb;

        } Iopb;

typedef struct  {
        uschar sectors;
        uschar heads;
        uschar secsize_msb;
        uschar secsize_lsb;
        uschar gap2;
        uschar gap1;
        uschar retry;
        uschar interleave;
        uschar reseek;
        uschar ecc;
        uschar incrhead;
        uschar movebad;
        uschar intr;
        uschar dualport;
        uschar dumb1;      /* reserved */
        uschar skew;      
        uschar dumb2;      /* reserved */

        } Uib;

