/*
 * V Kernel - Copyright (c) 1986 by David Cheriton, Lance Berc
 *
 * Kernel framebuffer routines.
 */

#include "Venviron.h"
#include "Vframebuffer.h"
#include "Vquerykernel.h"
#include "Vioprotocol.h"
#include "memory.h"
#include "process.h"
#include "dm.h"

extern short FramebufferType;
extern SystemCode NotSupported();

SystemCode FramebufferModify(), FramebufferQuery(), FramebufferRelease();
SystemCode FramebufferEnable();

/* Device Routines */

SystemCode FramebufferCreate( pd, inst )  
Process *pd;
DeviceInstance *inst;
  {
  /*
   * Create an instance for the framebuffer.
   */
    CreateInstanceRequest *req = (CreateInstanceRequest *) &pd->msg;

    if (req->filemode != FCREATE) return (MODE_NOT_SUPPORTED);

    /*
     * Initialize the device instance descriptor, can assume all fields
     * are zero except for id and first instance's owner.
     */
    inst->readfunc = NotSupported;
    inst->writefunc = NotSupported;
    inst->modifyfunc = FramebufferModify;
    inst->queryfunc = FramebufferQuery;
    inst->releasefunc = FramebufferRelease;
    inst->type = 0;
    return ( OK );
  }

static SystemCode FramebufferRelease( pd, inst )
    Process *pd;
    DeviceInstance *inst;
  {
    inst->owner = 0;
    return( OK );
  }

SystemCode FramebufferModify( pd, inst, dirIndex )
register Process *pd;
DeviceInstance *inst;
unsigned short dirIndex;
  {
    register ModifyFramebufferMsg *req = (ModifyFramebufferMsg *) &pd->msg;
    
    switch( req->request )
      {
	case FB_OFF:
	case FB_ON:
	    return( FramebufferEnable( (req->request == FB_ON) ) );
      }
    return( REQUEST_NOT_SUPPORTED );
  }

/* Machine dependent code */

#ifndef SUN3
#ifdef SUN2
/* The Sun-2 Video Control Register: */
struct videocontrol
  {
    unsigned dispen:1;
    unsigned copyen:1;
    unsigned inten:1;
    unsigned int:1;
    unsigned audio:1;
    unsigned res2:3;
    unsigned base:7;
    unsigned res1:1;
  };

#define VideoControl ((struct videocontrol *)V_VIDEO_CTRL_REG)

/* Base address of Sun-2 with Sun-1 framebuffer */
#define GXBase	(0xFC0000)
#else /* Sun-1 */
#define GXBase  (0x1C0000)
#endif SUN2

#define GXvideoEnable (1<<9)
#define GXset3  (3<<12)
#define GXothers  (1<<14)
#define GXcontrol  *(short *)(GXBase+GXset3+GXothers+(2<<1) )

#endif SUN3

SystemCode FramebufferQuery( pd, inst, dirIndex ) 
Process *pd;
DeviceInstance *inst;
unsigned short dirIndex;
  {
    QueryFramebufferMsg *reply = (QueryFramebufferMsg *) &(pd->msg);

#ifdef SUN3
    reply->baseAddress = V_SUN3_FRAMEBUFFER;
#else
#ifdef SUN2
    if (FramebufferType == PRF_FRAMEBUFFER_SUN2)
	reply->baseAddress = V_SUN2_FRAMEBUFFER;
    else
	reply->baseAddress = V_SUN1_FRAMEBUFFER;
#else  /* must be a sun-1 */
#endif SUN2
    reply->baseAddress = GXBase;
#endif SUN3
    return( OK );
  }

SystemCode FramebufferEnable( screenEnable )
int screenEnable;	/* 0 == off; 1 = on */
  {
    switch( FramebufferType )
      {
#ifndef SUN3
	case PRF_FRAMEBUFFER_SUN1:
	    GXcontrol = (screenEnable) ? GXvideoEnable:0;
	    return( OK );
#ifdef SUN2
	case PRF_FRAMEBUFFER_SUN2:
	    VideoControl->dispen = screenEnable;
	    return( OK );
#endif SUN2
#else SUN3
	case PRF_FRAMEBUFFER_SUN3:
	  {
	    SystemEnableRegister r;

	    r.u = Fc3ReadBit8( SYSTEM_ENABLE_REGISTER );
    	    r.f.enableVideo = screenEnable;
	    Fc3WriteBit8( SYSTEM_ENABLE_REGISTER, r.u );
	    return( OK );
	  }
#endif SUN3
      }
    return( REQUEST_NOT_SUPPORTED );
  }
