%% Converts an font file in sf format to one in gf format.
%% Argument: File name (without extension).
%% Output file name is lower-cased.
%% Returns: NoVAL.
%% Example: {TimesRoman12} sftogf
%% -which reads the file TimesRoman12.sf, and writes out timesroman12.gf
sftogf: :fn (fnam: fn string;
    ((fnam & {.sf}) cstring) loadsfont writegf ((fnam & {.gf}) lcase cstring);
)

TR: {timesroman12.sf} loadsfont

samplestring: {A} char
%% qsftogf: same as sftogf, but asks if the baseline should be adjusted
qsftogf: :fn (fnam: fn string;
  font: ((fnam & {.sf}) cstring) loadsfont;
  font querybaseline;
  font writegf ((fnam & {.gf}) lcase cstring);
)

newline: {
}
querybaseline: :font (
  stdout<<newline<<(samplestring font)<<{Type baseline adjustment:};
  val: stdin'getline eval;
  val<>0; ( font adjustbaseline val; font querybaseline;) ;
)
