/* Program to convert a font from the AL (alto) format to the SF format.
 * Per Bothner.   November 1982
 * Usage: ALtoSF [inputfile] {switches} >outputfile
 * If inputfile is omitted, standard input is used.
 */
#include "/usr/sun/include/sfont.h"
#include <stdio.h>
unsigned short MapChar[12000];
int firstChar = 0, lastChar = 127;
int underLinePos = 3, underLineWidth = 1;
int Align = 1;
int height=0, descent=0;
int extendTop = 0, extendBot = 0;
int indexable = 0;
#define MIN(x,y) ((x) < (y) ? (x) : (y))

unsigned short *index = MapChar+2;

Width(c)
  { register int w = 0, cw;
    while ( !((cw = index[c + index[c]]) & 1)) {w += 16; c = cw>>1;}
    w += cw>>1;
    return w;
}

inputFont(f)
FILE *f;
{ register unsigned short *wp = MapChar; unsigned char c0,c1;
    do { c0=getc(f); c1=getc(f); *wp++ = (c0<<8)|c1;}
    while (!feof(f));
}
    
outputWords(p,n)
register short *p;	/* output n words starting at p */
register n;
  {
    while (--n >= 0) {
	putchar(*p>>8);
	putchar(*p & 0xFF);
	p++;
    }
};

unsigned short workBuf[12000];
CharInfo width[256];
int bufUsed;	/* No. of used bits */
unsigned short *firstMap;
unsigned short *curMap = workBuf;
Sfont font;

flushBuf() { register i;
    curMap += height;
    for (i = 0; i < height; i++)  curMap[i] = 0;
    bufUsed = 0;
}

main (argc, argv)
    int argc; char **argv;
 {  register unsigned short *pBuf, *pMap; unsigned short *savepMap;
    unsigned ch; int i; int moreWidth, shift;
    FILE *fontFile = stdin;

    i = 1;
    if (argc >= 1 && argv[1][0] != '-' && argv[1][1]) { /* Must be filename */
        fontFile = fopen(argv[1], "r");
	if (fontFile <= 0)
	    { fprintf(stderr,"Couldn't find input file: %s\n", argv[1]); exit(-1);}
	i++;
    }
    inputFont(fontFile);

    /* process switches */
    for (; i < argc; i++) {
	if ( (argv[i][0] == '-' && (ch = argv[i][1]))
	  || (!argv[i][1] && (ch = argv[i][0]))) {
	    switch (ch) {
		case 'a': case 'A':	/* Alignment for chars within words */
		    if (++i >= argc) goto tooFewParams;
		    Align = atoi(argv[i]);
		    break;
		case 'd': case 'D':	/* descent */
		    if (++i >= argc) goto tooFewParams;
		    descent = atoi(argv[i]);
		    break;
		case 'h': case 'H':	/* height */
		    if (++i >= argc) goto tooFewParams;
		    height = atoi(argv[i]);
		    break;
		case 'i': case 'I':
		    if (++i >= argc) goto tooFewParams;
		    indexable = atoi(argv[i]);
		    break;
		case 'r': case 'R':	/* range of characters */
		    if (i + 2 >= argc) goto tooFewParams;
		    firstChar = atoi(argv[++i]);
		    lastChar = atoi(argv[++i]);
		    break;
		case 'u': case 'U':	/* underLineOk */
		    if (++i >= argc) goto tooFewParams;
		    underLinePos = atoi(argv[i]);
		    if (i < argc && (ch = argv[i+1][0]) >= '0' && ch <= '9')
		        underLineWidth = atoi(argv[++i]);
		    break;
		tooFewParams:
		    fprintf(stderr, "Too few command line parameters\n");
		    exit(-1);
		default:
		    fprintf(stderr, "Illegal command line parameter # %d: %s\n",
		        i,argv[i]);
		    exit(-1);
	    };
	}
    }

    if (!height) height = (MapChar[0] > 16 ? MapChar[0] : 16);
    if (!descent) descent = (height == 16 ? 4 : (MapChar[1] & 0x7F00) >> 8);
    extendBot = height - ((index[-1]&0x7F00) >> 8) - descent;
    if (extendBot < 0) extendBot = 0;
    extendTop = height - index[-2] - extendBot;
    if (extendTop < 0) extendTop = 0;
    fprintf(stderr, "[Height: %d, Descent: %d, extendTop: %d, extendBot: %d]\n",
	height, descent, extendTop, extendBot);

    flushBuf(); firstMap = curMap;
    for (ch = firstChar; ch <= lastChar; ch++) {
	bufUsed = ((bufUsed + Align - 1) / Align) * Align;
	width[ch].width = moreWidth = Width(ch);
	if (indexable > 0 && moreWidth < 0xFF & MapChar[1])
	    moreWidth = 0xFF & MapChar[1];
	if (bufUsed >= 16) flushBuf();
	if (16-bufUsed < moreWidth%16||(!moreWidth%16 && moreWidth>=16)) flushBuf();
	width[ch].bit =  bufUsed;
	width[ch].word = curMap - firstMap;
	pMap = index+ch;
	shift = bufUsed;
	while (moreWidth > 0) {
	    /*fprintf(stderr,"C: %o, pMap=%x:%x\n",ch,(int)pMap-(int)index,*pMap);*/
	    pMap += *pMap; savepMap = pMap;
	    pBuf = curMap + (pMap[1]>>8)+extendTop;
	    i = pMap[1]&0xFF;
	    pMap -= i;
	    while (--i >= 0) *pBuf++ |= *pMap++ >> shift;
	    i = MIN(moreWidth, 16 - bufUsed);
	    bufUsed += i; moreWidth -= i;
	    
	    /* if the current 16 bit source overflows into the next
	     * buffer chunk, write it */
	    if (moreWidth) flushBuf();
	    if (moreWidth && shift) {
	        pMap = savepMap; i = pMap[1] & 0xFF;
	        pBuf = curMap + (pMap[1]>>8) + extendTop;
		pMap -= i;
	        while (--i >= 0) *pBuf++ = *pMap++ << (16-shift);
	        bufUsed = MIN(moreWidth,shift);
	        moreWidth -= bufUsed;
	    }
	    pMap = index+((*savepMap)>>1);
        }
    }

    if (bufUsed) flushBuf();

	/* Now do output */
    font.numBytes = 16 + 4*(lastChar - firstChar + 1) + 2*(curMap-firstMap);
    font.height = height;
    font.maxWidth = 0;
    for (i = firstChar; i <= lastChar; i++)
	if (width[i].width > font.maxWidth) font.maxWidth = width[i].width;
    font.descent = descent;
    outputWords(&font,4);
    putchar(firstChar);
    putchar(lastChar);
    putchar((underLinePos << 3) + underLineWidth);
    putchar(0x80*(index[-1]>=0)
	 + 0x40 *(!(Align %16))
	 + 0x20 * (!(Align % 8))
	 + 0x10 * (indexable > 0) );
    for (i = 1; i <= 4; i++) putchar(0); /* kernTable */
    for (i = firstChar; i <= lastChar; i++) {
	width[i].word = 2 * (width[i].word + 2*(lastChar-firstChar+1) +8);
	outputWords(&(width[i].word), 1);
	putchar (width[i].bit);
	putchar (width[i].width);
    }
    outputWords(firstMap, curMap-firstMap);
    i = firstChar;
    fprintf(stderr,"[minChar: 0%o: width: %d, word: 0%o, bit: %d]\n", i,
	width[i].width, width[i].word, width[i].bit);
    i = lastChar - firstChar;
    fprintf(stderr,"[maxChar: 0%o: width: %d, word: 0%o, bit: %d]\n", i,
	width[i].width, width[i].word, width[i].bit);
    fprintf(stderr, "[words in bitmap: %d]\n", curMap - firstMap);
}
