@Part( VGTServer, root "manual" )
@Chapter(Virtual Graphics Terminal Server)
@Label[VGTS]

The Virtual Graphics Terminal Service (VGTS) allows the display
of structured graphical objects on workstations (with appropriate displays) 
that run the V system.
This chapter describes how the standard library routines interface to the VGTS,
as well as
describing some of the VGTS's internal structure.
Applications programmers usually need not concern themselves with the details
of this section; instead they should consult the ``Graphics Functions'' 
section of the manual (section @ref[VGTSlibc]).

@section[Current VGTS Versions]
There are currently two working versions of the VGTS.
@t[sun100vgts]@Index[sun100vgts] is used on
workstations with SMI model 100 framebuffers, while
@t[sun120vgts]@Index[sun120vgts] is used with
the SMI model 120 framebuffer.  (Sun model 50 workstations also use the 
model 120 framebuffer.)
Users usually will not have to concern
themselves with this distinction, since @t[team1-vgts] (the default first team)
automatically loads the correct version of the VGTS shortly after it begins
running.  Furthermore, the program
@t[vgts]@Index[vgts] is a `bootstrap' program which loads the correct version
of the VGTS
(in a new team), and then dies.  Thus, ``vgts'' can be given as an
argument to @t[newterm]@Index[newterm] (see Section @ref[CmdSummary]),
regardless of the
workstation's framebuffer type.

The difference in VGTS versions is important, however, when loading
special first teams that have a VGTS already linked in.  @t[team1+sun100vgts]
will run only with a SMI model 100 framebuffer, and @t[team1+sun120vgts] only
with a model 120 framebuffer.

@section(AVT Escape Sequences)@index(AVT Escape Sequences)
@index(Escape Sequences)

Unless otherwise noted, all escape sequences can come
with or without the optional left bracket between the escape
and the escape command character.
Arguments to the escape command are decimal character strings
separated by a semicolon.
The following subset of the ANSI standard escape sequences 
is decoded by the SUN VGTS terminal emulator:@index(Terminal Emulator)
@begin(description)
BELL@\Causes some form of audio feedback (buzzer, bell, etc.)@index(Bell)
if possible, and flashes all the views of the AVT.

TAB@\Positions the cursor at next multiple of eight@index(Tab)
(plus one) columns,
erasing characters between the current cursor position and the new position.
@b(WARNING: this behavior is not VT100 compatible and is subject to change.)

FF@\Clears the AVT.@index(Clear AVT)

CR@\Returns the cursor to the first column of the current line.@index(Return)

LF@\NewLine -- Moves the cursor down one line.@index(New Line)
If it is at the last line of the scrolling region, all lines
in the region move up (scroll).

BS@\Cursor moves backwards one space.@index(Backspace)

SO@\Shift Out -- Select the G1 character set.@index(Shift Out)
Currently ignored.

SI@\Shift Out -- Select the G0 character set.@index(Shift In)
Currently ignored.

NUL@\Null -- ignored; may be used for padding.@index(NUL)

DEL@\Delete -- ignored; may be used for padding.@index(DEL)

ESC A@\CursorUp -- move the cursor up one line.@index(Cursor Up)

ESC [@i(i) A@\CursorUp -- move the cursor up @i(i) lines.@index(Cursor Up)

ESC B@\NewLine -- move the cursor down, as with LF.@index(New Line)

ESC [@i(i) B@\NewLine -- move the cursor down the @i(i) lines.@index(New Line)

ESC C@\CursorForward -- move@index(Cursor Forward)
the cursor forward, but do not overwrite the
character at the current position.

ESC [@i(i) C@\CursorForward -- move@index(Cursor Forward)
the cursor forward @i(i) character positions.

ESC D@\Index -- scroll the current scroll region up one line.@index(Index)
@b(WARNING: this behavior is not VT100 compatible and is subject to change.)

ESC [@i(i) D@\CursorBackward -- move the@index(Cursor Backward)
cursor backwards @i(i) character positions.

ESC E@\Next Line -- move the cursor down one line,@index(Next Line)
but if it is at the end of the region, scroll the region up (Index).

ESC [@i[l];@i[c] f@\CursorPosition -- Move@index(Cursor Position)
the cursor to line @i[l], column @i[c].
The lines and columns start from the upper left, which is (1,1).
Specifying zero or leaving an argument blank is equivalent to
a value of 1.  Thus ESC[f alone will "home" the cursor to the upper left.

ESC H@\Ignored. Used by some terminals to set tab stops.@index(Ignored)

ESC [@i[l];@i[c] H@\CursorPosition -- same@index(Cursor Position)
as ESC f.

ESC J@\ClearToEOS -- clear@index(Clear To EOS)
from the current cursor position to
the end of the AVT.

ESC [@i[n] J@\Clear -- if@index(Clear)
the argument is 2, clear the entire AVT.
Otherwise, clear to end of AVT.

ESC K@\ClearToEOL -- clear@index(Clear To EOL)
from the cursor to the end of the current line.

ESC L@\InsertLine -- insert@index(Insert Line)
a line at the cursor position.
All the lines below and including the current one are moved down.
The bottom line goes away.

ESC [@i[n] L@\InsertLine -- insert@index(Insert Line)
@i[n] lines at the cursor position.

ESC M@\ReverseIndex -- move the scroll region down one@index(Reverse Index)
line. The top line in the scroll region becomes blank.
@b(WARNING: this behavior is not VT100 compatible and is subject to change.)

ESC [@i[i] M@\DeleteLine -- delete@index(Delete Line)
@i(i) lines starting from the line that the cursor is on, and
move all lines below them  up.

ESC P@\DeleteChar -- delete@index(Delete Char)
the character at the cursor position, moving
all the rest of the characters in the line to the left one column.

ESC [@i[i] P@\DeleteChar -- delete@index(Delete Char)
@i(i) characters, starting from the one under the cursor.

ESC @@ @\InsertChar -- move@index(Insert Char)
all the characters to the right of the
cursor to the right one column.
A space appears at the cursor position.

ESC [@i[i] @@ @\InsertChar -- Insert@index(Insert Char)
@i(i) characters at the cursor position.

ESC [@i[i] m@\If the value of the argument is non-zero,@index(Inverse Video)
standout mode is turned on, which will mean characters appear
in reverse video.
A zero argument resets to normal video.

ESC [@i[t];@i[b] r@\Specifies@index(Scroll Region)
the top and bottom lines of a scroll region.
This is used in the Index and ReverseIndex commands.

ESC < @\Enter ANSI mode.@index(ANSI)
Currently it is ignored, since AVTs are always in ANSI mode.

ESC ) @i(c) @\Select G0 character set.@index(Character Set)
Currently it is ignored.

ESC ( @i(c) @\Select G1 character set.@index(Character Set)
Currently it is ignored.
@end(description)

The default size of an AVT is 28 lines
by 80 columns.
This terminal type is just a 28 line VT-100, with a few additional
escape sequences as described above.
On (Stanford) Unix 4.2 systems, this corresponds to the terminal type
@t[vgts] (or @t[vgts28]).  (Other common AVT sizes are also supported in the
Unix @i[termcap] file, 
namely @t[vgts24], @t[vgts48] and @t[vgts54].)
For TOPS-20, the command @t[term VT100] will work.
On the SU-AI @c[WAITS] system, the 
@t(.tty sun 28 80)
command can be used
for display service.


@section(VGTS Message Interface)

This section describes the internal message interface to the VGTS.

@SubSection[I/O protocol requests]
The following requests of the I/O protocol (see section @Ref[IOprotocol])
are supported:
@begin(description)
CREATE@us()INSTANCE@\Causes a new AVT to be created.@index(Create Instance)
The view manager will let the user decide where to put the
upper left corner of the AVT by changing the cursor and blocking the
process until the user clicks the mouse.
The file instances created are READABLE, WRITEABLE, VARIABLE@us()BLOCK
STREAMs.
The first two unspecified fields of the message (if non-zero) are the 
number of lines and columns in the new AVT.
The filename field of the message is used as the name of the virtual terminal.
Usually this is invoked only by the @t[OpenPad()]@index(OpenPad)
routine described in section @ref[VGTSlibc].

QUERY@us()INSTANCE@\Returns the standard values,@index(Query Instance)
the same as a Create Instance@index(Create Instance) reply.

WRITE@us()INSTANCE@\Write@index(Write Instance)
the bytes to the AVT corresponding to the
file instance.
Output conversions are performed if the appropriate ``Cooking''@index(cooking)
modes are set.

WRITESHORT@us()INSTANCE@\Same as WRITE@us()INSTANCE.@index(Writeshort Instance)

READ@us()INSTANCE@\Blocks@index(Read Instance)
until some characters are entered into the AVT.
If there are any characters already in the event queue for this AVT,
they are returned immediately.
Note that since the instance is VARIABLE@us()BLOCK, un unknown number
of characters can be returned, up to the blocksize.

RELEASE@us()INSTANCE@\The@index(Release Instance)
AVT is deleted, along with any views
of the AVT, and storage is reclaimed.
@comment(should allow only owner to do this)

SET@us()BREAK@us()PROCESS@\The@index(Set Break Process)
break process for each instance is the process which will be
killed if the view manager ``Kill Program'' command is invoked within the AVT.
@index(View Manager)@index(Kill Program)

SET@us()INSTANCE@us()OWNER@\Changes the (process) owner of the AVT.
@index(Set Instance Owner)
@end(description)

@SubSection[Workstation Agent Requests]
The following request codes (and associated message structures) are defined
in @t[<Vtermagent.h>]:
@begin(description)
QueryPadRequest@\Returns
the cooking mode bits for the AVT, as well as the AVT's width and height.
@comment(Why not use QUERY_FILE???)

ModifyPadRequest@\The AVT's cooking mode bits and/or size are modified.
The structure ModifyMsg describes the format of this message.
@comment(Why not use MODIFY_FILE???)

SwitchInput@\The@index(Switch Input)
specified AVT is selected for input.
This is used in the @t[SelectPad()] routine.@Index[SelectPad]

EventRequest@\The@index(Event Request)
first item from the event queue is returned to
the requester.
If the event queue is empty, the requester is blocked
until an event comes in for the given virtual terminal.

SetBannerRequest@\The specified virtual terminal's banner string is changed.  This request 
code is used by the @t[SetVgtBanner] routine.@Index[SetVgtBanner]

RedrawRequest@\The specified AVT is redrawn.

LineEditRequest@\The data in the message are treated as line editing 
commands, rather than simply being output to the AVT.  Note, however, that 
the line editor treats most characters as self-inserting (see 
section @Ref[LineEditing]).@Index[Line Editing]

GetRawIO@\The server and instance ids of the VGTS's own stdio are returned to
the requester.  The @t[newterm]@Index[newterm] 
command uses this code in order to determine what stdio to give the new
workstation agent.

Die@\This code requests the VGTS (or other workstation agent) to commit 
suicide.  This is used by the @t[newterm]@Index[newterm] command, as
a @i[temporary kludge only] (to circumvent current problems with the system's
user number and permission checking policy).
@end(description)

@SubSection[Other requests]
@begin(description)
SET@us()DEBUG@us()MODE@\Sets (or clears) debugging flags within the VGTS.  This code 
is used by the @t[debugvgts] command.@Index[debugvgts]
@end(description)


@section(Internal Organization)

The current VGTS implementation consists (logically) of the following
modules (`modules' in this description do not necessarily correspond to 
procedure names or source files):
@begin(itemize)
Master Multiplexor.
This is the only module which is operating system dependent.
Upon initialization, the appropriate process structure is set up.
The main loop consists of waiting for a message,
dispatching to the appropriate routine in the other modules,
and returning a reply.  
Synchronization problems are avoided by having
the data structures accessed only in one process.

Terminal emulator.
This module interprets a byte stream as if it were an ANSI
standard terminal.
Printable characters are added to text objects, and control
and escape codes are mapped into the proper SDF manipulations.

Input handler.
There are various device-dependent input handlers.
For example, a single process reads the keyboard and sends
typed characters to the multiplexor.
Another reads the mouse and tracks the cursor.

SDF manipulator.
This module handles requests of applications to create, destroy,
and modify graphical objects in structured display files.
These routines maintain bounding boxes for symbols, and
call the appropriate redrawing routines when necessary.
There is a hash table to locate items given their client names.

SDF interpreter.
These are the highest level redrawing operations.
The structured display files are visited recursively,
with appropriate clipping for bounding boxes totally outside the
area being redrawn.

Display operations.
These are the graphical operations called by the SDF interpreter.
They are generally device independent.

Drawing primitives.
There is one module which implements device dependent graphics
primitives.  It is conditionally compiled for different graphics devices.

Hit detection.
The structured display file is visited, but instead of actually
drawing the primitives, the positions are checked to match the
cursor's position.  
A list of possibly selected objects (under other optional constraints)
is returned to the application.

View manager.
This module allows the user to
create, destroy, and modify the screen layout, using the mouse.

Viewport primitives.
These are the routines which perform the view-changing
operations, invoked by either an application program or the user
through the view manager.
@end(itemize)

@subsection(Executive Interface)
@index(Exec)

The V-System is intended to be modular, so VGTS could conceivably be
used with an executive other than the standard one.
The VGTS module @t(execs.c) handles the Exec Control part of the
view manager command.
It starts up new executives as new processes on the same
team, using the @t[CreateExec()] library routine.@Index[CreateExec]
The Executive calls the 
functions @t[SetVgtBanner(file, banner)]@index(SetVgtBanner)
and @t[SetBreakProcess(file, pid)]@index(SetBreakProcess)
as commands are executed.

@subsection(Frame Buffer Interface)

The device-dependent parts of the VGTS currently reside in the files
@t[draw1.c] and @t[draw2.c].
The @t[gl@us()...()] macros form the interface to the underlying
graphics device.
These macros are defined in the include files @t[gl@us()sun100.h] and
@t[gl@us()sun120.h].  (Which include file is used depends upon which version of
the VGTS is being compiled.)

@Section[Debugging the VGTS]
@Index[debugvgts]@label[debugvgts]
The @t[debugvgts] command allows the user to obtain a trace of certain events 
within the VGTS.  The command syntax is
@begin(programexample)
@t[debugvgts]@ @i[<debug code>]@ @i[<VGT #>]
	or
@t[debugvgts]@ @t[trace]@ @i[<VGT #>]
@end(programexample)
In the first form, the debug code
(interpreted as a hexadecimal number) 
is a disjunction of bit flags taken from 
those defined in the system header file @t[<Vgtp.h>].  @i[<VGT #>] is the 
number of a text VGT to which
debugging output is to be redirected.
If this number is not that of a valid text VGT, then debugging output is 
directed to the VGTS's stdout (the console) instead.
Once VGTS debugging has been turned on, it can be
turned off again using a debug code of 0. A debug code of 0 is also useful
for redirecting trace output as explained below.

In the second form of the @t(debugvgts) command,
the top-level symbol associated with @i[<VGT #>] is
dumped in a symbolic textual
form to the current output (as declared in the first
form.) This is useful for debugging programs that use the graphics
capabilities of the VGTS as well as debugging the internals. if @i[<VGT #>]
is positive, then interactive mode is used, and the trace routine pauses
after each item listed. If it is negative, then the top level symbol of
the VGT specified by the absolute value of @i[<VGT #>] is 
dumped without pausing.

