@part(TermAgent, root "manual.mss")
@Chapter(Workstation Agents)
@label(Workstation Agents)

Workstation agents are a generic class of server used in the V-System.
A workstation agent has the duty of mediating between the workstation
hardware, the user, and the other programs in the system.  It is
responsible for line editing functions,e.g. the fact that the back
space key does not add a backspace character to the input stream but
deletes a character from the input stream.  It translates the newline
character '\n' into a carriage return/linefeed sequence on workstations
that require it.  It is also responsible for interacting with the exec
server to create at least one executive, or providing means for the
user to do so.  It may, but need not, support multiple i/o streams.
Workstation agents may differ for two reasons: because they are designed
to offer different services to the user, or because they are designed
to run on different types of workstations.

The V system currently contains two different workstation
agents, the Simple Terminal Server (STS) and the Virtual Graphics
Terminal Server (VGTS).  The Simple Terminal Server is a minimal
workstation agent.  It provides a single i/o stream, using the terminal
facilities provided by the kernel console device, and
creates one executive using that i/o stream.  The standard V line
editing interface is provided, but no mouse or graphics facilities are
available.  The Virtual Graphics Terminal Server, in contrast,
provides a very large set of facilities: multiple i/o streams in
multiple windows, graphics, and mouse-controlled menus. But it
supports the same line editing facilities.  A large class of programs
should be able to run under either of these workstation agents, or any
other workstation agent, without any knowledge of which workstation agent is
present.

The @b[newterm] command allows the user to replace the workstation agent
on his workstation without rebooting the workstation.

@section(Implementation of Workstation Agents)

These are the requests that should be supported by a workstation agent,
at the minimum:
@begin(itemize)
It should support the V I/O protocol for @t(INTERACTIVE@uf()STREAM) files.  
In simple cases, it may give polite replies to
CREATE@us()INSTANCE and RELEASE@us()INSTANCE without really doing anything, as
the STS does.

It should support the @t[QueryPadRequest] and @t[ModifyPadRequest] 
messages in the
fashion expected by @t[QueryPad()] and @t[ModifyPad()].
In
particular,@t[ModifyPad(file, 0)] should turn off all ``cooking'', 
giving the client access to the raw, unadorned terminal.
@end(itemize)

In addition, the following conventions should be observed, in order to allow
the @t[newterm] command to work: 
@begin(itemize)
Upon starting up, the workstation agent should
join the local workstation agent group.

It should 
support the @t[Die] request message, which is a polite way of asking the
workstation agent to expire.
@end(itemize)

