@Part( team, root "manual" )
@Chapter(Team Server)

@section(Overview)

The team server manages the teams of a host.@index(team server)
(Teams usually correspond to
programs_although a program may consist of more than one team.)
Specifically, it performs the following functions:
@begin(itemize)
Accepts requests to load teams.@index(team loading)
Requests can originate both locally and 
remotely, with the team server deciding 
whether or not remote execution requests 
will be accepted.

Accepts requests to
terminate teams.

Implements a directory of all currently running teams.  This directory can be 
read using the standard directory listing protocol.

Implements round-robin scheduling for teams.@index(round-robin scheduling)
@index(foreground)@index(background)@index(guest)Teams can be run 
in @i[foreground], @i[background], or @i[guest] mode.  Typically, locally 
invoked programs are run either in foreground or background mode.
Remotely executed programs are @i[only] allowed to run in guest mode, which 
is lower in privilege than either foreground or background mode.  The team 
server also provides 4 real-time priority classes that run ahead of the three 
round-robin classes, and a "stopped" priority that ensures that no process on 
a stopped team will run.

Registers itself as the exception handler ``of last resort.''  The exception 
server forwards process exception messages to the team server if no one else 
has registered themselves for them.  The team server invokes a postmortem 
debugger on the team of the process that incurs an exception.

Responds to host state information requests.@index(host selection)
@index(remote execution)@index(host status)
This is the mechanism upon 
which host selection for remote execution of programs is based.

Acts as an agent for migration of logical hosts (i.e. remotely executed guest 
programs).
@end(itemize)
 
The team server resides on the ``first team'' of a host, i.e., it is
considered to be a system
server that is always present on a host and is loaded
automatically when a host is booted.  Various operations that the team server 
performs, such as team creation and team execution priority setting, are 
privileged operations that only processes on the first team may 
perform.

@section(Team Loading)

The team server is the only process that may create and load new teams.  The 
library routines @t[LoadProgram] and @t[ExecProgram] provide the user 
interface to this function.@index(LoadProgram)@index(ExecProgram)
These package up
an appropriate request to the team server and take care of matters such as
setting up the team environment block.  The team server
only creates a new team and loads down its object code from a designated
open file instance.  Setting up parameters and setting initial execution
priority and stack size is left to the team load requestor in order to allow
control over the order of events.  This is necessary for programs such as
debuggers which wish to allow users to set breakpoints and examine the code
before a team actually starts to run.

Load requests to the team server also specify who the ``owner'' of a team is.
Teams are destroyed if their owner process goes away (same semantics as for
processes created by other processes).  Teams can optionally be specified to
be owned by themselves, thus permitting them to outlive their
load requestors.@index(team ownership)

Teams owned by the themselves are run in background mode, all others are run 
in foreground mode.


@section(Team Termination and Exit Status Values)

A teams can be terminated by having its root process destroyed using 
the @t[DestroyProcess] kernel operation,
or it can exit voluntarily by calling
the @t[exit()] library routine or returning from @t[main()].

Calling @t[exit()] or returning from @t[main()] allows
an exit status to be 
associated with the terminating team.
Note: By convention, teams that are destroyed without having called
@t[exit()] or returned from @t[main()] are considered to have
exit status -1.

The team server also terminates any teams whose owners have died.  It
uses a timer process to periodically query the
state of all teams which the server thinks are still running and their 
owners.

@section(Host Status)

The standard context
directory listing protocol (see section @ref(ContextDirectories))
can be used to obtain information on
all teams that are currently running.
The command
@programexample(listdir [team/local])
lists teams running on the local host, while
the command
@programexample(listdir [team/@i[hostname]])
lists teams running on the named host.

To obtain
information on a specific team only, an NREAD@us()DESCRIPTOR
request can be made.
The command
@programexample(listdesc [team/local][bin]telnet)
prints information about a program running locally
that was invoked under the name @t{[bin]telnet}.
The team of interest can also specified by setting
the request message's @i[contextid] field to the team's root process id;
in this case
the CSname (character string name) in the message should be null.

The team server also keeps track of host resource information such as the 
number of teams running, processor utilization, memory resources available, 
etc.  It returns this information to requests it receives for host status 
information.  These request messages are used primarily to implement host 
selection for remote execution of programs.  Request messages can specify
resource requirements and the team server will only 
reply if its resource state information conforms to the specified
requirements.  Request messages are typically sent to the well-known process 
group of all team servers (see include file @t[Vgroupids.h]), although they 
can be sent directly to a particular team server.  (See the library 
routine @t[QueryHosts] for more details on remote host selection.)
The command 
@programexample(listdir [team/@i[hostname]])
lists all team servers (and hence all hosts) on the network.

@section(Remote Execution)

The implementation of the team server and team-loading library routines is
such that load requests can be made to both local and remote team servers,
thus allowing for transparent remote execution of V programs.  In order to 
assure the priority of local requests the team server keeps track of the 
state of the local host and uses this information to 
determine whether or not a remote load request will be accepted.

Currently the system's host selection facilities will not select hosts on 
which a user has logged in.  However, remote execution requests may 
still be sent to the team servers of such hosts and they will be accepted.  
This policy allows debugging programs to be executed on a host even when it 
has ``hung'' with a user logged in.  The policy depends on the goodwill of 
users to not circumvent the standard host selection facilities.  The -x 
option of the @t[login] command can be used to disallow all remote execution 
requests.


@section(Round-Robin Scheduling)

The team server implements a round-robin scheduling scheme for all teams 
except the first team and the workstation agent team
(typically either the @c[vgts] or 
the @c[sts]).  These are typically run at real-time priority levels 3 and 4 
respectively.
As mentioned, teams can be run either in foreground,
background, or guest mode.  
Foreground teams have priority over background teams, which have priority 
over guest teams.

Scheduling actually employs an additional team priority value for its 
implementation: a higher (i.e. more privileged) running priority.
The running priority is used to implement the concept of 
a ``time-slice'' so that one team can't block out all other teams of the same 
priority.

Team priorities are user-settable with the 
@t[ChangeTeamPriority] operation, 
which allows users to request that the priority class of a team be changed, 
subject to authorization privileges.  Users may change the priority of any 
team on a workstation they are logged in to, even if 
the @t[ChangeTeamPriority] request is sent from a remote location.  Guest 
users of a machine cannot change their priority to anything other 
than @i[guest] or @i[stopped].


@section(Exception Handling)

The team server is the exception handler of ``last resort.''  It invokes the 
standard debugger in ``postmortem mode'' on the team of a process that has 
incurred an exception.

The debugger is invoked
with the @t[-d] flag, so if the VGTS is in use, the debugger
will pop up a new window for its command interaction.
If the VGTS is not running on the workstation, however,
the debugger will use the
same standard 
I/O as the root process of the team that has incurred the exception,
and may thus
come up in a state where it is competing with an input reader process in the 
team incurring the exception.  This can prevent input from reaching the 
debugger, in which case the debugger will not be of much use.


@section(Migration)

The team server's duties also include acting as an agent for migration.  If a 
logical host is to be migrated from another machine then the team server must 
first accept the request and then act as a local agent for its 
implementation.  Implementation includes setting up initial descriptor 
information in the local kernel and team server, and then participating in 
the transfer operation of the actual descriptor information.

The team server also implements usage policies with respect to migrating 
guest logical hosts (i.e. remotely invoked guest programs) away from the 
local machine.  The current usage policy is to migrate guest programs 
whenever a user logs into the machine.
