@Part( STServer, root "manual" )
@Chapter(Simple Terminal Server)
@label(STS)

The Simple Terminal Server (STS) is a minimal terminal agent.  It does not use
graphics, and it takes up less memory than the VGTS.  Only one I/O stream is
supported.  A program that wants to
do graphics directly on the SUN hardware, not mediated by the VGTS, should
be run under the STS.

The STS creates one executive.  If this executive is ever destroyed, by
encountering end of file or by other means, it will be replaced within a
second or so.  Such a replacement can be forced by the sequence
control-^ x.  A program running under the executive can be killed by
control-^ k.  The normal ^Z and ^C commands also work, but they can be
disabled by @t[ModifyPad()] requests, while the control-^ sequences cannot be
disabled.

@section(STS Line Editing Facilities)
@label(STSLineEditing)@index[Line Editing]@index(STS line editing)

The STS provides a superset of the line editing facilities that are provided
by the VGTS.
All @t[ModifyPad()] bits that are not related to the mouse work as they do
under the VGTS:  @b(CR@us()Input), @b(LF@us()Output), @b(Echo), @b(Linebuffer),
@b(PageOutput), @b(PageOutputEnable), and @b(DiscardOutput).

As well as the line editing commands described in section
@Ref[LineEditing], the STS also supports the following commands:

@Begin(description)
CTRL-l@\Re-display the input buffer.@index(Re-Display Input)@index(CTRL-l)

CTRL-n@\Move cursor down one screen line.@index(Cursor Down)@index(CTRL-n)

CTRL-p@\Move cursor up one screen line.@index(Cursor Up)@index(CTRL-p)

CTRL-q@\Quote next character.  Control characters are displayed as `^C'.
@index(Quote Character)@index(CTRL-q)

CTRL-y@\Move the contents of killbuffer into the input buffer,
inserting at the current
cursor position.@index(Un-Kill)@index(CTRL-y)

CTRL-\@\Insert next character with the eighth bit set.  Character is displayed
as '\nnn', where nnn is the octal representation of the character code.
@index(Insert With Eighth Bit Set)@index(CTRL-\) 

ESC-,@\Move cursor to the beginning of the input buffer.
@index(Beginning of Buffer)@index(ESC-,)

ESC-.@\Move cursor to the end of the input buffer.
@index(End of Buffer)@index(ESC-.)

ESC-@c(backspace)@\Same as ESC-b.@index(ESC-@c(backspace))

ESC-d@\Kill from the cursor to the end of the current word.
@index(ESC-d)@index(Kill Word Forward)

ESC-@c(del)@\Same as ESC-h and CTRL-w.@index(ESC-@c(del))

ESC-t@\Transpose the two words preceding the cursor.
@index(ESC-t)@index(Transpose Words)
@End(description)


@section(Hardware Environment)
@label(STSHardwareEnvironment)@index(STS hardware environment)

The STS communicates with the user via the kernel console device.  If the
workstation has a framebuffer, characters are sent to the terminal emulator
built into the workstation's PROM monitor; otherwise, characters are sent
through serial line 0 to a character terminal.

The attached terminal or terminal emulator must understand the escape
sequences sent to it by the STS for cursor positioning.  The STS currently
works properly with the following terminal emulators and terminals:

@begin(itemize)

Any PROM monitor terminal emulator that supports ANSI standard escape
sequences, e.g., the SMI PROM monitor.

Cadlinc PROM monitor terminal emulator.

Any character terminal that supports ANSI standard escape sequences, e.g.,
VT100 or Heath-19 in ANSI mode.

@end(itemize)

@section{Remote Terminal Server}@label(RTS)@index(telnet)

The Remote Terminal Server (RTS) supports the same interface as the STS, but 
encapsulated in the ARPA TELNET Protocol; its standard input and output are 
normally a TCP connection opened by the telnet server (p. @ref{telnetserver}).
Like the STS, the RTS uses execs created by the local exec server; this may 
lead to difficulties if there is another telnet or local user on the same 
host, as the exec server assumes it serves only one user at a time.

The RTS violates the standard protocol on two points:  it insists on 
echoing input (under the control of client programs) even if the ECHO option
is not successfully negotiated, and it does not send go-aheads as may be 
required by some hosts to support half-duplex terminals.  These violations
are typically not a problem in paractice, as most user Telnet implementations 
support these options.  All other options are properly refused.

The RTS works with the Heath-19 terminal (in ANSI mode), the VAT provided 
by the VGTS, the SMI PROM monitor, and possibly others.
