@string(LastEditDate="")

@Part(messages, root "manual" )
@Chapter(Message Codes and Format Conventions)
@label(Messages)

This chapter describes the standard message formats and codes used
throughout the V-System.

@section(Message Format Conventions)
@Index[Message Format Conventions]

System server protocols obey several system-wide conventions.
Every request message contains a 16-bit request code@Index[request code]
indicating the service requested.
Similarly, every reply message contains a 16-bit code@Index[reply code]
indicating the
successful completion of the request's execution or the reason that the
request was not executed normally.
A requesting process can assume that the request has been completely 
executed when the reply message is received with a successful reply code
(although in cases such as disk write-behind this may not be strictly
true).

@section(Byte-Ordering Considerations)
@index(Byte order)@index(Byte-swapping)@index(Big-endian)@index(Little-endian)

V may run on a mixture of Suns and VaxStations.  The former contain Motorola
680x0 processors which use the first (lowest-addressed) byte of a 16-bit or
32-bit quantity to store the most significant byte of the quantity
("big-endian"), while the latter use VAX-architecture processors which store
the least significant byte first ("little-endian").  When processes running
on the two architectures exchange messages, some conversion must be done (if
messages included floating-point or other highly architecture-specific data,
considerably more conversion would be necessary; to date, however, only
16-bit and 32-bit integers have been required).

The kernel, servers, include-files and library routines have been altered to
perform the appropriate conversion (byte-swapping) for all code in the V-System
distribution.  However, anyone who implements a server or who uses 
message-passing that does not fit the client-server model should be aware of
how byte-swapping is done.

The kernel always sends inter-kernel packets in its own byte order.  A kernel
which receives an IKC packet must determine the byte order of the packet and,
if necessary, byte-swap the packet, including the message contained therein
(see @t[IKC@uf()LITTLE@uf()ENDIAN]@index(IKC@us()LITTLE@us()ENDIAN), 
@t[DifferentIKCByteOrder]@index(DifferentIKCByteOrder) and 
@t[SwapIKPacket]@index(SwapIKPacket) in @t[Vikc.h]).  Currently, the kernel swaps the
message as though every message were eight longwords, and treats any segment
as a stream of bytes (hence does nothing to the segment).

Any further swapping of the message must be done by a process.  We have adopted
the policy that a client sends messages and gets replies without regard to byte
order.  It is then the responsibility of the server to perform any necessary
swapping of requests and replies.  The server can always determine the byte
order of the message's sender because it is encoded in the sender's logical
host id (see @t[LITTLE@uf()ENDIAN@uf()HOST]@index(LITTLE@us()ENDIAN@us()HOST) and
@t[DifferentByteOrder]@index(DifferentByteOrder) in @t[Venviron.h]).  The
server must, of course, take account of swapping performed by the kernel.

In many cases it is not actually necessary for the process to byte-swap
messages at runtime; rather, the struct definition for the message can be
#ifdefed for big- and little-endian architectures so that 8- and 16-bit fields
automatically end up in the right place.  The MicroVAX C compiler #defines
@t[LITTLE@uf()ENDIAN]@index(LITTLE@us()ENDIAN) for this purpose; the 680x0 C
compiler does not.  The definition of a @t[Kernelrequest] in @t[Venviron.h]
demonstrates the use of @t[LITTLE@uf()ENDIAN].

@section(Standard System Request Codes)

Each system request is allocated a unique request code to be placed
in the first word of the request message when requesting that service.
The request codes obey the message format conventions imposed by the kernel,
as described for @t[Send()] in Chapter @ref(Process).
The manifest constant definitions for these request codes are defined
in the standard C include file @t[Venviron.h].@index(Venviron.h)

@section(Standard System Reply Codes)
The reply code returned in a message from a server is normally one of the 
following standard system replies:

@begin(Description)
@comment{I carefully alphabetized these, except for OK.
Please keep them that way when adding more.  --TPM}

OK@\Operation successful.@index(OK)

ABORTED@\An operation was aborted.  For example, a@index(Aborted)
network connection that has been aborted returns this code.

AWOKEN@\Returned by the kernel
server when a Delay request was terminated  by a Wakeup.  (It is @i[not]
returned by the Delay library routine, however.)@index(Awoken)

BAD@us()ADDRESS@\Request contains an invalid memory@index(Bad Address)
address.

BAD@us()ARGS@\Request contains field(s) with@index(Bad Args)
illegal or inconsistent values.

BAD@us()BLOCK@us()NO@\The block number specified@index(Bad Block No)
in an I/O request
does not specify an existing block. 
If the file instance has attribute STREAM,
the block number does not specify the block
which is sequentially next in reading or 
writing.

BAD@us()BUFFER@\A buffer specified in the request lies@index(Bad Buffer)
(perhaps partially) outside the client's address space.

BAD@us()BYTE@us()COUNT@\The@index(Bad Byte Count)
byte count is larger (or smaller) than that
supported by the server.
On a file instance without the
MULTI@us()BLOCK attribute, this is
returned if the number of bytes 
requested to read or write is greater
than the block size.

BAD@us()FORWARD@\BAD@us()FORWARD is returned by the kernel when
a Send is unblocked due to the receiver issuing an invalid @t[Forward]
kernel operation.
@index(Bad Forward)

BAD@us()PROCESS@us()PRIORITY@\The request@index(Bad Process Priority)
specified an illegal value for a process priority.

BAD@us()REPLY@us()SEGMENT@\If a process 
invokes @t[ReplyWithSegment()] with a
segment to which it does not have write access,
the kernel sets the reply code of the message returned
to the sender to BAD@us()REPLY@us()SEGMENT.

BAD@us()STATE@\Request invalid at this time.@index(Bad State)

BUSY@\The server cannot satisfy the request at this time,@index(Busy)
probably because a single-user resource is already allocated to another
client.

DEVICE@us()ERROR@\File or@index(Device Error)
device-dependent error has occurred.

DUPLICATE@us()NAME@\The request attempted to assign@index(Duplicate Name)
the same name to two different objects.

DISCARD@us()REPLY@\This reply code is used with the @t[Reply()] primitive
when the process receiving a message does not wish to reply.
Reply messages containing this reply code are never 
delivered.@index(Discard Reply)

END@us()OF@us()FILE@\Attempt@index(End of File)
to read beyond file boundaries.

HAS@us()SUBSTRUCTURE@\Returned by the storage server when a client attempts
to remove a file that has a son in the directory tree.  The attempt fails.
@index(Has Substructure)

ILLEGAL@us()NAME@\Returned
by a server that deems a name to be illegal_for example, the name might
be too long.
@index(Illegal Name)

ILLEGAL@us()REQUEST@\Invalid request code.@index(Illegal Request)
The request was probably sent to the wrong type of server,
one which could not perform that function.                    

INTERNAL@us()ERROR@\The server detected an@index(Internal Error)
inconsistency in its own state.  This error code may indicate a bug in the
server.

INVALID@us()CONTEXT@us()ID@\The
request contained a context@index(Invalid Context)
identifier (see chapter @ref(NamingProtocol)) that was invalid.

INVALID@us()FILE@us()ID@\The request contained an@index(Invalid File Id)
invalid file instance identifier.

INVALID@us()MODE@\The mode specified as part of a@index(Invalid Mode)
CREATE@us()INSTANCE request is not valid.

IO@us()BREAK@\Returned from interactive files when the
user hits the BREAK (Ctrl-C) key.  It currently isn't.@index(IO Break)

KERNEL@us()TIMEOUT@\A timeout occurred in the kernel when trying to
send to a remote process.@index(Kernel Timeout)
This error differs from NONEXISTENT@us()PROCESS in that the sending kernel did
not receive a negative acknowledgement from the remote kernel, but for
most purposes it can be handled in the same way.  This error code is
only generated by the kernel, but may be passed on by other servers.

MODE@us()NOT@us()SUPPORTED@\The@index(Mode Not Supported)
mode specified as part of a 
CREATE@us()INSTANCE request is not 
supported by this server.

MORE@us()REPLIES@\An operation request sent to a group
was successful, and the
client should use @t[GetReply()] to check for additional replies
from other group members.@index(More Replies)

MULTI@us()MANAGER@\The requested@index(Multi-manager)
operation is not supported on multi-manager objects.

NO@us()GROUP@us()DESC@\Returned when the kernel runs out of group
descriptors.@index(No Group Desc)

NO@us()MEMORY@\The server was not able to obtain enough @index(No Memory)
memory to satisfy the request.

NO@us()PDS@\@index(No Process Descriptors)The server was not@index(No PDs)
able to create a process needed to satisfy the request.

NO@us()PERMISSION@\Some kind of restricted operation@index(No Permission)
was attempted.

NO@us()SERVER@us()RESOURCES@\The@index(No Server Resources)
server has (temporarily) inadequate resources to satisfy the request.

NO@us()TDS@\@index(No Team Descriptors)The server was not@index(No TDs)
able to create a team needed to satisfy the request.

NOT@us()A@us()CONTEXT@\@index(Not a Context)The request asked 
the server to perform 
an operation that is only defined on contexts,
but the specified object was not a context.

NOT@us()HERE@\@index(Not Here)The character-string@index(Not Here)
name specified in the request does
not specify an object implementing by the receiving server,
but may be defined by some other server.
This reply code is never returned to a message sent to a process group
unless the replier knows that no member of the group implements the name.

NONEXISTENT@us()PROCESS@\The request was sent or@index(Nonexistent Process)
forwarded to a nonexistent process, or a nonexistent process was specified
in the request.  This error code is only generated by the kernel,
but may be passed on by other servers.

NONEXISTENT@us()SESSION@\The request referred to@index(Nonexistent Session)
a session (see chapter @ref(UnixServer)) which does not exist, or to an
object which is not a session.  @i[Obsolete.]

NOT@us()AWAITINGREPLY@\The process specified in a@index(Not Awaiting Reply)
request was not awaiting reply from the client.

NOT@us()FOUND@\The object named in the request was not found.@index(Not Found)

NOT@us()READABLE@\Specified file instance@index(Not Readable)
does not have the 
attribute READABLE which is required for
the requested operation.

NOT@us()WRITEABLE@\Specified file instance does@index(Not Writeable)
not have the 
attribute WRITEABLE which is required for
the requested operation.

POWER@us()FAILURE@\Operation was unsuccessful due to a power
failure.@index(Power Failure)

REQUEST@us()NOT@us()SUPPORTED@\The server@index(Request Not Supported)
recognizes the request, but does not support it.

RETRY@\Client should repeat request.@index(retry)

RETRY@us()UNICAST@\The request@index(Retry Unicast)
was sent to a group, but the responding server refuses to perform
it in parallel with other members of the group.
The client should retry the request, this time as
as a one-to-one @t[Send()], not a multicast.

SERVER@us()NOT@us()RESPONDING@\The server@index(Server Not Responding)
failed to receive a response from another server specified in the request.

TIMEOUT@\An attempt to satisfy the request failed because of a@index(Timeout)
timeout.  Usually applied to network connections.

@end(Description) 					
The @t[ErrorString()] function 
will return a character string version of
many of the system reply and request codes.
The string form is much more informative than printing the codes in 
numeric form.


