@part( ioprotocol, root "manual" )
@Chapter(The V-System I/O Protocol)@index(I/O Protocol)@Label[IOprotocol]

A standard input/output protocol is defined in V to
provide transfer of data between processes in a uniform fashion.
Using this protocol,
a @i[client] process views and accesses data managed by a @i[server]
process as a @i[file].
A file is a ``view'' of the data associated with an object or activity
managed by a server.
An object viewed as a file is a sequence of variable-size records or 
@i(blocks).@index(blocks)

To operate on an object viewing it as a file, it is necessary to create
an @i(instance) of that file.
The protocol is @i(object-based) in
the sense that it is defined in terms of 
operations on a object, the file instance.
File instance operations include:  creating a file instance, querying a
file instance, setting the file instance owner, reading, writing, and
releasing file instances.
There are also operations for setting a prompt string and break process
associated with a file instance which are restricted to interactive
file instances.
A server that supports this protocol is called an I/O server or file
instance server.
(The term ``file server'' might be more appropriate if it did not have a
different established meaning in the research literature on distributed
systems).

A file instance is created by a server in response to a client request,
which specifies the file, i.e. the object or data and the particular
view and usage required.
Conceptually, a file instance is an object which is created at the time of
the client's CREATE@us()INSTANCE request, and (possibly) initialized to contain
the same data as an existing, permanent file.  When the instance is released
by the client, the data contained in the instance is atomically written back to the
corresponding permanent file.  For some servers (for example, the
internetwork server), 
however, there is no
permanent file corresponding to an instance, while for others (for example,
the device server),
there is effectively no
distinction between the instance and the permanent file_changes in the
instance are immediately reflected in the underlying file or I/O device.
The current implementation of
some storage servers (e.g., the V Unix server) also causes 
changes
in an instance to be immediately reflected in the underlying
file.

A file instance is uniquely identified by the server process identifier and
the @i(instance identifier) returned by the CREATE@us()INSTANCE
request.
The creating process is made the owner of the file instance.
The lifetime of the file instance and the validity of the instance
identifier does not exceed that of the owner of the file instance.
The owner of a file instance can be changed by the 
SET@us()INSTANCE@us()OWNER request.

The reply message to a CREATE@us()INSTANCE or QUERY@us()INSTANCE
request specifies the server, file instance identifier, block length in 
bytes, file type, last block (written) in the file instance,
number of bytes in the last block, and the next block to read.

The file @i(type) indicates the operations that may be performed
on the file instance as well as the semantics of these operations.
These types@index(File Types) are defined in the include file <Vio.h>;
@index(Vio.h)@index(Types)
file types are specified as some combination of the following
attributes.

@begin(Description)
READABLE@\@index(Readable)READ@us()INSTANCE operations are allowed on the file instance.

WRITEABLE@\@index(Writeable)WRITE@us()INSTANCE operations are allowed
on the file instance.

APPEND@us()ONLY@\@index(Append Only)WRITE@us()INSTANCE operations are only
effective to bytes in the file instance
beyond the last byte associated with the instance at the time it was created.

STREAM@\@index(Stream)@begin(Multiple)All reading and writing is strictly
sequential.
The first READ@us()INSTANCE
operation must specify the block
number returned as @i[nextblock]
in the reply to the CREATE@us()INSTANCE request.
This next block number
to read is incremented after each 
READ@us()INSTANCE operation.
Its current value is returned by a QUERY@us()INSTANCE.
A server that uses the @t[ReplyWithSegment()]
kernel operation to return the data requested in a READ@us()INSTANCE
must store the last block read and 
allow it to be read again, to provide duplicate suppression 
on requests.

WRITE@us()INSTANCE operations on STREAMs always write to
@i[lastblock]+1, where @i[lastblock] is a value
returned by CREATE@us()INSTANCE or QUERY@us()INSTANCE.
This block number is incremented after every
write operation.
The block number specified in the request message is ignored.

A file instance without the STREAM attribute stores its associated data for
non-sequential (``random'') access.  That is, on a non-stream file, for any
@i[n], block @i[n] may be read or written at any time, and reading block
@i[n] will return the same data as was last written to block @i[n].

Since each file models a single sequence of data blocks, 
objects which
provide bidirectional communication, such as serial lines or network
connections, are most appropriately modeled as a pair of file instances,
one a READABLE STREAM, the other a WRITEABLE STREAM.  Some servers may allow
both instances to be created by a single CREATE@us()INSTANCE request.
@foot{A
few existing servers bend this rule by assigning the same instance id to the
input and output streams, even though block number @i[n] of the input stream is
unrelated to block number @i[n] of the output stream.  Strictly speaking, this
behavior is in violation of the protocol,
and we plan to change these servers eventually.
A single STREAM that is both READABLE and WRITEABLE would have to return the
data written to block @i[n] if block @i[n] is later read back. This type of
file might be used to model a Unix-like pipe, but in fact, 
the V-System pipe server (see
chapter @ref[PipeServer]) takes a different approach,
creating a separate instance for
each end of the pipe,
with the connection between them invisible to the protocol.}
@end(multiple)

FIXED@us()LENGTH@\@index(Fixed Length)The file instance is fixed in length. 
The length is specified by the last block and last
byte returned from a create or query instance
request.
Otherwise the file instance grows to
accommodate the data written or else the length
of the file instance is not known (as in the
case of terminal input).

VARIABLE@us()BLOCK@\@index(Variable Block)@begin(multiple)Blocks
shorter than the full block size may be
returned in response to read operations other 
than due to end-of-file or other exception
conditions.
For example, input frames from a 
communication line may differ in length under
normal conditions.

With a file instance that is VARIABLE@us()BLOCK,
WRITEABLE, and not STREAM, blocks that are
written with less than a full block size number
of bytes return exactly the amount written when
read subsequently.
@end(multiple)

MULTI@us()BLOCK@\@index(Multi Block)Read and write operations are allowed that
specify a number of bytes larger than the block
size.

INTERACTIVE@\@index(Interactive)The file instance is a text line-oriented input
stream on which a prompt can be set using the
SET@us()PROMPT request and a break process can
be defined using the SET@us()BREAK@us()PROCESS
request.  
It also has the connotation of
supplying interactively (human) generated
input.
@end(Description)

Not all of the possible combinations of attributes yield a useful file type.
The file instance types supported by each server are documented with each
server.

A client must specify a mode of usage for the file instance when creating it.
The mode is one of FREAD, FCREATE, FMODIFY and FAPPEND.  
The modes of usage have@index(Modes)@index(File Modes)
the following semantics.

@begin(Description)
FREAD@\@index(FRead)No write operations are to be performed, only reads.

FCREATE@\@index(FCreate)Any data previously associated with the 
described file is to be ignored and a new
file instance is to be created.  Write 
operations are permitted; read operations
are also permitted if the file instance has
type attribute READABLE.

FAPPEND@\@index(FAppend)Data previously associated with the described
file remain unchanged.  
Write operations are
permitted only to append data to the existing 
data.

FMODIFY@\@index(FModify)Existing data is to be modified and possibly
appended to.  
Both read and write operations are required.  
This is only supported on file
instances that are not STREAM.
@end(Description)
A server creates a file instance of a suitable type for the specified 
usage mode if it can.  
For example, the storage server provides file
instances with type attributes READABLE, FIXED@us()LENGTH and
MULTI@us()BLOCK in response to a CREATE@us()INSTANCE request specifying
FREAD usage mode.

One of three modifiers may be used on the mode field of a
CREATE@us()INSTANCE request.
@begin(description)
FDIRECTORY@\@index(FDirectory)Indicates that the given name specifies a
context directory.  See section @ref(ContextDirectories).

FEXECUTE@\@index(FExecute)Specifies that the given file is to be executed
as a program
on the storage server machine.  The mode must be FREAD or FCREATE.
Respectively, one or two file instances are returned, which allow reading
from the program's standard output, and optionally (in FCREATE mode) writing
into its standard input.  When two instances are created,
the fileid of the second (readable) file instance is obtained
by adding 1 to the fileid of the writeable instance (which is returned in the
reply message).  This mode modifier need not be supported by all storage
servers.

@end(description)

The following subsections give the format of the request message and
the format of the reply, plus a description of the semantics for each
operation in the protocol.@index(Request Message Formats)
These message formats
are defined in the C include file <Vioprotocol.h>@index(Vioprotocol.h).

@section(CREATE INSTANCE)@index(Create Instance)

@Hbar(2 inches)
@begin(description)
requestcode@\CREATE@us()INSTANCE

filenameindex@\The index of the first byte in the filename
to use in the name mapping.

type@\Type of file to create an instance of, for servers that do not
support character-string naming.
This is used, for example, to specify
the protocol to the internet server.@foot{All newly written servers 
that provide the CREATE@us()INSTANCE operation should
support character string naming and should not use the @i[type] or
@i[unspecified] fields of the CreateInstanceRequest.}

filemode@\Desired usage mode indicating FREAD, FCREATE, FAPPEND or
FMODIFY, plus optionally FDIRECTORY or FEXECUTE.@index(Mode)

unspecified@\Server-dependent information specifying the file to
be created, for servers that do not support character-string naming.

contextid@\Specifies the context within the server in which the filename is
to be interpreted.  (See section @ref(ContextIds).)

filename@\Pointer to a byte array containing the symbolic name of
the server or file.

filenamelen@\Number of bytes in filename, not including
the terminating null byte.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply.  If the reply code is not OK,
the file instance was not created and the remainder of the reply is
not defined.

fileid@\File instance identifier.
This is the number used in subsequent operations on the file.

fileserver@\Process identifier of the server managing this file.
This is not necessarily the same as the 
id to which the request was sent.

blocksize@\Maximum size in bytes of a block.

filetype@\Type attributes of the file instance as described at the
beginning of this section.

filelastblock@\Index of the last block in the file or of the
last block written to the file instance if it is a STREAM file.
Indexing is 0-origin.

filelastbytes@\Number of bytes in the last block.
For file instances which are not WRITEABLE and
not FIXED@us()LENGTH, this field and the @i[filelastblock] field
should return the maximum unsigned integer.

filenextblock@\Number of the next block that can be read
if this file is a READABLE
STREAM.
@end(Description)
@Hbar(2 inches)

The @i[filename] field of a CREATE@us()INSTANCE request
specifies the type and properties of the instance to be
created, perhaps by naming some existing permanent object.
The request is issued either
directly to the server or sent 
to a group including the server, as described in section
@ref(NamingProtocol).

The @i[fileid] and @i[fileserver] uniquely identify the file
instance created.
The file instance exists until released or until the requesting
process ceases to exist.

@section(QUERY INSTANCE)@index(Query Instance)

@Hbar(2 inches)
@begin(description)
requestcode@\QUERY@us()INSTANCE

fileid@\File instance identifier.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\A standard system reply.
If the reply code is not OK, the file instance was not queried and the
remainder of the reply is not defined.

fileid@\File instance identifier, same as the request for
compatibility with the reply to the CREATE@us()INSTANCE request.

fileserver@\Server process identifier.

blocksize@\The maximum size in bytes of a block.

filetype@\Type attributes of the file instance as described at the
beginning of the section.

filelastblock@\Index of the last block in the file or the last
block written to the file instance if it is a STREAM file.
Indexing is 0-origin.

filelastbytes@\The number of bytes in the last block.

filenextblock@\Number of the next block that can be read if the
file is a READABLE STREAM.
@end(description)
@Hbar(2 Inches)

In response to a QUERY@us()INSTANCE request message,
the server queries the file instance specified by fileid for the
parameters supplied in the reply message.
The reply message has the same format and semantics as the reply
to a CREATE@us()INSTANCE request except for the reply code.
For example, a reply code of NOT@us()FOUND to a CREATE@us()INSTANCE
request indicates that the file specified does not exist, while
a reply code of INVALID@us()FILE@us()ID
to a QUERY@us()INSTANCE request indicates the file instance does not
exist.

@section(CREATE DUPLEX INSTANCE)@index(Create Duplex Instance)

@Hbar(2 inches)
@begin(description)
requestcode@\CREATE@us()DUPLEX@us()INSTANCE

fileid@\File instance identifier.

mode@\Desired usage mode.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\A standard system reply.
If the reply code is not OK, the file instance was not created and the
remainder of the reply is not defined.

fileid@\File instance identifier, same as the request for
compatibility with the reply to the CREATE@us()INSTANCE request.

fileserver@\Server process identifier.

blocksize@\The maximum size in bytes of a block.

filetype@\Type attributes of the file instance as described at the
beginning of the section.

filelastblock@\Index of the last block in the file or the last
block written to the file instance if it is a STREAM file.
Indexing is 0-origin.

filelastbytes@\The number of bytes in the last block.

filenextblock@\Number of the next block that can be read if the
file is a READABLE STREAM.
@end(description)
@Hbar(2 Inches)

In response to a CREATE@us()DUPLEX@us()INSTANCE request message,
the server creates (or causes to be created) the "other side" of a duplex
file (such as a bi-directional network connection, or a terminal).
The reply message has the same format and semantics as the reply
to a CREATE@us()INSTANCE request except for the reply code.
For example, a reply code of NOT@us()FOUND to a CREATE@us()INSTANCE
request indicates that the file specified does not exist, while
a reply code of INVALID@us()FILE@us()ID
to a CREATE@us()DUPLEX@us()INSTANCE request indicates the file instance
does not exist.

@section(RELEASE INSTANCE)@index(Release Instance)

@Hbar(2 inches)
@begin(Description)
requestcode@\RELEASE@us()INSTANCE

fileid@\File instance identifier

releasemode@\Server-dependent action to perform when releasing
the instance.
This field is set to zero on a normal close.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\A standard system reply code.
@end(description)
@Hbar(2 inches)

In response to a RELEASE@us()INSTANCE request, the
server invalidates the instance identifier, reclaims server resources
dedicated to the instance and possibly performs some server-dependent
function with the file instance data.
A @i[releasemode] of 0 indicates normal completion of the
use of the file instance.  
For example, in the case of the printer server, the file instance data is
printed.
In the case of the storage server, the data atomically replaces the
previous version of the stored file data.
A non-zero release mode causes the data to be discarded.

A server may release a file instance with a non-zero release mode
if it detects that the process that created the instance no longer
exists.
A server should maximize the time before reusing a file instance identifier.

@section(READ INSTANCE)@index(Read Instance)

@Hbar(2 inches)
@begin(Description)
requestcode@\READ@us()INSTANCE

fileid@\File instance identifier

@comment{I have been omitting garbage, filler, padding,
and other unused fields from the descriptions, as the 
descriptions do not give enough information to build a C 
struct or Pascal record anyway -- the types of the fields are
not given.  -- TPM

garbage@\5 words to put the next two fields in the last two 32-bit words of
the message.}

blocknumber@\Index of the block in the file from which the read is to begin.

bufferptr@\Address of the data buffer in which the data is to be
moved if more than IO@us()MSG@us()BUFFER bytes are read.
That is, IO@us()MSG@us()BUFFER is the maximum number of data bytes
that fit in the message.

bytecount@\Number of bytes to be read.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

fileid@\Same as in request.

shortbuffer@\IO@us()MSG@us()BUFFER bytes containing the data bytes read if
less than or equal to IO@us()MSG@us()BUFFER bytes.

bytecount@\Number of bytes read.
@end(description)
@Hbar(2 Inches)

In response to a READ@us()INSTANCE request, the 
server transfers up to @i[bytecount] bytes from the file instance
starting at the block numbered @i[blocknumber].
If the number of bytes read is less than the number requested, the
reply code indicates the reason.
If the file instance has the
type attribute VARIABLE@us()BLOCK and the block being read was not
the full block size specified for the file instance,
this case is not an error, and the reply may be OK,
or END@us()OF@us()FILE if the last block was read.
Servers should set the byte count to zero on error conditions.

If the number of bytes read is less than or equal to
IO@us()MSG@us()BUFFER, the data read is contained in the reply
message starting at @i[shortbuffer].
If it is greater than IO@us()MSG@us()BUFFER, the data read is
transferred into the space of the requesting process starting at the
address @i[bufferptr].

If the file instance has the type attribute STREAM, the block number
specified must be the next block to read for this instance,
which is incremented after the read.
Reads always start at the beginning of the specified block.
The values of bytes read that were not explicitly written are
undefined.
The number of bytes requested must be less than or equal to the block
size unless the file instance has the type attribute MULTI@us()BLOCK.

@section(WRITE INSTANCE)@index(Write Instance)

@Hbar(2 inches)
@begin(description)
requestcode@\WRITE@us()INSTANCE, or WRITESHORT@us()INSTANCE
if @i[bytecount] is less than or equal to IO@us()MSG@us()BUFFER.

fileid@\File instance identifier.

blocknumber@\Index of the block in the file instance at which the write
is to begin.

shortbuffer@\Data bytes to be written if less than or equal to
IO@us()MSG@us()BUFFER.

bufferptr@\Address of the data buffer if no more
than IO@us()MSG@us()BUFFER bytes are being written.
Otherwise, this field may be overwritten by the data bytes.

bytecount@\Number of bytes to be written.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

bytecount@\Number of bytes written.
@end(description)
@Hbar(2 inches)

In response to a WRITE@us()INSTANCE or WRITESHORT@us()INSTANCE request,
the server transfers up to @i[bytecount] bytes to the file instance starting
at the block numbered @i[blocknumber].
If the number of bytes written is less than the number requested, the
reply code indicates the reason.
As with READ@us()INSTANCE, 
servers should set the byte count to zero on error conditions.

If the number of bytes to write is less than or equal to
IO@us()MSG@us()BUFFER, the data is assumed to be contained in the request
message starting at @i[shortbuffer].
If it is greater than IO@us()MSG@us()BUFFER, the data is transferred from
the space of the requesting process starting at the address @i[bufferptr].
Writes always start at the beginning of the specified block.
Note that the separate request code WRITESHORT@us()INSTANCE is used
when the data is contained in the message only to be consistent with
the kernel message format conventions.
There is no READSHORT@us()INSTANCE needed because the data is passed
back in the reply.
That is, WRITE@us()INSTANCE specifies that segment access is being passed
while WRITESHORT@us()INSTANCE specifies no segment access.

If the file instance has type attribute STREAM, the block number written
is one greater than the last block in this file instance,
regardless of the block number specified.
The number of bytes to write must be less than or equal to the block size
unless the file instance has the type attribute MULTI@us()BLOCK.

@section(SET INSTANCE OWNER)@index(Set Instance Owner)

@Hbar(2 inches)
@begin(description)
requestcode@\SET@us()INSTANCE@us()OWNER

fileid@\File instance identifier

instanceowner@\Process identifier of new file instance owner.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.
@end(description)
@Hbar(2 inches)

In response to a SET@us()INSTANCE@us()OWNER
request, the server sets the file instance owner process to that
specified by @i[instanceowner].
The requesting process must be the current owner of the file instance.
The initial owner of a file instance is the process that created the
instance.

@section(SET BREAK PROCESS)@index(Set Break Process)

@Hbar(2 inches)
@begin(description)
requestcode@\SET@us()BREAK@us()PROCESS

fileid@\File instance identifier

breakprocess@\Process to be ``broken'' when next break generated on
this file instance.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.
@end(description)
@Hbar(2 inches)

In response to a SET@us()BREAK@us()PROCESS request,
the server sets the break process associated with the file instance
to the process specified by @i[breakprocess].
When a break is generated on this file (the IO@us()BREAK reply
returned to any outstanding read operations), the server issues
a DestroyProcess kernel operation on the specified process.

@comment{This is not implemented in V:
The specified process must be the same user as the requesting
process which must be the same user as the owner of the file
instance.}

This request is only supported on file instances with type attribute
INTERACTIVE.

@section(SET PROMPT)@index(Set Prompt)

@Hbar(2 inches)
@begin(description)
requestcode@\SET@us()PROMPT

fileid@\File instance identifier

promptstring@\Prompt string, which must be less than IO@us()MSG@us()BUFFER
bytes long.

@end(description)
@Hbar(2 inches)
@begin(description)

replycode@\Standard system reply code.
@end(description)
@Hbar(2 inches)

In response to a SET@us()PROMPT request, the server
sets the prompt string output previous to every read operation to that
specified.
This request is only supported on file instances with type attribute
INTERACTIVE.

@section(QUERY FILE and NQUERY FILE)@index(Query File)@index(NQuery File)

@Hbar(2 inches)
@begin(description)
requestcode@\QUERY@us()FILE

fileid@\File instance identifier

unspecified@\Server-specific.
@end(description)
@Hbar(2 inches)
@begin(description)

requestcode@\NQUERY@us()FILE

nameindex@\The index of the first byte in the file name
to use in the name mapping.

unspecified@\Server-specific.

namecontextid@\Context in which the name is to be interpreted.

nameptr@\Pointer to a memory segment containing the file name.

namelength@\Length of the segment in bytes.

@end(description)
@Hbar(2 inches)
@begin(description)

replycode@\Standard system reply code.

unspecified@\Server dependent information.
@end(description)
@Hbar(2 inches)

In response to a QUERY@us()FILE or NQUERY@us()FILE
request, the server
returns server specific information about the file or file
instance.
For example, the VGTS returns the ``cooking'' bits, 
and the internet server returns connection information.
A QUERY@us()FILE request specifies the file using an instance identifier,
while a NQUERY@us()FILE request uses a character-string name.  Both types 
of request return the same information.

@section(MODIFY FILE and NMODIFY FILE)
@index(Modify File)@index(NModify File)

@Hbar(2 inches)
@begin(description)
requestcode@\MODIFY@us()FILE

fileid@\File instance identifier

unspecified@\Server-dependent information.

@end(description)
@Hbar(2 inches)
@begin(description)

requestcode@\NMODIFY@us()FILE

nameindex@\The index of the first byte in the file name
to use in the name mapping.

unspecified@\Server-dependent information.

namecontextid@\Context in which the name is to be interpreted.

nameptr@\Pointer to a memory segment containing the file name.

namelength@\Length of the segment in bytes.
@end(description)
@Hbar(2 inches)
@begin(description)

replycode@\Standard system reply code.
@end(description)
@Hbar(2 inches)

The MODIFY@us()FILE and NMODIFY@us()FILE
requests are supported by some servers to modify
some attributes of the file or file instance.
For example, the device server uses MODIFY@us()FILE
to change the data rate on RS-232 serial interfaces.

A MODIFY@us()FILE request specifies which file is to be modified by passing
an instance identifier, while an NMODIFY@us()FILE request passes a character
string name.
