@Part( network, root "manual" )
@Chapter(Internet Server)
@label(internet Server)
@Index(internet server)

The internet server is an I/O server that provides network communications
using any of several protocols.  It is essentially a @i(protocol converter)
which allows applications which communicate by means of the V I/O protocol
to communicate with hosts which can only (or prefer to) be reached by some
other protocol.  As such, the server has been structured in a manner which
allows easy addition and deletion of protocols.  The server consists of a
general framework which is independent of the particular protocols being
supported, and one or more protocol-specific modules.  Each module
implements a particular protocol and must interface that protocol to the
requirements and facilities provided by the server's general framework.
Currently the DARPA Internet protocols IP and TCP are supported.
@Index(IP/TCP)@Index(TCP/IP)@Index(Protocol conversion)
@foot{The Xerox PUP protocol is no longer supported (starting with V-System 
version 5.2).  We continue to show the PUP protocol in some of the examples
of this section for illustrative purposes only.}

@section(Running the Internet Server)

The internet server can be compiled as an independent V program,
or linked into another program.  As an independent V program, it is often
loaded automatically some other V program (e.g., by telnet), so that users
usually don't need to invoke it separately.

The standard V command ``internetserver'' may be run in the background to
provide a local internet server on any workstation.  The internet server
program by default will only register the server for the logical id
INTERNET@us()SERVER on a local basis.  There are two optional switches that
may be used when starting an internetserver.  The @t[-g] option causes
the internet server to register itself globally so that it can create
connections for hosts anywhere in the V-System.  This facility allows local
hosts to avoid spending some 100K of memory for this server.
@foot{Using a global internet server can degrade performance if many
connections are being supported simultaneously.  For bursty applications
such as telnet connections, however, any performance degradation from using
a global internet server is typically small enough to go unnoticed.} The
 @t[-d #] option causes the internet server to enable debug messages up to a
severity of ``@t[#]'' (an integer in the range [0..9]; 0 is the default).

To include the internet server in another V program, have it create a
process which executes the function

@begin(programexample)
InitInternetServer(localFlag, debugFlag)
    int localFlag;	/* True if internetserver should be local. */
    int debugFlag;	/* True if debug output should be printed. */
@end(programexample)

and cause the linker to search the V internet library when loading the
program (i.e., add -lVinternet on the C compilation command line).  It is
generally preferable to run the internet server on its own team by invoking
the internet server program described above, rather than linking it into
another program.

@section(Accessing the Internet Server)

Once the internet server has been started it can be accessed using the V I/O
protocol plus the protocol-specific requests and parameters specified in
<Vnet.h>.

A CREATE@us()INSTANCE request to the internet server must specify the mode
FCREATE.  It results in the creation of two instances, one of type READABLE,
VARIABLE@us()BLOCK, and STREAM, the other of type WRITEABLE,
VARIABLE@us()BLOCK, and STREAM.  The parameters of the writeable instance
are returned in the CreateInstanceReply.  The readable instance has an
instance id equal to the id of the writeable instance plus 1; its parameters
can be obtained using QUERY@us()INSTANCE.  Although the internet server does
not implement the full naming protocol (see Section @ref(NamingProtocol)),
it does implement context directories.  Thus, commands such as @t{listdir -l
[internet/local]} return useful information.

An internet server connection is owned by the process which requested its
creation.  Ownership of a connection can be passed on to another process by
means of the SET@us()INSTANCE@us()OWNER request.  If the owner process
should die then the connection is aborted.

@Section[DARPA Internet Protocol (IP)]

Possession of an IP network instance provides a process access to the
network for sending and receiving IP packets of a specific IP protocol type.
Differing IP instances are delineated by the protocol field in the IP
packets.  Any protocol id value may be specified when creating the instance
except for those values already taken.  For example, the value for TCP, is
already taken by the TCP implementation inside the internet server itself.
Creating an instance with protocol 0 yields a ``promiscuous'' instance that
receives all protocol types which have not been specified by any other
active IP instances.

IP network instances expect WRITE@us()INSTANCE to supply completely packaged
IP packets.  READ@us()INSTANCE similarly will return complete IP packets.
This approach allows IP instances to remain connectionless in concept and
thus avoids the overhead of establishing a network connection instance for
each different set of IP packet parameters.  (Remember that READ and WRITE
under the I/O protocol don't allow for specification of parameters.)

To open an IP network instance, use CREATE@us()INSTANCE and specify the
protocol by overlaying the IpParms structure definition in Vnet.h onto the
@i[unspecified] field of the CreateInstanceRequest structure.  
QUERY@us()FILE will return the value of the protocol field for an IP
instance.  MODIFY@us()FILE has no meaning for these instances.  A standard
library routine ``OpenIp'' is provided to allow creating an IP instance and
allocating a File structure for it, for use with other I/O library routines.

@Section[DARPA Transmission Control Protocol (TCP)]

TCP file instances created by the internet server implement DARPA TCP byte
stream connections.  There are three minor differences from the
specification in the DARPA Internet Handbook.  First, the ``push flag'' is
always set  -- data written is transmitted over the network as soon as
possible.  (Buffering of data is performed by the I/O library routines and
would thus be redundant.) Second, the urgent data flag is not set as part of
a write operation.  Instead, a MODIFY@us()FILE request is used to set the
urgent data flag immediately before a write operation containing urgent
data.  The urgent data flag is reset immediately after the write operation
and thus must be set using a MODIFY@us()FILE request before each urgent data
write operation.  Third, there is no concept of connection timeout provided.
Connections are aborted if their owner process goes away.

Two variants of CREATE@us()INSTANCE are permitted on instances of type TCP,
corresponding to the Active and Passive opens of the Internet Handbook.
Note that the foreign host must be specified completely when issuing a
CREATE@us()INSTANCE request with the active bit set.  A standard library
routine, OpenTcp, is provided to allow creating a TCP instance and
allocating a File structure for it, for use with other I/O library routines.

Two types of release mode are supported for RELEASE@us()INSTANCE requests
corresponding to the Close and Abort primitives of the DARPA specification,
respectively REL@us()STANDARD (equal to 0, the normal release mode defined
by the V I/O protocol) and REL@us()ABORT.  Releasing the writeable instance
closes the client's end of the connection.  Data can still be read from the
readable instance until the other end closes.  It is necessary to release
both the readable and writeable instances to deallocate a connection.

Since TCP supports the concept of a byte stream, the READ@us()INSTANCE and
WRITE@us()INSTANCE operations do not segment the data flow in any way.
(There is one exception: when a packet is received with the urgent flag set,
the next READ@us()INSTANCE receives a BEGIN@us()URGENT@us()DATA reply code
with zero bytes of data.  A similar zero-length reply of
END@us()URGENT@us()DATA is returned when the point in the data stream
indicated by the urgent pointer is reached.) Any READ@us()INSTANCE requests
outstanding when a TCP connection closes for whatever reason are replied to
with a replycode indicating the reason.  An attempt to read from a closed
connection is signaled by an END@us()OF@us()FILE reply code.

The QUERY@us()FILE operation may be used on TCP instances to find out the
state of the TCP connection.  MODIFY@us()FILE may be used to change various
parameters of the connection.  The structure TcpParms1 in Vnet.h defines the
parameters which can be set both at CREATE@us()INSTANCE time and by means of
a MODIFY@us()FILE request.  The meaning of the fields are defined in the
Internet Handbook.  TcpParms2 defines both parameters which may be set and
state variables which may not be set but whose values are returned if
QUERY@us()FILE is executed with TcpParms2 specified.  The parameter in
TcpParms2 which may be set is sndUrgFlag.  This parameter is used to signal
urgent data.  The rcvUrgFlag field returns whether or not urgent data has
been sent from the remote host and not yet received.  The bytesAvail field
indicates how many bytes of data are waiting to be received by the user.
The state field indicates what state the connection is in with respect to
being open, listening, established, closed-waiting-for-remote-close, etc.
(see the Internet handbook).

@begin(comment)
*** support discontinued starting with V-System 5.2, March 1986 ***
@Section(Xerox PUP Protocol)

Possession of a PUP network instance provides a process access to the
network for sending and receiving PUP packets on a specific local PUP port.
Different PUP instances are delineated by the local socket field in the PUP
packets.  (Net and host fields will be the same for all PUP packets received
by the local host, of course.) Opening socket 0 yields a ``promiscuous''
instance that fields all PUP packets whose local socket numbers have not
been explicitly registered for.

PUP network instances expect WRITE@us()INSTANCE to supply completely
packaged PUP packets.  READ@us()INSTANCE similarly will return complete PUP
packets.  This approach allows PUP instances to remain connectionless in
concept and thus avoids the overhead of establishing a network connection
instance for each different set of PUP packet parameters.

Since PUP instances are connectionless, MODIFY@us()FILE has no meaning for
these network instances.  QUERY@us()FILE will return the value of the local
socket field for an PUP instance. (QUERY@us()INSTANCE will only return
whether an instance is IP, TCP, or PUP.)

A standard library routine, OpenPup, is provided to allow creating a Pup
instance and allocating a File structure for it, for use with other I/O
library routines.
@end(comment)



@section(Adding New Protocols)

This section should be of interest only to persons who wish to add an
additional protocol to (or remove one from) the internet server.  It
describes the specifications governing the interactions between particular
communications protocols and the general framework of the internet server.  

There are two interfaces that a protocol must deal with: the external
interface to clients of the internet server, and the internal interface to
the general communications facilities provided by the server's framework.
The external interface consists of the operations, message formats, etc.
that the protocol must understand in order to interface with a client's V
I/O connection.  The internal interface consists of the routines, message
buffer conventions, etc. that the protocol implementation must respectively
use or provide in order to send packets to the network and receive packets
from the network.



@subsection(External Client Interface)

The external interface to a protocol is dictated for the most part by the V
I/O protocol specification.  Interaction between a client and the internet
server is by means of a V I/O connection and the only variations that can be
effected are by means of the QueryFile and ModifyFile operations.  Thus
clients open a connection by means of the CreateInstance operation, they
read and write data by means of the ReadInstance and WriteInstance
operations, they determine the general state of a connection by means of the
QueryInstance operation, and they close a connection with the
ReleaseInstance operation.  

A connection is "owned" by the client process which sent its CreateInstance
request, but can be transferred by means of a SetInstanceOwner request.  The
semantics of ownership are that a connection must be aborted if its owner
process dies.  One of the general facilities provided by the internet server
is monitoring of the existence of connections' owners.  However, the
protocol implementation module is responsible for providing an abortion
routine.

Protocol-specific interactions are handled by means of the QueryFile and
ModifyFile operations.  Protocol-specific instantiation parameters can also
be specified as part of the CreateInstance operation.  The QueryFile
operation is used by the client to determine the state of protocol-specific
connection variables; the ModifyFile operation is used to modify these
variables.  Thus the manner in which things such as the "Urgent Data
Notification" facility in TCP must be implemented is the following:
@Begin(enumerate)
The client's  ReadInstance operation returns an exception code indicating
that something out of the ordinary has happened.

The client does a QueryFile operation to determine the protocol-specific
state of the connection and obtains the "Urgent Data Notification" on return.
@End(enumerate)
Similarly, a client wishing to signal "Urgent Data" on a TCP connection must
do so with a ModifyFile operation.@foot(The reason why the V I/O protocol
specification has been structured in this manner is for reasons of
efficiency.  The vast majority of data read and write operations done on a
connection are done with "normal" settings for the connection parameters.
By removing parameter specification from the read and write operations these
operations can be executed more quickly.)



@subsection(Internal Protocol Interface)

Protocol implementations  must interface both to the external internet
server client and also to the internal environment of the server itself.
This internal interface consists of the following components:
@Begin(enumerate)
A network packet buffer module which all protocols must use.  This module
provides a pool of packet buffers which have a standardized header format so
that various general facilities can manipulate them.

A process structure specification for the protocol.  All protocol
implementations must define certain processes and be aware of the existence
of certain other processes.  Part of this specification is a specification
of the message interactions between these processes.

A set of protocol-independent routines supplied by the server which all
protocol implementations must use for such things as writing packets out to
the network, obtaining and returning packet buffers, etc.

A set of protocol-specific routines supplied by the protocol implementation
which are used by the general server facilities to return incoming network
packets to a connection, signal timeout conditions, etc.
@End(enumerate)
These components will be described in more detail in the following subsections.


@paragraph(A Brief Overview Of The Internet Server's Structure)

The internet server consists of the following processes:
@Begin(enumerate)
A connection-establishment process.  This process registers itself as the
internet server logical id and waits for connection creation requests from
new clients.  For each new connection creation request it invokes a creation
routine for the protocol specified in the request.  This routine is
responsible for setting up a connection and its associated data structures
and handling process(es).

Connection handling processes.  Each protocol connection is handled by one
or more separate processes.  It is up to the protocol implementation to
decide how to structure the connection handling processes for a connection.
However, one of these must be designated the "primary" connection process.
This process will be responsible for handling all communications with the
rest of the internet server.

A network reader process.  The V kernel allows only one network device
instance to exist at any time.  The network reader process reads packets
from the network device and calls a protocol-specific routine for each
protocol being supported.  The protocol-specific routines invoked are
responsible for determining which connection of their protocol type a packet
should be given to.  The network reader process runs at the highest priority
allowed so that it can read and multiplex incoming network packets before
they are overwritten by subsequent packets in the kernel device.

Two timer processes.  The first timer is a timeout timer which wakes up
periodically and invokes a timeout checking routine for each connection.  If
the timeout check for a connection returns a time which is less than the
current time then a message is sent to that connection's primary connection
handling process.  The timer determines how long to sleep before waking up
again by keeping track of the minimum timeout time beyond the current time.
The second timer checks whether any connection owners have died.  A message
is sent to the primary connection handling process of each connection whose
owner has died signalling that the connection should be aborted.  This
second timer wakes up once every 5 seconds.
@End(enumerate)


@paragraph(The Packet Buffer Module)

The packet buffer module provides a set of routines which manage a pool of
packet buffers which are used as the medium of data transmission inside the
internet server.  These packet buffers are handed between various parts of
the internet server by means of pointers (to avoid copy operations) and
their header format must be understood by all parts of the internet server.

The header format for packet buffers is the following:
@Begin(programexample)
typedef struct pbuf
  {
    struct pbuf *next;		/* General purpose link field.*/
    int length;			/* Length of the data in the buffer. */
    char *dataptr;		/* Location of the start of the 
				   data. */
    unsigned unspecified[2];	/* Scratchpad fields. */
    char data[MAXPBUFSIZE];	/* The actual packet buffer. */
  } *PktBuf;
@End(programexample)
The @b[next] field allows packet buffers to be placed in various queuing
data structures.  The @b[dataptr] field points to the start of the data in
the @b[data] array.  Packets are typically constructed starting from the
back of the data array, with various headers progressively added on to the
front.  The @b[unspecified] fields are intended for storing various
packet-specific items of information.  They are used as scratchpad working
areas.  MAXPBUFSIZE must be large enough to accommodate all packets
encountered by the internet server.  It is set to the maximum allowed packet
size of the physical network.@foot(Note that there is only one packet buffer
size for the entire internet server.  A single buffer size was chosen
primarily for reasons of simplicity.  Extending the packet buffer module to
handle multiple buffer sizes would not be difficult.)

The routines provided by packet buffer module are the following:
@Begin(programexample)
PktBuf AllocBuf();

DeallocBuf(pkt);
    PktBuf pkt;
@End(programexample)
Buffers are handed out one at a time by means of calls to @b[AllocBuf]().
Buffers are returned to the free pool by calling @b[DeallocBuf]().  These
routines manipulate the buffer pool in an atomic manner; so that they can be
used from multiple processes without conflict.


@paragraph(Process Interactions)

The implementation of a protocol connection must deal with the network
reader and the two timer processes in a prescribed manner.  In order for
these processes to know whom to send messages to each connection must have a
"primary" process associated with it.  The process ids of these primary
processes are stored in a global data structure maintained by the internet
server which contains one entry per connection.  The details of this data
structure will be described in a later subsection.

@b(Network Reader Interactions)

The network reader process must run at high priority and cannot afford to do
much processing because it must always be ready to accept incoming network
packets before they are overwritten in the kernel device by subsequent
packets.@foot[That is, it must be able to keep up with the (possibly many)
hosts that are sending it packets.]  This has led to an interface format
between the network reader and the various connection handling processes
where communication is by means of atomically updated queues of packet
buffers.  The network reader process enqueues packets for a connection by
calling the @b[EnQueueSafe]() routine, which places a packet in a specified
connection queue.  This routine is non-blocking (i.e. no message traffic
involved) so that the reader process can immediately continue on to process
any additional packets that may have arrived from the network.  The
connection handling processes then remove packet buffers from their queues
by calling the @b[DeQueueSafe]() routine.  The definitions for these two
routines are as follows:
@Begin(programexample)
EnQueueSafe(pkt, q)
    PktBuf pkt;
    RingQueue *q;

DeQueueSafe(q)
    RingQueue *q;
@End(programexample)
RingQueues are atomically updated queues which are defined in the general
internet server module.  They must be initialized with calls to the
 @b[InitSafeQueue]() routine:
@begin(programexample)
InitSafeQueue(q, ringBufs)
    RingQueue *q;		/* Queue header. */
    RingBufRec ringBufs[];	/* An array of MAX@uf()RING@uf()BUFS queue
				   records. */
@end(programexample)

RingQueues consist of the following two data types:
@begin(programexample)
typedef struct
  {
    RingBuf head;
    RingBuf tail;
  } RingQueue;

typedef struct RingBufType
  {
    PktBuf pkt;
    struct RingBufType *next;
  } RingBufRec, *RingBuf;
@end(programexample)
The RingQueue structure defines a header record for the queue.
@b[RingBufRec]s are the actual queue elements, and are placed in a circular
list by the @b[InitSafeQueue]() routine.@foot(The reason why a circular
queue of this form is needed stems from the problem of maintaining these
queues in an atomic manner.)  The @b[pkt] field of a @b[RingBufRec] is used
to point to the packet buffer which is enqueued by it.  

Note that 
at most MAX@us()RING@us()BUFS packet buffers can be enqueued in a RingQueue.
@b[EnQueueSafe]() returns 0 if it can't enqueue a packet buffer.

There is one caveat to the above description of how the network reader
interacts with individual connections.  The primary connection handling
process for a connection may be blocked waiting on client requests@foot(The
protocol implementations to date have consisted of a single process per
connection which alternately waits on client requests and processes its
packet buffer queue.) so that the packet buffer queue cannot be processed
until a request message is received.  To take care of this case each primary
connection process must also set a variable indicating whether it is
blocking awaiting client requests  or not.  The network reader checks this
variable when enqueuing a packet for a connection and sends the connection a
"wakeup" message if it is blocked.  The process receiving the message must
reply immediately to this message in order to minimize the time that the
network reader is blocked.

Another point to be made here is that the actions for the network reader
described above (i.e. invocation of @b[EnQueueSafe]() and checking to see if
a "wakeup" message must be sent) are actually part of the protocol-specific
"network reader" routine that each protocol must supply as part of its
implementation.  This will be described in more detail later.

@b(Timer Interactions)

The two timer processes communicate with connections by means of "timeout"
messages.  Whenever a timeout condition is detected by a timer process it
sends a message to the relevant connection process indicating that a timeout
condition has occurred.  The message format employed is the following:
@Begin(programexample)
struct timeoutMsg
  {
    SystemCode requestcode;	/* Standard message request code
				   field. */
    short unused;
    unsigned timeoutCondition;	/* Which timeout has occurred. */
    unsigned unused1[6];
  };
@End(programexample)
The @b[requestcode] field is the same as that used for all other message
requests.  However, instead of a "standard" V I/O protocol request code an
internet server-specific request code signalling timeout is used.  The
@b[timeoutCondition] field specifies which timeout condition has occurred.


@paragraph(Protocol-Independent Interface Routines and Data Structures)

@b(Global Data Structures)

There is one global data structure that must be maintained by all active
connections in the internet server.  This is the @b[NetInstTable], which
contains an entry for each connection specifying various V I/O
protocol-specific parameter values, the process id of the primary connection
handling process, and a pointer to a control block associated with that
connection.  The V I/O protocol parameter information is used by the
@b[QueryInstance]() routine for answering QueryInstance requests about
connections.@foot[These requests are actually directed at the connection
handling processes themselves, implying that each connection could employ
its own QueryInstance routine.  However no benefit would be gained by such
duplication.]  The process id is used by the network reader and timer
processes to find the primary process for a given connection.  The control
block pointer is used to access connection-specific information.  It is
intended for use by the protocol-specific network reader and timeout
checking routines.

The primary manner in which connections manipulate the @b[NetInstTable] 
is through the following two routines:
@Begin(programexample)
int AllocNetInst(prot, ownerPid, pid, rblocksize, wblocksize, tcbId)
    int prot;			/* Instance protocol type 
				   (TCP, PUP, ICMP, etc.) */
    ProcessId ownerPid;		/* Process id of owner of the 
				   connection. */
    ProcessId pid;		/* Process id of primary connection 
				   handling process. */
    int rblocksize, wblocksize;	/* Block sizes for resp. read and write
				   V I/O connection instances. */
    unsigned tcbId;		/* Pointer to the control block for 
				   this connection. */

DeallocNetInst(index)
    int index;			/* Index of NetInstTable entry to
				   deallocate. */
@End(programexample)
@b[AllocNetInst]() returns an index into the table where the newly allocated
entry has been placed.  Individual fields can then be set by indexing
through this value into the table.  (E.g. SetInstanceOwner requests would be
dealt with in this manner.)

Each protocol implementation is expected to employ these routines to manage
the @b[NetInstTable] in a correct manner.  I.e. allocation and deallocation
of @b[NetInstTable] entries is @i(not) done automatically by the server's
general facilities.

@b(Useful But Not Essential Routines)

The internet server provides several generally useful but not essential
routines which may be employed by protocol implementations if they so chose.
These include the following:
@Begin(programexample)
SystemCode QueryInstance(rqMsg)
    QueryInstanceRequest *rqMsg;

Boolean InvalidFileid(rqMsg)
    IoRequest *rqMsg;

ReplyToRead(replycode, pid, packet, bufferPtr, length)
    SystemCode replycode;	/* Reply code to send to a reader. */
    ProcessId pid;		/* Process id of the reader. */
    PktBuf packet;		/* Packet buffer containing data to 
				   return to the reader.  NULL if 
				   there is no data to return. */
    char *bufferPtr;		/* Address of reader's buffer. */
    int length;			/* Length of data to return. */

QueryProcess()
@End(programexample)

@b[QueryInstance]() returns the state of a specified network connection.
It is V I/O protocol-specific and hence independent of the particular
network protocol being supported by the other end of the connection.  It
obtains its information from the @b[NetInstTable] entry for the connection.
Connections are specified in the request message in the same manner as with
all other V I/O connections, namely by a @b[fileid].

@b[InvalidFileid]() checks whether the @b[fileid] field in a client's 
request message is reasonable; i.e. whether it maps to an existing
connection entry in @b[NetInstTable] which is in use.  All incoming client
requests should be checked with this routine to avoid corruption of other
connections' control blocks.

@b[ReplyToRead]() is a generic routine for replying to a client's read
request.  It performs the MoveTo operation needed to move data from a packet
buffer to the client's read buffer and packages an appropriate reply
message.

@b[QueryProcess]() is a routine which runs in its own process and is used
for debugging.  It provides a means for examining and changing the state of
the internet server while it is in operation.


@paragraph(Protocol-Specific Interface Routines and Data Structures)

There are two types of protocol-specific routines that a protocol
implementation must provide: network-level routines and connection-level
routines.  Network-level routines are used by the network reader process to
multiplex incoming network packets to the correct connection.
Connection-level routines are used to initialize a protocol, create a new
connection and interface with the connection timeout checking process.

Protocol implementations are usually done for @i(protocol families) rather
than individual protocols.  For example, the current internet server
implements both the IP and the TCP Internet protocols.  However, rather than
implementing these two protocols as separate modules, they are implemented
together, so that the TCP module can make use of facilities already defined
by the IP module.  This results in a situation where only the IP module
interfaces with the network layer and the TCP module interfaces internally
to the IP module.  Thus the IP/TCP protocol family implementation has three
interfaces to the rest of the internet server rather than four: it has a
single network-level interface and a connection-level interface for both IP
and TCP respectively.

Protocol-specific interface routines are accessed by the general server
facilities through function tables indexed by protocol type.  There are two
such function tables, one for the network-level routines and one for the
connection-level routines.  The format of these tables is described below.

@b(Network-level)

The network-level function table is called @b[PnetTable] and is defined
as follows:
@begin(programexample)
struct PnetBlock
  {
    unsigned prot;		/* Network protocol type. */
    Boolean active;		/* True if a network connection is 
				   active for this protocol. */
    int (*initNetProt) ();	/* Initialization routine for this 
				   protocol. */
    int (*rcv) ();		/* Receiving routine for this 
				   protocol. */
  } PnetTable[NumPnetProtocols];
@end(programexample)

The first two fields are actually not functions.  The @b[prot] field is used
to store the network protocol type id so that the network reader process can
figure out which table entry to use for a given network packet.

The @b[active] field is used to allow the network reader process to "short
circuit" discarding of broadcast and invalid packets for inactive protocols.
Without this field the reader process would have to call the rcv() routine
for these packets since it can't tell itself whether they should be
discarded.  The @b[active] field is managed through the following two
routines:
@begin(programexample)
ActivateNetProtocol(prot)
    int prot;

DeactiveateNetProtocol(prot)
    int prot;
@end(programexample)
@b[prot] specifies which table entry to access.

Associated with the @b[active] field is another table, called
@b[NetLevelProtocol], which is used to map from connection protocols to the
network-level protocols which support them.  For example, the IP/TCP
protocol implementation described previously would designate both IP's and
TCP's network-level protocol as being IP.  The definition of the table
data structure, along with an example initialization is as follows:
@begin(programexample)
int NetLevelProtocol[NumProtocols] =
  {
    0, 				/* IP */
    0,	 			/* TCP */
    1,				/* PUP */
    0				/* ICMP */
  };
@end(programexample)

The index of each entry corresponds to the index of the corresponding
protocol entry in the @b[FuncTable] table.  The contents of each entry is
the index of the corresponding network-level protocol in the 
@b[PnetTable] table.  Thus, in the example shown, the @b[FuncTable] defines
the IP protocol at index 0, the TCP protocol at index 1, the PUP protocol at
index 2, and the ICMP protocol at index 3.  The @b[PnetTable] defines the IP
network-level protocol at index 0 and the PUP network-level protocol at
index 1.
@foot{The actual internet server code uses manifest constants instead of 
integers to fill these fields - making things much more readable.  However,
to illustrate the principle, no manifests were employed.}

The @b[initNetProt] field specifies an initialization routine for the
protocol which is called at server boot time.  

The @b[rcv] field specifies a routine which is called whenever a network
packet arrives which has a protocol type equal to that specified in the
 @b[prot] field of the entry (and the @b[active] field is true).  This
routine is responsible for figuring which connection of its protocol, if
any, should receive the packet.  If a connection is found then the routine
is responsible for enqueuing the packet in that connection's RingQueue
(using the @b[EnQueueSafe]() routine) and for checking to make sure that the
connection's process(es) will actually be able to process the enqueued
packet buffer (i.e., if the connection's process(es) are receive-blocked
awaiting client requests then the routine must send a message to "wake" them
up).  Packets for which no connection is found must be returned to the free
buffer pool with a call to @b[DeallocBuf]().

The interface definition for the @b[initNetProt]() and @b[rcv]() routines
is as follows:
@begin(programexample)
InitNetProtocol()

ReceiveProtocolPkts(packet)
    PktBuf packet;		/* Ptr to the incoming network 
				   packet. */
@end(programexample)
where @b[InitNetProtocol]() and @b[ReceiveProtocolPkts]() are example names.


@b(Connection-level)

The connection-level function table is called @b[FuncTable] and is defined
as follows:
@begin(programexample)
struct FuncBlock
  {
    int (*InitProtocol) ();
    SystemCode (*CreateConnection) ();
    int (*NextTimeout) ();
  } FuncTable[NumProtocols];
@end(programexample)

The @b[InitProtocol] field specifies an initialization routine for the
protocol which is called at server boot time.  

The @b[CreateConnection] field specifies a routine which is called by the
connection-establishment process when a client requests the creation of a
new connection instance.  The routine must create the data and process
structures for a new connection and then handle the CreateInstance request
from the client.@foot[The method recommended for doing this is to have the
routine create the connection handling process(es) and then forward the
CreateInstance request to the connection's primary process.  This allows the
connection handling process(es) to manipulate their own data structures
(which are typically kept on the process(es)' stack(s)).]  This is usually
also the place where a call to the @b[ActivateNetProtocol]() routine is made
to signal that the protocol is active.

The @b[NextTimeout] field specifies a routine which is called by the timeout
checking timer process.  This routine returns the time of the next timeout
for its connection.  If that time is already past then the timer process
will send a timeout message to the connection's primary process.  The
connection's data structures are accessed through the @b[tcbId] field of the
connection's
@b[NetInstTable] entry.

The interface definition for the @b[InitProtocol](), @b[CreateConnection](),
and @b[NextTimeout]() routines is as follows:
@begin(programexample)
InitProt()

CreateProtConnection(reqMsg, clientPid)
    CreateInstanceRequest reqMsg;
				/* CreateInstance request message sent 
				   by a the client. */
    ProcessId clientPid;	/* Process id of the client. */

NextProtTimeout(tcbId)
    unsigned tcbId;		/* Ptr to the control block for the 
				   connection. */
@end(programexample)
where @b[InitProt](), @b[CreateProtConnection](),
and @b[NextProtTimeout]() are example names.

@section(Monitoring and Debug Facilities)

Normally the internet server runs in the background and is accessed using
the standard mechanisms discussed in the previous sections.  In situations
where poor network or protocol behavior is suspected, it is often useful to
inspect the internal state of the internet server and to observe the
behavior of particular connections.  

A simple approach to debugging or monitoring involves starting an internet
server in debug mode (e.g., @t[internetserver -d 5], where the debug level
``5'' is useful for debugging or monitoring a wide range of potential
problems).  Much of the debug information provided details the operation of
TCP/IP connections, though some information about the V I/O protocol and
other protocols is also reported.

Upon startup, the internet server reads the configuration database for the
workstation on which it is running and prints out information about how it
will route to various internet addresses.
@foot{This is a temporary mechanism until more complete standards
for internet routing in local network environments can be defined and
implemented.} This information typically takes the form shown below (for a
workstation with internet address 36.8.x.y):

@begin(programexample)

    IP Gateway Table:
    36.8 -> local
    36 -> 36.8.0.4
    default -> 36.8.0.1

@end(programexample)

The host at @t[36.8.0.4] is a gateway that can route to subnets within net
@t[36] (Stanford), while the host at @t[36.8.0.1] is a gateway that can
route to all non-Stanford hosts.  This routing information is often useful
in determining whether the configuration database for the workstation is set
up properly.  See Section @ref(ConfigDatabase) for a description of the
V-System configuration database.

More flexible debugging is possible using a separate V program that is
provided specifically for this purpose.  There are many advantages to this
approach: an internet server that is already running can
be examined, and non-local internet servers can be inspected to name two.
Typing
@Index(inquery program)

@begin(programexample)

    inquery

@end(programexample)

to a V executive will start a program that can be used for more advanced
inspection (and modification) of the internal state of the internet server.
Inquery will attempt to find an internet server on the local machine.  If
none can be found, or if a different internet server is of interest, the
user must type additional commands as described below.

Once the inquery program has started, it will prompt for single letter
commands.  Most commands are intended for low-level debugging by program
maintainers and are not described in detail.  The commands that may be
useful for user-level monitoring are described below in approximate order of
usefulness:

@begin(description)
@t[?]@\list available commands (including brief description).

@t[A]@\attach to the debug I/O stream of the internet server.  The default
is for debug I/O to go to stdout (as defined at the time the internetserver
program was invoked).  You must always use this option when inspecting
non-local internet servers.

@t[U]@\unattach from the debug I/O stream of the internetserver (returning
it to stdout).  One typically uses ``@t[d 0]'' to turn of debug output before
unattaching (since sending output to stdout is not always what is wanted).

@t[d]@\change the verbosity of the debug information that is printed.  
The user is prompted for a digit in the range [0..9], where 0 (the default)
indicates silence and 9 indicates full verbosity.  A value of 5 is
appropriate for most user-level debugging, as this will cause only the most
``interesting'' events (e.g., retransmission of packets, bad packets,
unusual events) to be reported.  The effect of this command is identical to
the @t[-d #] command line switch that can be given to the internet server at
startup.

@t[R]@\reattach to (or relocate) an internet server.  User is prompted for 
the process id of the internet server of interest (or 0 to mean the local
internet server).  The inquery program can only communicate with one
internet server at a time.

@t[V]@\print version informatin about the internet server currently being
inspected (workstation name, compilation date and time).

@t[f]@\lists free resources (e.g., buffers and network instances).

@t[n]@\list some basic information about active network instances.

@t[p]@\show detailed information about a particular network instance.  Only
implemented for TCP instances.  Primarily useful to maintainers  see the
DARPA Internet Handbook for clues to the meaning of this information.
Fields of possible interest at the user-level include counts of
retransmissions, out-of-order packets and packet delays (10ms units).

@t[x]@\immediately exit the internet server  abort any existing connections.
The inquery program continues to run  use @t[R] to reattach to an internet
server.

@t[Q]@\quit out of the inquery program (leaving the internet server
running).  The @t[U]  and @t[d 0] commands are often used before using
@t[Q].
@end(description)

For typical user-level monitoring of a local internet server, the ``@t[A]''
command followed by the ``@t[d 5]'' command are the only commands that
should needed.  They allow a user to observe the frequency of
retransmissions, receipt of bad packets, and other unusual events.  This may
be helpful in identifying the source of poor performance  flakey networks
or gateways, incorrect or inefficient TCP/IP implementations, or just long
network delays.
