@part(ExecServer, root "manual.mss")
@Chapter(Exec Server)


The exec server is the central control facility for all instances of the V
system executive on a workstation.  Its purpose is to allow sharing of
code and data (such as aliases) among all executives.  The intention
is that while each executive is a separate command stream, all
executives on the same workstation should present the same command
interface to the user.  That includes customized aspects of that
command interface, such as aliases.  Since the exec server is part of
the basic environment of the V system, such customizations do not vanish
even if the terminal agent (i.e., the VGTS or STS) is replaced; they 
remain as long as the user is logged in.

The exec server allows programs to have instances of the executive
(usually referred to simply as ``execs'') created and destroyed.  An
exec is known to the server by its exec id; exec ids are small
integers starting at 0.  There is currently no concept of ownership of
execs; any program can destroy any exec regardless of whether it
created it or not.

The exec server is located by
@begin(programexample)
GetPid(EXEC@uf()SERVER, LOCAL@uf()PID)
@end(programexample)
It is present in all the standard configurations of the  Vsystem.

The following requests are supported.
@begin(description)
CREATE@us()EXEC@\Creates an executive, with standard i/o and context specified
in the request message, and returns the exec id.

START@us()EXEC@\Under some circumstances an exec is not started by the 
CREATE@us()EXEC request, because the requestor needs to do some
@b[SetInstanceOwner] operations first. START@us()EXEC then allows
the exec to start running.  Normally all this is
transparent and is handled in the @b[CreateExec] library routine.

DELETE@us()EXEC@\Delete an executive. If there is a program running under it,
it is abruptly stopped due to the death of its parent process. 

KILL@us()PROGRAM@\Kill the program running under an executive.  If there
was no program running under that executive, nothing happens.

QUERY@us()EXEC@\Returns information on an executive: its status (free, loading
a program, or running a program), its process id, and
the process id of the program running under it, if any.

CHECK@us()EXEC@\Makes a check of all executives.  If the standard input
server or standard output server of an exec has died, the exec is
destroyed.  This is used mainly when changing terminal agents.
@end(description)

The message structure for the requests, the request values and the logical
identification of the exec server can be found in the header file Vexec.h.
