@Part(pgmexec, root "manual" )
@Chapter(Program Execution Functions)@Label(exec)

This chapter describes a number of routines related
to program execution.  Included are routines for program loading and 
execution, selecting hosts for remote execution of programs,
execution of Unix commands remotely on a Unix V server (see 
section @ref[UnixServer]), routines that provide
compatibility with various Unix program execution routines, and other
routines.


@section(Program Execution)

@function{ProcessId LoadProgram(argv, hostSpec, rtMsg, path, concurrent, error)
    char *argv[];	/* Program arguments (including name). */
    SelectionRec *hostSpec;
  			/* Specifies the host to execute on.
			   (NULL => default, i.e. local host) */
    RootMessage *rtMsg;
			/* Root message to use. NULL => default settings */
    char *path;		/* Search path to use for finding the program
			   file.  NULL indicates that the default should
			   be used. */
    int concurrent;	/* Specifies whether the program should be 
			   owned by the system (concurrent = 1) or 
			   by the user (concurrent = 0). */
    SystemCode *error;	/* Return code. */}@index(LoadProgram)

@t[LoadProgram()] interacts with the team server on the specified host,
to create a new team and
load a program image into the new team space.  
The program is placed in a separate team and is set ready to
run.

The array @t[argv] contains
pointers to the character string arguments to be passed to the new
team.  By convention, @t{argv[0]} should point to the name of the program.
The last element of the array must be a null pointer.

The @t[hostSpec] argument is used to select a host to execute the 
new program.
If @t[hostSpec] is NULL, the program is run locally.
Alternatively, @t[hostSpec] can be a pointer to a @i[selection record], as 
defined by the @t[SelectionRec] structure in @t[Vteams.h].
In this case, if the @c[teamServerPid] field of the selection record is 
non-zero, then this value is assumed to be a pid of a team server on the 
desired host.
If, however, the @t[teamServerPid] field is zero, then an `arbitrary' remote 
host is selected, according to the constraints specified in the other fields 
of the record.
@comment[RSF - Someone should really explain what these other fields really 
mean.  Marvin??]
@i[NOTE: This method of host selection is likely to change in future releases 
of the system.]@comment[... because it's such a crock the way it is now!!]

The @t[rtMsg] argument holds the root message to be passed to the new
team.  This message specifies file instances to be used for standard input,
output, and error, the @i[team environment block], and some other information.
The fields in the message are described in detail
in section @ref(TeamRootMessage).
If @t[rtMsg] is given as NULL, then a `default' root message is used (see 
the description of the @t[DefaultRootMessage()] routine, below).

The @t[concurrent] argument specifies whether the team is to be ``owned''
by the process executing the @t[LoadProgram()] call (if @t[concurrent] is zero)
or by the team server itself (if it is nonzero).
The team server destroys any team whose owner ceases to exist; thus,
programs to be run ``in the background'' should be flagged as concurrent.

@t[path] specifies the @i[search path] that is used to locate the code file 
for the program that is to be executed.
A search path is a character string consisting of a sequence of name prefixes separated by spaces.
If @t[path] is NULL, then the value of the ``PATH'' environment variable is 
used instead, or, if the ``PATH'' environment variable is not set, the 
`default' search path.
This default search path is @t{"./ [bin]"}, which indicates that the program 
code file is searched for first in the invoker's current context, and then in 
the @t{[bin]} context.
(Note that the search path mechanism also involves checking for 
machine-specific program name suffixes, as described in 
section @ref[HeterogeneousCommandExecution].)

If the named program is not found, then the @t[fexecute] program is invoked
instead, to attempt to execute the program remotely on the server that is 
providing the invoker's current context.  See section
@ref(RemoteExecutionBySession) for further details.

Note: If @t{argv[0]} is an @i[absolute name] (that is, beginning with 
@t{'['}), then a search path is @i[not] used, nor is the @i[fexecute] program 
used in the case of a failed match.

@t[LoadProgram()] returns the pid of the new team's root process, or 0 to
indicate an error.
A standard system code is return in the location pointed to by @t[error].
The new team can be started running by replying to the pid returned,
using the same root message as was passed to @t[LoadProg].


@function{ProcessId ExecProgram(argv, hostSpec, rtMsg, path, status, error)
    char *argv[];	/* Program arguments (including name). */
    SelectionRec *hostSpec;
    			/* Specifies the host to execute on.
			   (NULL => default, i.e. local host) */
    RootMessage *rtMsg;	/* Root message to use. NULL => default settings */
    char *path;		/* Search path to use for finding the program
			   file. */
    int *status;	/* Return code from program executed or NULL
			   if the program is to be run concurrently. */
    SystemCode *error;	/* Return code. */}@index(ExecProgram)

@t[ExecProgram()] is like @t[LoadProgram()], except that it also starts the 
new team running (by replying to it).
The arguments @t[argv], @t[hostSpec], @t[rtMsg], @t[path], and @t[error] are 
the same as for @t[LoadProgram()].

If the @t[status] parameter is NULL then the program is run 
concurrently, otherwise the function waits until the program has
terminated and returns its exit status in @t[status].


@function{Wait(pid, status)
    ProcessId pid;
    int *status;}@index(Wait)

Wait for the team whose root pid is specified by @t[pid] to expire, and then
return its exit status code in the location 
pointed to by @t[status].


@function{DefaultRootMessage(rtMsg)
    register RootMessage *rtMsg;}@index[DefaultRootMessage]

This routine sets up the structure pointed to by @t[rtMsg] to be 
the `default' @t[RootMessage] for any program that the invoker should load.
In particular, the @t[stdin], @t[stdout] and @t[stdin] servers and instance 
ids are set to be those of the invoker.

@section(Host Selection)@index(host selection)

@function{int QueryHosts(spec, descArray, numHosts, error)
    SelectionRec *spec;	/* Host selection spec. */
    SelectionRec *descArray;
			/* Array for returning descriptors of selected 
			   hosts. */
    int numHosts;	/* Maximum number of selections to return.
			   Also the size of pidArray. */
    SystemCode *error;	/* Status code. */}@index(QueryHosts)

Select a set of hosts for remote execution of programs.  Nothing is actually 
executed -- this routine merely returns candidate hosts for remote execution.
@t[QueryHosts()] returns descriptor records for hosts selected in @t[descArray] 
which meet the selection criteria specified by @t[spec].  At most @t[numHosts] 
selections are returned.  
The number of hosts actually selected is returned as the function
value.  @t[error] returns a system status code for the operation.

If @t[spec] is NULL then the default specification 
is used (see the description of @t[DefaultSelectionRec()], below).

The format of a selection record is specified 
in @t[Vteams.h]@index(Vteams.h).  The @t[pid] field of a 
@t[SelectionRec]@index(SelectionRec)
specifies the team server of a candidate host.  It is this process-id that 
should be used with any subsequent calls to @t[ExecProgram()] 
or @t[LoadProgram()].

@t[QueryHosts()] finds candidate hosts by sending a message to the process 
group containing all team servers in the system (the 
VTEAM@us()SERVER@us()GROUP).
Only those hosts which satisfy the requirements specified in @t[spec] 
will reply to this message.

@function{DefaultSelectionRec(hostSpec)
    SelectionRec *hostSpec; /* assumed to be non-NULL. */}
@index{DefaultSelectionRec}
Sets up the @t[SelectionRec] structure pointed to by @t[hostSpec], so that it 
can be used (as an argument to @t[QueryHosts()], @t[ExecProgram()] 
or @t[LoadProgram()]) to select an `arbitrary' remote host.
This currently specifies the following minimum resource requirements:
@begin(itemize, spread 0)
1 free team descriptor.

10 free process descriptors.

200 Kbytes of free memory.

Less than 50% processor utilization.

No one logged into the host.
@end(itemize)

@section(Remote Execution of Unix Commands)

@function{SystemCode RemoteExecute(processFile, programname, argv, mode)
    File *processFile[2];  char *programname;
    char *argv[];  unsigned short mode;}@index(RemoteExecute)
Cause the specified program to be executed on the server
that provides the invoking process's current context, by
opening a file in FEXECUTE mode.
Of course, this server must be a Unix V server (see section @ref[UnixServer]).
This function is used by
the @t[fexecute] program.

The @t[argv] parameter is an array of null-terminated strings
which are to passed as arguments to the program.  The array itself
is terminated by a null pointer.  @t[mode] should be FREAD or
FCREATE.  A File structure describing a stream from which the
program's standard output can be read is returned in 
@t<processFile[0]>.  If the mode is FCREATE, a File structure
describing a writeable stream that is fed into the program's
standard input is returned in @t<processFile[1]>.
@t[RemoteExecute()]
returns OK if successful, else a standard system code describing
the error condition.

Closing the writeable file passes an end-of-file indication
on to the remote program.  Closing the readable file terminates
the program.

@section(Other Program Execution Routines)

@function{ProcessId Execl(input, output, errput, status, error, arg0)
char *arg0;
File *input, *output, *errput;
SystemCode *error;
int *status;}@index(Execl)
@t[Execl()] calls @t[ExecProgram()] (and thus
waits for the program created to finish executing, if @t[status] is non-NULL).
It returns the program exit 
status in @t[status] and a system status code @t[error] (which indicates the 
nature of any errors encountered in @t[Execl] itself).
@t[input], @t[output], and @t[errput] are used to specify the standard I/O of 
the program to be loaded and run.  The remaining fields of the root message 
passed to @t[ExecProgram()] are derived from the invoker's root message.
@t[arg0] actually represents the first of a variable number of parameters 
that represent the arguments to be passed to the new program.  It is 
the first element of the @t[argv] array passed to @t[ExecProgram()].

@function{int system(cmd)
char *cmd;}@index(system)
Invokes an @ProgramExample[exec -c] on the @t[cmd] string. 
The program's exit status is returned.
