@Part( others, root "manual" )
@Chapter(Miscellaneous Functions)

@Section(Time Manipulation Functions)
@Label(time)@index(time)

The time-related functions in the V C library are described below.
A few of them are not present in the Unix C library.

@function{unsigned GetTime(clicksptr)}@index(GetTime)
return the current time in seconds
as maintained by the local kernel.
The current time is represented as seconds since January 1, 1970 GMT.
If clicksptr is not @c[NULL], the number of clicks since the last
second is stored in location pointed to by clicksptr.
The standard manifest CLICKS@us()PER@us()SEC indicates the number of
clicks per second for the host.

@function{SystemCode SetTime(seconds, clicks)}@index(SetTime)
sets the local kernel time to the specified @t[seconds] and @t[clicks.]
The time maintained by the kernel is normally set on system boot
and need not be changed subsequently.

The standard time representation used is
the number of seconds since January 1, 1970 GMT,
plus the number of clock interrupts since the last second.

@function{unsigned Delay(seconds, clicks)}@index(Delay)
suspend the execution of the invoking process for
the specified number of seconds and clicks.
(where a click is a machine-specific unit, usually one clock interrupt).
@t[Delay] returns the number of clicks remaining in the delay period.
Thus, it normally returns 0.
However, if the delaying process is awakened using @t[Wakeup],
it may return a non-zero value.

@function{SystemCode Wakeup(pid)}@index(Wakeup)
unblock the process specified by @t[pid], returning OK,
assuming the process is currently delaying using @t[Delay]
and the invoker is the same
user as the specified process, or is a privileged user.
Otherwise, the return value is a standard system code indicating
the error.

@function{stime(), time(), ftime()}@index(stime)@index(time)@index(ftime)
These are Unix system 
calls and are implemented here with simple library
functions which emulate the Unix functions
by performing the appropriate V kernel
operations @t[SetTime()] and @t[GetTime()]. They have the same interface and
functionality as in Unix; however, @t[ftime()] has the timezone hardwired as
Pacific Time, since the V-System provides no time zone information.

@function{ctime(), localtime(), gmtime(), asctime(), timezone()}
@index(ctime)@index(localtime)@index(gmtime)@index(asctime)@index(timezone)
These are identical to the Unix library functions.

@function{sleep(seconds)
    unsigned seconds;}@index(sleep)
The invoking process is 
suspended from execution for the specified number of
seconds.  The actual time may be considerably longer than that specified
if the process is not the highest priority ready process 
when its sleep time expires.
@t[sleep()] is not sensitive to @t[Wakeup()]'s. Use the V
system call @t[Delay()] for a @t[Wakeup()]-able suspension.

@function{unsigned GetRemoteTime()}@index(GetRemoteTime)
Returns the time according to the TIME@us()SERVER
in seconds since January 1, 1970, GMT.
Returns zero if it fails, e.g., no time server responded.

@section(Strings)
@Label(strings)@index(Strings)@index(Character strings)
The string-related functions in the V-System C library are described below.

@subsection(Unix String Functions)
The following functions are identical to the functions of the same name
provided by Unix.  See the @i[Unix Programmer's Manual] for documentation.
@begin(verbatim)
atof()		atoi()		atol()		crypt()
ecvt()		gcvt()		index()		rindex()
strcat()	strncat()	strcmp()	strncmp()
strcpy()	strncpy()	strlen()
@end(verbatim)
@index(atof)@index(atoi)@index(atol)@index(crypt)
@index(ecvt)@index(gcvt)@index(index)@index(rindex)
@index(strcat)@index(strncat)@index(strcmp)@index(strncmp)
@index(strcpy)@index(strncpy)@index(strlen)

@subsection(Verex String Functions)
There is also another set of string manipulation functions which
were ported from Verex.  These include the following:

@function{int Any(c, string)
    char c;  char *string;}@index(Any)
Determine whether there is any occurrence of the byte @t[c] in the
string @t[string], and return true (nonzero) if so, else false (zero).

@function{char *Concat(dest, s1, s2, s3)
    char *dest, *s1, *s2, *s3;}@index(Concat)
Concatenate the strings @t[s1], @t[s2], and @t[s3], store the result
in @t[dest], and return @t[dest].  @t[dest] must have enough room
to store the resulting string.  If any of @t[s1], @t[s2], @t[s3] are
null pointers, the remaining arguments are ignored.

@function{int Convert@uf()num(string, delim, base)
    char *string;  char **delim;  unsigned base;}@index(Convert@us()num)
Parse the given string to extract a number of
base @t[base] and return its value.
If @t[base] is zero, the initial character of the
string determines the base, as follows
@begin(format)
@tabclear
@tabset(16,18)
@>@t[#]@\@\Base 2
@>@t[0] (zero)@\@\Base 8
@>@t[$]@\@\Base 16
@>otherwise@\@\Base 10
@end(format)
Upon return, @t[*delim] is modified to contain a pointer to the
delimiter that terminated the number.

@function{char *Copy@uf()str(string)
    char *string;}@index(Copy@us()str)
Copy the given string into a newly allocated region of memory
and return a pointer to the copy.  The new region is allocated using
@t[malloc()] and may thus be freed using @t[free()] when the copy
is no longer needed.
The function @t[strsave()] is identical to @t[Copy@uf()str()].@index(strsave)

@function{int Equal(s1, s2)
    char *s1, *s2;}@index(Equal)
Compare the strings @t[s1] and @t[s2].  Return true (nonzero) if the
strings are equal, else false (zero).  Strings are considered to be
equal if and only if they are of equal length (up to the terminating
null byte) and each corresponding byte is the same.

@function{int Hex@uf()value(c)
    char c;}@index(Hex@us()value)
Return the value of @t[c], interpreted as a hex digit.  Return -1 if
@t[c] is not a hex digit.

@function{char *Lower(string)
    char *string;}@index(Lower)
Convert all alphabetic characters in @t[string] to lower case and return
@t[string].

@function{unsigned Null@uf()str(string)
    char *string;}@index(Null@us()str)
Return true (nonzero) if @t[string] is a null string (i.e., of length
zero), else return false (zero).

@function{char *Shift@uf()left(string, chars)
    char *string;  unsigned chars;}@index(Shift@us()left)
Delete the leftmost @t[chars] characters of @t[string] by shifting
the remaining characters to the left, and return @t[string].
@t[string] must be at least @t[chars] characters long,
but this condition is not checked.

@function{unsigned Size(string)
    char *string;}@index(Size)
Return the number of characters in the given string, i.e., the index of the
null byte that terminates the string.

@function{char *Upper(string)
    char *string;}@index(Upper)
Convert all alphabetic characters in @t[string] to upper case and return
@t[string].

@section(Exception Handling Functions)

@function{short *StandardExceptionHandler(req, pid, fout)
    register ExceptionRequest *req;
			/* Exception message. */
    ProcessId pid;	/* Process incurring exception. */
    File *fout;		/* Print out messages on this file */}
@index(StandardExceptionHandler)
Standard exception handling print routine.  Prints out some information
about the process incurring the exception and returns the pc at
which the exception occurred.
@t[req] points to the exception request message, @t[pid] is the
process id of the process that incurred the exception, and @t[fout] is
the file on which the message is to be printed.

@function{PrintStackDump(fout, pid)
    File *fout;  ProcessId pid;}
Prints out the stack of the process specified by @t[pid].  The process must 
be in the same address space as the invoker.


@section(Other Functions)

@function{qsort(base, nel, width, compare)
    char *base;  int nel, width;  int (*compare)();}@index(qsort)
Implements the quicksort algorithm.
@t[base] is a pointer to the base of the data;
@t[nel] is the number of elements; @t[width]
is the width of an element in bytes;
and @t[compare] is a function to compare two elements.
The function @t[compare]
must return an integer less than, equal to, or greater than zero,
if the first argument is less than, equal to, or greater than the second,
respectively.

@function{setjmp(env)
    jmp@uf()buf env;

longjmp(env, value)
    jmp@uf()buf env;  int value;}@index(setjmp)@index(longjmp)
@t[setjmp()] saves the stack environment in @t[env], so
that a later call to @t[longjmp()] will act like a return was made from
the function which contained the call to @t[setjmp()], with
return value @t[value].

@function{char *ErrorString(error)
    SystemCode error;}@index(ErrorString)
Returns a pointer to a string describing the
system request or reply code @t[error], in human readable terms.
Use this in error messages instead of printing the numeric value of the code.

@function{PrintError(error, msg)
    SystemCode error;  char *msg;}@index(PrintError)
Prints the string @t[msg] and an explanation of the
SystemCode @t[error] on the standard error file.
