@Part(config, root "manual")
@Chapter(The V-System Configuration Database)
@label(ConfigDatabase)@index(Configuration)@index(Config Files)

The V-System maintains a configuration
database, containing information about each workstation.
The information is
organized as sets of keyword/value pairs, one set per workstation.

@section(Querying the Database)

There is one standard library function provided for extracting information
from the configuration database:

@function{SystemCode QueryWorkstationConfig(keyword, value, maxlength)
    char *keyword, *value;
    int maxlength;}@index(QueryWorkstationConfig)
Given a character string representing the keyword, this routine returns the
corresponding value as another character string.
The variable @t[keyword] points to the keyword, @t[value] points to the 
place to
put the value, and @t[maxlength] is the size of the buffer, which should
include space for a terminating null byte.  The routine returns a system
error code if there is no configuration information recorded for the querying
workstation (NOT@us()FOUND), there is some configuration information, but no
value corresponding to the given keyword (BAD@us()ARGS), or
the buffer was too short to hold the value 
(BAD@us()BUFFER), else
returning OK.  In the buffer-too-short case, it will return as much as
there is room for.
In unusual situations, other error codes may be generated; these can be
treated as failures or considered equivalent to NOT@us()FOUND.

@section(Currently Defined Keywords)
The following keywords are in use at this writing.  A list of keyword names
and their meanings is presently kept in the same directory as the config
files themselves, in a file called ``keywords.''

@begin(description)
name@\The name of this workstation.  Should match the name used in
local IP name tables for this workstation's IP address.  There is no
default.

alt-ether-addr@\Alternate ethernet addresses for this workstation, one per
line.  These are addresses the workstation may use, other than the one the
config file is named for.  10 Mbit addresses should be given in hexadecimal,
in the form xxxx.yyyy.zzzz.  3 Mbit addresses may be given in octal.  The
default is null.  This keyword must be present for use by the Vax Unix ND
server for workstations that boot using the ND protocol under a different
Ethernet address than the one the config file is named for.  This is true of
SMI Sun-2's with PROM revision N or later and 3Com Ethernet interfaces.

bootfile@\File to be loaded by ndserver or mvaxbootserver.  Defaults
to compiled-in /usr/V/boot/Vload10.d or /usr/V/boot/Vload.vax respectively.
The former is appropriate for a Sun-2 or Sun-1.5 with 3Com Ethernet interface.
Should be an absolute pathname.

ip-address@\The
workstation's Internet Protocol address, given in the conventional
[a.b.c.d] notation, where a, b, c, and d are decimal integers.  On the
3 Mbit Ethernet, the default value of d is the 8-bit Ethernet host address,
while default values of a, b, and c are determined by the Internet server.
For the 10 Mbit Ethernet, this keyword should always be present.

ip-gateways@\Name
of a file containing a list of Internet gateways to be used by
this workstation.  The file name is given relative to the standard [sys]
context.  If this keyword is omitted, the Internet server will not forward
datagrams through any gateways, i.e., only local traffic will be supported.

boot@\Controls whether the boot server (ndserver for Sun Network Disk 
protocol, mvaxbootserver for MicroVAXes with DEC MOP protocol) will respond to
boot requests from this workstation.  The server will refuse to respond only if
there is no config file (although mvaxbootserver has a ``-n'' flag to override
this) or if the config file contains ``boot:no''. This field has no effect
on Sun-3 RARP/TFTP booting.

ndboot@\A synonym for ``boot'', used only by the ndserver.  This is an
historical relic and should vanish in the future.  Any existing config files
which use ``ndboot'' should be edited to use ``boot''.

kernel@\Filename of the program to be loaded as the kernel, for use by Vload.
The name is given relative to the standard [sys]boot context.  If this
keyword is omitted, Vload uses a compiled-in default.

team@\Filename of the first team, as above.  If it is omitted, Vload uses a
compiled-in default, currently team1-vgts.

world@\Either V or xV.  Used by Vload.  If omitted, Vload uses a compiled-in
default, currently V.

boot-options@\Boot options for use by Vload.  Currently the only option 
is @t[b], meaning
``break before starting kernel.''  The default is a null string.

startup-script@\Filename of the startup script.  Currently used only by
team1-server,
for workstations that autoboot as servers.  No default.  In the future,
the definition of this keyword will be changed to allow the startup script to
be placed directly in the config file, and all (or most) versions of the
first team will use it. This feature is not in V6.0.

terminal-type@\Type
of terminal used as a console.  Used by the STS.
The default is to assume the 
Stanford PROM terminal emulator for Cadlincs, or something ANSI-compatible
(like the SMI PROM terminal emulator) otherwise.  The only other recognized
value for this option is ``h19''.

location@\Optional location field.

comment@\Used
to put a comment in the file, such as a description of the
workstation.
@end(description)

@section(Implementation)
Ordinarily, programs should not be aware of the implementation of the
configuration database; this implementation may change in the future.
The QueryWorkstationConfig() function should be the only interface used.
Since there is no standard library function provided to modify the 
configuration database, however, system maintainers need to be aware of its
implementation.  The current implementation allows the configuration
database to be modified with an ordinary text editor, and the changes
installed with the same tools that are used for installing new binary
program images on storage servers.

The V configuration database is currently implemented as a set of
@i[configuration files], one for each workstation.  Each configuration file
must be present on every publically-available V storage 
server.@foot{Publically-available storage servers are defined as those that 
respond
to GetPid(STORAGE@us()SERVER, ANY@us()PID) requests from nonlocal clients.}

The name of each workstation's 
configuration file is derived from its hardware Ethernet address (a
convenient unique identifier).@foot[Currently, on Sun-2 workstations
with 3Com Ethernet interfaces, the address assigned to the Ethernet board is
used, not the address assigned to the processor.]  The files are kept in a
subcontext named ``config'', under the server's [sys] context.
For a workstation with Ethernet address 0260.8c01.9954 (a typical
3Com-@|assigned address), the configuration file could then be read by a
workstation as a file named ``[sys]config/C.02608c019954''; this is in fact
how QueryWorkstationConfig() is implemented.

A configuration file is an ASCII text file,
consisting of a set of keyword/value pairs, arranged in no particular
order.  Each keyword appears at the beginning of a new line, and
is separated from its corresponding value by a colon (`:').  A line
beginning with a colon serves as a continuation of the value on the
previous line.  
This format has been designed to be easy to read and easy to parse.  
(Note that spaces both before and after the colon may be
considered significant by programs, so take care when creating or editing
config files.)

At Stanford,
the master copies of configuration files are kept in the directory
/xV/config on Pescadero, and only those copies should be edited.  The
command ``build install'' (run as user @i[ds]) is used to install changes.

@section(Usage)

In general, we have implemented
programs that use this service in such a way that if a configuration
file or specific keyword/value pair is missing, some reasonable
default is used where this is possible.
Also, where it is easy to reliably determine
something by examining the hardware present, it is best to do that instead
of putting the information
in the configuration file.  Following these principles
means that
fewer updates to the configuration files are needed to keep
workstations running correctly when something changes.

In some cases,
the value of a keyword may be the name of a file,
perhaps because it is more convenient
for the client to read the information from a file, or
because the information associated with the keyword is quite
bulky.
In the present implementation, such files are kept
in the ``[sys]config'' directory
along with the configuration files themselves.  Files whose names begin with
``S.'' are startup command scripts for workstations that boot automatically.
Files whose names begin with ``G.'' are gateway information files used by
the internet server.

