@Part( operations, root "manual" )
@Chapter(Kernel Operations)@Label(operations)
@index(Kernel Operations)

The operations provided by the V kernel can be divided into three
classes: kernel traps, kernel process operations, and kernel device
operations.

The most basic kernel operations, including @t[Send()], are implemented
as kernel traps.  These operations are invoked by executing a trap
or system call instruction which invokes the kernel.
A number of secondary operations are implemented by a pseudo-process
running in the kernel, called the kernel process.  Such operations are 
invoked by sending to the kernel process's pid.  Finally, operations
on kernel-implemented devices are provided by a second pseudo-process,
called the kernel device server.  Such operations are invoked by sending
messages to the device server's pid, using the standard V-System I/O
protocol.

The kernel traps include:
@begin(verbatim)
Forward()		GetPid()		MoveFrom()	
MoveTo()		ReceiveSpecific()	ReceiveWithSegment()
ReplyWithSegment()	RereadMsg()		Send()
@end(verbatim)

The kernel process operations include:
@begin(verbatim)
CreateProcess()		CreateTeam()		Delay()
DestroyProcess()	GetTime()		QueryProcessState()
SetPid()		SetTeamPriority()	SetTeamSize()
SetTime()		Wakeup()		WriteProcessState()
@end(verbatim)

These functions are documented fully in the @i[V-System Program Environment 
Manual].  Other kernel operations described there, such as @t[Receive()],
@t[Reply()], @t[ValidPid()], etc., are implemented as library functions
using the basic operations listed above.



