@Part( maintain, root "manual" )
@Chapter(Kernel Modification and Maintenance)@Label(maintain)

The type of kernel modifications anticipated include:
changing the maximum number of processes, teams, or devices allowed,
adding or removing kernel operations, and adding support
for new devices.
@Section(Kernel Configuration Parameters)
@Index[kernel configuration]
The machine-dependent file @i[config.h] contains the kernel 
configuration@Index[config.h]
parameters.
@begin(Description)
MAX@us()PROCESSES@\Maximum number of processes, which must be a power of 2.
@Index[number of processes]

MAX@us()TEAMS@\Max. number of teams, currently at most 16 on the SUN
workstation.@Index[number of teams]

MAX@us()DEVICES@\Max. number of device instances, which must be a power of 2.
@Index[number of devices]

ROOT@us()PRIORITY@\Priority of root process of first team.
@Index[root process]

INIT@us()STACK@\Size of initial stack for root process of first team.
@Index[initial stack]
@end(Description)
The kernel can be reconfigured with respect to these parameters
by changing their definitions in @i[config.h] within the constraints mentioned
above and recompiling the kernel.
@Section(Adding New Device Support)
@Index[adding devices]
Supporting a new device using the kernel device manager
requires writing device-specific initialization, read, write,
release, modify and interrupt-handling
routines and adding an entry for the device
in the DeviceCreationTable defined in @i[config.c].
@Index[DeviceCreationTable]
There is normally a header file for the new device that defines
its device type for this table plus other device-specific information
required by users of the device.
The existing devices and kernel operations are useful models from
which to work.

@Section(Adding Kernel Operations)
@Index[adding kernel operations]
Adding a kernel operation requires writing the C routines
that implement the operation,
adding an entry for it to the kernel trap table, @b[kernelops],
@Index[kernelops]
defined in @i[trap.c]
@Index[trap.c]
and possibly adding a @i[stub] for this call to the
C environment library for the kernel calls.
Adding a new operation to the kernel process requires defining
a new request code in <Venviron.h>, handling this request code
in the main loop of the kernel process and writing the appropriate
code for handling the request.  Operations that must be available
to remote processes should be implemented as kernel process operations
rather than kernel traps.

Certain restrictions apply to kernel operations.
They may not execute trap operations or call upon services provided
by other processes outside the kernel.
However, they can use other routines already available inside
the kernel.
Kernel operations are passed exactly 5 arguments and allow
@Index[kernel arguments]
one return value.
A kernel operation cannot take a variable number of arguments
unless the number is encoded in the values passed.
Operations that access any data modified by interrupt-invoked
routines need to mask interrupts if there is any possibility
of interference.
Finally, operations that block or unblock processes should
use the internal primitives Addready and Removeready.
@Index[Removeready]
@Index[Addready]
