@string(LastEditDate="Tue Jun 17 15:20:36 1986")
@comment(Current maintainer: Keith Lantz)

@part(Introduction, root "manual")
@chapter(Introduction)

The V-System is a message-based distributed operating system designed
primarily for high-performance workstations connected by local networks.  It
permits the workstation to be treated as a multi-function @i(component) of
the distributed system, rather than solely as a intelligent terminal or
personal computer.  Ultimately, it is intended to provide a general-purpose
program execution environment similar to some degree to U@c(NIX).  The
programs are intended to interact with each other, and with programs running
on traditional timesharing systems, to produce an integrated distributed
system.

@section(The Hardware Environment)

The V-System is targeted for a hardware environment consisting of (see Figure
 @ref(FigWBDS)):
@begin(itemize)
powerful workstations with:
@Begin(itemize, spread 0)
a high-resolution (e.g. 1024 by 1024) raster display;

a general-purpose 1 MIPS (or better) processor;

2 Mbytes or more of local memory;

a large (greater than 20 bits) virtual address space;

a graphics input device, such as a mouse; and optionally,

a disk,
@End(itemize)
which, typically, will be dedicated to a single user at a time;

a fast (greater than 1 MHz) communications network that will link the
workstations;

a number of dedicated processors providing printing, file storage, general
computation support, and other services; and

access to time-sharing or special-purpose computers and to long-haul
computer networks.
@end(itemize)
@Begin(Figure)
@PressPicture( Height = "5.75 Inches", File = "wbds.fig" )
@Caption(A workstation-based distributed system.)
@Tag(FigWBDS)
@End(Figure)

This release of the system runs on Sun and VaxStation workstations
interconnected by either 3 or 10 Mb Ethernet.
``Guest-level'' implementations are available for 4.2BSD and 4.3BSD
U@c(NIX) systems (with Stanford enhancements).  

@section(The User Model)

One of the most important functions for the workstation is to
provide state-of-the-art user interface support.  
The workstation should function as a @i(front end)
to all available resources, whether local to the workstation or remote.
To do so, the V-System adheres
to three fundamental principles:
@begin(enumerate)
The interface to application programs is (reasonably) independent
of particular physical devices or intervening networks.

The user is allowed to perform multiple tasks simultaneously.

Response to user interaction is fast.
@end(enumerate)

Adhering to these principles, the V-System supports a reasonably
sophisticated ``window system''.  Multiple executives or shells may be run
simultaneously, each of which may run one application in the ``foreground''
and any number in the ``background'' (a la the UNIX C-shell).  Applications
may run local to the workstation or remote.  Each application may be
associated with one or more separate @i(virtual terminals), each of which
may be used to emulate either a VT-100 terminal or a 2-D ``structured
graphics'' terminal.

@section(The System Model)

The V-System adheres to the @i(server model):  The world consists of a
collection of @i(resources) accessible by @i(clients)@foot{A @i(client) is a
program requesting access to a resource, typically on behalf of a human
 @i(user).} and managed by
@i(servers).  A server defines the abstract representation of its
resource(s) and the operations on this representation.  A resource may only
be accessed or manipulated through its server.  Because servers are
constructed with well-defined interfaces, the implementation details of a
resource are of concern only to its server.  Note that a server frequently
acts as a client when it accesses resources managed by other servers.  Thus,
 @i(client) and @i(server) are merely roles played by a process.

Clients and servers may be distributed throughout the (inter)network.  By
default, access to resources is @i(network transparent);  a client may access
a remote resource with the same semantics as it accesses a local resource.
The result is an environment in which clients may communicate with servers
without regard for the topology of the distributed system as a whole.
However, we do not intend that a client cannot determine or influence the
location of a particular resource, rather that a transparent mechanism is
available.  Moreover, we allow for clients and servers that were not
written with network-transparent access in mind.

Architecturally, then, the V-System consists of a distributed kernel and a
distributed set of server processes.  

@subsection(The Distributed Kernel)

The distributed kernel consists of the collection of kernels resident on
each participating machine (see Figure @ref(FigVKernel)).  Each host kernel
provides process management, interprocess communication, and low-level
device management facilities.  All other operating system services are
implemented as (collections) of processes outside the kernel.  A host
kernel may be implemented at a @i(base level) (as on the S@c(UN)
workstation) or a @i(guest level) (as under 4.2BSD).
@begin(figure)
@PressPicture( file="vkernel.fig", height="4.03 inches")
@Caption(The distributed V kernel.)
@Tag(FigVKernel)
@end(Figure)

The host kernels are integrated via a low-overhead @i(inter-kernel) protocol
(IKP) that supports transparent interprocess communication between machines.
IKP is a reliable request-response protocol,
intermediate in complexity between conventional datagram and
virtual circuit protocols.

@subsection(Servers)

Servers include:
@Begin(description)
@i(virtual graphics terminal server)@\Provides all
terminal management functions, including VT-100 emulation and
2-D graphics.  One per workstation.

@i(internet server)@\Provides network and transport level
support for traditional network architectures, namely, ARPA Internet and
Xerox PUP.  Higher-level protocols, such as TELNET, are provided as separate
packages that interface to the internet server.

@i(pipe server)@\Provides asynchronous, buffered communication facilities
similar to U@c(NIX) pipes.

@i(team server)@\Provides team creation, destruction, and management.  One
per workstation.

@i(exception server)@\Fields process exceptions and dispatches them to
registered handlers, such as debuggers.  One per workstation.

@i(storage server)@\Provides file storage.

@i[device server(s)]@\Interfaces to a specific physical device, such as the
console, mouse, serial line, or disk.

@End(description)

@section(The Application Model)

In general, it is just as easy to write applications to run under the
V-System as it is to write applications to run under any traditional
operating system, such as U@c(nix).  A standard program environment is
defined, the principal instance of which is the C program library.  The C
library provides runtime support for standard C and U@c(NIX)-like library
functions, including both byte-stream and block-I/O facilities (see Figure
 @ref(FigVLib)).  In effect, these libraries can be used to ``hide'' the
underlying V-System kernel calls, thus facilitating the porting of existing
C programs.  
@begin(figure)
@PressPicture( file="vlib.fig", height="4.84 inches")
@Caption(Client interfaces to the V-System)
@Tag(FigVLib)
@end(Figure)

On the other hand, an application programmer may choose to take advantage of
the enhanced facilities provided by the V-System.  These facilities fall in
two major categories: user interaction and concurrent programming.  Additional
advantage accrues from the fact that applications may be distributed across
multiple machines.

@subsection(User Interaction)

With respect to user interaction, the V-System provides two principal
enhancements over traditional U@c(NIX)-like systems.  First, a program may
manipulate multiple virtual terminals (windows) simultaneously.
Second, an application may employ @i(structured) graphics.  Specifically, a
graphical object can be defined in terms of other objects, which can in turn
be defined in terms of yet other objects.  Thus, the VGTS supports
 @i(structured display files) rather than the more common @i(segmented
display files).  The resulting @i(virtual graphics terminal protocol) (VGTP)
is a high-level object-oriented protocol that minimizes both the
frequency of communication between application and VGTS and the amount of
data transmitted at any one time.  

@subsection(Concurrent Programming)

Using the distributed kernel well requires understanding the model of
processes and messages that the kernel provides, and how they are intended
to be used.  Processes represent logical @i[activities] within the
application.  They are intended to be sufficiently inexpensive to allow the
use of multiple processes to achieve the desired level of concurrency.  In
particular, multiple processes may share the same address space or @i(team),
to facilitate fine-grain sharing of code and data.  A team must be entirely
contained on a single machine.

Processes can be dynamically created and destroyed.  When a process is
created, it is assigned a unique @i(process identifier) that is
used subsequently to specify that process.  

Synchronous message-passing facilitates communication between processes that
looks to the sender like a procedure call.  That is, the sender blocks until
a reply to his request is received.  Greater flexibility is provided to the
receiver to allow scheduling of requests.  Messages are addressed to the
process identifier of the recipient; there is no concept of  a @i(mailbox)
or @i(port) distinct from a process.

Messages are short and fixed-length.  To facilitate transfer of large
amounts of data, a separate data transfer facility is provided.
Specifically, a process can pass, in a message, access to an area in its
team space.  This facility follows the procedure paradigm in being used
primarily to access what are logically ``call-by-reference'' parameters.
Synchronization between the two processes involved in the data transfer is
guaranteed by virtue of the fact that the recipient will not reply to the
sender (and hence awaken him) until the transfer is complete.

The kernel also provides process groups and group interprocess communication.
Each process can create, join, and leave groups dynamically,
and can belong to many groups simultaneously.
A message sent to a group is delivered reliably to the first group member to
reply, and unreliably to the rest.
Replies subsequent to the first may be received (unreliably) by
the sender, or ignored, at its option.

Process scheduling is strictly priority-based.
The effective priority
of a process is the sum of its @i[process priority]
and its @i[team priority].  
Team priorities are dynamically varied by the team server
to provide time-slicing.

@subsection(Classes of Applications)

From the previous discussion it should be apparent that applications may run
local to the user's workstation or on any other host accessible via the
various network protocols.  Ultimately, all applications must
communicate with the user via the virtual graphics terminal server (VGTS)
resident on the user's workstation.  The application interface to the VGTS
is referred to as the virtual graphics terminal protocol (VGTP).

The VGTP is constant over all applications.  However, some applications
have no knowledge of the VGTP and some applications are running on machines
that do not support the interprocess communication mechanisms underlying the
VGTP.  The following situations arise (see Figure @ref(FigClients),
in which each inter-machine arc is labeled
with an example @i[(presentation protocol, transport protocol)] pair):
@begin(figure)
@presspicture(height 4.5in, file "clients.fig")
@caption(Some possible applications.)
@tag(FigClients)
@end(figure)
@begin(itemize)
Application @p(A) runs on the workstation and communicates via the VGTP.
Current examples include text editors, document illustrators, and design
aids, many of which are documented here.

Application @p(B) runs on a machine that supports V kernel services,
specifically, network-transparent interprocess communication via 
IKP.  @p(B) communicates with the VGTS via the VGTP, as in
the case of a application @p(A).  

Application @p(C) runs on a machine that does not support IKP, but does
support a traditional network architecture such as the Internet protocol
family.  In addition, a VGTP interface package is available that
encapsulates the VGTP within the appropriate transport protocol.  Similarly,
a local @i(agent) for the application, @p(C'), is created on the workstation
to decapsulate the VGTP.  Thus, the application may still be written in
terms of the VGTP and neither it nor the VGTS have any knowledge that the
other is remote.  Our VLSI layout editor, for example, can be run in this
fashion under V@c(AX)/U@c(NIX).

Application @p(D) has no knowledge of the VGTS or the VGTP; it wishes to
regard the workstation as just another terminal.  The local agent, @p(D'),
is ``user T@c(ELNET)'' and performs the appropriate translations between
T@c(ELNET) and VGTP.  Any pre-existing application that runs on a remote
host falls into this class.

Application @p(E) is distributed between the workstation and one or more
other machines.  The local agent, @p(E'), is responsible for representing
the multitude to the VGTS.  It must perform the appropriate set of protocol
conversions indicated above.  In addition, it may wish to perform
application-specific functions, such as caching.  In that case, the protocol
used to communicate with the remote applications may require more than
simple transport service.  The Amaze game documented herein is an
example of such an application.
@end(itemize)

@section(Outline)

The remainder of this manual consists of four parts:
@Begin(description)
Part 1@\@b(Using V):
describes the user interface and available application programs.

Part 2@\@b(V Programming):
defines the V-System program environment in
terms of the existing C program library.

Part 3@\@b(V Servers):
defines the standard message formats, request and reply types, and
protocols; presents the various server-specific protocols; and gives some
implementation details.

Part 4@\@b(Appendices): a V-System bibliography, notes on programming style,
installation notes, and a list of where the various library functions are
defined.
@End(description)

