@Part(ved, root "manual")

@Chapter(ved: A Text Editor)
@label(ved)
@index(Ved)@index(editor)

Ved is the V system text editor.
Its basic keyboard commands are a
subset of Emacs.  However, the mouse adds a whole new style of interaction
with the editor.  The multiple window capability of the VGTS is put to good
use, as well.

Ved manages one or more editing windows.  Each window is thought of as 
a viewport onto a @i[buffer] of text, a continuously accurate display of some
portion of that text.  A change to the buffer is followed immediately by a
corresponding change to the display.  In each buffer there is a cursor, which
is guaranteed always to be in the portion of the text displayed.
Each buffer normally has a filename associated with it, the file from
which it was read or the file to which it was most recently written.

@Section(Starting up)
@index(Starting up Ved)

Ved is invoked as follows:
@begin(programexample)
ved {-@i[number]} {@i[filename]}
@end(programexample)
If a file name is given, Ved begins by reading in the file.
It then requests an AVT, its first editing window.  This
is indicated by the mouse pointer, which changes to the word ``Pad''.  Move the
mouse to the desired upper left corner of the AVT and click any button.  The
AVT will appear, and in it the first screenful of text will be displayed.
The AVT in which ved was invoked is reserved for displaying error messages and
typing special text, such as filenames or search strings, which is not to
be inserted into any buffer.  Typing into this window while not specifically 
being prompted there for text will buffer those characters until input @i[is] 
requested.  This is not, in general, the desired result.
In normal use it is convenient to shrink this
window down to a few lines at the bottom.

The number of lines in the AVT created for displaying a 
file can be specified with 
the @b[-]@i[number] option.  The default size is 28 lines.

At the top of the editing window, there is a banner.  When the banner is
inverted (darkened),
then this window is selected for input either by the mouse or the
keyboard.  The banner specifies the ved window number which is used by the
window selection command (described in section @ref(Select)) and the Vgt
number (see section @ref(ViewManager)).  The rightmost area is
reserved for the file name associated with this window.  If the file name
has an asterisk (*) prefix, then ved thinks that this buffer has been modified
since the last write or save of the specified file.

As an added feature, there is a inverted line of text
at the bottom of every ved window.  This is the fixed menu area of the window.
It can be used to enter some frequently used commands
using the mouse instead of the keyboard
(a full description of the fixed menu is in section 
@ref(FixedMenu)).


@section(Some Notational Conventions)

In the subsequent command descriptions the following notational conventions 
will be used:
@begin(itemize, spread 0)
^@i[k] denotes hitting the @c[ctrl] key simultaneously with the @i[k] key.

Esc-@i[k] denotes hitting the @c[esc] key followed by hitting the @i[k] key.

^@i[k]-@i[j] denotes hitting the @c[ctrl] key together with the @i[k] key, 
followed by hitting the @i[j] key.

Some keyboards have function keys that generate sequences beginning
with Esc-[.
Where these are 
supported by ved, they will be denoted by Ansi-@i[k], meaning the 
sequence Esc-[-@i[k].
@end(itemize)

In general, there are (roughly) the following categories of key commands:
@begin(itemize, spread 0)
Regular key strokes: e.g. @i[k].

"Control" characters: e.g. ^@i[k].

"Escape" characters: e.g. Esc-@i[k].

"Control-x" characters: e.g. ^x-@i[k].

"Control-x control" characters: e.g. ^x-^@i[k].
@end(itemize)


@section(Special Commands)
@index(Special Ved commands)

@Begin(Description)
^g@\Get out of special states.
Whether you have just typed Escape or ^X and didn't
want to, or are busy typing a search string, or whatever, ^g will get you
back to the normal state.

^x-^z, ^c@\Quit the editor.
If there are any modified buffers, you will be asked
if you want to save them.  If any @b(.CKP) files (files with @b(.CKP) suffixes
are checkpoint files) have been created during this ved session, they will
automatically be deleted.
Here and in similar cases, if you are warned and then decide you don't want
to do the command at all, type ^g to escape back to normal editing.  Typing 
anything other than an @b[n] or @b[y] will cause the question to be asked 
again.

^l@\(CTRL - L) Redraw the display.

^u@\Prefix argument.  Typing a number after this causes the number to be used 
as an input argument to the subsequent editing command.  The prefix argument 
is only used by some commands.  The others simply ignore it.  ^u is very 
similar (in intention at least) to the ^u repeat factor in Emacs.
@End(Description)


@Section(Cursor Motion)
@index(Ved cursor motion)

@Begin(Description)
^f, Ansi-c, right arrow@\Move forward (right) one character.

^b, Ansi-d, left arrow@\Move backward (left) one character.

Esc-f@\Move forward to the end of a word.

Esc-b@\Move backward to the beginning of a word.

^p, Ansi-a, up arrow@\Move up one line.  A half page is scrolled if the 
cursor would go off the AVT.

^n, Ansi-b, down arrow@\Move down one line.  A half page is scrolled if the 
cursor would go off the AVT.

^a@\Move to the beginning of the line.

^e@\Move to the end of the line.

Esc-comma, Ansi-h@\Move to top, left-hand corner of the viewport.

Esc-period@\Move to bottom, right-hand corner of the viewport.

Esc <@\Move to the beginning of the buffer.

Esc >@\Move to the end of the buffer.

Esc-g@\Go to line.
Prompts for a line number, and moves the cursor to the head
of that line in the file.  The first line is numbered 1.  If the number is too
large, it will go to the end of text and notify you of the true line number
there.
@End(Description)


@Section(Paging and Scrolling)
@index(Ved paging)@index(Ved scrolling)

@Begin(Description)
^v@\Page down 1 page.

Esc-v@\Page up 1 page.

Esc-down-arrow, Esc-Ansi-b@\Page down 1/2 page.

Esc-up-arrow, Esc-Ansi-a@\Page up 1/2 page.

^z@\Scroll one line up.  I.e. move the viewport up one line relative to the 
text.

Esc-z@\Scroll one line down.  I.e. move the viewport down one line relative 
to the test.

Esc-!@\Scroll current line to the top of the viewport.
@End(Description)


@Section(Special Characters)
@index(Ved special characters)

Typing any printing character, or TAB, inserts the character typed.
Ved also supports an "auto-linefeed" mode.
When auto-linefeed is enabled, typing in characters which would extend beyond 
the viewport's right-hand edge causes a linefeed character to be inserted 
before the last word on the current line.  The effect is to split the current 
line into two lines, with the last word of the old line becoming the first 
word of the new line.  This mode can be toggled on 
or off:
@begin(description)
^x-l@\Toggle auto-linefeed option.
@end(description)

Various special characters are handled as follows:
@begin(Description)
Return@\Insert a Linefeed, not a CR character_gets the desired effect.

Linefeed@\Insert a newline (Linefeed) and then indent the new line
to the indentation of the previous line, using tabs where possible.
If the previous line is empty, it will look up until it finds a nonempty
line and use that as the standard of indentation.

^o@\Insert a Linefeed, leaving the cursor before it.

^q@\Quote
the following character.  Allows you to insert non-printing characters
(such as the useful ^l, formfeed, which forces a page break on most printers)
into the text.

^\@\Quote
the following character and insert it with the high bit set.  ^q and
^\ are the only exceptions to the ^g command: they will quote a following ^g,
but that simply means the insertion of a character, which can easily be deleted.
@end(Description)


@section(The Kill Buffer)
@index(Ved kill buffer)

Ved provides a special buffer, called the @i[kill buffer], that is used to 
temporarily store text for various operations.  
Various editing commands specify 
this buffer as the source or destination of text they manipulate.  The buffer 
should be thought of as a "clipboard" that is used for "cutting and pasting" 
operations on text.


@section(Basic Editing Commands)
@index(Ved editing commands)

@Begin(Description)
^d@\Delete
forward from the cursor_the character under the cursor.

del, backspace, ^h@\Delete backward from the cursor.

Esc-d@\Delete word forward.

Esc-h@\Delete word backward.

^k@\As in Emacs.  Delete the contents of one (logical) line, or the
carriage return on an empty line, into the killbuffer.  A 
sequence of ^k commands @b[uninterrupted] by any other command causes
the whole section thus deleted to go into the killbuffer.  ^k
after any other command restarts the killbuffer from scratch.

^y@\Yank_insert contents of the killbuffer at the cursor.  The killbuffer
is unchanged.  The cursor ends up at the beginning of the insertion, and
the Mark (see below) ends up at the end.

Esc-y@\Yank,
but without disturbing the Mark.  The cursor ends up at the
end of the insertion.

^t@\Transpose the two characters before the cursor.

Esc-u@\Make the word the cursor is in, or just after, all capital letters.

Esc-l@\Make the word the cursor is in, or just after, all lower case.

Esc-c@\Capitalize the word the cursor is in, or just after.

Esc-tab@\Add indentation to this line equal to the indentation of the
previous line.  Intended use: if you type Return and wish you had typed
Linefeed, this will make up the difference.

Esc-blank, Esc-right-arrow, Esc-Ansi-c@\Indent the current line four spaces.

Esc-backspace, Esc-^h, Esc-left-arrow, Esc-Ansi-d@\Decrease the indentation 
of the current line four spaces.
@end(description)


@section(Mark and Region)
@index(Ved mark)@index(Ved region)

Ved maintains an invisible point in the buffer called Mark. 
Until otherwise
set, it is at the beginning.  It can be set by ^x^m or
Control-@@ (Control-spacebar is the same as Control-@@ on some keyboards).
``Region'' refers to all the text between Mark and the cursor.
The following commands use these concepts:

@begin(Description)
^x-^m, ^@@@\Set the Mark at the current cursor position.

^x-^x @\Exchange Mark and cursor (changing the display if necessary to
keep the cursor on the screen).

^w, ^x-^k @\Kill region.  Region vanishes and becomes the killbuffer_so this
command can be undone with ^y.

^x-^r @\Write region.  Prompts for a file name, and writes the region into
that file.  The buffer is unchanged.

Esc-i@\Indent region.  Indents all lines in the region by the number of 
spaces specified by the prefix argument.  If no prefix argument was 
specified, then all lines are indented one space.
@end(Description)


@section(C-Specific Editing Commands)

The commands described in this section are specific to the editing of C 
programs.
@begin(description)
Esc-{@\Generate two new lines, the first containing a { indented two spaces 
from the previous cursor position, the second containing the cursor an
additional two spaces indented.

Esc-}@\Generate two new lines, the first containing a } indented two spaces 
less than the previous cursor position, the second containing the cursor 
indented an additional two spaces less.
@end(description)


@Section(Searching and Replacing)
@index(Ved searching)@index(Ved replacing)

@begin(description)
^s@\Search for string.
Prompts for a string, and finds the first
instance of that string after the cursor.
Prints ``Not found'' if there is no such instance.
If you type Return without typing any search string, the previous
search string is used. 
Here and elsewhere, a newline can be inserted into the search
string using the Linefeed key.  It is echoed as an inverse-video backslash.
Non-printing characters can be searched for, and are echoed as like ``^A''.
If the search succeeds, the string found is selected, and several special
commands (described in The Right Hand and the Left, below) are available.
In particular, typing @b[s] will repeat the search.

^r@\Reverse search.  Just like ^s but searches backward.

Esc-s@\Repeat search.
Forward search for the string most recently used
in a ^s or ^r command.  Works regardless of whether there is currently a
selection or not.

Esc-r@\Repeat search backward.
Like Esc-s but searches backward.

Esc-q@\Query Replace.
Prompts for a search string, then a replacement string.
Then searches till it finds the search string, and selects that text.  Type
@b[y] (yes) to replace, @b[n] (no) to leave it alone and go on.  
Other options are
described below.  These special commands are available whenever there is a
selection, so Query Replace is easily re-enterable.

^x-t@\Tag search.  If a @t[tags] file is present in the current working 
directory, then this command can be used with it to find keywords in various 
files.@foot(Those unfamiliar with tags should read the @c[unix] manual entry 
for @t[ctags].  This command creates a file which specifies the location of 
every C-program function and type definition in a specified set of source 
files.  It provides a means of locating such definitions without having to 
perform a string search on all source files each time.)
@end(Description)


@Section(File Access)
@index(Ved file access)

Ved supports various options with respect to file writing operations and 
checkpointing operations.  Files can be backed up and they can be written out 
using a "verify" option that ensures that what was written out is actually 
what is in a buffer.  
These options can be toggled on or off, as described below.
Files can also be automatically checkpointed every @i[n] editing actions.  
Specification of the checkpoint frequency is done in the 
@t[.Ved@uf()pro] initialization file.  (See section @ref(VedPro).)

When ved's backup option is on, it preserves the previous version of a file 
by renaming it to its former name followed by ".BAK".
Thus @i[myfile.c] becomes @i[myfile.c].BAK .
Similarly, if the checkpointing option is on, files are periodically written 
out to a file whose name consists of the actual filename followed by ".CKP".
Thus @i[myfile.c] becomes @i[myfile.c].CKP .
The verify option reads files back in after writing them and compares them 
against the buffer contents.  This feature represents an end-to-end check 
that was implemented at a time when the V-system's file writing operations 
were not completely reliable.

Upon normal exit from ved
(by either typing ^x-^z, or ^x-d to the last window) the .CKP files that
were created during the current ved session will be automatically deleted.
If ved exits abnormally, these files will contain a copy of your files
that are correct as of the last time checkpointing was performed.

Ved filenames can be up to 256 characters long, but filenames of this length
are not in general recommended.

@begin(Description)
^x^v@\Visit a file, whose name will be requested.  The new file replaces
the current one, so if the current buffer is modified you will be asked
before proceeding.

^x^s@\Write the buffer back to the file from which it was read.

^x^w@\Write the buffer to a file whose name will be requested.

^x^i@\Insert file at the cursor.  You will be asked for the file name.
Cursor and Mark are set just as in ^y above.

Esc-^m@\Write all modified buffers to the files from which they were read.  Esc-Return has the same effect.

Esc-~@\Forget that the buffer has been modified.  This will cause the file 
not to be written out on exit or when a command is given to write out all 
modified buffers.

^x-b@\Toggle
the .BAK safety feature.  Creation of .BAK files makes file
writing take about 4 times as long as it otherwise would, so if you really
want that speedup, this will turn off the making of .BAK files.  
Typing ^x-b again will turn it back on.

^x-v@\Toggle the verified write option.

^x-c@\Change current context (working directory).
The Ved control window always displays the absolute name
of the current context in its banner,
while file windows display the absolute path name of the file being edited.
@End(Description)


@Section(Windows and Buffers)
@index(Ved windows)@index(Ved buffers)

Ved is normally started with one editing window, but it can support
several.  Each editing window is associated with a separate editing buffer,
which includes the text, cursor position, selection if any, associated
filename, and whether this buffer has been modified.  Multiple windows on the
same buffer are not supported.  Since the correspondence is one to one,
hereafter we refer to ``window'' meaning ``window and its associated buffer''.
At any time one window is selected for editing, and has its banner 
inverted (darkened).
Window selection can be changed by clicking a mouse button in an unselected
window, or by ^x-@i[digit].  Windows are
numbered, starting at 1, in the order of their creation.

The search and replacement strings and the killbuffer are
universal across windows.  Thus it
is possible to kill some text in one window and yank it into another.  It is
likewise possible to search for a string in one window, then select another
window and repeat-search on the same string.

The window from which ved was invoked is special.  It cannot receive
input except during certain commands, at which time it is selected
automatically.  It is never receptive to mouse input.

@begin(description)
^x-g@\Get file.  Prompts for a file name, and reads it into a new
window.  If no file name is given, creates an empty window.  Here and in
all other cases, when a window is to be created the mouse cursor will change
to ``Pad'' and let you indicate where the window is to go.  If you abort the
AVT creation by pressing all three buttons, the command is aborted.

^x-G@\Get file and specify window size.  In addition to prompting for a file 
name, you also get prompted for the number of lines the window should have.

^x-d@\Delete the current window.  Will warn you if it is modified.
The next lower numbered window becomes selected.  If the last
window is deleted, ved quits, because it cannot live without a
selected window.

^x-y@\Yank to window.  The killbuffer is copied into a new window.

^x-a@\Pull Apart.  Kills the Region in the current window and transfers
it to a new window.

^x-m@\Merge windows.  Asks the user to indicate a secondary window, and
transfers its contents into the current window at the cursor
position.  The secondary window is then deleted.  The secondary window is
indicated by clicking the mouse in it.

^x-1 - ^x-9@\Select the corresponding window.@label(Select)

^x-o@\Order buffers.  Redisplays all the buffers, starting with the highest
numbered one.  This leaves the buffers "stacked" on top of each other on the
screen.  This is useful if buffers have been positioned in a "stair-case" 
order, starting at the lower left and moving to the upper right, so
that the stacked configuration leaves the file name banner of each buffer 
displayed.
@end(description)


@Section(The Mouse)
@index(Ved mouse)
@Label(Mouse)

@index(Mouse)
The mouse offers an alternative way of doing several common editing
functions, such as placing the cursor and deleting or moving text.  
The mouse has two functions: fixed menu selection and editing.

@subSection(Editing With the Mouse)
@begin(Description)
Left button@\Click and release it at any character@index(Left Mouse Button)
in the text: sets the cursor at that character.
Click it at one character, move the mouse to another point in the window,
and release:  selects the text between the point of clicking and the point of
release.  While you are moving the mouse with the left button held down,
the region
which would be selected if you released it at this moment is displayed in
inverse video.  When you release, your selection is defined and remains
displayed in inverse video.  Carriage returns are invisible, so the selection
of a carriage return is shown by black space from the end of the text on that
line to the end of the window.  Note that a selection and a normal cursor are
mutually exclusive.  The importance of this will become apparent below.
If you have a selection and click the left button, with or without moving,
the former selection is deselected and a new cursor position or selection is
chosen.  @b[Caution]: The difference between the cursor and a selection which 
is only one character long is that the cursor flashes, while the selection 
remains inverted.

Middle button@\When@index(Middle Mouse Button)
you have a selection, clicking the middle button 
deletes it into the
killbuffer.  If you have no selection, nothing happens.  The position of the
mouse is irrelevant.

Right button@\Brings@index(Right Mouse Button)
back the contents of the killbuffer
and makes it selected.  If there
is nothing in the killbuffer, nothing happens.  If there was a selection
already, its contents are swapped with the contents of the killbuffer.  If
there was no selection, the contents of the killbuffer replace the cursor.
@end(description)

@subSection(Fixed Menu)@label(FixedMenu)

The fixed menu that appears at the bottom of every ved window provides
the user with mouse oriented file perusal capabilities.  Clicking the
middle or right mouse buttons in the fixed menu area will execute
the command that is nearest the mouse cursor.  All the commands in the
menu could be entered from the keyboard, therefore they are not described
here.  Refer to the sections on searching, scrolling, and
regions for descriptions.

In the fixed menu area, the semantics of the each of the buttons differ.
The middle button (in general) means @i[forward] whereas the right button
means @i[backward].  For instance, clicking the middle button at the
@b[Full-Page] command will cause the window to be scrolled forward one full
page and the right button will cause a reverse scroll.  The commands
@b[Half-Page], @b[Scroll-Line], and @b[Search] behave in this same manner.
The @b[Tag]
command has exactly the same semantics for both buttons.  @b[Mark/Point] is
the only ``different'' command; in it,
the middle button causes a jump to the
Mark and the right button sets the mark at the point.  
Note that the left
button has no effect on any menu selection, to maintain continuity during
dynamic selection.  The @b[Search] and @b[Tag] commands will either use the
selected string as the pattern or prompt the user for one in the case
of no selection.


@Section(The Right Hand and the Left)

When there is a selection, the cursor is not in a single spot, so it would
not make much sense to insert characters at the cursor.  So various printing
characters are used as special selection-mode commands.  The most basic of
these commands are all assigned to left-hand keys.  Thus one possible mode
of operation is for the user to have his right hand on the mouse, selecting
things, and his left hand at the usual place on the keyboard, giving commands
which are not available on the mouse buttons.  Others of these commands are
designed for use with the search and replacement facility.

Non-printing characters other than those described below deselect, then
perform their usual function as if the cursor had been at the beginning
of the selection.

@begin(Description)
space bar@\Deselect.
The cursor lands at the beginning of the selection.
All printing characters not mentioned here also have this effect, but the
space bar is recommended.

tab@\Deselect, but the cursor
lands following the end of the selection.

d@\Delete.
Exactly identical to the middle mouse button.

e@\Exchange.
Exactly identical to the right mouse button.

c@\Copy in place.
A copy of the current selection is inserted right
after it, and becomes the new selection.

g@\Grab.
The current selection is copied into the killbuffer without
deleting it.

s@\Search for the next instance of the selected string.
This becomes the
search string, as used in future Repeat Search or search-and-replace
commands.

r@\Reverse version of s.

^l@\(CTRL - L) Redisplay,
with the selection near the top of the screen.  Good for long
selections which run off the bottom of the screen.

y@\Yes replace.
Replace the selection with the stored replacement string.

n@\No don't replace.
Search for the next instance of the stored search string.

backspace@\Undo replacement.
Search backward for the first instance of the
replacement string and replace it with the search string.  The resulting
string is selected.

Y@\Yes replace but don't move on.
The selection is replaced and the result
remains selected.

u@\Undo in place.
The current selection (which hopefully is the replacement
string) is replaced with the search string.

S@\Search for next instance of the replacement string.

R@\Reverse version of S.

q@\Start query replace.
Takes the current selection as the search string,
and prompts for a replacement string.  Replaces the current selection, and
goes on to the next instance of it, just as ``y'' would do.

Q@\Set replacement string.
The current selection is copied into the
replacement string.  This makes it possible to alter a Query Replace in
mid-flight.

t@\Tag search.  Treats the selection as a tag and searches for its location 
using the @t[tags] file of the current working directory. 
@end(Description)


@Section(Ved Initialization)
@label(VedPro)

Various ved features can be initialized to prespecified values using 
the @t[.Ved@uf()pro] file, which should reside in the user's home directory.
(The existence of this file is optional.)
These include:
@begin(itemize, spread 0)
Redefinition of key bindings.

Specification of toggle settings for various options.

Specification of the checkpointing frequency.
@end(itemize)


@subsection(Key Bindings)

Ved uses a key table to determine what function should be invoked when a 
particular key  or key sequence (such as ^x-^c) is typed.  The default 
settings in this key table have been described.  The user can change the key 
table settings by specifying new bindings in the initialization file.  The 
syntax to use for specifying new key bindings is demonstrated below in the 
list of default bindings shown.  Thus, for example, one could set a new key 
binding that defined the ^x-^m key sequence to denote WriteModifiedFiles 
instead of the Esc-^m key sequence, by placing the following line in 
one's @t[.Ved@uf()pro] file:
@begin(programexample)
^x-^m WriteModifiedFiles
@end(programexample)

The default key bindings are the following:
@begin(programexample)
\\r InsertReturn
\\n NewlineAndIndent
\\t InsertTab
Esc-\\t IndentLikePreviousLine
^u ProvidePrefixArgument
^x-^z ExitEditor
^c ExitEditor
@end(programexample)
@begin(programexample)
^f ForwardCharacter
Ansi-c ForwardCharacter
rarrow ForwardCharacter
^b BackwardCharacter
Ansi-d BackwardCharacter
larrow BackwardCharacter
@end(programexample)
@begin(programexample)
^a BeginningOfLine
^e EndOfLine
^n NextLine
Ansi-b NextLine
darrow NextLine
^p PreviousLine
Ansi-a PreviousLine
uarrow PreviousLine
@end(programexample)
@begin(programexample)
^z ScrollOneLineUp
pf1 ScrollOneLineUp
smi-pf1 ScrollOneLineUp
Esc-z ScrollOneLineDown
pf2 ScrollOneLineDown
smi-pf2 ScrollOneLineDown
@end(programexample)
@begin(programexample)
Esc-f ForwardWord
Esc-b BackwardWord
Esc-u CaseWordUpper
Esc-l CaseWordLower
Esc-c CaseWordCapitalize
@end(programexample)
@begin(programexample)
^v NextPage
Esc-v PreviousPage
Esc-darrow NextHalfPage
Esc-Ansi-b NextHalfPage
Esc-pf1 NextHalfPage
Esc-smi-pf1 NextHalfPage
Esc-uarrow PreviousHalfPage
Esc-Ansi-a PreviousHalfPage
Esc-pf2 PreviousHalfPage
Esc-smi-pf2 PreviousHalfPage
@end(programexample)
@begin(programexample)
^l RedrawDisplay
Esc-, BeginningOfWindow
Ansi-h BeginningOfWindow
Esc-. EndOfWindow
Esc-! LineToTopOfWindow
Esc-< BeginningOfFile
Esc-> EndOfFile
Esc-g GotoRequestedLine
@end(programexample)
@begin(programexample)
^x-t RequestTagSearch
^s RequestStringSearch
Esc-s RepeatStringSearch
pf3 RepeatStringSearch
smi-pf3 RepeatStringSearch
^r RequestReverseStringSearch
Esc-r RepeatReverseStringSearch
pf4 RepeatReverseStringSearch
smi-pf4 RepeatReverseStringSearch
Esc-q QueryReplace
@end(programexample)
@begin(programexample)
^h DeletePreviousCharacter
del DeletePreviousCharacter
^d DeleteNextCharacter
Esc-d DeleteNextWord
Esc-h DeletePreviousWord
^t TransposeCharacters
@end(programexample)
@begin(programexample)
^o NewlineAndBackup
^k KillToEndOfLine
^y YankKillBufferAfterCursor
Esc-y YankKillBufferBeforeCursor
^x-^v VisitFile
^x-^s SaveCurrentBuffer
^x-^w WriteNamedFile
Esc-^m WriteModifiedFiles
Esc-~ MarkUnmodified
@end(programexample)
@begin(programexample)
^x-b ToggleBackup
^x-v ToggleVerifyWrite
^x-l ToggleAutoLineFeed
^x-c ChangeContext
^x-^i InsertFile
@end(programexample)
@begin(programexample)
Esc-{ OpenBrace1
Esc-} CloseBrace1
Esc-  IndentFour
Esc-rarrow IndentFour
Esc-Ansi-c  IndentFour
Esc-^h OutdentFour
Esc-larrow OutdentFour
Esc-Ansi-d OutdentFour
@end(programexample)
@begin(programexample)
^@ SetMark
^x-^m SetMark
set-up SetMark
^x-^x ExchangeDotAndMark
Esc-i IndentRegion
^x-^r WriteRegion
@end(programexample)
@begin(programexample)
^x-^k DeleteToKillBuffer
^w DeleteToKillBuffer
^x-g VisitFileNewBuffer
^x-G VisitFileNewBuffer
^x-d DeleteWindow
^x-y YankToNewWindow
^x-a RegionToNewWindow
^x-m MergeWindows
@end(programexample)
@begin(programexample)
^x-1 GoToBuffer
^x-2 GoToBuffer
^x-3 GoToBuffer
^x-4 GoToBuffer
^x-5 GoToBuffer
^x-6 GoToBuffer
^x-7 GoToBuffer
^x-8 GoToBuffer
^x-9 GoToBuffer
^x-o OrderBuffers
@end(programexample)

Several editor functions exist that are not bound to any key by the default 
definitions.  These are the following:
@begin(description)
OrderBufferBackwards@\Order the buffers in the opposite order of that used by 
OrderBuffers.  Depending on whether a user prefers to stack their windows 
from lower left to upper right, or from lower right to upper left, one or the 
other of these ordering functions should be used.

OpenBrace@\C-program editing command.  Generates three new lines, with the 
first and third line containing matching { and } braces indented two spaces 
from the original cursor position.  The middle line is blank and indented 
four spaces from the original cursor position.

CloseBrace@\C-program editing command.  The same as CloseBrace1, except that 
the second, blank line is not generated.  The cursor is left after the } 
character.

BackwardHackingTabs@\Same as DeletePreviousCharacter except that tabs are 
expanded first if they are encountered.  Thus, this command will convert a 
tab into 7 spaces instead of deleting the equivalent of 8 spaces worth of 
white space.
@end(description)


@subsection(Specifying Options and Checkpoint Intervals)

Various options and the checkpointing frequency (in number of editing 
actions) can be specified in the initialization file.  These include:
@begin(programexample)
(checkpoint @i[number])
(defaultrows @i[number])
(autolinefeed on/off)
(backup on/off)
(verifywrite on/off)
@end(programexample)

The @i[checkpoint] specification expects an integer number between 1 and 
2@+(32)-1.  To turn off checkpointing specify some large number.  The default 
is 500, which corresponds roughly to typing 10 lines of text.
The @i[defaultrows] specification sets the default AVT size.
The other specifications expect either an @t[on] or an @t[off], indicating 
that the option should either be turned on or turned off.

The case of the keywords used is unimportant_everything gets converted to 
lower case before parsing anyway.  However, the parser is unforgiving of 
extraneous blanks in the specification.  @b[No] blanks are allowed between 
the parentheses and the keywords.  (I know, this is easy to fix.  It just 
hasn't been done yet.)


@Section(Crash Recovery)
@index(Ved crash recovery)

In an ideal world, this program would never crash.  But in fact it sometimes
does_but it is so designed that it has to crash in two stages to lose your
text.  Normally a crash only breaks the first stage, in which case you will
generally drop into the debugger.
At this point, the debugger command
@t[Suicide,g] will destroy the process that got the exception.
This will
usually activate ved's crash recovery facility, signalled by the message:
@programexample(Editor crash!  Shall I try to save this buffer?)
If you have any changes, and you value them, and the crash did not come 
during a save, it is probably a good idea to answer ``y''.  A .BAK file will
be made if the backup option has not been turned off,
so the danger of total loss is small.  If this succeeds you will be
asked
@programexample(Try to continue?)
If you answer ``y'', the inner editor will be recreated with the buffers just
as they were.  For some display-related errors, a ^L at this point will set
everything right.  However, you are on shaky ground, and the best thing to
do first is save any modified buffers in other windows.

Remember that if the checkpointing feature was on when ved crashed, that there
may be good copies of your files checkpointed in your directory.  Take a look
at them before you panic, you may end up only losing a few lines of text.

Ved tries to detect the cases in which it runs out of memory.  In some 
activities, such as reading in a file, it will simply refuse.
In others,
such as a kill or an insertion, you will get the message
@begin(programexample)
Out of memory!  Please do one of the following:
  Pick a window to delete
  c - continue (after you free something)
  q - save and quit
  ^C - quit without saving
@end(programexample)
Ved cannot proceed without more memory, and cannot exit gracefully from this
activity, so you have to help it out.  To pick a window, select it with one
mouse click and signal it with a second click.  It will be saved if modified,
then deleted to reclaim its storage.  If you have anything else going on on
your Sun, you can delete a view or terminate a program or delete an exec to
free some storage.  After doing so, type c to continue.  If this won't work,
type q to try to save everything and quit gracefully.  It will save the
current buffer last, trying to avoid the dangers of saving a half-modified
text.  ^c is a last resort, a quick and dirty quit.


@Section(Some Hints on Usage)

If you get into a weird state, try ^l, it often restores sanity.
If that
fails, a save may work anyway_it uses only the textual data structures,
and it is the display structures that usually foul up.

Esc followed by a number key invokes one of the debugging routines.  Avoid
them, especially number 9, which is @b[suicide].
