@Part(standalone, root "manual" )
@Chapter(Standalone Commands)
@label(Standalone)
This chapter discusses standalone programs,
i.e., programs that do not run under the V kernel,
that are useful with the V-System.

@section(Vload)
@index(Vload)
@label(Vload)
@i[Vload] is the V-System
bootstrap loader.  The Vload program loads the
V kernel and initial team into memory and starts up the kernel.

There are several versions of Vload.  Currently, all versions use the
V I/O protocol and V IKC protocol to load programs
over the Ethernet.@foot[In the future, there will be a version of Vload
that can boot a fileserver machine directly from its local disk.]
On the Sun-1, the Sun 3 Mbit Ethernet board and Excelan 10 Mbit
Ethernet boards are supported as boot devices.  On
Sun-2s, the 3Com 10 Mbit Ethernet board and the built-in Ethernet
interface of the Sun-2/50 are supported. The standard Sun-3 cpu card (not
the 3/50) and MicroVaxen with DEUNAs are also supported.

Vload determines the files to load and other actions to take
at run time, depending on
what was typed on the command line and what
information is stored in the configuration database for
the workstation being booted (see section
@ref(ConfigDatabase)).
For each of its parameters, Vload gives first priority to 
command-line information, if any,
second priority to the defaults
for this workstation
recorded in the configuration database, if any,
and third priority to a default value determined at compile time.

Team and kernel
filenames are interpreted in the V-System ``[sys]boot''
context, unless they begin with a square bracket.  In the latter
case, the name inside brackets is taken as a machine name.
If ``#'' is given as the kernel file name, no kernel is loaded.
Instead, the file specified as first team is loaded into the
kernel's memory area and executed as a standalone program.

Besides file names,
two other parameters are also understood: ``world'' and ``options.''
The world may be either V (production) or xV (experimental).
The only option currently recognized is `b', which causes a break to the
@c[PROM] monitor before the kernel is started.

The following sections describe the defaults and special characteristics
of the four
versions of Vload in use at this writing.

@subsection(3 Mbit Ethernet)
This version of Vload is intended for booting Cadlinc, SMI Sun-1, and
other Sun-1 workstation configurations with 3 Mbit Sun Ethernet
boards.  
These workstations ordinarily use a version of the Stanford
@c[PROM] monitor that incorporates PUP bootstrap code.  The
first step in booting these workstations is to load Vload using the
bootstrap @c[PROM]s.  This can be done by typing a keyboard command
(@t[b @u[filename]] for SMI workstations, @t[n @u[filename]] for others),
or automatically on powerup or reset (see below).

For these workstations, the kernel resides from 0x1000 to 0x20000, and
teams are loaded at 0x20000.

The compiled-in default values for Vload's parameters in this version
are as follows:

@begin(description)
world@\V

team@\team1-vgts

kernel@\Vkernel/sun1+en

options@\@i[null]
@end(description)

The only command line information visible to Vload is the name it was
invoked under.  Therefore, Vload is installed under several different
names, and its action depends on its name.  The names and actions are
listed below.  

@begin(description)
V@\When called under this name, Vload will load the team @i[team1-vgts] and
the default kernel for this workstation, using the default options.
The team and kernel are loaded from a V storage
server (production versions) rather
than an xV storage server (experimental versions), that is, the @i[world]
parameter is set to @i[V].

VV@\The team is @i[team1-sts], and the world is @i[V].

xV@\The team is @i[team1-vgts], and the world is @i[xV].

xVV@\The team is @i[team1-sts], and the world is @i[xV].

Vload@\The user is prompted for @i[team], @i[kernel], and @i[options].
The default value is used for any field where the user enters a blank line.
The world is @i[V].

xVload@\Same as Vload, except that the world is set to @i[xV].

@i[null]@\If the name is null, Vload assumes it was autobooted.
Default values are used for all parameters.

@i[others]@\If a copy of Vload is installed under any other name, it will
use its name as the team name to be loaded, set the options to null,
and use defaults for the kernel and world.
@end(description)

No special setup is required to get an SMI Sun-1 processor to autoboot_it will
do so automatically 30 seconds after powerup or a @t[k2] command.  The
PUP boot @c[PROM] requests boot file number 1 by number, which causes a file
called 1.Boot to be loaded from the first responding PUP EFTP server.
We have arranged for this file to be a copy of Vload, so the boot action
is as described under the @i[null] name above.@index(Autobooting)

A non-SMI processor can be made to autoboot by installing
the proper jumpers in its configuration register.  (See the @i[Sun User's
Guide] for a full description of the configuration register.)  Bits
7-4 of the configuration register are an index into a table of
bootfile names stored in the @c[PROM].  An
in-place jumper or closed DIP switch corresponds to a 0 bit; no jumper or
an open switch corresponds to a 1.  These bits should be set to the
number corresponding to the name ``Vload.''  The ``W ff'' command typed
to the @c[PROM] monitor causes it to list the bootfile names and corresponding
numbers that it knows about.  Vload is usually number 5, corresponding
to jumpers on bits 5 and 7.  Vload's action will be as described
under the @i[null] name above.

@subsection(Excelan Ethernet)
This version of Vload is intended for booting Cadlinc, SMI Sun-1, and
other Sun-1 workstation configurations with Excelan 10 Mbit Ethernet
boards.  Ordinarily, this version of Vload is used only with workstations
using a special version of the
@c[PROM] monitor that incorporates TFTP bootstrap code.  The
first step in booting these workstations is to load Vload using the
bootstrap @c[PROM]s.  This can be done by typing a keyboard command,
not described here.

The compiled-in default values for Vload's parameters in this version
are as follows:

@begin(description)
world@\V

team@\team1-vgts

kernel@\Vkernel/sun1+ex

options@\@i[null]
@end(description)

The only command line information visible to Vload is the name it was
invoked under.  Therefore, Vload is installed under several different
names, and its action depends on its name.  The names and actions are
listed below.  

@begin(description)
xlnV@\When called under this name, Vload will load the team @i[team1-vgts] and
the default kernel for this workstation, using the default options.
The team and kernel are loaded from a V storage
server (production versions) rather
than an xV storage server (experimental versions), that is, the @i[world]
parameter is set to @i[V].

xlnVV@\The team is @i[team1-sts], and the world is @i[V].

xlnxV@\The team is @i[team1-vgts], and the world is @i[xV].

xlnxVV@\The team is @i[team1-sts], and the world is @i[xV].

xlnVload@\The user is prompted for @i[team], @i[kernel], and @i[options].
The default value is used for any field where the user enters a blank line.
The world is @i[V].

xlnxVload@\Same as Vload, except that the world is set to @i[xV].

@i[others]@\If a copy of Vload is installed under any other name, it will
use its name as the team name to be loaded, set the options to null,
and use defaults for the kernel and world.
@end(description)

There is currently no way to autoboot a workstation with TFTP boot PROMs.
This limitation may be removed in the future.

@subsection(3Com Ethernet)
This version of Vload is intended for booting Sun-1.5s and Sun-2s with
3Com 10 Mbit Ethernet
boards.  These workstations boot using either a local disk or tape, or
the SMI network disk protocol.  The network disk protocol does not allow
specifying a file name, so the V-System ND boot server 
reads the boot file name from the workstation's configuration file;
ordinarily, Vload will be specified.
Once loaded, Vload can read the entire command
line typed by the user.

The compiled-in default values for Vload's parameters in this version
are as follows:

@begin(description)
world@\V

team@\team1-vgts

kernel@\Vkernel/sun2+ec

options@\@i[null]
@end(description)

Zero or more arguments may be passed on the command line to Vload.
If the first argument to Vload is one of the special values described
below, it is stripped off and the special action listed is taken.
After this check, the first three remaining arguments are respectively
used to override the defaults for team name, kernel name, and options.
Values set by these arguments have priority over values that may have
been set by the first argument.

@begin(description)
V@\Sets the world to @i[V], and the team to @i[team1-vgts].  (This team name
will be overridden by the next argument if present.)

VV@\The team is set to @i[team1-sts], and the world is @i[V].

xV@\The team is set to @i[team1-vgts], and the world is @i[xV].

xVV@\The team is set to @i[team1-sts], and the world is @i[xV].

@i[null]@\If no arguments are present, the default values are used for
all parameters.

vmunix@\The SMI boot PROMs have this name hardwired in for autobooting,
so it is treated the same as a null first argument.

@i[others]@\If the first argument is not one of these values, the default
world is used, and the arguments present specify team name, kernel name,
and options, as described above.
@end(description)

For example, the command
@programexample(b V team1-vgts [pescadero]/user/fred/mykernel.r)
will load the installed version of team1-vgts as the first team,
and a special version of the kernel from Pescadero.

If the workstation being booted has a disk or some other device that the
@c[PROM] prefers over the Ethernet for booting, specify the boot device
@t{ec()} immediately following the @t[b] in the boot command, and preceding
the first argument.  (Some older @c[PROM] revisions require @t{nd()} in
place of @t{ec()}.

@subsection(Sun-2/50 Ethernet)
The Sun-2/50 version of Vload is identical to the 3Com version described
above, except that the default kernel is Vkernel/sun50.  The boot device
name is @t[ie()].

@subsection(Sun-3 Ethernet)
The Sun-3 version of Vload is also similar to the 3Com version. The default
kernel is Vkernel/sun3+ie, and the boot device is @t[ie()]. Currently a Sun
prom monitor bug requires one to power cycle Sun-3 workstations when
rebooting. Our Sun salesman has told us that new proms may be available.

@subsection(MicroVaxen)
There are three switches on the back of the MicroVax @c[cpu]. One is
obviously the console baud rate selector. The other two have semi-random
icons and affect booting. 

The flat switch, whose symbol is a triangle
inscribed in a circle controls the halt button and auto-reboot. With the
switch at the dot-in-circle position the halt button on the face of the
@c[cpu] halts the machine and forces it into the monitor, leaving you with a
@t[>>>] prompt. Remember to press it once more to take the machine out of
the halt state. When in the other, circle-out-of-dot position, the halt
button is disabled and any action which would cause a halt (such as a kernel
halt instruction or a power failure) will cause a reset and auto-boot
attempt.

The circular knob has three positions. The downward pointing arrow is the
normal position. The outline of a face causes the proms to prompt for
language and keyboard type. The T-in-circle is a test position.

The commands for booting a MicroVax are:
@begin(description,leftmargin +8, indent -8)
@t[b]@\Boot according to the config file specifications.

@t[b/1]@\Boot into the V world.

@t[b/2]@\Boot into the xV world.

@t[b/3]@\Boot into V, but prompt for the kernel and first team.

@t[b/4]@\Boot into xV, but prompt for the kernel and first team.

@end(description)
If the disk drives are enabled then @t[b xqa0] forces the bootstrap to load
over the network.

@section(Netwatch)@label(Netwatch)@index(netwatch)

@t[netwatch] is a standalone tool for examining packets as they are spewn
accross the ethernet. It has knowledge of many different protocol formats,
including V, IP, XNS, Chaos, and PUP. It maintains packet buffers seperate
from those of the ethernet hardware for maintaining packet traces.

We have found this to be the most powerful tool we have for debugging all
nature of network protocol and distributed program communication bugs. This
includes typical V distributed applications as well as protocol
implementations (such as IP/TCP) on other hosts on our networks.  There's
nothing like silencing a roomfull of random conjecture with a packet trace
printout.  The utility of looking at what's actually on the wire cannot be
overemphasized.

@subsection(Booting)
@t[netwatch] runs standalone, so it must be booted fresh on a bare machine.
A typical boot command to fire up the 3com version on a Sun-2 is:
@begin(programexample)
b V netwatch-ec2 #
@end(programexample)
The sharp sign tells netwatch to load the first argument at the kernel start
address and not to load a first team. See @ref(Vload) for the details on
booting other hardware configurations. Other versions of Vload supported are:
@t[netwatch-en] (Sun-1/3Mb),
@t[netwatch-ec] (Sun-1/3Com),
@t[netwatch-ec2] (Sun-2/3Com),
@t[netwatch-50] (Sun-2/50), and
@t[netwatch-ie3] (Sun-3/75).

@subsection(Operation)
The standard train of events is to set up the packet filters, then commence
recording packets until a certain event has occured. When recording, packets
which pass through the filter are stored in a 127 buffer fifo queue. After
recording the queue can be examined and/or written to a file. One may
authenticate the @t[netwatch] process, which runs initially as @c[unknown].
If your storage server allows the unknown user to write to /tmp this may
not be needed.

@subsection(Commands)
The commands available at the top level are:
@begin(description)
h@\Modify host address filter (see @ref(HostFiltering)).

r@\Receive packets into buffer (flushes current buffer).

t@\Same as r, but prints packets as they are received (may drop packets).

b@\Display buffer contents.

s@\Same as b, but allows skipping of initial packets.

w@\Write current buffer to a file.

l@\Login (authenticate).

c@\Change default directory for file writing.

!@\Print an exclmation mark when a packet is received.

m@\Always display the annoying option menu.

q@\Quit.

?@\Print a list of commands along with the current flag status

@end(description)

@subsection(Filtering by Packet Type)
@t[netwatch] understands several protocols, and can filter out packets based
on the type field in the packet header. The packet types understood
currently are: V, ARP & RARP,  Chaos (Symbolics), IP, PUP and XNS.

@paragraph(10meg Address Filter)@label(HostFiltering)
The ten megabit packet filter is composed of two lists, the primary and
secondary host lists. A packet is passed through the filter if its source and
destination addresses can be found, one in each list.
Ten megabit host addresses
are specified using the last four hex digits of the ethernet address.
At startup, the primary list is empty and the secondary list is full
(contains all addresses) with multicast turned off.
@b[Note:] At the time of this release the netwatch driver for the Intel
85286 chip (Sun-2/50 and Sun-3) randomizes the first short of the
destination address, so filtering on multicast packets doesn't work on those
versions.
In
basic operation, one fills the secondary list with all addresses, and enters
the addresses of ``interesting'' hosts into the primary list.
Another typical use, when trying to debug communications between two
hosts, is to have the two hosts in the primary list and all but one host
(usually the the fileserver) in the secondary list.

@paragraph(3meg Address Filter)
The 3 meagabit host address filter maintains one list of hosts, and filters
in one of two modes. In the first mode, @t[AND] mode, both the source and
destination addresses must be in the list. In the second mode, @t[OR] mode,
only of the source or destination must be present.
Hosts addresses are entered in octal form. The entire eight bit address is
used.

@section(Postmortem)
The @i[Postmortem] diagnostic tool is no longer supported. Much of its
functionality has been put into the kernel funtions @t[Aliens()] and
@t[Processes()]. On Suns these functions can be called manually from the
monitor
using the @t[g <addr>] command. The address of the function can be gleaned
from the kernel's symbol table with either @t[debug -o 2000 <kernel>] or
@t[nm68]. These functions are not normally compiled into the MicroVax kernel.

@section(Diskdiag)
The @i[diskdiag] program is a diagnostic program that allows one to manually
access specific sectors on the disk.  It is useful for verifying the correct
interaction between the disk controller and disk drives, as well as for 
initializing a new disk.  Diskdiag is configured to run on a system
with a Xylogics 450 or Interphase 2181 disk controller and Fujitsu 
M2351 and M2284 disk drives.

To run diskdiag, type the command
@programexample{b ec() diskdiag #@foot[Some SMI workstations with older
PROM revisions require that nd() be used in place of ec().]}
for SMI workstations, or
@programexample(n diskdiag)
for Cadlinc workstations.
There are commands available to @t[format(f)], @t[read(r)], @t[seek(s)],
and @t[write(w)].
The user is prompted, as necessary, for more information on each of these
commands.

In addition, it is possible to @t[label(l)] the first sector of a drive 
with the configuration
parameters needed by the disk driver in the kernel.  Executing the format
command automatically labels the disk after the format is complete.
The @t[verify(v)] command reads the label off of disk and prints 
it on the console.  

The @t[partition(p)] command prompts the user for the
start block and length of each partition on the disk and creates a disk
partition table.  Existence of a disk
partition table is optional as it is not needed by any system software.
The @t[examine(x)] command allows one to examine the contents of the disk
partition table.

Reinitializing the diskdiag program is accomplished using the @t[again(a)]
command.

One should be aware of the fact that diskdiag's block size is the actual
disk sector size, which may be different than the block size used by
@i(fscheck) and the @i(storage server).

