@Part(siledit, root "manual")

@Chapter(siledit: A Simple Illustrator)
@label(siledit)
@index(siledit)
The @t(siledit) program can be used to edit simple illustrations.
It is uses a compatible file format with the Alto @t(SIL) program,
although some obscure features such as macros are not implemented.
The main limitation of this format is that only horizontal and
vertical lines are supported, with a limited range of fonts.
On the other hand, it is simpler and faster than @t(draw),
and illustrations produced by @t(siledit) can be easily inserted
into other documents or printed out.
A remote version of this program will run under U@c[NIX],
although users will probably prefer the V-System version
of the program if permitted by workstation memory limitations.

@section(Basic Operation)

The @t(siledit) program is invoked with one argument:
@example(siledit @i[filename].sil)
It first attempts to open the file name
given as an argument.
If no such file exists, the program continues and allows one
to be created.
An SGVT is created, and the cursor should change to the
``View'' prompt indicating the creation of a default view.
The default view will be slightly larger than the illustration,
or a whole page if the illustration is empty.
Press and hold any button an an outline the size of the
default view will appear and track the cursor.
Position the upper left corner of the desired default view with the cursor,
and lift the button up when the view is in the right place.
Next the @t(siledit) program prints out the text fonts
that will be used, and tries to load the appropriate fonts
into the VGTS.
Then the existing illustration is displayed,
and the following prompt appears:
@example(Use mouse buttons: Mark, Select, Menu)
Thus two mouse buttons are used for the basic commands,
with other commands available through combinations of buttons
or from the popup menu.

The @i(Mark),
indicated by an ``X'' shaped cross, is used as one end of lines and the
position of added text.
Once objects are added to the illustration, they can
be modified by first selecting them and then performing
one of the modification commands.
Selected objects
will appear higlighted in some way,
although the exact form of the highlight
is dependent on the VGTS implementation.
In the SUN implementation, objects are normally black on while,
with selected lines appearing as half-tone gray and 
selected text appearing within a gray box.

@section(Commands)

The commands available on the mouse are as follows:
@begin(description)
Left Button@\Moves the mark to the point of the click.
The ``X'' shaped cross moves to the new location.
The mark is normally moved before drawing lines or placing text.

Middle Button@\Selects the single object at or near the click.
Any other objects previously selected are no longer selected.
The program will echo the kind of object selected,
or issue a diagnostic if no objects are found.

Left+Middle Button@\Draws a line from the mark to the point
of the click.
The line is either horizontal or vertical, depending
on which difference in position is larger.
This is a faster way of drawing lines than using the menu.
The current line width is used for the line.
The mark is moved to the point of the click, to facilitate
drawing a series of connected line segments.

Middle+Right Button@\Adds the object near the click to the selection.
This is in contrast to the Middle Button, which causes exactly one
object to be selected.
Use this command to select several objects.

Right Button@\Command menu, as described below.
@end(description)

More advanced commands are available on the menu as follows:
@begin(Description,leftmargin +12, indent -12)
Quit@\Exits @b(without) saving the illustration.
Usually you want to do the Write command first,
so if there have been changes since the last Write command,
confirmation is requested first.

Line Width@\Pops up another menu of default line widths.
Select the desired new width from 1 to 8 units.
Clicking outside the menu results in no change to the width.

Delete@\The selected objects are deleted.
Currently there is no Undelete, so be careful!

Unselect@\Another click is requested, and the object near that
click will no longer be selected.

Draw Line@\Another click is requested, and a horizontal
or vertical line is drawn
between the mark and the position of the click.

Add Text@\A line of text is requested, and the text is
added at the position of the mark in the current font.

Modify Text@\Selects another menu for modifying text.

Write@\Writes the illustration back to the file given
on the command line.

Stretch Line@\Position the cursor near one end of the selected
line, and hold down a button.
The end of the line will move following the cursor until the button
is released.
(Available only in the native V-System version.)

Move@\Position the cursor anywhere in any view of the illustration
and press any button. 
The selected objects will follow the cursor until the button
is released.
(Available only in the native V-System version.)

Copy@\Position the cursor anywhere in any view of the illustration
and press any button. 
A copy of the selected objects will follow the cursor until the button
is released.
(Available only in the native V-System version).

Box@\Move the cursor to one corner of the box, and press
any button.
While holding down the button, position the opposite corner
of the box.
The box will be drawn in the current line width.
The box can be aborted by pressing all three buttons at the
same time.
(Available only in the native V-System version.)

Select Area@\Move the cursor to one corner of the area, and press
any button.
While holding down the button, position the opposite corner
of the area.
All objects within the area will be selected.
(Available only in the native V-System version.)

Debug@\Enables several debugging print statements,
for maintenance use only.
(Available only in U@c[NIX] version.)
@end(Description)

The following commands are used to modify text:
@begin(Description,leftmargin +14,indent -14)
Edit Text@\First select some text, then issue this command.
The text is stuffed into the VGTS line buffer, and edited
by the user.

Default Font@\Displays a menu of fonts to be chosen to become the
new default font.
Text added with the Add Text command will use the new default font.

Change Font@\Changes the font of the selected text.
Displays a menu of fonts to be chosen as the new font for the selected
text.
@end(Description)


@section(Selecting Alternate Fonts)

@index(Fonts)
Only two text font/size combinations are available, but with
all of the regular, bold and italic faces.
Default fonts are Helvetica7 and Helvetica10, with
Helvetica7B, the bold face, Helvetica7I the italic face, etc.
A third font, Template64, is used to draw circles and diagonal
lines.
A one-page chart of the Template64 character set is probably required
to use any of these shapes.

Other fonts can replace the two Helvetica fonts
by creating a file with the name @i(filename)@t(.fonts).
This file should contain the names of the fonts to be used,
one per line.
Comments in this file are indicated by a # character at
the start of a line.
The default fonts are acceptable for illustrations to be
included in papers,
but for slides larger fonts like 12 and 18 point should be used.
Thus, for example, the font file:
@example(# font file for slides
Helvetica12
Helvetica18
)
could be used when making slides.
The command:
@example(nm68 -d -g /usr/sun/lib/libsfonts.a)
can be used to determine what fonts are available.
This command lists the defined global symbols in the font library.

@section(Generating Printed Copy)

The @t(silpress) program is used to produce the printed illustrations
from SIL format.@index(silpress)
Currently this command only runs under U@c[NIX].
Alternate fonts can be selected as in the @t(siledit) program.
The command line:
@example(silpress filename.sil)
will convert the named illustration into a Press format file and 
print it on the Dover.
Most of the options available to the CZ program are available
in @t(silpress).
Use the @t(man cz) command for more details.
In particular, the @t(-p file.press) option can be used to
specify the name of a press file and inhibit printing.
This is useful if the illustration is to be merged into
a document produced with the Scribe or T@-[E]X document compilers.

When using Scribe, include the command
@example[@@libraryfile(picture)]
near the beginning of your manuscript file.
Then, for each illustration include the following commands:
@begin(example)
@@Begin(Figure)
@@PressPicture( Height = "5.25 Inches", File = "filename.press" )
@@Caption(A caption for this illustration)
@@End(Figure)
@end(example)
Where the height is an estimate of the vertical size of the picture.
Then place the character sequence <==<< with @t(siledit)
near the bottom center of the illustration, and run
@t(silpress) to create the Press file.
The CZ program of U@c(NIX) will insert the figures automatically.
It usually several iterations to get the positioning and size right,
but it is much faster than using a scissors and paste.
@begin(example)
! siledit filename.sil
! silpress -p filename.press filename.sil
! cz paper.press
[Inserting filename.press on page 1]
@end(example)
