@string(LastEditDate="Tue Jun 17 17:13:43 1986")
@comment(Current maintainer: Keith Lantz)

@part(manager, root "manual")
@chapter(User Interface Overview)
@label(ViewManagerChapter)
@label(User Interface Overview)

This chapter presents an overview of what it is like for the user to
interact with the V-System.  Details of terminal emulation or graphics
support are not discussed, since that is best described by the programmer's
interface in Chapter @ref(VGTSlibc).  Rather, the basic stylistic
conventions are presented, including an overview of how applications'
actions are manifested to the user.  Also included is a discussion of the
the basic architecture of the user interface, in the hope that it will
enable the user to better understand the style of interaction and the
facilities available to him.  The user who is ``in a hurry'' to get started
may skip this discussion, at least on first reading, and begin with Section 
@ref(Getting Started).
The following chapter discusses command interpretation in some detail.

@section(The User Interface Architecture)
@label(UIArchitecture)

In a typical operating system, the user is presented with the illusion of
interacting with a single, unified front end, often referred to as an
``executive'' or ``shell''.  However, in contemporary workstation-based
systems, this front end actually provides three basic levels of interaction:
@begin(enumerate)
@b(device I/O):  Manipulation of input devices and generation of output on
output devices.

@b(command interpretation): Command (or argument) specification and response 
handling, and invocation of applications.

@b(window management): Management of multiple simultaneous applications (in
separate ``windows'').
@end(enumerate)

Rather than combine these three levels of function in one module, the
V-System distinguishes three separate software components @ld() respectively:
@begin(enumerate, spread 0)
the @i(workstation agent),

the @i(executive), and

the @i(workstation manager).
@end(enumerate)
This separation was inspired by a desire to be able to configure each
component independent of the others.  While this release of the V-System
does not reflect the @i[ideal] realization of this separation, it nevertheless
fits the basic framework.

@Begin(warning)
The workstation agent was originally referred to as the @i(terminal
agent)@index[terminal agent].  The two terms are used interchangeably.
@End(warning)

@subsection(Workstation Agents)

The workstation agent provides the lowest-level interface between the
hardware and the rest of the system.  One of its principal functions is to
hide any idiosyncrasies of that hardware @ld() through a virtual
terminal interface.  

@paragraph(Virtual Terminals)

Rather than dealing with the ``raw'' hardware, applications interact with a
@i(virtual terminal).@index(virtual terminal)
They request input from a virtual keyboard or mouse, for
example, and write output to a virtual store.  Depending on the ``class'' of
real terminal (workstation) being emulated, the characteristics of the
virtual input and output devices may vary widely.  In the simplest
implementation, each workstation agent emulates exactly one class of real
terminal; emulating a different terminal requires a new workstation agent.
More sophisticated workstation agents emulate multiple classes of
terminals simultaneously.  Note that the number of @i(classes of terminals)
emulated is independent of the number of @i(virtual terminals) being
emulated at any one time.

Historically, the most common class of terminal emulated has been the
page-mode (character) terminal @ld() exemplified by the D@c(EC) VT-100.
Even in this case, the workstation agent can be thought of as emulating
different types of terminals, corresponding to the various input and output
modes provided by a VT-100 @ld() character-at-a-time versus block
transmission, local editing facilities, and the like.  In general, the
workstation agent, through its virtual terminals, provides a set of
facilities that might be referred to as ``cooked I/O'' @ld() ranging from
character echoing to line-editing to page-editing to graphics-editing.
These facilities are enabled and disabled on a virtual terminal by virtual
terminal basis.

True to its name, a virtual terminal need have no physical, real-world
manifestation.  In particular, it is possible to write output to a virtual
terminal without seeing that output displayed on the screen.  Hence, any
application may run and change the store of any virtual terminal at any
time.  

While it is common for multiple applications to be generating output
simultaneously, it has historically (if erroneously) been thought less
desirable to permit the user to direct input to multiple applications
simultaneously.  True to this historical bias, the V-System 
currently restricts input to one application at a time.  We refer
to the application and associated virtual terminals as being ``selected''
(for input).  Selection for input has no effect on the underlying
application's ability to generate output.  As with output, however, it
 @i[is] possible to generate keyboard input for a virtual terminal without
having the virtual terminal mapped to the screen; users should be wary of
the possible consequences!

@paragraph(Views)

In order for the user to actually see the output from or generate graphical
input to a virtual terminal, the virtual terminal must be mapped to the
screen through a @i[view].@index(view)  A view defines the portion of the
virtual terminal's store that should be displayed, the area on the screen in
which it should be displayed, and the transformation that should be applied
when mapping the store to the screen.  Using traditional graphics
terminology, the store is referred to as the @i(display file), the portion
of the store is a @i[window], the area of the screen is a @i[viewport], and
the transformation is a @i(viewing transformation).@foot[Unfortunately,
traditional ``window system'' terminology tends to use the word ``window''
to mean any or all of window (as just defined), viewport, view, or virtual
terminal.] Viewports are invariably rectangular, although there is no
conceptual reason for this to be the case.  

Typically, an application will create one view of a virtual terminal at the
same time it creates the virtual terminal.  Nevertheless, views are maintained as entities distinct from
virtual terminals because, in general, each virtual terminal may have more
than one view associated with it.  When using the VGTS, for example, the
same picture, maintained as one entity by the program, may appear in two
separate viewports on the screen, possibly with different viewing
transformations.
That is, a second view may look upon a different portion of the
virtual terminal's store from the first, or at a different magnification.

@Begin(note)
Because a view is the physical manifestation of a virtual terminal on the
display screen, we will tend to use the term ``view'' rather than ``virtual
terminal'' when discussing screen management issues.  Where necessary to be
even more specific, we will use the term ``viewport''.
@End(note)

So, a virtual terminal may be associated with more than one view.  On the
other hand, because the virtual terminal is independent of its physical
manifestation, there need be no views associated with it.  Destruction of
all views does not in any way affect the virtual terminal, though it will
make it rather difficult for the user to see what is going on.

One common policy is that views are the domain of the user.
A program that creates a virtual terminal should create a view
of it, so that the user knows that it exists, but after that, in the
ordinary course of things, the program should leave the view alone.  The
program should not depend on the continue existence of that view, nor need
it be aware of any other views of the virtual terminal that the user chooses
to create.  Let the user decide where on the screen he wants views to be,
and how big, and with what viewing transformations.  That is what the
workstation manager is for.  

@paragraph(V-System Agents)

The V-System currently supports two workstation agents, the @i(simple
terminal server) (STS) and the @i(virtual graphics terminal server) (VGTS).
The STS provides basic text terminal emulation by making the workstation
appear as a single, traditional, page-mode terminal @ld() compatible with
 @c[ANSI] standard X3.64.@foot{The most widespread example of a terminal
adhering to this standard is the D@c(EC) VT-100.} Character echoing and
line-editing are optional.  The STS is used principally to interface to
ASCII terminals, but it can also be used over remote terminal connections
and as the interface to the normal workstation keyboard and display.

The VGTS provides considerably greater functionality, including support of
what is commonly referred to as a @i(window system) (more on this later).
Any ``window'' may emulate the same type of terminal provided by the STS.
Alternatively, a window may emulate a (structured) graphics terminal that
provides roughly the facilities available in the ISO standard Graphical
Kernel System, together with rudimentary modeling facilities in the form of
structured display files.  Thus, the VGTS provides simultaneous support for
two very different types of real terminal.  Each virtual terminal may have
any number of views associated with it.  Any number of views of any number
of virtual terminals can be mapped to the screen at the same time.
Applications are unaware of the number of views or what is being displayed
in them, except insofar as graphical input events return the appropriate
world coordinates.  
The VGTS is used when it is desired to make the best use
of devices typically found on contemporary workstations @ld() such as
bit-mapped displays, encoded keyboards, and mice.  

While the abstractions
for keyboard and mouse are common across (existing) virtual terminals, the
abstractions for the store are quite different, as discussed in Chapter
 @ref(VGTSlibc).  When necessary to distinguish the two classes of virtual
terminals currently supported, we will refer to the type of virtual terminal
that emulates an @c(ANSI) standard terminal as an @i(ANSI virtual terminal)
(AVT)@index(ANSI terminal)@index(AVT)@index(virtual terminal)
@index(ANSI virtual terminal) and the type of virtual terminal that
emulates a structured graphics terminal as a
@i(structured graphics virtual terminal) (SGVT).
@index(structured graphics virtual terminal)@index(SGVT)

@begin(warning)
The ``store'' of an AVT is referred to as a @i[pad].@index(pad)
Unfortunately, that term  has been most frequently (and erroneously) used as
a placeholder for the complete AVT abstraction.  While this manual attempts
to use each term where it is appropriate, the code uses ``pad'' almost
exclusively.  Consequently, many of the routines described herein also refer
to ``pad''.  Similarly, the term ``virtual graphics terminal''@index(virtual
graphics terminal) (or VGT)@index(VGT) has been used almost exclusively in the
code, rather than the term ``structured graphics virtual terminal''.  In
both cases, we trust the reader will be able to make the appropriate
semantic substitutions.
@end(warning)

The bulk of the discussion to follow assumes use of the VGTS.

@subsection(Workstation Managers)

The workstation manager permits the user to control multiple simultaneous
executives @ld() with accompanying applications.  Through it executives are
created and destroyed, programs are interrupted and killed, and both virtual
terminal and views are manipulated.  With respect to the last, in
particular, the workstation manager is the module that enforces the
 @i[constraints] on view management that the user desires.  For example, it
enforces the precise position and front-to-back ``ordering'' of viewports.  

It is crucial to appreciate the distinction between workstation managers and
workstation agents.  The manager exerts ``control'' over the ``facilities''
provided by the agent, while at the same time using those facilities to
interact with the user.   Different users may want different styles of
control.  For example, one user may prefer to specify all views manually,
whereas another user may prefer the system to determine the ``best'' view
automatically; one user may prefer his viewports to be tiled, whereas
another may prefer them to overlap.  These styles are independent of the
basic facilities provided by the workstation agent.

In principle, it should be possible to define the ideal workstation manager,
independent of all workstation agents.  But, just as workstation agents are
limited in practice by the classes of real terminals they support,
workstation managers are limited in practice by the available classes of
workstation agents.  For example, the VGTS comes with a large and powerful
workstation agent, called the @i(view manager), which is accessed via popup
menus.  Many of its commands require the user to select or position
viewports on the screen.  Such interaction works best in an environment with
a mouse, for example, yet some workstation agents may not provide an
efficient emulation of a mouse.  The STS, on the other hand, has only a
trivial vestige of a workstation manager.  Its primary function is to
guarantee the existence of one executive running on the terminal at all
times.

@subsection(Executives)

Workstation agents and managers provide the basic facilities by which the
user interacts with the workstation.  But little has been said about how the
user actually specifies commands and applications.  In fact, these functions
are provided by executives (or shells).

Some systems permit only one executive, often running only one application at
a time, but sometimes capable of running multiple applications at a time
 @ld() one in the ``foreground'' and the rest in the ``background'', for
example.  Under the STS, the V-System provides one executive (of the latter
variety).  Under the VGTS, multiple executives are supported simultaneously;
the view manager is responsible for creating (and destroying) them.

@subsection(Summary)

We have outlined the basic concepts underlying the user interface to the
V-System.  The rest of this chapter discusses the more practical details of
how the user actually interacts with the system via its workstation agents
and workstation managers.  Interaction with executives is discussed in
the next chapter.

@section(Getting Started)
@label(RunningV)
@label(Getting Started)
@index(Booting)
When you come up to an idle workstation, it may be in one of several 
states.  If the screen is blank, it is probably running V, but idle.  The
VGTS blanks the screen on idle workstations after a few minutes of inactivity.
Move the mouse slightly or press any key on the keyboard to restore the
display.  A previous user may have left one or more of his sessions
(see below) active.  The command
@programexample[logout]
will terminate them all and get you off to a fresh start.
If the workstation is running something other than V, is dead, powered down, or
the like, it will be necessary to reboot it, as described in the following
paragraphs.

@subsection(Booting the Workstation)
@index(booting)

As previously noted, the V-System runs on a variety of workstations.
Booting procedures vary depending on the manufacturer and on the model.
Section @ref(Vload) describes in detail how to boot all of
the workstation configurations supported with this release.
The following is an overview that should cover most
situations.

@paragraph(VaxStations)

When in the @c(prom) monitor VaxStations display a @t[>>>] prompt. If the
workstation is not in this state, press the @t[halt] button twice (once to
put it in, once to bring it out). If this doesn't halt the machine, press
@t[reset]. These buttons are on the front panel of the VaxStation CPU.
Once at the @c[prom] prompt, the command @t[b xqa0] will cause the workstation
to boot over the ethernet.

@paragraph(SMI Workstations)

An SMI workstation in a random state can be reset to the @c[PROM]
monitor by
holding down the key in the upper left hand corner
of the keyboard, and hitting the ``A'' key.@index(SMI)
(The key in the upper left hand corner may be labeled either
@c[L1], @c[SET-UP], or @c[ERASE EOF] depending on the exact model.)
There is no reset button on SMI workstations, so a very serious
crash can make it necessary to power-cycle the workstation.

Once you have gotten into the @c[PROM] monitor, the next thing
to do is to type the @t[k2] command, which simulates a power-up
reset.  (Shortcuts are sometimes possible, but @t[k2] is the
safest route.)  After the power-up memory test is completed,
the workstation will try to boot its default program.  Most
Sun workstations at Stanford are configured to boot the
V-System with VGTS.  The bootstrap program first loads
the workstation's configuration file (see Chapter @ref(ConfigDatabase))
to find out what its defaults are.
It next prints
``V-System'' or ``xV-System'' to indicate whether the production
or experimental version of V is being loaded, then
prints the filenames of the kernel and initial team as it loads them.

If you notice the workstation is not booting what you want it to,
you can interrupt the autoboot with the reset key sequence described
above, then type in the exact boot command you want.  Most of
the time, one of the following simple commands will do the job:
@begin(description)
@t(b)@\Boots the default program.

@t(b V)@\Boots the production version of the V-System, with the VGTS.

@t(b xV)@\Boots the experimental version of the V-System, with the VGTS.
@end(description)
General boot commands and the V bootstrap loader
are described fully in section @ref(Standalone).

@begin(note)
Most SMI workstations at Stanford use the Sun-2 processor
board, but a few Sun-1s have not been upgraded.  The above description
is correct for SMI workstations with Sun-1 processors as well
as Sun-2s, but the details of the
general boot command and other @c[PROM] monitor
commands vary.
The V kernel tickles a bug in the current Sun-3 @c(prom)s. Rebooting a Sun-3
usually requires power cycling the workstation.
@end(note)

@paragraph(Cadlinc Workstations)

A Cadlinc workstation in a random state can be reset to the @c[PROM] monitor
by typing @c[<CTRL><SHIFT><BREAK>], pressing the reset button, or
(in desperation) power-cycling the workstation.@index(Cadlinc)
It is best to try pressing the
comma key on a Cadlinc's numeric keypad before resetting it.
If the 
V kernel is active at that point, this key instructs it to turn off the mouse,
necessary for proper operation of the @c[PROM] monitor.
Otherwise, you may 
have to power cycle the workstation or keyboard to regain control.

On the Cadlinc, either @t[k1] or @t[k2] will simulate a powerup reset.
You may need to type the command twice for it to take effect.
The Cadlinc @c[PROM] monitor uses @t[n] in place of @t[b] in the
simple boot commands above.  
See section @ref(Standalone) for a
full description of Cadlinc boot commands.

All Cadlinc workstations
use a version of the Sun-1 processor board.

@paragraph(Rack-Mount Suns)
Suns that have an ordinary terminal as their console can usually be
brought into the @c[prom] monitor by hitting the terminal's @c[break] key.
Sometimes there is a reset button or switch attached.  
Some rack-mount Suns at Stanford contain
Sun-1 processors; others use the Sun-2.
Some boot using the @t[n] command; others use @t[b].
In most cases, the boot commands listed above will work, and
the STS will automatically be loaded in place of the VGTS,
but in general it is best to check with a wizard before rebooting
a rack-mount Sun.

@subsection(An Overview of Subsequent Interaction)
@Begin(note)
This section is somewhat redundant with Section @ref(UIArchitecture) since
it is assumed that many people will read it without reading that section!
@End(note)

Once the user has booted his workstation he may communicate with one of two
entities: an @i(executive) or the @i(view manager).  The user executes
commands (application programs) from within an executive, which is similar
to the UNIX C-shell.  The applications may run local to the workstation or
remote.  They may be written with the particular workstation in mind, or run
in ``terminal emulation'' mode.  They may require I/O modalities other than
traditional text, namely, graphics.  Each application may be associated with
one or more separate virtual terminals as discussed above.

When the user wishes to initiate a new application concurrent with existing
applications, he must first create a new executive.  To do so, the user
communicates with the view manager.  The executive serves as a command
interpreter from which the desired application may be initiated.  The user
can create a new executive, with associated virtual terminal, at any time,
asynchronous to any existing activities.  When a particular application
requires additional virtual terminals, it is free to create them.  These
virtual terminals will be deallocated when the application terminates.

A virtual terminal is made ``visible'' by mapping it to the screen.  Each
such mapping is termed a @i(view).  When an application creates a new
virtual terminal, the application may specify where on the screen the view
should appear or the application may request that the user should specify
the view interactively.  Thereafter, the user may create as many additional
views as he wishes.  To some extent, he may manipulate views of the same
virtual terminal independent of all other views of that virtual terminal,
for example, pan or zoom one view independent of all other views of the same
virtual terminals.  All such virtual terminal management is performed via
the view manager.

@Section(VGTS Conventions)

When using the VGTS, views
appear as white overlapping rectangles on the screen, with a black border
and a ``banner'' across the top edge.  The banner contains the following
information:
@Begin(itemize, spread 0)
a virtual terminal identifier

a view identifier

the ``name'' of the associated application (if any)
@End(itemize)

Every view of every ANSI virtual terminal displays the text input cursor
as a small black box.  An additional cursor is associated with the mouse; it
may change shape  depending on what graphical input event is expected, for
example.

@subsection(Selecting for Input)

As discussed above, at most one application is selected for input at one
time.  At most one of its virtual terminals (usually an AVT) may be selected
for keyboard input.@index(ANSI virtual terminal)@index(AVT) Any subset of
its virtual terminals may be selected simultaneously for mouse input; the
application may selectively enable and disable mouse input for each virtual
terminal.

All views of all virtual terminals selected for input (of any kind) display
a ``blackened'' banner @ld() white text on black background.  In
addition, the virtual terminal selected for keyboard input will display a
flashing black box at the cursor.  Unselected  virtual terminals have
whitened banners @ld() black text on white background.

@subsection(Using the Mouse)

There are a few conventions for using the mouse with the VGTS.@index(Mouse)
First, we assume a three-button mouse.  
In the discussion that follows, the buttons are
labeled simply "left", "middle", and "right".

We assume that there is always a cursor associated with the mouse.  Wherever
the term ``cursor'' is used without qualification, we are probably talking
about the mouse cursor @ld() rather than the keyboard cursor.  Also, we will
often use the phrase ``pointing to'' to mean ``the mouse cursor is in'' or
``the mouse cursor is pointing to''.

A ``click'' consists of pressing any number of buttons down@index(Click)
and releasing them at a certain point on the screen. 
While the buttons are down there may be some kind of feedback,
like an object which follows the cursor.
The click is usually only acted upon
when all the buttons are released, so if you decide you have made 
a mistake after pressing the buttons you can slide the mouse
to some harmless position before releasing the buttons.
Holding all three buttons down is also interpreted as a universal
abort by most programs and the view manager.@index(abort)
The click event is sent to the program associated
with the view in which the event occurred (through its virtual terminal).

A ``transition'' consists of a press @i[or] a release of @i[any] combination
of buttons@index(Transition).  A transition event is sent to the program
associated with the view in which the event occurred.  Since it typically is
acted on immediately, the VGTS provides no feedback and the universal abort
feature described above does not work.

@subSection[The Screen Saver]@Index[Screen saver]
The VGTS will automatically disable (blacken) the screen if no keyboard or 
mouse events have occurred within the preceding 10 minutes.  This helps
protect the screen's phosphor.  The screen is reenabled by a subsequent 
keyboard or mouse event.  Note that other VGTS events will not reenable the 
screen, so the screen save will work even if a program such as @t[mon] (which 
periodically updates the screen) is being run.

@section(Workstation Management)

Almost all workstation management functions are accessible via a set of
menus managed by the @i(view manager).  The only exception is selection of
an application for input.  Many view manager functions are also available
via ``accelerators'' @ld() ``appropriate'' mouse clicks in ``appropriate''
places.  Some functions are triggered by program-generated requests.  We
discuss each situation in turn.

@subsection(Selection for Input)

Clicking the left or middle button of the mouse in a view of a non-selected
virtual terminal will cause the associated application to be selected for
input.  The view will be brought to the top.

@subsection(Using the View Manager Menus)
@label(ViewManager)
@index(View Manager Menu)@index(Menu, View Manager)

The view manager menus can always be invoked by moving
the cursor to the grey background area or to any view not selected for
input (except in the banner area) and pressing the right button.
The following commands are available from the view manager menus.  The
commands are presented in alphabetical order, followed by a summary of what
each (sub-)menu contains.

@paragraph(View Manager Menu Commands)
@begin(description)
Center Window@\Change the ``window'' associated with a view @ld() without
changing the position of the associated viewport.  Click@index(Center Window)
any button at the position in the viewport that you want to become the
center of the viewport.  Doing this to AVT's is almost always a mistake.

Create Executive@\Create a new executive, with associated AVT.@index(Create
Executive)  The cursor changes to the word "Exec".  When you press a button,
an outline of the new AVT will appear, and will follow the cursor as you
hold the button down.  Lift the button up at the desired position, or press
all three buttons to abort.  
@begin(note)
Comes in two flavors, for two different
default sizes of AVT (see Set Alternate Exec Size below).
@end(note)

Create View@\Create@index(Create View) another view of an existing virtual
terminal.  The cursor changes to the word "View".  Move the cursor to the
desired position of any one of the four corners for the new viewport.  Hold
any button down, and move the cursor to the diagonally opposite corner.  An
outline of the new view will follow the cursor as it moves with the button
down.  Let the button up, and then point at the virtual terminal that you
would like to see with the left or middle button, or hit the right button
and select the virtual terminal from the menu.  Normally only used with
SGVT's.

Delete Executive@\Delete an executive.@index(Delete Executive)  Click any
button in any view associated with the executive.

Delete View@\Delete a view.  Click@index(Delete View)
any button in the associated viewport.  
@begin(warning)
If you delete the last
view of a virtual terminal, it does @i[not] destroy the virtual terminal or
the process associated with it.  You can still create views of the virtual
terminal by using the right button menu in the Create View command.
@end(warning)

Exec Control@\Select the submenu for executive and program control 
functions.@index(Exec Control)
A shortcut to the Exec Control
menu is obtained by pressing both the middle and right buttons while
the cursor is in the gray background or in a
view not selected for mouse input.

Expansion Depth@\Set the ``expansion depth'' for a SGVT.@index(Expansion
Depth) For hierarchically defined graphical symbols, this determines how
much (how deep) of the hierarchy will be displayed.  If this causes some
graphical item not to be displayed, its bounding box is displayed, possibly
with a text name (if there is room).  The default expansion depth is
infinity, such that all levels will be expanded.  Click any button in the
view whose expansion depth you wish to set, then select the new expansion
depth from the menu that pops up.

Graphics Commands@\Select the submenu for graphics functions.@index(Graphics
Commands)
A shortcut to the Graphics Commands menu is obtained by pressing both the
left and right buttons while the cursor is in the gray background or in
a view that is not selected for mouse input.

Interrupt Program@\Interrupt a program, forcing it into the debugger.  Click
any button in any view associated with the program.@index(Interrupt Program)

Kill Program@\Kill a program.@index(Kill Program)  Click any button in any
view associated with the program.

Make Bottom@\Push a view to the bottom,@Index(Make Bottom)
potentially making visible other views.  Click any button in the desired
view.  A
shortcut to this function is obtained by pressing the right button while
the cursor is in the banner of the desired view.

Make Top@\Bring a view@index(Make Top) to the top, potentially obscuring
other views.  Click any button in the desired view.  Does @i[not] select
the associated virtual terminal for input.  A shortcut to this function is
obtained by pressing the left button while pointing to the banner of the
desired viewport, which action action @i[does] select the virtual
terminal for input.

Move Edges@\Change the viewport associated with a view by moving one or more
edges.  Scaling is not provided, so this also changes the window (the portion
of the object being viewed), but without moving the object relative to the
screen.
Push@index(Move Edges)
any button down next to an edge or corner,
move that edge or corner to the new position, and
let the button up.
The edge outline should follow the cursor as long as you hold the
button down.

Move Edges + Object@\Similar to Move Edges,@index(Move Edges + Object)
but drags the underlying object around with the moved edge or corner.

Move Viewport@\Change the viewport associated with a view by changing its
position, but retaining its size.
Press@index(Move
Viewport) any button in the desired view.  While the button is being
held down, the outline of the viewport will move, following the cursor.
Lift up the button at the desired position.  
A shortcut to this function is
obtained by pressing the middle button while pointing to the banner of the
desired view; the viewport outline will follow the cursor until the
middle button is released.

Redraw@\Erase and redraw@index(Redraw) the entire screen.
Should be necessary only when low-level debugging information trashes the
screen.

Reset State@\Reset the state of an AVT@index(Reset State).  Click in any
view of the AVT.  This is equivalent to pushing the
``reset'' key on a VT-100 or most other page-mode terminals and is necessary
only in extraordinary situations where the AVT appears to be ``wedged''.

Set Alternate Exec Size@\Set the ``alternate'' size for 
executives.@index(Set Alternate Exec Size)  Type in the size to the VGTS
window.  Executives of the new size can then be created using the
Exec Control submenu.

Toggle Grid@\Toggle the background grid in a view of SGVT.
Click@index(Toggle Grid)
once to turn the grid on if it is off, or off it
is on in the view you select.
The grid dots are every 16 screen pixels, and always line up with the origin.

Toggle Paged Output Mode@\Enable or disable paged-output mode in a 
AVT.@index(Toggle Paged Output Mode)  Click in any view of the AVT.

Zoom@\@begin(multiple)Invoke ``zoom mode'' in an SGVT.@index(Zoom) The
cursor changes to the word "Zoom".  You can get out of this mode in two
different ways: First, clicking the left or middle buttons when the cursor
is inside a view of an AVT returns from the view manager and selects that
AVT for input.  As a side effect that view is also brought to the top.
Secondly, you can click the right mouse button.  The cursor should change
back to the normal arrow.

The left and middle buttons in Zoom mode@index(Zoom)
zoom out and in respectively.
That is, the left button makes the object look smaller,
and the middle button makes it look larger.
You can remember this because the ``outer'' (left) button zooms out,
and the ``inner'' (middle) button zooms in.
A shortcut to this mode is available by clicking the middle and
left buttons at the same time while the cursor points to the
gray background or to a view not selected for mouse input.
@end(multiple)
@end(description)

@paragraph(Assignment of Commands to Menus)

The top-level view manager menu contains the following commands:
@Begin(display, leftmargin +1in)
Create View
Delete View
Exec Control
Graphics Commands
Make Bottom
Make Top
Move Viewport
@End(display)

The "Exec Control" sub-menu contains:
@Begin(display, leftmargin +1in)
Create Executive (@i(two flavors!))
Delete Executive
Interrupt Program
Kill Program
Reset State
Set Alternate Exec Size
Toggle Paged Output Mode
@End(display)

The "Graphics Commands" sub-menu contains:
@Begin(display, leftmargin +1in)
Center Window
Expansion Depth
Move Edges
Move Edges + Object
Redraw
Toggle Grid
Zoom
@End(display)

@subsection(Summary of Accelerators)

The workstation management functions available though mouse clicks
are listed in Table @ref(FastPaths).
See also section @ref(EmacsHack).

@begin(table)
@Begin(format, leftmargin +.5in)
@tabclear
@tabset(+.25in, +.25in, +.25in, +3.5in, +1.5in)
 Mouse 
Buttons@\@=Where@=Effect
@ux(L@\M@\R@\@\@\)
x@\.@\.@\In banner@\Make Top and select
.@\x@\.@\In banner@\Move Viewport
.@\.@\x@\In banner@\Make Bottom
x@\.@\.@\In non-selected viewport@\Make Top and select
.@\x@\.@\In non-selected viewport@\Make Top and select
.@\.@\x@\In gray or non-selected viewport@\Top-level menu
.@\x@\x@\In gray or non-selected viewport@\Exec Control
x@\.@\x@\In gray or non-selected viewport@\Graphics Commands
x@\x@\.@\In gray or non-selected viewport@\Zoom
x@\x@\x@\During any workstation management command@\Abort
@End(format)
@caption(Accelerators for workstation management functions.)
@tag(FastPaths)
@end(table)

@subsection(Program-generated Requests)

When a program requests the creation of a view, the VGTS enters the
same interaction cycle as described for the Create View command above.
However, since the virtual terminal will have been specified in the function
call, you do not need to select the virtual terminal, and universal abort
typically will not work.

When a program requests the creation of an AVT, the cursor will change to the
word ``Pad'' (sorry about that).  At this point, hold down any button, and
an outline of the viewport that will be created will be tracked on the
screen.  Position the viewport where desired, and let go of the button.

@section(Line Editing Facilities)
@label(LineEditing)@index(Line Editing)

Keyboard input can be edited with Emacs-style line-editing commands.  More
specifically, the commands listed below are available. 
@comment(begin(comment *** MOVE TO CONVENTIONS SECTION ***)
@c(CTRL)-x means@index(Control)
holding down the Control key and the x key simultaneously;  ESC-x means
striking the Escape key and then the x key.@index(Escape)
@comment(end(comment)
@Begin(description, leftmargin +8, indent -8)
@c(CTRL)-a@\Move@index(Beginning of Line)@index(Start of Line)
cursor to beginning of the command line.
@index(@c(CTRL)-a)

@c(CTRL)-b@\Move cursor back one character.@index(Cursor Backward)
@index(@c(CTRL)-b)

@c(CTRL)-c@\Kills@index(Kill Break)@index(Break Process)
the Break Process, usually the command running in the current
executive.

@c(CTRL)-d@\Delete character under the cursor.@index(Delete Character)
@index(@c(CTRL)-d)@index(Delete Character Forward)

@c(CTRL)-e@\Move cursor to the end of the command line.@index(End of Line)
@index(@c(CTRL)-e)

@c(CTRL)-f@\Move cursor forward one character.@index(Cursor Forward)
@index(@c(CTRL)-f)

@c(CTRL)-g@\Abort the command.@index(Abort Command)
The line editor will pass the command line, followed by a @c(CTRL)-g, to the 
client program, which is responsible for detecting the @c(CTRL)-g
and reacting to it.  (The standard executive responds to such a line by 
printing ``XXX''.)
@index(@c(CTRL)-g)

@c(CTRL)-h@\Delete the character before the cursor.@index(Delete Last Character)
Equivalent to the @c(DEL) key.
@index(@c(CTRL)-h)@index(Delete Character Backward)

@c(CTRL)-i@\Insert an appropriate number of spaces, to simulate a TAB character.
Equivalent to the @c[TAB] key.
@Index(@c(CTRL)-i)@Index(Tab)

@c(CTRL)-k@\Delete@index(Delete to End of Line)
the command line from the cursor to the end of the line.
@index(@c(CTRL)-k)

@c(CTRL)-t@\Transpose the two characters preceding the cursor.
@index(@c(CTRL)-t)@index(Transpose)

@c(CTRL)-u@\Delete the command line up to the cursor.@index(Delete Line)
@index(@c(CTRL)-u)@index(Delete to Beginning of Line)
@index(Delete to Start of Line)

@c(CTRL)-w@\Delete from the cursor to the beginning of the current word.
@index(@c(CTRL)-w)@index(Delete Word Backward)

@c(CTRL)-z@\Causes an End of File indication to be sent
to the application reading the line.@index(End of File)
This will terminate the Executive if no application is running.
@index(@c(CTRL)-z)

@c(ESC)-b@\Move cursor to the beginning of the current word.
@index(@c(ESC)-b)@index(Previous Word)@index(Cursor Word Backward)

@c(ESC)-d@\Delete from the cursor to the end of the current word.
@index(@c(ESC)-d)@index(Delete Word Forward)

@c(ESC)-f@\Move cursor past the end of the current word.
@index(@c(ESC)-f)@index(Cursor Word Forward)

@c(ESC)-h@\Delete from the cursor to the beginning of the current word.  Same as
@c(CTRL)-w.
@index(@c(ESC)-h)

@c(CR)@\Return the line-edited text to the client.  Even if struck in the
middle of the ``line'', the entire line will be returned.
@End(description)
Printing characters are normally inserted at the cursor.  

@section(Paged Output Mode)
@label(Paged Output Mode)@index(paged output mode)

When paged output mode is on, the workstation agent stops writing to an AVT
when the AVT fills up with output.  The workstation agent then displays the
message "Type <space> for next page" in the banner and waits
for the user to issue a command that unblocks the AVT.  

Most commands are optionally preceded by an integer argument @p(k).  Defaults
are in brackets.  Star (*) indicates that the argument becomes the new
default.
@begin(description, indent -8, leftmargin +8)
<space>@\Display the next @p(k) lines [current page size]

z, Z@\Display the next @p(k) lines [current page size]*

@c<CR>, @c<LF>@\Display the next @p(k) lines [1]

q, Q@\Throw away all output until the next time input is sent to the application
program.

s@\Scroll forward @p(k) lines [1]

S@\Scroll forward to the last line

f@\Scroll forward @p(k) pages [1]

F@\Scroll forward to the last page

@c(BS), @c(DEL)@\Erase the last character of the numeric argument

.@\Repeat the previous command
@end(description)

If the user types a character that is not a valid command, the character is
treated as a normal input character.  If line-editing mode is on, the
@c(CTRL)-c and @c(CTRL)-z commands (see section @ref(LineEditing)) have their usual
effect here.

@section(Sending Mouse Events to Text-oriented Applications)
@label(EmacsHack)

Many applications exist that have not been written expressly for the
V-System, but can be accessed via the text terminal emulation protocol.  A
few minor additions to this protocol permit applications to receive a number
of mouse clicks as escape sequences that they may interpret as they wish.
The precise escape sequences generated are given in Chapter @ref(VGTSlibc).

A complete list of the events that generate escape sequences, and the
use to which the UNIX EMACS text editor puts them, is given in Table 
2-2.@comment[@ref(Emacs Actions).]
The actual
escape sequences generated are given in Section @ref(EmacsHack2).
@begin(table)
@Begin(format, leftmargin +.9in)
@tabclear
@tabset(+.25in, +.25in, +.25in, +4in)
 Mouse 
Buttons@\@=Emacs Interpretation
@ux(L@\M@\R@\@\)
x@\.@\.@\Position the cursor at the position of the click.@index(Left
Button)
x@\x@\.@\Set the mark to the clicked position.@index(Left+Middle Buttons)
x@\.@\x@\Delete from the mark to the clicked position.@index(Left+Right
Buttons)
.@\x@\x@\Insert the kill buffer at the clicked position.
@index(Middle+Right Buttons)
@end(format)
@caption(Events that generate escape sequences.)
@tag(Emacs Actions)
@end(table)

@section(Emulating the Mouse with the Keyboard)@index(mouse emulation)

For the benefit of hardware configurations without a working mouse, the VGTS
can interpret certain keyboard escape sequences as mouse input.  

@subsection(Workstation Management)

The input virtual terminal can be changed by using @c(CTRL)-^ (octal 036)
followed by a single command character.  The only command characters
interpreted by the VGTS are 1-9 to select the given virtual terminal for
input.

@subsection(Graphics Events)

The VGTS also interprets certain character
sequences as mouse movements or button
transitions.  However, the VGTS will only intercept these escape sequences
if they are sent as a rapid burst of characters, as is the case when they
are sent by pressing a function key.  If the escape sequences are typed
manually, the VGTS detects the space between characters and passes them
through in the normal fashion.

The following is a list of the escape sequences used and the function keys with
which they are normally associated on an ANSI (VT100-style) keyboard:
@begin(description)
@c(ESC)-[ A@w[   (ANSI Down Arrow)]@\Move the mouse cursor down.

@c(ESC)-[ B@w[   (ANSI Up Arrow)]@\Move the mouse cursor up.

@c(ESC)-[ C@w[   (ANSI Right Arrow)]@\Move the mouse cursor to the right.

@c(ESC)-[ D@w[   (ANSI Left Arrow)]@\Move the mouse cursor to the left.

@c(ESC)-O P@w[   (ANSI PF1)]@\Toggle the value of the left mouse button.
The new value of the left mouse button is displayed in the view manager
window.

@c(ESC)-O Q@w[   (ANSI PF2)]@\Toggle the value of the middle mouse button.
The new value of the middle mouse button is displayed in the view manager
window.

@c(ESC)-O R@w[   (ANSI PF3)]@\Toggle the value of the right mouse button.
The new value of the right mouse button is displayed in the view manager
window.

@c(ESC)-O S@w[   (ANSI PF4)]@\Toggle mouse emulation mode.  When mouse emulation mode
is OFF, all escape sequences except this one are passed
through as normal, allowing the associated function keys to perform
application-defined functions.  The new state of mouse emulation mode is
displayed in the view manager window.
@end(description)

When the VGTS receives input from a "real" mouse, this type of emulation is
permanently disabled.  If your mouse fails, you must use the "newterm" command
to create a new VGTS in order to use mouse emulation.

@Begin(warning)
These sequences only work on Sun-100's.
@End(warning)

@section(STS Conventions)

The bulk of the discussion thus far has assumed the availability of the
VGTS.  However, there are occasions when users may have the interact with
the STS instead.  In that case, the user sees exactly one view of
exactly one terminal associated with exactly one executive.  That
view occupies the entire screen.  The user interacts with this
executive exactly as he would with an executive running under the VGTS.
Line-editing facilities and output paging are provided.
