@part(hack, root "manual")
@Chapter(hack:  Exploring The Dungeons of Doom)
@label(hack)

@section(Command format)

To start up a game of @i[hack], use the command
@begin(programexample)
hack -u @i[playername] -@i[role] -n -D -d @i[directory]
@end(programexample)
All arguments are optional, and most are normally omitted.
You can use the @t[-u] flag to specify your name on the command line.  If
this flag is not given, @i[hack] will use your V login name,
or if you are not logged in, it will ask your name after starting.
If your name is suffixed by a hyphen and a single letter, the letter
specifies your character type.  For example @t[-u fred-t] specifies that Fred
wants to play as a Tourist.
You can also select a character without changing your name by
giving the character type as a flag, e.g., @t[-t] to play as a Tourist.
The @t[-n] flag suppresses printing of the latest ``hack news''.
(Usually there is no news anyway.)
The @t[-D] flag lets you play in ``wizard mode''.  It is (almost) 
impossible to
die in this mode, and you get a free wand of wishing with 20 charges, but
your score is not counted.  This mode is mostly good for debugging the game.
The @t[-d] flag specifies the
directory @i[hack] is to use for storing temporary files, the 
score record, etc.
If this flag is omitted, the default directory @t([sys]run/hack) is used.

To see the current scores without playing, use the command
@begin(programexample)
hack -s -@i[roles] @i[playernames] -d @i[directory]
@end(programexample)
The @t[-s] flag is required.
It may be followed by one or more @i[role] flags, or one
or more player names to see scores for only those players or roles.
If no player or role names are given, @i[hack] prints only your own scores.
The @t[-d] flag is optional and functions as described above.

@section(Description)
@i[Hack]
is a display oriented game inspired by the popular
Dungeons and Dragons fantasy game.
Both display and command structure resemble @i[rogue], but
@i[hack]
has many more types of monsters, magic items, and so forth.

To get started you really only need to know two commands.  The command
@t[?]
will give you a list of the available commands and the command
@t[/]
will identify the things you see on the screen.

To win the game (as opposed to merely playing to beat other people high
scores) you must locate the Amulet of Yendor which is somewhere below
the 20th level of the dungeon and get it out.  This is easier to do in
@i[hack] than in @i[rogue].

When the game ends, either by your death, when you quit, or if you escape
from the caves,
@i[hack]
will give you (a fragment of) the list of top scorers.  The scoring
is based on many aspects of your behavior, but a rough estimate is
obtained by taking the amount of gold you've found in the cave plus four
times your (real) experience. Precious stones may be worth a lot of gold
when brought to the exit.
There is a 10% penalty for getting yourself killed.

The administration of the game is kept in the directory specified with the
@t[-d]
option, or, if no such option is given, a default directory specified
at compile time.  (Currently @t{[sys]run/hack}.)
This same directory contains several auxiliary
files such as lockfiles and the list of top scorers, and a subdirectory
@t[save] where games are saved.

@section(Options)
You may set options using the HACKOPTS
environment variable, or the @t[O] command within the
game.  The flag or command is followed by
a comma-separated list of options.  Available options are
echo, tersehelp, name, oneline, and passgo.  A description of these
is available through the @t[?] command.  All boolean options default to
being false.  To set a boolean option true, specify it in the option
list.  To set your character's name, use the construct @t[name=@i{your name}].
For example, to set tersehelp, passgo, and your name to Yen Goi,
the option string would be
@t[tersehelp,passgo,name=Yen Goi].
You cannot change your name once you start playing.

@section(Authors)
Jay Fenlason (plus Kenny Woodland, Mike Thome and Jon Payne) wrote the
original @i[hack], very much like @i[rogue] (but full of bugs).
Andries Brouwer continuously deformed their sources into the current
version_in fact an entirely different game.
Ported to the V-System, and additional hacking done, by Tim Mann.
The V-System version is based on Andries Brouwer's version 1.0.3.

@section(Files)

Files other than the @i[hack] program itself are kept in the administration
directory mentioned above.

@begin(description)
data@\Data file for the @t[/] command.

help, hh@\Data files for the @t[?] help command, respectively the long and
terse forms.

news@\Hack news, printed whenever a game is started.

rumors@\Fortune cookie database.

record@\The list of top scorers.

save@\A subdirectory containing the saved games.

bones@us()dd@\Descriptions of the ghost and belongings of a deceased adventurer.
@end(description)

@section(Bugs)

Probably infinite.
You can mail complaints to games@@Pescadero, but
we suggest volunteering to fix it yourself if you want it fixed.

This game is a huge time sink.
