@Part(fscheck, root "manual")

@Chapter(fscheck: File System Checking Program)
@label(fscheck)
@index(fscheck)

This program is a file system disk checker as well as simple file system editor
that can be used to inspect and modify file system disk data structures.
In addition, it gives one the capability to create and initialize new file
systems.
Fsheck must only be used when there is no other file system activity.
It also should only be used by persons responsible for maintaining
the file system.

@Section(Invocation)
One can invoke fscheck from within the V system executive by typing
@programexample(fscheck)
or
@programexample(fscheck @i<devicename>)
If no device name is specified, fscheck attempts to open two devices,
[device]disk0 and [device]disk1.  Non-existence of a second device does not
affect correct operation of the program.
Note that the devices must be attached to the workstation from which
the command is invoked and the kernel running on the workstation must include
the proper disk driver (see the Kernel Section for details on which
kernel should be booted).

@Section(Commands)
Commands are provided to check the global data structure consistency of
each file system, 
inspect and modify individual node descriptors (ND), and initialize new file
systems.
@begin(description)
a [+r] [+s]@\check
the consistency of the file system block allocation.
If +r is specified, the bitmap is reconstructed.
If +s is specified, error messages about blocks marked in the bitmap
but not allocated to a file are suppressed.

b block@\print
the nd number of all node descriptors that point to the given block number.
Normally,
there is at most one.
If the allocation is inconsistent,
a block may be allocated more than once.

c@\update
the checksum in the current ND,
print it, and set the current field to the checksum field.

f @\print
the pathname of the current ND relative to the file system being checked.

g field@\set
the field corresponding to the given name as the current field
and print
the current field.

i @\initialize file system information.
Prompts the user for the name, drive number, start block, and length
of each file system in the disk subsystem and writes the information
into the file
"fstab" on the root file system.
Note that the start block of the first (root) file system should correspond
to the START@us()FD@us()FILE definition (usually 40) 
in "/V/servers/storage/storagedefs.h".
Warning:  this command should only be executed when new file systems are
being created.

l @\print
all links from and to the current ND.

n <path> | <nd>@\set
the ND corresponding to the given pathname or number to be the current ND.
Pathnames must be specified as absolute pathnames
(i.e. starting with "/").
If a pathname cannot be followed,
the current ND is set to the last node
visited while looking up the pathname.
This occurs if
the node does not exist
or the path from
the root cannot be followed
(e.g. a node in the path has a bad checksum).

p @\print
all the fields of the current ND.

q@\quit.

s number@\set the current file system to be the one indicated by number.

t @\check
the consistency of the file system tree structure.

w@\write
the current ND back to disk.
The ND number is taken from the current value of the number field.
If the current ND describes an allocated node
(i.e. its name field is not the null string),
it is written only if
its checksum is correct.
If it describes an unallocated node,
it is written
unconditionally.
Checks that the number field is correct before writing the current ND out.

<RETURN>@\advance
to the next field and print its name and value.
Hitting <RETURN> after an "n"
command prints the first field.

.@\print
the current field.

^@\set
the current field to the previous field and print it.

= <number> | <str>@\store
the given number or string in the current field and print it.
The number may be decimal,
octal (``0'' prefix), or hexadecimal (``$'' prefix).
A string is a sequence of characters.
A null string is represented by "".  Strings are accepted only when the
name field is being modified.
Note that modifications are not
effective until a "w" command is issued.
@end(Description)

@Section(Initializing a new disk subsystem)
Once the disk drive(s) have been formatted (using @i[diskdiag]), the
characteristics of each of the multiple possible file systems should be
specified.  This can be accomplished by creating the root file system (as
described below) and subsequently running the "i" command.  Then,
using the "s" command to successively switch to each new file system,
the rest of the file systems should be created.

@Subsection(Creating a new file system)
To build a new file system, one should allocate blocks to the ND file (ND 1)
and to the bitmap file (ND 2).  If the file system being created is the root
file system then a single block should be allocated to ND 3, with name
FSTABLE@us()NAME (as define in /V/servers/storage/storagedefs.h).
This is done by modifying these node descriptors so that each refers to 
non-overlapping extents of disk blocks.  
The ``eof@us()blk'' field of a ND should represent the sum of all the extents
in that ND.  The total number of blocks allocated to ND 2 should be
large enough so that the total number of bits allocated is greater than
the total number of blocks in the file system.  Note that all block 
allocations are relative to the beginning of the file system.

The ``permissions'' field of ND 1 should be 
SS@us()NORM@us()PERM (as defined in <Vstorage.h>).
Setting the ``timestamp'' field to the current
time can be accomplished with "=t".

Also, the link fields in each 
node descriptor should be updated so that a proper tree structure 
exists, i.e., ND 2 is the son of ND 1 and ND 3 is the brother of ND 2.
After this is done, a "t" command should be used
to check the consistency of the new tree structure, and an "a +r" command 
must be
issued so that the bitmap reflects these newly allocated blocks.

@Section(Checking file system integrity)
Once the "s" command has been used to set the current file system to the one
you want to check,
test the consistency of block allocation using the "a" command.
Used with the +r option,
it rebuilds the bitmap file in the case of missing
blocks (i.e. blocks marked as allocated in the bitmap
but not actually allocated to any file)
or blocks allocated to a file,
but marked as free
in the bitmap.
Blocks allocated more
than once have to be handled manually.  In this case,
use the "b" command to determine to which ND's they are allocated.
Use the "n" and the "f" commands to determine the pathnames of those ND's.
Note that the information in
the files may be damaged.

Second, check the tree structure using the "t" command.
If there are missing links,
find out what they should be
using "n" and "l".
If there are nodes completely disconnected from the file system,
remove them or else determine from their father pointers where they should
be in the tree structure.
The easiest way to remove a disconnected node is to mark the corresponding ND 
as
unallocated
(setting the name field to the null string)
and then using "a +r"
to recover the blocks that were allocated to that file.

