@Part(cmds, root "manual" )
@Chapter(Command Summary)@label(CmdSummary)

@section(Workstation Commands)

The following briefly summarizes the currently available commands for V.
@begin(Description)
addcorr@\Add correspondences from your V user identity to 
UNIX user accounts.  
Each V user can correspond to one account on
each local UNIX machine that is running a V/UNIX server.
The V superuser can add correspondences for other users as well as itself.
See Chapter @ref(UnixServer) for more information about user
correspondences.

amaze@\A multi-person distributed game.@Index(amaze)
Does not (yet) run under the VGTS.  See Chapter @ref(Amaze).

ar@\Constructs library files (``archives'').@index(ar)
See the UNIX manual for documentation.

biopsy@\Prints information about all the processes on the workstation,
sorted by team.  Several options are recognized.
The -l option also includes the filename from which each team was loaded.
(This generally makes the output longer than one screenful.)
The -t option followed by a pid or the @i[suffix] of a team's filename will
cause information to be printed only about the team associated with the pid
or filename.  More than one pid or filename can be specified - information
for each will be printed.
To obtain detailed information about one or more processes, invoke biopsy
with just the pid(s) of the relevant process(es).@Index(biopsy)

bitcompile@\Converts human readable bitmap specifications into initialized C
data structures.  @begin(multiple)Usage:  bitcompile [ options ] [ file ].

The file argument specifies the source, otherwise standard input is
used.  Output goes to standard output by default.@Index(bitcompile)

The following options are interpreted by bitcompile:
@begin(description, indent -12)
-DBIG@us()ENDIAN@\Order the bytes (and bits) of the bitmap for big endian
machines.  This is the default.

-DBLACK@us()IS@us()1@\Generate bits of 1 for black.  This is the default.

-DBLACK@us()IS@us()0@\Generate bits of 0 for black.

-DCOLUMN@us()ORDER@\Generate bitmaps as columns of 16 bit words.

-DLITTLE@us()ENDIAN@\Order the bytes (and bits) of the bitmap for little
endian machines.

-DNOHDR@\Do not place a header before each output bitmap.

-DROW@us()ORDER@\Generate bitmaps as rows of 16 bit words.  This is
the default.

-DSUN100FB@\Generate bitmaps for (the current implementation of)
SUN 1 frame buffers.  This is equivalent to
specifying -DCOLUMN@us()ORDER.

-DSUN120FB@\Generate bitmaps for (the current implementation of)
SUN 2 frame buffers.  This is equivalent to
specifying -DCOLUMN@us()ORDER.

-DVAX@\Generate bitmaps for (the current implementation of)
MicroVax frame buffers.  This is equivalent to
specifying -DLITTLE@us()ENDIAN -DBLACK@us()IS@us()0.

-o @i[file]@\Send the output to @i[file].
@end(description)
@end(multiple)

bits@\A program for manipulating (@i[e.g.] hand-editing) bitmaps and fonts.
See Chapter @ref(bits).

boise@\@begin(multiple)Prints@Index(boise)
files on the Boise laser printer.

Several switches are allowed, preceding the filenames:
@begin(description, indent -12)
-r@\Print rotated, that is, in landscape (horizontal) mode.

-n @i[name]@\Use @i[name] to label the output.  If this option is not given,
the user's name is fetched from the system authentication database.

-b @i[banner]@\Use @i[banner] in the ``File:'' field instead of the filename.

-h @i[hostname]@\Host name to use instead of ``V-System''.

-m @i[mode]@\Print mode.  Possible modes are
@begin(description)
0@\Line printer.  For printing ordinary text files.  The default unless the
filename ends in ``.dvi'' or ``.press''.

1@\DVI.  For printing TeX output.  The default if the filename ends in
``.dvi''.

2@\Press.  Not implemented.  The default if the file name ends in ``.press''.

3@\HP2680a.  For files in HP2680a ``spool file'' format.
@end(description)

-w@\File is in the Sail (``WAITS'') character set instead of standard ASCII.
(Line printer mode only).

-W@\File is in the TeX character set instead of standard ASCII.
All characters with the high-order (8th) bit set are treated as
printing characters after the high-order bit is stripped.  This feature
permits access to the printing characters ``hidden under''
the ASCII codes for carriage return, linefeed, etc.
(Line printer mode only).
@end(description)

If no filenames are given, @i[boise] reads its standard input.
@end(multiple)

build@\Automatically run programs depending on which files are
out-of-date. See Chapter @ref[build]. @i[build] is an extension
of the Unix @t[make] program.

cat@\File concatenation program.  Copies each named file to the
standard output.  A hyphen (``-'') represents standard input.  
If no arguments are given, standard input is assumed.
There are no flags.@index(cat)

cc68@\Compiles @t[C]@Index[C]@Index(cc68)
source programs for running on the m68000 processors.
See the Unix @t[man] page.

cd@\Change directory: change the current context.  Built in to the exec.
@Index(cd)@Index(Change Directory)

checkers@\Lets you play a game of checkers against the@Index[Checkers]
workstation.  This
is also a good demonstration of the VGTS's graphics capabilities.  See
Chapter @ref[checkers].

checkexecs@\Kill off any exec whose standard input server or standard
output server has died.@index(checkexecs)

ci@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(ci)

clear@\Clears the AVT.@Index[Clear]

clock@\An analog clock. Understands two flags: -s (with second hand) and -t
(without text, in case you want to zoom the clock).@Index[clock]

co@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(co)

cp@\If two filenames are given, @t[cp]
copies the first file specified to the second file (or to @t[stdout] if the 
second filename is ``@t[-]'').
If more than two filenames are given, or the @t[-d] flag is given,
the last argument is assumed to be a directory name,
@t[cp] copies the first @i[n]-1 files specified into that directory,
forming the name of each new file by appending the last component of 
the corresponding old file to the directory name.
Note that this behavior is not quite
identical to that of the Unix @t[cp] program; the V @t[cp] program
does not attempt to determine whether the last argument ``is'' a directory.
@Index(cp)@index(Copy files)

cpdir@\Invoked as:@Index(cpdir)
@Begin(programexample)
@t(cpdir) @i(flags) @i(fromdir todir)
@End(programexample)
copies all files in the @i[fromdir] directory to @i[todir].  @i[todir] must
previously exist.
The @t[-r] flag specifies that the copy should be recursive: the
entire subtree rooted at @i[fromdir] is copied.
The @t[-y] flag suppresses copying files if a destination file of
the corresponding name already exists and is
@i[younger] than the source file, i.e., has a more recent modified date.
The @t[-v] flag causes a `verbose' message to be printed each time a file is
copied.

cx@\Changes your current @i[execution context]_see section
@ref[VRemoteExecution].@Index(cx)  This command is built into the exec.

dale@\Distributed version of YALE (Yet Another Layout Editor).
This is a
VLSI layout editor that provides
graphics editing of SILT chip descriptions.@Index(Yale)@Index(Dale)
YALE is documented in a Stanford CSL Technical Report.@comment{reference?}

date@\Prints the date as maintained by the local workstation
kernel, and as maintained by first responding network time server.@Index(date)
The kernel-maintained time on a workstation is set from a time server
when the workstation is booted.
The command @t[date -s] resets the kernel-maintained
time from a network time server.

debug@\The V debugger.  See Chapter @ref(VDebugger).@Index(debug)

debugvgts@\Allows the user to turn on/off debugging output from the VGTS.  
See section @ref[debugvgts] for further details.@Index[debugvgts]

define@\Defines a local name (alias) for a context.
The first argument is the new
name to be defined. The last argument is a context name, specifying
the value to be given to the new name.  Built in to the exec.
@Index[Define]@Index(Context)

delcorr@\Delete correspondences from your V user identity to 
UNIX user accounts.
Each V user can correspond to one account on
each local UNIX machine that is running a V/UNIX server.
The V superuser can delete correspondences for other users as well as itself.
See Chapter @ref(UnixServer) for more information about user
correspondences.

delexec@\Delete an executive, specified by its exec id.  The first exec
created when the workstation is booted will always have an id of
0.@index(delexec)

destroy@\Takes@Index(destroy)
the name of a team (or any suffix) as an argument,
and destroys the root process of that team.
If the argument begins with the characters @t[0x], it is taken
as a process id, and that process is destroyed.
This is useful for killing processes run in the background.
The @t[-i] flag causes the process to be interrupted (with @t[ForceException])
instead of destroyed.

diff@\This command has the same syntax and semantics as 
under Unix 4.2BSD,@Index[diff] with the addition
of the @t[-n] option of the Revision Control System's @t[rdiff] program.

do@\Create an exec with a named file as its input.  This file should
contain a list of V commands, exactly as you would type them, one to a
line.
If the @t[-v] option is given, then each command line is typed out at the
time that it is executed.@index(do)

domake@\A synonym for @t[doseq] (described below).

dopar@\A program similar to @t[doseq], except that it allows the
executions of@Index(dopar)
its command arguments
to take place in parallel on different hosts.  For each context, the program
prompts for the name of a host on which to execute the command, and pops up 
an AVT that acts as the command's standard input and output.
If ``@t[any]'' is entered as the host name, then an @i[arbitrary] remote host
will be selected.  The local host can be selected by entering ``@t[0]''.

doseq@\This program takes two string arguments: a@Index(doseq)@Index(domake)
list of context names, and
a command to execute.  The command is executed in each context in turn.
@t[doseq] is often useful in buildfiles.

draw@\An interactive drawing program that runs under the VGTS.
See Chapter @ref(Draw).@Index(draw)

echo@\Echos its arguments.  The @t[-n] flag suppresses
the newline at the end of the output.@Index(echo)

fexecute@\Force a command to be executed on the server@Index(fexecute)
providing the
current context, as described in section @ref(RemoteExecutionBySession).

freemem@\Displays a bar graph showing the current percentage of free memory,
and the percentage before the last change.@index(freemem)

fscheck@\File system checking program.  See chapter @ref(fscheck).

gftodvi@\For producing magnified proofs of fonts created 
by @t[mf] (@i[q.v.]).@Index(gftodvi)

gftype@\Produces terminal-readable output from a @t[gf] font file.
See @t[mf].@Index(gftype)

grep@\This command has the same syntax and semantics as 
under Unix 4.2BSD.@Index[grep]

hack@\A @t[rogue]-like game.  See chapter @ref(hack).

ident@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(ident)

instances@\A@Index(instances)
diagnostic program that prints
out information about any file instances (see chapter @ref[IOprotocol]) that 
are being maintained by the server that is providing your current 
context.  At present this will work only if your current context is being 
provided by a Unix server (see chapter @ref[UnixServer]).

internetserver@\A@Index(Internet Server)
version of the Internet Server.  See chapter @ref(internetserver).

iphost@\If given a single host name as an argument, @i(iphost)@Index(iphost)
lists all
IP addresses corresponding to that host.  If no argument is given,
the IP address of the local workstation is printed.

killprog@\Kill the program, if any, running in the specified
executive.@index(killprog)

listdir@\Lists the names defined in one or more context directories.
If the @b[-l] flag is given, @i[listdir] prints one line of information
about each object.
The output is sorted by default; the @b[-n] flag specifies ``no sorting.''
If no argument is given, the current context is assumed.
@Index(listdir)

listdesc@\Prints one line of information about each named object,
extracted from its object descriptor.
If no argument is given, the current context is assumed.
@Index(listdesc)

login@\Log in to the V system.  See section @ref(login).
@Index(login)

logout@\Log out of the V system.  See section @ref(logout).

mail@\The UC Berkeley Unix 4.2 @i[mail] program, ported to the V-system.  
Note that this program is merely a front end (for composing, reading and
editing mail).
In order to use this program, your current context must be on a Unix system.
The program's commands are the same as in the Unix version, with the 
following exceptions:
@begin[enumerate]
The ~e command invokes @t[ved] by default.

The new command ``Quit'' (or ``Q'' for short) behaves just like 
the ``quit'' (or ``q'') command, except that if new mail has arrived, you 
will be immediately put back in the ``mail'' program so that you can read it.

The new command ``Update'' (or ``U'') is like ``Quit'', except
that you will be put back in ``mail'' even if no new mail has arrived.
(This command is equivalent to exiting the program, and then re-running it.)

``@t[mail -c @i[n]]'' will cause the program to check your mail file, 
every ``@i[n]'' minutes, for the arrival of new mail.  If new mail is found, 
the ``Update'' command described above will be run automatically (unless 
another command is in progress at the time).
@end[enumerate]
@Index[mail]

memserver@\A server that allows unused main memory to be used for temporary 
file storage.  See section @ref[memserver] for more details.@Index[Mem server]

mf@\Metafont-84 is Donald Knuth's language for compiling algebraic shape
descriptions into bitmap images and fonts (m68k only).
See Knuth's book @i[The MetafontBook] (Addison-Wesley, 1986).
Also note the programs @t[gftodvi] and @t[gftype].@Index(mf)@Index(Metafont)

migrateprog@\@Multiple{Migrate a guest program from the local machine to 
another machine.@Index(migrateprog)@Index(migration).  Invoked as
@begin(programexample)
migrateprog [-p] [-h <host-name>] [<progs>]
@end(programexample)

The unit of migration is the logical 
host, @i(not) individual teams.  All remotely executed programs are created 
in their own logical host, whereas all locally executed programs are run in 
the system logical host, which never migrates.  Thus only remotely 
executed "guest" programs will ever migrate.  Currently there is no way to 
create a locally invoked program in a separate logical host other than to 
invoke it remotely from another machine.

If no arguments are specified then all guest programs on a machine are 
migrated to "lightly loaded" machines, where lightly loaded is defined in the 
same sense as @t(any) is defined when initially executing a program 
remotely.  The -p flag specifies that information about what programs are 
being migrated where should be printed out.  The -h flag allows specification 
of a particular machine to migrate to.  The machine to migrate to may be 
specified by either the hex pid of its team server (in the form 0x(pid)) or 
by giving its official string name (e.g. sun-mj416).
If specific programs are specified then only those programs are migrated.  
Programs may be specified by the hex pid of one of their processes or by 
their full invocation name, as stored by the team server.
}

mon@\This program monitors resource utilization of the
workstation and presents it graphically.  The -d flag specifies a vertical
display ("down") instead of horizontal.  The default display shows percentage
used of memory and processor, and the number of incoming Ethernet packets per
second.  The flags -m, -p, and -e limit the display to only those specified.
The -f flag violates the user interface standards by putting the display in
the upper right corner of the workstation instead of requiring the user to
position it with the mouse.
@Index[mon]

name@\Prints the login name of the user under whose account
the command is running.@index[name]@index[Who is logged in]

newterm@\Change terminal agents.  Takes one argument, the filename
of@Index(newterm)
a new terminal agent to take the place of the existing one.  All
executives running under the old terminal agent are destroyed; the new
one will presumably provide means of creating a new one.  For example,
@b[newterm sts] replaces the VGTS with the Simple Terminal Server,
which does no graphics but simply presents the workstation as an ascii
terminal.  If no argument is given, it defaults to "vgts".  
@begin(warning)If
the named program is not in fact a terminal agent, you will probably lose
control of your workstation.
@end(warning)

pagemode@\Enable or disable paged output mode in the current executive.
Takes one argument, which may have one of two values:  "on" or "off".
When paged output mode is on, the terminal agent stops writing to a AVT
when the AVT fills up with output. The terminal agent then displays the
message "Type <space> for next page" and  waits
for the user to issue a command which unblocks the AVT.  The user
interface for paged output mode is described in section
@ref(Paged Output Mode).@Index(pagemode)

password@\@begin(multiple)Use
this program to change your V password, home directory,
or personal name.  The V superuser can also use it to create new
accounts or modify other users' accounts.
Uses the @t[fields] package (section @ref(fields)).@index(password)
To modify the displayed @i[Name], @i[Fname], or @i[Home], click
on the old value with the mouse, use the normal line-editor
commands to change the value, then hit return.
To make the change take effect,
click on @i[Modify] and supply your old and new passwords.

Other functions: click on @i[find] to find another user's authentication
database entry.  Click @i[add] to add a new user account (a unique
user number is selected for you).  Click @i[delete] to delete the
displayed account.  Click @i[exit] to leave the 
program.@index(Personal name)@index(Home directory)
@end(multiple)

pc68@\Compiles@Index(pc68)
@t[Pascal]@Index[Pascal] source programs for running
on the m68000 processors. See the Unix @t[man] page.
The flags are similar to those of cc68.

pwd@\Prints@index(pwd)
the absolute name of the current working directory.  Built in to the exec.

pwx@\Prints the (absolute) name of your current @i[execution context]_see
section @ref[VRemoteExecution].@Index(pwx)  This command is built into the exec.

Q@\This is an experimental interactive functional@Index(Q)
programming language (m68k only). See Per Bothner (bothner@@su-pescadero)
for information and a user guide.

query@\Prints out the result of performing various `query'@Index(query)
operations.  In particular,
@t[query kernel] prints the result of the @t[QueryKernel()]
library routine (see page @pageref[QueryKernel]),
@t[query config] prints the contents of the workstation's configuration file
(see Chapter @ref[ConfigDatabase]),
and @t[query ethernet] prints the result of querying the
``ethernet'' device (see section @ref[Ethernet]).
@t[query ?] lists the possible options.

queryexec@\Find out the status of the specified executive.  Useful
mainly for system testing.@index(queryexec)

ranlib68@\Identical to the UNIX @t[ranlib] command, but handles
archives of either m68k or vax binaries.  This command is
installed on UNIX under the name @t[ranlib68], and on V under both the
names @t[ranlib] and @t[ranlib68].@index(ranlib)@index(ranlib68)

rcs@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(rcs)

rcsdiff@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(rcsdiff)

rcsmerge@\Part of the Revision Control System.
Described by a UNIX manual page.
@index(rcsmerge)
Currently, this program must remotely execute the @t[rdiff3] and
@t[merge] programs of RCS on a UNIX host, since the latter have not
been ported to V.

rename@\Renames the object specified by the first argument to
the name given as the second argument.
Will not move objects from one server to another; there are also
restrictions on moving objects within one server (for example, from
one file system to another under the Unix server).@index(rename)

rlog@\Part of the Revision Control System.  Described by a UNIX manual page.
@index(rlog)

rm@\@begin[multiple]
Takes one or more filenames as arguments, and removes each file.
The @Index(rm) @t[-f] flag suppresses error messages if some of the
files do not exist.

Note that in particular, @t[rm] may be used, as an alternative to 
the @t[destroy] command, to destroy one or more teams (by name).
For example, @ProgramExample{rm [team/toto/[bin]internetserver} will `remove'
(i.e. destroy) the program ``@i{[bin]internetserver}'' that was executing on 
host ``@i[toto]''.  Unlike the @t[destroy] command, the full 
program name must be given.
@end[multiple]

sed@\Stream editor.  Described by a UNIX manual page.

serial@\This program provides a full-duplex conversation between
its standard input and output, and a device
connected to one of the serial@Index(serial)
ports of the workstation.  The argument is a device name, specifying
the line to be opened.  It defaults to @i{[device]serial0} if omitted.
Names of the form @i{[device]serial}@p{n} (with
@p{n} a single digit) can be abbreviated by giving only the digit.
If the serial line is connected to
a modem or a terminal port on another computer,
this program allows the workstation to act as a terminal.
The flag @t[-b bitrate]
can be used to specify the bit rate (baud rate)
of the connection; it defaults to 9600 bps.

show@\Displays a @t[.dvi] file or a @t[.press] file.@Index(show)
It creates a menu in the invoking window; commands are normally
selected with the mouse. A new window is created for displaying
a page from the @t[.dvi] or @t[.press] file.
You can invoke the program with @w[@t(show) @i(filename)], or you can set the
filename in the menu.
More details are given by the "help" command
(type @t[h] or select @t{[Help]} with the mouse).
TeX generated @t[dvi] files are handled pretty well, except
for possibly missing fonts (and perhaps speed).
The @t[press] support is pretty minimal.

sleep@\Delays for a time, then exits.  The delay time (in seconds) must be
specified as an argument.@index(sleep)

sort@\This command has the same syntax and semantics as under 
Unix 4.2BSD.@Index[sort]

startexec@\Create an exec in a new AVT.@index(startexec)  The new exec will
have the same context as the exec from which @t[startexec] was invoked,
@i[not] the @t([home]) context.  For most purposes the view manager's  @b(Create
Executive) commands are to be preferred over this one, as the view manager
will not work on an executive created by @t[startexec].  @t[startexec]
prints out the exec id and process id of the new exec.

storagestats@\Obtains access statistics collected by the V storage server
and disk driver.
The @b[-c] flag causes the statistics to be cleared to zero.
@index(storagestats)

stuffboot@\A program that stuffs the file named in argument 2 into the boot
block of the disk named as argument 1.  The file to be stuffed normally will
be Vload and is needed during auto-boot when the boot program is read out of
the boot block on the root disk device.  If a third argument is present,
it is taken as the name of a file to copy into block #0 of the root device
(the disk label).
@index(stuffboot)

tail@\This command has the same syntax and semantics as under 
Unix 4.2BSD.@Index[tail]

talk@\Allows interworkstation communication among V hosts similar to
talk under Unix.@begin(multiple)@Index(talk)  Invoked as
@begin(ProgramExample)
@t[talk] [@i[person]]
@end(ProgramExample)
@i[Person] is optional.
If @i[person] is specified, it can either be in the form @t[userid]
to specify a user on the first host we find that user to be logged in,
@t[userid@@host] to specify a particular
user on a particular host, or @t[@@host] to get anyone on that host.

Once inside @t[talk], you can enter commands by first typing @c{[esc]},
and then another letter.  The available commands are:
@begin(Description, indent -12)
i@\invite a new user.  You are prompted for who you want to invite, and
you can respond in any of the ways mentioned for @i[person] above.

l@\log in AVT.  This allows you to see in a temporal fashion who says
what.  You are prompted for a new AVT to write the log in.  Giving 
this command again terminates logging.

q@\quit.  Only you quit; any other persons engaged in 
the conversation can continue to do
so, even if you were the one who initiated the conversation.

r@\read from file.  It reads the file into the conversation
such that it looks as though you typed it all.  However,
there is currently no pagenation.
If what was read is very long it will quickly get overwritten.

w@\write to file.  This is the same as ``log in AVT'' above, except logging
is done to a file you specify.  Giving this command again terminates
writing.
@end(description)
@begin(warning)
@t[talk] runs only under the VGTS.  There is currently
a compiled in maximum of six talkers in one conversation.  @t[talk]
AVTs are fixed at 24 by 80.

Due to current VGTS restrictions, @t[talk] is forced to initiate
a conversation by writing to the VGTS AVT (the small one 
originally in the lower right
hand corner) and then opening a new AVT, which gives the victim a @c[pad]
cursor.  To accept the invitation the AVT is placed normally; to reject
the invitation click all three mouse buttons.  This is bad if the VGTS
AVT is obscured_the victim will get a beep and a AVT prompt and not
know why.
@end(warning)
@end(multiple)

telnet@\@multiple{IP/TCP-based telnet implementation.  It can run under the
STS, or in a VGTS AVT.@Index(iptelnet)@Index(telnet)@index(IP/TCP)
A destination host name or address may be given as a command argument;
if none is given, @i(telnet) prompts for one.
A host name is a string of non-white-space characters starting with a
non-numeric character.  A host address is a string of the form a.b.c.d,
where a,b,c and d are decimal integers.  Both names and addresses may
be followed by a dot and a decimal port number (with no intervening
spaces).

If the @b[-e] flag is given when it is invoked, @i(telnet)  recognizes a set 
of commands prefixed by ctrl-^ while connected to a remote host.  
Ctrl-^ ? prints a list of all such commands. These functions are not
available by default because they sometimes interfere with higher level
protocols such as that used by the VGTS.

After disconnecting from a remote host, @i(telnet) prompts for another host.
To exit @i(telnet), enter ctrl-c or ctrl-z in response to the prompt.

If there is no internet server on your workstation when @i(telnet) is
loaded, it runs one in the background.  The @b[-l] flag inhibits
loading a local server, instead looking for a public internet
server running on another V host.

The @b[-d] flag enables debug mode.  In this mode, all transmitted
and received telnet protocol commands are printed, and all received
non-printable characters are printed in an escaped notation.
Debug mode can be toggled
on and off by typing ctrl-^ d while connected to a remote host if the -e 
option is specified on the command line.

The @b[-g] flag enables logging mode, which implies the @b[-d] debug mode
above. A file, "telnet.loigfile" will be
created in the current directory. This file will contain a complete
transcript of bothe sides of the @i(telnet) session. Lines preceded by "<"
originated from the host while those preceded by ">" originated from the
workstation. All non-printing characters are quoted and all telnet protcol
commands are printed. Password input is automatically deleted. This mode is
transparent to both sides of the connection.
Logging mode can be toggled
on and off by typing ctrl-^ g while connected to a remote host if the -e 
option is specified on the command line.
}

telnetserver@\IP/TCP telnet listener.  This program listens for incoming 
telnet connections on the local internetserver, spawning a remote terminal 
server (RTS) for each connection received.
@label(telnetserver)@index(telnet server)@index(telnet)


testexcept@\Simple interactive program for testing the exception server.
@Index(testexcept)

timeipc@\Performs timing tests of the V interprocess communication primitives.
See chapter @ref(timeipc).

timekernel@\Program to measure the time for Send/Receive/Reply 
kernel primitives.  @Index(timekernel)

tsort@\Topological sort.  Identical to the UNIX program of the same name.
@index(tsort)

type@\Type out one or more files on the terminal.@Index(type)
Types a page-full and then stops and waits for input.  Pressing @c{[space]}
brings up another page, while @c{[return]} brings up another line.
Hit @t[q] or @t[^C] to quit.

undefine@\Removes the definitions of one or more local context
names (aliases).@Index(undefine)  Built in to the exec.

ved@\A text editor, somewhat similar to Emacs, that runs under the VGTS.
Described in Chapter @ref(ved).@Index(ved)

vemacs@\A version of the Emacs text editor that can, among other things,
make use of the window features of the VGTS.  When vemacs is invoked without
any arguments, it will display a help file describing how vemacs differs
from standard Emacs.@Index(vemacs)@Index(emacs)@Index(editor)

w@\Lists logged-in V users throughout the
network.@Index[w]@index[Who is logged in]

wc@\Counts characters, words, and lines in a text file.@index(wc)
See the UNIX manual for full documentation.

wh@\Lists hosts on the network together with information such as logical
host name, free memory, average processor usage, number of free process
descriptors, host type, etc., sorted by host name.@Index[wh]

whi@\Lists currently executing teams for each host.
If one or more `host' arguments are given, then only the teams on the 
specified host(s) are listed.  Such arguments can take the following form: a 
hostname, a pid (@t[0x...]), or ``@t[0]'' (indicating the local
host).@Index[whi]
@end(Description)

@Section(Commands on Non-V Hosts)

There are also several useful commands that can be invoked
on non-V hosts (usually a Vax/Unix@Index(Vax)@Index(Unix) system).
Use these commands once you have logged into a machine through a
telnet connection.
Most of these commands also have versions that run locally on the
workstation under the VGTS, and the Unix versions can also be run 
remotely under the VGTS, using the exec's remote execution feature
(section @ref(RemoteExecutionBySession)).

@begin(description)
dale@\@Index(dale)A version of the Yale layout editor that runs under the VGTS.

draw@\An interactive drawing program that runs under the VGTS.
See Chapter @ref(Draw).@Index(draw)

photo@\@Index(photo)Reads and displays a ``.sun'' format raster file.

siledit@\@Index(siledit)A program which edits .SIL format files.
SIL, a Simple Interactive Layout program, is a graphics editor
for logic designs and illustrations.

silpress@\@Index(silpress)A program which takes a .sil format file and
produces a .press format file that can be printed on the Dover.
@end(description)

