@part(Checkers, root "manual")
@chapter(checkers)
@label[checkers]
@i[checkers] allows you to play a game of checkers against
the computer.
The default version of the program executes entirely on the players 
workstation.

On starting the program, the view manager will prompt you for the
position of the SGVT representing the checkerboard.

The player moves the 'red' (white) pieces; the program's pieces are black.
You are expected to make the first move. You can, however, force the program
to move first by "passing". (See the paragraph describing the menu, to follow.)
To make a move, move the mouse to the square containing the piece that
you wish to move, and click either the left or the middle mouse button.
If this piece can be legally moved, it will then be highlighted. Complete
the move by moving the mouse to the destination square and once
again clicking the left or the middle button.

If the move that you have selected is legal, your piece will be moved, and the
program will then make its move. Note that having selected a piece to move,
you can abort this selection by clicking an illegal destination square
(the source square itself, for example). If a capture of an
opposing (ie. black) piece is possible, your next move must be a capture.
A message indicating such "forced captures" will be displayed just below the
board. In such a case, the program will not allow you to make a move that is
not a capture. Multiple captures are handled correctly - if you move a piece
by making a capture, your move will not be completed until all possible
captures with this piece have been made.

The standard rules of checkers apply. If a piece reaches the
eighth rank of the board, it is promoted to a king; kings may move in any
direction. A side wins either by capturing all of the opposing pieces, or
if the opposing side can make no legal move.

When it is your turn to move, you may also use the right mouse button to
select from a menu of options, which are described below:
@begin[description]
Redraw@\This causes the VGTS to redraw the entire board. This command should
	rarely be necessary.

Pass (skip turn)@\This command can be used if you want the program to make
	the first move. You can also use this to avoid any capturing
	obligations.

Change search depth@\By default, the program searches 4 half-moves ahead when
	choosing its next move. That is, it considers its own move, your
	response to this move, its next move, and your response to that.
	The "Change search depth" command allows you to change the depth of
	lookahead to any value from 1 to 8. Don't select any of the higher
	depths unless you have a lot of patience, however. The program takes
	about 20s to respond to a typical opening move when the depth is 6,
	about 50s when the depth is 7, and about 3 minutes when the depth is 8.
	(These times were taken on a 10 MHz SMI workstation - Cadlincs will be
	slightly slower.) Note that you may find out the current search depth
	by selecting "Change search depth", and then clicking outside the
	'depth' menu.

Edit board@\This command puts you into @i[Edit mode], which allows you to cheat
by adding pieces
	to, or removing pieces from, the board. Edit mode is described below.

Back up one move@\This allows you to retract (eg. to correct) your last move.

Resign@\The quick and cowardly way to end the game.
@end[description]

The program chooses it's move by performing a 'brute-force' search, using
alpha-beta pruning. It evaluates the board positions at the 'leaves' of the
search tree using a simple heuristic based on the number and position of pieces
on each side. A 'value indicator' to the right
of the board indicates the value of the current position, as seen by the
program. (If the indicator is above the halfway mark, for example, then
the program 'believes' that you are winning.) There are also counters
immediately above and below the value indicator, giving the number of pieces
on each side. The value indicator and the piece counters are updated whenever
the program completes its move.

You can make changes to the board (between moves) in @i[Edit mode].
In this mode, a special menu is displayed
to the right of the board.
To add a piece to the board (or change an existing piece), click the square
in the menu that contains that piece. You may place a copy of this piece on
any (shaded) square of the board, by clicking that square. You may do this
repeatedly; it is not necessary to select from the menu each time.
Note that you use the 'empty square' to delete one or more pieces from the
board. You may remove all pieces from the board by clicking "Clear". When you
have finished making changes to the board,
click "Done" to leave Edit mode. It will still be your turn to move next.

A distributed version of the game may be started by specifying the r flag:
@i(checkers -r <NoOfSlaves>). The program will then try to create up to
@i(NoOfSlaves) slave processes on lightly loaded remote workstations, that
help in the search of the alpha-beta search tree. 
As far as the player in concerned, the only two noticeable differences to the
default sequential version of  the game, are the possible improved response
times and that the computers moves may be nondeterministic.
(Note: it is only worthwhile to play the distributed version of the game
if the search depth is chosen greater than four.)

Mail comments and/or gripes to stumm@@pescadero.
