@comment[garbage to include for generating bits.help
@device(file)
@Equate(Chapter=MajorHeading)
@Equate(Section=Heading)
@Equate(SubSection=SubHeading)
]
@part(bits, root "manual")
@Chapter(bits: a bitmap and font editor)
@label(bits)
@index(bits)

@t(bits) is a special-purpose editor for working with bitmaps and fonts.
It makes intensive use of the VGTS.  The virtual terminal of the executive
under which @t[bits] is started up, is used to display various status
information, as well as being the menu of commands to execute.  When
started, @t(bits) will ask for you to create a new view (of a new virtual
terminal) in which the actual editing is performed.  If you request to view
sample text, you will be asked to create a third virtual terminal (see
below).  These last two virtual terminals are SGVT's and can be zoomed.

(@b[Note:] If you are using a Sun-120 framebuffer (including a model 50),
you should read the @t[Bugs] section!)

@section(Command Input)

In this chapter, when you are asked to do the command @t{[xxx]}, it means
that you should select and click the mouse at the field @t{[xxx]} of the
status/command virtual terminal.
You get the same feedback as with pop-up menus, with the field in inverse
video. Some of these fields, when activated, expect you to type in some
number or string. In those cases, you have the full power of the line editor,
until you type a <return>. (To abort input, type CTRL-g.)

@section(Rasters)

The important thing to remember is that @t[bits] handles @i[pointers]
to bitmaps. These we call @i[rasters].
A raster also contains size and offset data, so it can point to @i(part)
of a bitmap.
You can name a raster using the @t{[Store with new name]}
command, and later retrieve it from the @t{Table of saved rasters}.
You can thus save multiple pointers to the same bitmaps under different names.
If you change bits in one of the bitmaps, the bits will also change in the
other rasters, since they refer to the same bitmaps.
Use the @t{[Save a fresh copy]} command to make a virgin copy of a bitmap,
which is guaranteed to have no other rasters pointing at it.

@Section(Changing Raster Size)

To change the @i[size] of a raster, point at the boundary,
hold down the @i[middle] button and ``drag'' the boundary to where you want it.
You can also change the size of a raster with the @t{[Width]} and @t{[Height]}
commands. To do this, select one of these fields, and type in a number.
The absolute value typed in becomes the new size. If the value is positive,
the old and new rasters coincide at the top left corner; if the value is
negative, they coincide at the bottom right corner.

Note that when you change a raster's size, all other rasters pointing at
the same bitmap will be adjusted to point at whatever bits they used to
point at. This is true even when you @i(increase) the size. (When the size is
increased, and the underlying bitmap is larger than the part pointed to
by the current raster, the hidden part of the bitmap will appear. If this
isn't enough, a new bitmap will be allocated, and all the pointers
adjusted.)

@Section(Bitmap I/O)
You can read and write bitmaps in @t(.sun) format (as used by the photo
program), using the @t([Read raster]) and @t([Write raster]) commands.  To
write a raw raster in hex suitable for putting in a C program, use the
@t([Write hex]) command.

@section(Painting)

To @i[set] (blacken) a pixel, point at it with the mouse,
and click the @i[left] button.
To @i[clear] (whiten) a pixel in a bitmap, use the @i[middle] button.

@Section{Inverting a Raster}
Selecting @t{[Invert black and white]} inverts the interpretation of black
and white pixels. This interpretation is actually stored as part of the raster
object, so no pixels are actually changed (except on the display).

@Section{Raster Operations (BitBlt)}

You can do a general 2-operand BitBlt with the @t([Raster operation]) command.
The current (displayed) raster is used as one of the operands
(the ``destination''), so this should be selected first.
Then give the @t{[Raster operation]} command, after which you will be asked to
select an operation. Available are plain copy, 'and', 'or' (paint) and 'xor'.
In addition, the @t{[Invert Source]} modifier first inverts the source.
@t{[Invert Destination]} does the same for the destination, which means
inverting the destination operand @i[and] the output result.
Finally, you must select the other operand (the ``source'') from the name table.

You can also select @t{[Get the empty raster]} as a source. This gives you
an infinite plane of white pixels. This, together with the @t{[Invert Source]}
option, allows you to conveniently clear or set any rectangle.

@Section{Reflection and Rotation}
Selecting @t{[Reflect/Rotate]} will do one of these transformations.
(A popup menu asks for the particular transformation.)
Note that the result is a ``fresh'' raster: There are no other rasters @i[or]
tables pointing at its bitmap.

@Section{[Replace in table]}
This command asks you to select an element in the raster table or the
current font. The element is replaced by the current raster.
If a @t{[Table of saved raster]} element is replaced by the Empty Raster,
its space is freed.

@Section{Making a Copy of the Screen - CURRENTLY NON-WORKING}
You can make copy of the frame buffer, with a little bother.
Select @t{[Get framebuffer]}, which gets a pointer to the frame-buffer.
You should now use @t{[Height]} and @t{[Width]} to reduce the time and
space required to deal with it. (The framebuffer is @i{big}.)
You should @t{[Save a fresh copy]} to see what's going on, and
then use the middle button to select the part that interests you. This will be
slow, since such a big raster is involved, and you will also have to use the
VGTS workstation manager commands.

@Section(Fonts)
A @i[font] is a collection of @i[characters].
From @t[bits]' perspective, a character is a bitmap with some extra
information.
@t[bits] currently knows about fonts in the following formats:
@begin(itemize)
@b[sf] format (``Sun format''), which is specially optimized for the Sun-1
graphics hardware. (Will soon be obsolete.)

The same format, but the font is stored in an archive (library) of
relocatable binary files.
Thus fonts can be linked in with programs, @i[or] read in at run time.
The standard fonts are stored in @t[/usr/sun/lib/libsfonts.a].

@b[Pxl] format, which can be generated by MetaFont78, and is used
by a lot of the TeX people.

@b[Gf] (``generic font'') format, a compact format generated by MetaFont84.
@end(Itemize)

To read / write a font, select the desired field in the
@t[Read font | Write font] table.
Note that you cannot write a font to an archive.

@subsection(Displaying Fonts)

When a character in a font is displayed, there are funny lines sticking out
of the bitmap picture. The intersection of the left and top segments
indicates the @i[origin] of the character: The left segment indicates
the baseline, and the top segment the starting position.
The intersection of the right and bottom segments show the ``ending
position'': the vector from the origin to the ending position is the
@i[width] of the character. The width vector is almost always horizontal,
and indicates the spacing between adjacent characters: The ``next''
character in a string should be positioned so that its origin
coincides with the ending position of the current character.

You can select any of these lines (with the middle button),
and adjust them with the mouse.

@subSection(Font parameters)
This is a section of the AVT with magic numbers about the current font.
They can all be changed, but you should know what you are doing.

@t[Design size] is the size in points at which the font is designed for.
@t[Resolution] is ratio of pixels per point (vertically and horizontally)
at which the font is designed for.
(To be compatible with the Altos, we have decided that the resolution of
the Sun display should be defined to be 80 pixels/inch.
Older Pxl fonts use a @i[magnification] relative to a 
default Pxl resolution of 200 pixels/inch.)
Both these are TeX/Pxl parameters.

@t{[Raster alignment]} is the bit boundary character bitmaps should
be aligned on in @t[sf] font files. It must be 1, 8, or 16.

@t{[Max. height]} and @t{[descent]} give the maximum total height,
and descent below the baseline, of all the characters in the current font.
If you change @t{[descent]}, the baseline of all the characters will be
adjusted accordingly.

@Section(Sample Texts)
To study how a text string would look at no magnification, select
@t{[Sample text]}. You should then type in the text you want displayed.
This text will be placed in a new virtual terminal.
To change the text, just reselect @t{[Sample text]}; the old text will
be placed in the line editor buffer, to simplify small changes.
If you edit the font, select @t{[Redraw]} to update the sample.

Note that in the sample, the character @t['\'] is special.
It is used to indicate special non-ascii characters, as in C.
Specifically, @t{'\'} followed by a 3-digit octal number is the character
with that ordinal value.
@t{\\} displays @t{\}, and @t{\b}, @t{\t}, @t{\e}, @t{\r} and @t{\n}
are Backspace, Horizontal Tab, Escape, Carriage Return and Line Feed,
respectively.
@t{\@@}, @t{\A}, ... @t{\@ux[ ]} are
control characters: @t{^@@}, @t{^A}, ... @t{^@ux[ ]}.

@Section(Printing a Raster)
There is a Unix program to convert a @t[.sun] file to a @t[.press] file.
To run it (on some Stanford VAXen), do:
@begin(programexample)
/usr/sun/src/graphics/pix/sunpress -p X.press X.sun
@end(programexample)
This, together with the (@i{non-working}) @t{[Get framebuffer]} command,
allows you to print a hardcopy of the screen on a Dover printer.


@Section(Bugs and Problems)
@t[.sun] files use 1 to mean `white' while @t[bits] uses 0.
This means that you should @t{[Invert black and white]}
after reading and before writing, if you want to use the bitmaps for
programs like @t{sunpress} and @t{photo}.

The are some limitations on how bitmaps are displayed by the VGTS.
A bitmap can only be magnified 1, 2, 4, 8, or 16 times, so other
zoom factors will be wrong. Also, it is over-conservative when clipping
rasters, which means that a whole row of bits could be missing.
On Suns with the 120 frame-buffer, bitmaps cannot yet be magnified at all.
@b[BUT] @t[bits] still starts up with the working window magnified 8 times!

Raster operations do not take into account that rasters may be overlapping.

@t[bits] is not very robust against things like running out of memory.
Caution would imply that you save your work often.

The whole mechanism for grabbing a copy of (part of) the frame-buffer
is very unclean (and currently doesn't work). It should be done by
the VGTS, not application programs.
