/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleshowsel.c */

#include "aledefs.h"

/* yaleSelectDependentItems: selects all parts of rectangles dependent upon
 * the moused reference point.  x and y are the mouse coordinates.
 */

yaleSelectDependentItems(x, y)
short x, y;
{
    LISTTYPE list, FindSelectedObject ();
    short refNum;

    list = FindSelectedObject(YaleSDF, x, y, GlobalVGT, JustRefPt);
    if (list.NumOfElements == 0)
        return;
    if (list.NumOfElements > 1)
        TtyBlinkError("Ambiguous");
    refNum = list.Header -> item;
    UnSelectAll(OpenCellDefinition);
    yaleSelectRefPoint(refNum);
    SelectRefRelatives(SunInstanceArray[refNum].ptr.refPtr);
}

/* SelectRefRelatives: takes a reference pointer, and builds a display
 * symbol which includes outlines for all selected rectangles and subcells
 * which are dependent upon the selected reference point.  Nothing is done
 * about displaying it on the screen.
 */

SelectRefRelatives(refPtr)
REFERENCE_POINT_ER refPtr;
{
    RECTANGLE_CONS_PTR rectConsPtr;
    REFERENCE_POINT_ER FindInvolvedRefPt ();
    RECTANGLE_PTR rectPtr;
    short symNumber, edgeSet, sin, openCellSin, calledSin;
    short xmin, xmax, ymin, ymax;
    INSTANCE_CONS_PTR instConsPtr;
    CELL_INSTANCE_PTR cellInstPtr;

    openCellSin = OpenCellDefinition -> expandedSunIds[2];

    instConsPtr = refPtr->dependentInstances;
    while (instConsPtr != NIL)
      {
        cellInstPtr = instConsPtr->value;
        instConsPtr = instConsPtr->next;
	if (cellInstPtr==NIL) continue;    
        sin = cellInstPtr->sunInstanceNumber;
	yaleSelectCellInstance( sin, FALSE );
      }

    rectConsPtr = refPtr->dependentRectangles;

    while (rectConsPtr != NIL)
      {
        rectPtr = rectConsPtr->value;
        rectConsPtr = rectConsPtr->next;
	if (rectPtr==NIL) continue;    
        edgeSet = 0;
        if (refPtr == FindInvolvedRefPt(rectPtr->t, Horizontal))
    	    edgeSet += TopEdge;
        if (refPtr == FindInvolvedRefPt(rectPtr->b, Horizontal))
    	    edgeSet += BottomEdge;
        if (refPtr == FindInvolvedRefPt(rectPtr->l, Vertical))
    	    edgeSet += LeftEdge;
        if (refPtr == FindInvolvedRefPt(rectPtr->r, Vertical))
    	    edgeSet += RightEdge;
    
        if (edgeSet)
	  {
            sin = rectPtr->sunInstanceNumber;
            SelectRectangle(rectPtr);
            rectPtr->selectedEdgeset = edgeSet;
            EditSymbol(YaleSDF, openCellSin);
	    InquireItem(YaleSDF, sin, &xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL );
            AddItem(YaleSDF, sin+EDGECODE, xmin, xmax, ymin, ymax, edgeSet, SDF_OUTLINE, NULL);
            EndSymbol(YaleSDF, openCellSin, GlobalVGT);
	  }
      }
    
}
