/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleshow.c */

#include "aledefs.h"

/* yaleShowCellNames:  prints a list of all cell definition names on
 * the tty viewport.
 */

yaleShowCellNames()
{
  CELL_DEFINITION_PTR cellDef;
  S_ENTRY_PTR sPtr;
  short lineCount;	/* number printed so far on one line */

  lineCount = 0;
  cellDef = MasterCellList;
  while (cellDef != NIL)
      {
      TtyPutString(cellDef->symTblPtr->stringPtr);
      TtyPutString(" ");
      if (lineCount++ == 5)
	  {
	  lineCount = 0;
	  TtyCRLF();
	  }
      cellDef = cellDef->next;
      }
  TtyCRLF();
}


