/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleinssym.c */

#include "aledefs.h"

typedef struct minmaxvector
  {
    short xmin, xmax, ymin, ymax;
  } MIN_MAX, *MIN_MAX_PTR;

extern short CurrentFB;

extern short defStack[];
extern short defStackPtr;

#define POP defStack[defStackPtr--]

#define C_FLIPPED_LR 1
#define C_FLIPPED_UD 2
#define C_ROTATED_3 3
#define C_ROTATED_6 4
#define C_ROTATED_9 5
#define C_EOT 6

static PopUpEntry TransPopUp[] =
  {
    "Flipped Left-Right", C_FLIPPED_LR,
    "Flipped Up-Down", C_FLIPPED_UD,
    "Rotated 3", C_ROTATED_3,
    "Rotated 6", C_ROTATED_6,
    "Rotated 9", C_ROTATED_9,
    "End of transform", C_EOT,
    0, 0
  };

/* yaleInsertSymbol: inserts a cell instance. */

yaleInsertSymbol()
{
    TRANS_MATRIX *tmPtr, tm;
    char *cellName,
	*instanceName, *PutUpRecentMenu();
    EXPRESSION MakeConst(), MakeRelativeExpression();
    EXPRESSION_CONS_PTR MakeParamList(), paramList;
    MIN_MAX minMax;
    CELL_INSTANCE_PTR inst, XInsCellInstance();
    short instNumber, sin, fb;
    MATRIX mat;
    short xTrans, yTrans, button;
    short xmin, xmax, ymin, ymax;

    if (OpenCellDefinition == NIL)
      {
        TtyBlinkError("No cell open");
        return;
      }
    
    minMax.xmin = minMax.ymin = 32767;
    minMax.xmax = minMax.ymax = -32767;
    
    tm.x11 = tm.x22 = 1;
    tm.x12 = tm.x21 = 0;
    tm.x31 = tm.x32 = MakeConst(0);
    tmPtr = &tm;

    TtyPutString("instance of M: ");
    cellName = PutUpRecentMenu();
    lowercasestring(cellName);
    if ((cellName == NIL) || (*cellName == '\0'))
        return;
    instanceName = "\0";
    
    TtyCRLF();
    TtyPutString(" (use MB1 for transform, MB3 otherwise) at B:");
    
    GetMouseClick( &xTrans, &yTrans, &button);

    if (button == 1)
      {
	TtyCRLF();
        getTrans(tmPtr);
	GetMouseClick( &xTrans, &yTrans, &button);
      }

    TtyCRLF();

    if (button == 7)
	return;
    
    mat.x11 = tm.x11;
    mat.x12 = tm.x12;
    mat.x21 = tm.x21;
    mat.x22 = tm.x22;
    mat.x31 = 0;
    mat.x32 = 0;
    
    ResetXYStatus(xTrans, yTrans);
    
    paramList = MakeParamList(cellName);
    tmPtr->x31 = MakeRelativeExpression
    	(OpenCellDefinition->xSelectedRef,
    	 xTrans);
    tmPtr->x32 = MakeRelativeExpression
	(OpenCellDefinition->ySelectedRef,
	 yTrans);
    inst = XInsCellInstance(cellName, instanceName, paramList, tmPtr);
    if (inst == NIL)
        return;
    fb = EvalParameterList(OpenCellDefinition -> masterInstance, inst, CurrentFB);
    instNumber = CellInstExpand(inst, fb, &mat, 1);
    InquireItem(YaleSDF, instNumber, &xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL );
    sin = OpenCellDefinition->expandedSunIds[2];
    
    EditSymbol(YaleSDF, sin);
    AddCall(YaleSDF, inst->sunInstanceNumber, xTrans,
    			 yTrans, instNumber);	/* +++ fix */
    EndSymbol(YaleSDF, sin, GlobalVGT);

    yaleSelectCellInstance(inst->sunInstanceNumber, TRUE);
    TouchString(cellName);
    return;
}

getTrans(tmPtr)
TRANS_MATRIX *tmPtr;
{
  short popup(), temp;

  TtyPutString("Transformation M:");
  while (TRUE)
   {
    switch(popup(TransPopUp))
	{
	case C_ROTATED_3:
	    temp = tmPtr->x11;
	    tmPtr->x11 = tmPtr->x12;
	    tmPtr->x12 = -temp;
	    temp = tmPtr->x22;
	    tmPtr->x22 = -tmPtr->x21;
	    tmPtr->x21 = temp;
	    break;
	case C_ROTATED_6:
	    tmPtr->x11 *= -1;
	    tmPtr->x22 *= -1;
	    tmPtr->x12 *= -1;
	    tmPtr->x21 *= -1;
	    break;
	case C_ROTATED_9:
	    temp = tmPtr->x11;
	    tmPtr->x11 = -tmPtr->x12;
	    tmPtr->x12 = temp;
	    temp = tmPtr->x22;
	    tmPtr->x22 = tmPtr->x21;
	    tmPtr->x21 = - temp;
	    break;
	case C_FLIPPED_LR:
	    tmPtr->x11 *= -1;
	    tmPtr->x21 *= -1;
	    break;
	case C_FLIPPED_UD:
	    tmPtr->x22 *= -1;
	    tmPtr->x12 *= -1;
	    break;
	case C_EOT:
	    TtyCRLF();
	    return;
	}
    }
}

/* MakeParamList: makes an empty parameter list */

EXPRESSION_CONS_PTR MakeParamList(instName)
char *instName;
{
S_ENTRY_PTR sEntry, LookupSTableEntry();
EXPRESSION_CONS_PTR eConsHead, eConsTail, newCons;
EXPRESSION parseexp();
VARIABLE_CONS_PTR pListPtr;

eConsTail = eConsHead = NIL;
sEntry = LookupSTableEntry(instName, 0);
if (sEntry == NIL)
    return(NIL);
pListPtr = sEntry->data.symbol.cellPtr->parameterList;
while (pListPtr != NIL)
    {
    newCons = (EXPRESSION_CONS_PTR) GetCons();
    if (newCons == NIL)
	return(NIL);	/* out of free storage */
    newCons->value/*.postfix*/ = NIL_EXPRESSION;	/* undefined */
    newCons->next = NIL;
    if (eConsTail)
	eConsTail->next = newCons;
    eConsTail = newCons;
    if (eConsHead == NIL)
	eConsHead = eConsTail;
    pListPtr = pListPtr->next;
    }
    
return(eConsHead);
}
