/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

#include "aledefs.h"

/* yaleInsertArray: inserts an array of symbols with some number in the
 * x- and y- direction, and with a given displacement.  Any rotation of
 * the original symbol is allowed.  As it is now written, it is
 * somewhat of a hack.  It is equivalent to the entry of as many
 * individual symbol calls -- not as a SILT array command.
 */

extern short CurrentFB;
/*extern BOOLEAN LowOnSpace();*/

yaleInsertArray()
{
    char *cellName, *instanceName, *PutUpRecentMenu ();
    short xNumber, yNumber, dx, dy;
    TRANS_MATRIX *tmPtr, tm;
    EXPRESSION MakeConst (), MakeRelativeExpression ();
    MATRIX mat;
    short xTrans, yTrans, button, i, j, sin, fb, instNumber;
    EXPRESSION_CONS_PTR paramList, MakeParamList ();
    CELL_INSTANCE_PTR inst, XInsCellInstance();

    if (OpenCellDefinition == NIL)
      {
        TtyBlinkError("No cell Open");
        return;
      }

    TtyPutString("array of instances of M:");
    cellName = PutUpRecentMenu();
    TtyCRLF();
    if ((cellName == NIL) || (*cellName == '\0'))
        return;
    
    instanceName = "\0";
    
    tm.x11 = tm.x22 = 1;
    tm.x12 = tm.x21 = 0;
    tm.x31 = tm.x32 = MakeConst(0);
    tmPtr = &tm;

    xNumber = TtyGetNumber("Number in x-direction:");
    yNumber = TtyGetNumber("Number in y-direction:");
    dx = TtyGetNumber("x-displacement:");
    dy = TtyGetNumber("y-displacement:");

    TtyPutString(" (use MB1 for transform, MB3 otherwise) at B:");

    GetMouseClick( &xTrans, &yTrans, &button);
    TtyCRLF();
    if (button == 1)
      {
	TtyCRLF();
        getTrans(tmPtr);
	GetMouseClick(&xTrans, &yTrans, &button);
      }

    TtyCRLF();

    if (button == 7)
	return;

    ResetXYStatus(xTrans, yTrans);

    mat.x11 = tm.x11;
    mat.x12 = tm.x12;
    mat.x21 = tm.x21;
    mat.x22 = tm.x22;
    mat.x31 = mat.x32 = 0;

    sin = OpenCellDefinition->expandedSunIds[2];
    for (i = 0; i< xNumber; i++)
      for (j = 0; j < yNumber; j++)
    	{
/*	  if (LowOnSpace())
	      i = xNumber;
 */
    	  paramList = MakeParamList(cellName);
    	  tmPtr->x31 = MakeRelativeExpression
    		(OpenCellDefinition->xSelectedRef,
    		 xTrans+i*dx*2);
	  tmPtr->x32 = MakeRelativeExpression
		(OpenCellDefinition->ySelectedRef,
		 yTrans+j*dy*2);
	  inst = XInsCellInstance(cellName, instanceName, paramList, tmPtr);
	  if (inst == NIL)
	      return;
	  fb = EvalParameterList(OpenCellDefinition -> masterInstance,
						inst, CurrentFB);
	  instNumber = CellInstExpand(inst, fb, &mat, 1);

	  EditSymbol(YaleSDF, sin);
	  AddCall(YaleSDF, inst->sunInstanceNumber, 
	  	xTrans + i*dx*2, yTrans + j*dy*2, instNumber);

	  EndSymbol(YaleSDF, sin, GlobalVGT);
	  yaleSelectCellInstance(inst->sunInstanceNumber, ((i==0)&(j==0)));
    	}
    
    TouchString(cellName);
}
