/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: reparse.c */

#include "aledefs.h"

/* The routine reparse is called when the length of an export or parameter
 * list changes.  It assumes that all of the symbol table entries have had
 * their frame-displacements appropriately updated, and it simply runs
 * through a cell definition and re-parses all expressions.  If locFlag is
 * TRUE, then only the cell pointed to is reparsed (this will happen if only
 * the parameter list is changed -- dependent cells must be reparsed only if
 * the export list is changed).  locFlag is similarly set to false if the
 * cell being recompiled is one of the dependent ones -- because of the
 * nature of the export mechanism, the recompilation can only affect directly
 * calling cells -- changes do not propagate recursively.
 */

	/************************************************/
	/*		reparse:			*/
	/************************************************/

reparse(cellDef, locFlag)
CELL_DEFINITION_PTR cellDef;
BOOLEAN locFlag;
{
CELL_DEFINITION_CONS_PTR cCons;
int sin;

/* +++ debug */ printf("\nEntering reparse");
/* +++ debug */ if (locFlag) printf(" -- local");

if (!locFlag)
    {
    cCons = cellDef->dependentCells;
    while (cCons != NIL)
	{
	reparse(cCons->value, TRUE);
	cCons = cCons->next;
	}
    }

sin = cellDef->sunInstanceNumber;

ReparseExpressionList(sin, cellDef->constraint_list);
ReparseExpressionList(sin, cellDef->defaultList);
ReparseExpressionList(sin, cellDef->assignment_list);

ReparseRectangleList(sin, cellDef->rectangles);
ReparseInstanceList(sin, cellDef->cells);
}

	/************************************************/
	/*		ReparseExpressionList:		*/
	/************************************************/

ReparseExpressionList(sin, eCons)
int sin;
EXPRESSION_CONS_PTR eCons;
{
EXPRESSION ReparseExp();

while (eCons != NIL)
    {
    eCons->value = ReparseExp(eCons->value, sin);
    eCons = eCons->next;
    }
}

	/************************************************/
	/*		ReparseRectangleList:		*/
	/************************************************/

ReparseRectangleList(sin, rPtr)
int sin;
RECTANGLE_PTR rPtr;
{
EXPRESSION ReparseExp();

while (rPtr != NIL)
    {
    rPtr->l = ReparseExp(rPtr->l, sin);
    rPtr->t = ReparseExp(rPtr->t, sin);
    rPtr->b = ReparseExp(rPtr->b, sin);
    rPtr->r = ReparseExp(rPtr->r, sin);
    rPtr = rPtr->next;
    }
}

	/************************************************/
	/*		ReparseInstanceList:		*/
	/************************************************/

ReparseInstanceList(sin, iPtr)
int sin;
CELL_INSTANCE_PTR iPtr;
{
EXPRESSION ReparseExp();

while (iPtr != NIL)
    {
    iPtr->trans.x31 = ReparseExp(iPtr->trans.x31, sin);
    iPtr->trans.x32 = ReparseExp(iPtr->trans.x32, sin);
    ReparseExpressionList(sin, iPtr->parameterList);
    iPtr = iPtr->next;
    }
}

	/************************************************/
	/*		ReparseExp:			*/
	/************************************************/

EXPRESSION ReparseExp(exp, sin)
EXPRESSION exp;
int sin;
{
EXPRESSION AddExpression();
char *savePtr, *semiPtr, *MarkEndOfExp(), *FindExpString();
int expChar;

if (/*expChar =*/ exp/*.postfix*/)
    {
    savePtr = LexSource;
/*    LexSource = &string[exp.string];*/
    LexSource = FindExpString(exp);
    semiPtr = MarkEndOfExp(LexSource);
/*    while (expArray[expChar] != Eend)
	expArray[expChar++] = Eunused;
    expArray[expChar] = Eunused;
 */
    FreeExp = 1;
    exp = AddExpression(&expArray[parseexppost(sin)]);
    lex();				/* read the semicolon */
    *semiPtr = 0;
    LexSource = savePtr;
    }
return(exp);
}

/* MarkEndOfExp puts an illegal expression character at the end
 * of the input so that parseexp will know when to stop.
 */

	/************************************************/
	/*		MarkEndOfExp:			*/
	/************************************************/

char *MarkEndOfExp(sPtr)
char *sPtr;
{
while (*(sPtr++))
	;
*(--sPtr) = ';';

ErrorCount = 0;
return(sPtr);
}
