/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: leaf.c 
 * This file will eventaully replace the old file leaf.c, and will provide
 * multiple output files.  An attempt will be made to make it parallel the
 * old routines in leaf.c as much as possible.
 */

#include "aledefs.h"
#include <leaf.h>

#define TRUE 1
#define FALSE 0
#define NIL 0
#define BUF 2
#define OutBufLength 400

static char instr[OutBufLength];
static short instrpos = OutBufLength;
short OpenInputFile = MAINFILE;
extern BOOLEAN BackupOpen;

  /* set up data structures necessary; allow BUF packets buffering */

static struct SequinConnection conn; /* the single open connection */

union SequinData buf[BUF];

/* File Handles: */

static ushort mainHandle,	/* main silt i/o file */
	      libHandle,	/* handle for library input */
	      backupHandle,	/* file for backups */
	      scratchHandle;	/* YALE scratch file */

static ushort err;		/* in which leaf returns error #s */

static ulong mainLength,	/* length of main input file */
	     libLength,		/* length of library file */
	     backupLength,	/* length of backup file */
	     scratchLength,	/* length of scratch file */
	     outaddr,		/* output character position */
	     inaddr;		/* input character position */

XOpenConnection(host)
char *host;
{
/*  enopen(); */
  if (SequinOpen(&conn, buf, BUF, 0, 0, 36000, 60, 5, host) != OK)
    {
        TtyBlinkError("SequinOpen failed");
        return(0);
    }
  return(1);
}

XOpenInFile(fileName, userName, password)	/* for lib files */
  char *fileName, *userName, *password;
{
    if (Lopen(&conn,fileName,userName,password,"","",LOPENREAD) != OK)
      {
        TtyBlinkError("Lopen failed");
        return(0);
      }
    if (LopenAns(&conn,&libHandle,&libLength,&err) != OK)
      {
        TtyBlinkError("LopenAns failed");
        return(0);
      }
    instrpos = OutBufLength;
    inaddr = 0;
    return(1);
}


XOpenFile(fileName, userName, password, filetype) /* for output */
  char *fileName, *userName, *password;
  short filetype; /* MAINFILE, BACKUPFILE or SCRATCHFILE */
{
  ushort *fileHandlePtr;
  ulong *fileLengthPtr;
    if (Lopen(&conn,fileName,userName,password,
    	"","",LOPENWRITE+LOPENREAD) != OK)
      {
        TtyBlinkError("Lopen failed");
        return(0);
      }

    switch (filetype)
	{
	case MAINFILE:
	    fileHandlePtr = &mainHandle;
	    fileLengthPtr = &mainLength;
	    break;
	case BACKUPFILE:
	    fileHandlePtr = &backupHandle;
	    fileLengthPtr = &backupLength;
	    break;
	case SCRATCHFILE:
	    fileHandlePtr = &scratchHandle;
	    fileLengthPtr = &scratchLength;
	    break;
	}

    if (LopenAns(&conn, fileHandlePtr, fileLengthPtr, &err) != OK)
      {
        if (err == FileNotFound)
    	  {
    	    if (Lreset(&conn,userName,password) != OK)
    	      {
    	        TtyBlinkError("Lreset failed");
    	        return(0);
    	      }
    	    if (LresetAns(&conn, &err) != OK)
    	      {
    	        TtyBlinkError("LresetAns failed");
    	        return(0);
    	      }
    	    if (Lopen(&conn,fileName,userName,password,"","",
    			LOPENWRITE+LOPENREAD+LOPENCREATE) != OK)
    	      {
/*    	        printf("Lopen failed"); */
    	        return(0);
    	      }
    	    if (LopenAns(&conn, fileHandlePtr, fileLengthPtr, &err) != OK)
    	      {
    	        TtyBlinkError("LopenAns 2 failed");
    	        return(0);
    	      }
    	    else
		if (filetype != SCRATCHFILE)
	    	      TtyMessage("(new file)");
    	  }
        else
    	  {
    	    TtyBlinkError("LopenAns 1 failed");
    	    return(0);
    	  }
        }
    outaddr = 0;
    inaddr = 0;
    if (filetype == BACKUPFILE)
	BackupOpen = TRUE;
    return(1);
}

XCloseConnection()
{
    if (SequinClose(&conn) != OK)
      {
        TtyBlinkError("SequinClose failed");
        return(0);
      }
    return(1);
}

XCloseFile(filetype)
  short filetype;
{
  ushort *fileHandlePtr;

    switch (filetype)
	{
	case LIBFILE:
	    fileHandlePtr = &libHandle;
	    break;
	case MAINFILE:
	    fileHandlePtr = &mainHandle;
	    break;
	case BACKUPFILE:
	    fileHandlePtr = &backupHandle;
	    break;
	case SCRATCHFILE:
	    fileHandlePtr = &scratchHandle;
	    break;
	}

    if (Lclose(&conn, *fileHandlePtr) != OK)
      {
/*        printf("\nLclose failed\n"); */
        return(0);
      }
    if (LcloseAns(&conn, fileHandlePtr, &err) != OK)
      {
/*        printf("\nLcloseAns failed\n"); */
        return(0);
      }
    return(1);
}
    
XWriteString(data, filetype)
short filetype;
char *data;
{
  char *ch;
  int len;
  ushort *fileHandlePtr;

    switch (filetype)
	{
	case MAINFILE:
	    fileHandlePtr = &mainHandle;
	    break;
	case BACKUPFILE:
	    fileHandlePtr = &backupHandle;
	    break;
	case SCRATCHFILE:
	    fileHandlePtr = &scratchHandle;
	    break;
	}

    len = 0;
    ch = data;
    while (*(ch++))
        len++;
    if (Lwrite(&conn,outaddr,len, *fileHandlePtr, data) != OK)
        {
/*        printf("\nLwrite failed\n"); */
        return(0);
        }

    if (LwriteAns(&conn,&outaddr,&len,fileHandlePtr, &err) != OK)
        {
/*        printf("\nLwriteAns failed\n"); */
        return(0);
        }
    outaddr += len;
    return(1);
}

/* The OutputString routine will do buffering so that one or
 * two characters sent will not cause a packet to be sent.  If the
 * input is NIL, the text so far is flushed.
 */

OutputString(str, filetype)
  short filetype;
  char *str;
{
    static char outstr[OutBufLength];
    static short outstrpos = 0;
    
/*    if (str != NIL)
	printf("%s", str);	DEBUG */

    if (str == NIL)
      {
        outstr[outstrpos] = 0;
        XWriteString(outstr, filetype);
        outstrpos = 0;
        return;
      }
    while (*str)
      {
        if (outstrpos == (OutBufLength - 1))
          {
    	outstr[OutBufLength - 1] = 0;
    	XWriteString(outstr, filetype);
    	outstrpos = 0;
          }
        outstr[outstrpos++] = *(str++);
  }
}

char LeafGetchar()
{
  int getLength, length;
  ushort *fileHandlePtr;

    switch (OpenInputFile)
	{
	case MAINFILE:
	    fileHandlePtr = &mainHandle;
	    length = mainLength;
	    break;
	case LIBFILE:
	    length = libLength;
	    fileHandlePtr = &libHandle;
	    break;
	case SCRATCHFILE:
	    fileHandlePtr = &scratchHandle;
	    length = scratchLength;
	    break;
	}
    
    if (inaddr == length)
        return (-1);
    
    if (instrpos < OutBufLength)
        {
	inaddr++;
	return(instr[instrpos++]);
	}

/* looks like we have to bite the bullet if we get here */

if (length-inaddr>= OutBufLength)
    getLength = OutBufLength;
else
    getLength = length-inaddr;

if (Lread(&conn, inaddr, getLength, *fileHandlePtr) != OK)
    {
/*    printf("\nLread failed"); */
    return(NIL);
    }
if (LreadAns(&conn, &inaddr, &getLength, fileHandlePtr,
	instr, &err) != OK)
    {
/*    printf("\nLreadAns failed: %d", err); */
    return(NIL);
    }

inaddr++;
instrpos = 1;
return(*instr);
}

ResetOutputFile(filetype)
  short filetype;
{
outaddr = 0;
instrpos = OutBufLength;
inaddr = 0;
}

GetFileLength(filetype)
{
  switch (filetype)
      {
      case MAINFILE:	return(mainLength);
      case BACKUPFILE:	return(backupLength);
      case SCRATCHFILE: return(scratchLength);
      case LIBFILE:	return(libLength);
      }
}
