/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: error.c */

/* This file is just a procedure which prints out the appropriately */
/* numbered error message (on stderr) */

#include "aledefs.h"
char *error[] = {
"bad call to ErrorPrint"				/*  0 */,
"lex: unexpected end-of-file"	  			/*  1 */,
"lex: unexpected end-of-file inside comment"		/*  2 */,
"lex: end-of-file inside string"			/*  3 */,
"lex: string too long"					/*  4 */,
"lex: illegal char after '.' -- ignored"		/*  5 */,
"bug UnLex: illegal UnLex"				/*  6 */,
"parseexp: illegal expression"				/*  7 */,
"bug op_prec: illegal op code"				/*  8 */,
"ParseIdent: error in parsing a name"			/*  9 */,
"ParseIdent: lookup error"				/* 10 */,
"ParseIdent: type not signal"				/* 11 */,
"ParseIdent: only local symbol allowed"			/* 12 */,
"ParseIdent: type not 0-dim instance"			/* 13 */,
"ParseIdent: non-local 0-dim lookup failure"		/* 14 */,
"ParseIdent: expected .x, .y, or ident"			/* 15 */,
"ParseIdent: type not 1-dim instance"			/* 16 */,
"ParseIdent: expected period"				/* 17 */,
"ParseIdent: non-local 1-dim lookup failure"		/* 18 */,
"ParseIdent: type not 2-dim instance"			/* 19 */,
"ParseIdent: non-local 2-dim lookup failure"		/* 20 */,
"ParseIdent: expected ] or comma"			/* 21 */,
"ParseIdent: type not signal vector"			/* 22 */,
"ParseIdent: expected > or period"			/* 23 */,
"ParseIdent: expected .x or .y"				/* 24 */,
"ParseIdent: not xvar, yvar, constant, or scalar"	/* 25 */,
"ParseIdent: identifier expected"			/* 26 */,
"GetSEntry: out of symbol_table space"			/* 27 */,
"bug GeneralConsRemove: cons not found"			/* 28 */,
"RemoveReferencePoint: can't -- dependent structure"	/* 29 */,
"RemoveReferencePoint: can't -- origin ref point"	/* 30 */,
"bug RemoveReferencePoint: reference tree screwed up"	/* 31 */,
"bug evalexp: bad parse -- impossible postfix form"	/* 32 */,
"evalexp: uninitialized signal"				/* 33 */,
"GetConnPoint: out of connection points"		/* 34 */,
"evalexp: signal index out of bounds"			/* 35 */,
"evalexp: instance index out of range"			/* 36 */,
"XInsCellDef: name already in use -- aborted"		/* 37 */,
"XOpenCellDef: cell def not found -- aborted"		/* 38 */,
"XInsRectangle: no cell open for editing"		/* 39 */,
"XRemRectangle: not a rectangle"			/* 40 */,
"XRemRectangle: containing cell not open"		/* 41 */,
"GetSunInstanceNumber: no more free numbers"		/* 42 */,
"prefix_ify: evaluation stack overflow"			/* 43 */,
"XSelectRefPt: no cell open for editing"		/* 44 */,
"XInsRefPt: no cell open for editing"			/* 45 */,
"XInsRefPt: name already in use"			/* 46 */,
"XSelectRefPt: ref point not found"			/* 47 */,
"XDelRefPt: ref point not found"			/* 48 */,
"bug FreeSymbolTableEntry: entry not found"		/* 49 */,
"XInsCellInstance: no cell open for editing"		/* 50 */,
"XInsCellInstance: name already in use"			/* 51 */,
"XInsCellInstance: cell definition not found"		/* 52 */,
"XCellExpand: cell definition not found"		/* 53 */,
"XDelCellInstance: instance not found"			/* 54 */,
""								/* 55 */,
"ReadLayer: not a valid layer"				/* 56 */,
"parse_parameter_declarations: unknown param type"	/* 57 */,
"XAddExportVar: no cell open for editing"		/* 58 */,
"XAddExportVar: name already in use"			/* 59 */,
"ParseIdent_list: multiply-defined ident"		/* 60 */,
"ParseIdent_list: illegal ident list"			/* 61 */,
"parse_symbol_tail: illegal command"			/* 62 */,
"parse_exportList: illegal export list"			/* 63 */,
"parse_point: ',' or ')' expected"			/* 64 */,
"XAddLocalVar: name already in use"			/* 65 */,
"parse_exportList: export not declared"			/* 66 */,
"ParseIdent: variable not exported"			/* 67 */,
"bug generalInstRemove: inst not found"			/* 68 */,
""								/* 69 */,
""								/* 70 */,
"parse_place: expected butt, cut, box, or ident"	/* 71 */,
"parse_cut: expected poly, diff, or ')'"		/* 72 */,
""								/* 73 */,
"parse_transformation: rotation must be multiple of 3"	/* 74 */,
"parse_transformation: illegal mirroring -- lr assumed"	/* 75 */,
"parse_variable: boolean and layer not implemented"	/* 76 */,
"parse_variable: illegal use of symbol"			/* 77 */,
"parse_variable: illegal_label -- already in use"	/* 78 */,
"parse_variable: expected ']' or ','"			/* 79 */,
"parse_variable: expected ']'"				/* 80 */,
"parse_variable: expected symbol-name"			/* 81 */,
"parse_variable: expected '.' or '::'"			/* 82 */,
"parse_variable: illegal variable format'"		/* 83 */,
"parse_variable: expected '>' or ':'"			/* 84 */,
""								/* 85 */,
""								/* 86 */,
"parse_symbol_defs: expected 'symbol' or 'begin'"	/* 87 */,
"parse_symbol_defs: expected name for symbol"		/* 88 */,
"parse_actual_param_list: expected '(' or ';'"		/* 89 */,
"parse_actual_param_list: parameter not found"		/* 90 */,
"parse_parameter_declarations: expected ';' or '('"	/* 91 */,
"parse_place: not a symbol name"			/* 92 */,
"parse_actual_param_list: bad assignment"		/* 93 */,
"EnterHash: out of string space" 			/* 94 */,
""								/* 95 */
};

	/************************************************/
	/*		ErrorPrint:			*/
	/************************************************/

ErrorPrint(errnum)
int errnum;
{
    TtyBlinkError(error[errnum]);
/* More("Call to ErrorPrint !!!!!!!!!"); -- TRD */
/*    if (CurrentLine != -1 && (LexSource == NIL))
	printf("line %5d, column %4d\n",CurrentLine,CurrentColumn);
    if (LexSource != NIL)
	printf( "column %4d\n", CurrentColumn); */
    /* may want to add a buffer containing the current line */
    if (++ErrorCount > MAX_ERRORS)
      {
	printf("\ntoo many errors -- I give up\n");
	SignalCatcher();
      }
}
