/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: dymanicmenu.c */

#include <Vgts.h>

#define MaxForPopUp 8 /* max (-1) strings in a popup menu */

char MostRecentlyTouched[MaxForPopUp + 1][20] =
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/* TouchString: is a routine which takes as input a string pointer, and
 * modifies the array MostRecentlyTouched (may change this later to make
 * the whole thing more useful), and treats it as a sort of priority
 * queue.  The string which is touched is either inserted into slot zero,
 * or is moved up to slot zero.
 */

TouchString(string)
char *string;
{
short i, j, foundSlot;
char saveString[20];

for (i = 0; (saveString[i] = *string++) != 0; i++)
	;	/* in case string was in the menu */
string = &(saveString[0]);

foundSlot = MaxForPopUp - 1;
for (i = 0; i < MaxForPopUp; i ++)
    {
/*    printf("compare %s <-> %s\n", string,
				&(MostRecentlyTouched[i][0])); */
    if (strcmp(string, &(MostRecentlyTouched[i][0])))
	foundSlot = i;
    }
/* DEBUG  printf("foundSlot = %d\n", foundSlot); */
for (i = foundSlot; i > 0; i--)
    for (j = 0; (MostRecentlyTouched[i][j] =
		MostRecentlyTouched[i-1][j]) != 0; j++)
			;

for (j = 0; (MostRecentlyTouched[0][j] = *string++) != 0; j++)
	;
}

/* UnTouchString: removes the input string from the menu (if it was
 * there already).
 */

UnTouchString(string)
char *string;
{
short i, j, foundSlot;
char saveString[20];

for (i = 0; (saveString[i] = *string++) != 0; i++)
	;	/* in case string was in the menu */
string = &(saveString[0]);

foundSlot = MaxForPopUp - 1;
for (i = 0; i < MaxForPopUp; i ++)
    {
    if (strcmp(string, &(MostRecentlyTouched[i][0])))
	foundSlot = i;
    }

for (i = foundSlot; i < MaxForPopUp; i++)
    for (j = 0; (MostRecentlyTouched[i][j] =
		MostRecentlyTouched[i+1][j]) != 0; j++)
			;

/*for (j = 0; j < 20; j++)
    MostRecentlyTouched[MaxForPopUp-1][j] = 0;*/
}

static PopUpEntry RecentPopUp[] =
    {
    0, 0,
    0, 1,
    0, 2,
    0, 3,
    0, 4,
    0, 5,
    0, 6,
    0, 7,
    0, 8,
    0, 9,
    0, 0
    };

/* PutUpRecentMenu: uses the array managed by the routine above to
 * return a pointer to the string selected by the user.
 */

char *PutUpRecentMenu()
{
    short i, menuCount, popup();
    char *TtyGetPromptedString();

    menuCount = 0;
    while (MostRecentlyTouched[menuCount][0] != 0)
        menuCount++;
    /* DEBUG  printf("menuCount = %d\n", menuCount); */
    for (i = 0; i < menuCount; i++)
        RecentPopUp[i].string = &(MostRecentlyTouched[i][0]);
    RecentPopUp[menuCount].string = "Typein Symbol";
    RecentPopUp[menuCount + 1].string = 0;

    i = popup(RecentPopUp);
    if (i == -1)
	return(NIL);
    if (i < menuCount)
        return(&(MostRecentlyTouched[i][0]));
    return(TtyGetPromptedString("Symbol Name:", TRUE));
}
