/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE datamung1.c */

#include "aledefs.h"

	/************************************************/
	/*		GeneralConsRemove:		*/
	/************************************************/

/* The following routine takes a pointer to the cons-ptr in
 * a random record definition of any type, and a pointer to
 * a given instance which is guaranteed to be on the cons-
 * list somewhere, and removes it.  The items consed together
 * may be of any type.
 */

GeneralConsRemove(startPtr, instPtr)
    CONS_PTR startPtr;  /* not necessarily this type! */
    CELL_INSTANCE_PTR instPtr;
{
CONS_PTR instCons, saveCons;
if (NIL == (instCons = startPtr->next))
    {
    ErrorPrint(28);
    return;
    }
if ((CELL_INSTANCE_PTR)(instCons->value) == instPtr) /* first in list */
    {
    startPtr->next = instCons->next;
    FreeCons(instCons);
    }
else
    while (instCons != NIL)
	{
	if ((CELL_INSTANCE_PTR)(instCons->next->value) == instPtr)
	    {
	    saveCons = instCons->next->next;
	    FreeCons(instCons->next);
	    instCons->next = saveCons;
	    instCons = NIL;
	    }
	else if (NIL == (instCons = instCons->next))
	    {
	    ErrorPrint(28);
	    return;
	    }
	}
}

	/************************************************/
	/*		generalInstRemove:		*/
	/************************************************/

/* This routine does something similar to what the routine above
 * does, except that it removes an object which is chained through
 * "next" (first thing in record), and not by a cons-list.
 */

generalInstRemove(startPtr, instPtr)
    CELL_INSTANCE_PTR startPtr, instPtr;
{
CELL_INSTANCE_PTR saveInst;

if (startPtr->next == NIL)
    {
    ErrorPrint(68);
    return;
    }

if ((saveInst = startPtr->next) == instPtr)
    startPtr->next = instPtr->next;
else
    {
    while (saveInst != NIL)
	{
	if (saveInst->next == NIL)
	    {
	    ErrorPrint(68);
	    return;
	    }
	if (saveInst->next == instPtr)
	    {
	    saveInst->next = saveInst->next->next;
	    saveInst = NIL;
	    }
	else
	    saveInst = saveInst->next;
	}
    }
}

	/************************************************/
	/*		GeneralPointerFind:		*/
	/************************************************/

/* This routine takes a pointer to an object, and a pointer to the
 * first element of a cons_list, and returns a pointer to the
 * cons cell which points to the object, if any.  If the object is
 * not found, NIL (=0) is returned.  The parameters in the routine
 * are for finding a cell instance, but they are general enough for
 * any type of cons-cell linked chain.
 */

INSTANCE_CONS_PTR GeneralPointerFind(consPtr, instPtr)
    INSTANCE_CONS_PTR consPtr;
    CELL_INSTANCE_PTR instPtr;
{
while (consPtr != NIL)
    {
    if (consPtr->value == instPtr)
	return(consPtr);
    consPtr = consPtr->next;
    }
return(NIL);
}

/* AddExportVariable CONSes a new variable onto the cell definition's
 * list.  No check is done to see if it is a duplicate.
 */

	/************************************************/
	/*		AddExportVariable:		*/
	/************************************************/

/* +++ signal vectors cannot yet be exported. */

AddExportVariable(cellDefPtr, symTablePtr, addToList)
CELL_DEFINITION_PTR cellDefPtr;
S_ENTRY_PTR symTablePtr;
BOOLEAN addToList;	/* xmin, ... are not added.  All others are. */
{
VARIABLE_CONS_PTR vCons;
CONS_PTR GetCons();

if (cellDefPtr->exportEnd != cellDefPtr->frameEnd)
    {
    /* We need to re-parse the rest of the cell */
    vCons = cellDefPtr->localList;
    while (vCons != NIL)
	{
	vCons->value->frameDisplacement += 1;
	vCons = vCons->next;
	}
    vCons = cellDefPtr->parameterList;
    while (vCons != NIL)
	{
	vCons->value->frameDisplacement += 1;
	vCons = vCons->next;
	}
    reparse(cellDefPtr, FALSE);
    }
symTablePtr->data.isExport = TRUE;
symTablePtr->frameDisplacement = (cellDefPtr->exportEnd)++;
(cellDefPtr->param_end)++;
(cellDefPtr->frameEnd)++;
if (addToList)
    {
    vCons = (VARIABLE_CONS_PTR) GetCons();
    if (vCons == NIL)
	return;	/* out of free storage */
    vCons->next = cellDefPtr->exportList;
    vCons->value = symTablePtr;
    cellDefPtr->exportList = vCons;
    }
}

	/************************************************/
	/*		AddDefaultDisplacement:		*/
	/************************************************/

/* disp is the displacement (given in 2*world coords), and e_cons is
 * the expression cons pointer into which the new expression is to be
 * stuffed.  If e_cons is NIL, a new cons-ptr is created and appended
 * to the tail of the default list.
 */

AddDefaultDisplacement(cellDefPtr, sEntry, refRefPt, disp, eCons)
EXPRESSION_CONS_PTR eCons;
CELL_DEFINITION_PTR cellDefPtr;
S_ENTRY_PTR sEntry;
REFERENCE_POINT_ER refRefPt;
short disp;
{
char work[50], *saveLex, *numb = "        ";
EXPRESSION_CONS_PTR tailPtr;
EXPRESSION parseexp();
TOKEN_TYPE lex();

if (disp == -1)
    numb = "-0.5";
else if (disp & 1)
    sprintf(numb, "%d.5", disp/2);
else
    sprintf(numb, "%d", disp/2);

if (refRefPt == cellDefPtr->xOriginRef ||
			refRefPt == cellDefPtr->yOriginRef)
    sprintf(work, "%s:=%s;", sEntry->stringPtr, numb);
else
    sprintf(work, "%s:=%s%c%s;", sEntry->stringPtr,
	    refRefPt->symTblPtr->stringPtr, (disp >= 0)? '+':' ',
	    numb);

saveLex = LexSource;
LexSource = work;
if (eCons == NIL)	/* gotta add a new one to the end */
    {
    eCons = (EXPRESSION_CONS_PTR) GetCons();
    if (eCons == NIL)
	return;	/* out of free storage */
    eCons->value = parseexp(cellDefPtr->sunInstanceNumber);

    eCons->next = NIL;

    if (cellDefPtr->defaultList == NIL)
	cellDefPtr->defaultList = eCons;
    else
	{
	tailPtr = cellDefPtr->defaultList;
	while (tailPtr->next != NIL)
	    tailPtr = tailPtr->next;
	tailPtr->next = eCons;
	}
    }
else
    eCons->value = parseexp(cellDefPtr->sunInstanceNumber);

lex();
LexSource = saveLex;
}

	/************************************************/
	/*		AddParameter:			*/
	/************************************************/

/* +++ right now, only simple (non-signal vector parameters) can be added */

AddParameter(cellDefPtr, symTablePtr)
CELL_DEFINITION_PTR cellDefPtr;
S_ENTRY_PTR symTablePtr;
{
VARIABLE_CONS_PTR vCons, tailCons;
CONS_PTR GetCons();

if (cellDefPtr->param_end != cellDefPtr->frameEnd)
    {
    /* We need to re-parse the rest of the cell */
    vCons = cellDefPtr->localList;
    while (vCons != NIL)
	{
	vCons->value->frameDisplacement += 1;
	vCons = vCons->next;
	}
    reparse(cellDefPtr, TRUE);
    }
symTablePtr->frameDisplacement = (cellDefPtr->param_end)++;
(cellDefPtr->frameEnd)++;
vCons = (VARIABLE_CONS_PTR) GetCons();
if (vCons == NIL)
    return;	/* out of free storage */
vCons->next = NIL;           cellDefPtr->parameterList;
vCons->value = symTablePtr;
if (cellDefPtr->parameterList == NIL)
    cellDefPtr->parameterList = vCons;
else					/* gotta find the tail */
    {
    tailCons = cellDefPtr->parameterList;
    while (tailCons->next != NIL)
	tailCons = tailCons->next;
    tailCons->next = vCons;
    }
}

