/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/


/*
 * File: dale.c
 *
 * Vax/Unix spceific routines for the Distributed Attempt
 * at a Layout Editor (DALE).
 *
 * Bill Nowicki, September 1982
 *
 * Also now runs under the Vgts Exec - March 1983 WIN
 */


#define TRUE 1
#define FALSE 0
#define NIL 0

# include "aledefs.h"
# ifdef VAX
# include <signal.h>
# include <stdio.h>
# else VAX
# include <Vio.h>
# define FILE File
# endif VAX

short OpenInputFile = MAINFILE;
extern BOOLEAN BackupOpen;

short AltSDF;

static FILE  *mainHandle,	/* main silt i/o file */
	     *libHandle,	/* handle for library input */
	     *backupHandle,	/* file for backups */
	     *scratchHandle;	/* YALE scratch file */

static char SaveName[256] = "";

XOpenConnection(host)
char *host;
{
  return(1);
}

XOpenInFile(fileName, userName, password)	/* for lib files */
  char *fileName, *userName, *password;
{
    strcpy(SaveName,fileName);
    if (fopen(fileName,"r")==NULL)
      {
        TtyBlinkError("fopen failed");
        return(0);
      }
    return(1);
}


XOpenFile(fileName, userName, password, filetype) /* for output */
  char *fileName, *userName, *password;
  short filetype; /* MAINFILE, BACKUPFILE or SCRATCHFILE */
{
  FILE *fileHandle;

    strcpy(SaveName,fileName);
    if ( (fileHandle=fopen(fileName,"r") ) == NULL)    
      {
        TtyBlinkError("fopen failed");
        return(0);
      }

    switch (filetype)
	{
	case MAINFILE:
	    mainHandle = fileHandle;
	    break;

	case BACKUPFILE:
	    backupHandle = fileHandle;
	    break;

	case SCRATCHFILE:
	    scratchHandle = fileHandle;
	    break;
	}
    if (filetype == BACKUPFILE)
	BackupOpen = TRUE;
    return(1);
}

XCloseConnection()
{
    return(1);
}

XCloseFile(filetype)
  short filetype;
{
  FILE *fileHandle;

    switch (filetype)
	{
	case LIBFILE:
	    fileHandle = libHandle;
	    break;
	case MAINFILE:
	    fileHandle = mainHandle;
	    break;
	case BACKUPFILE:
	    fileHandle = backupHandle;
	    break;
	case SCRATCHFILE:
	    fileHandle = scratchHandle;
	    break;
	}

    if (fileHandle) fclose(fileHandle);
    return(1);
}
    
XWriteString(data, filetype)
short filetype;
char *data;
{
  FILE *fileHandle;

    if (data==NULL) return;
    switch (filetype)
	{
	case MAINFILE:
	    fileHandle = mainHandle;
	    break;
	case BACKUPFILE:
	    fileHandle = backupHandle;
	    break;
	case SCRATCHFILE:
	    fileHandle = scratchHandle;
	    break;
	}
    fprintf(fileHandle,data);
    return(1);
}

/* The OutputString routine will do buffering so that one or
 * two characters sent will not cause a packet to be sent.  If the
 * input is NIL, the text so far is flushed.
 */

OutputString(str, filetype)
  short filetype;
  char *str;
    {
	if (str) XWriteString(str, filetype);
    }

char LeafGetchar()
{
  FILE *fileHandle;

  switch (OpenInputFile)
    {
	case MAINFILE:
	    fileHandle = mainHandle;
	    break;

	case LIBFILE:
	    fileHandle = libHandle;
	    break;

	case SCRATCHFILE:
	    fileHandle = scratchHandle;
	    break;
    }
    
  return(fgetc(fileHandle));
}

ResetOutputFile(filetype)
  short filetype;
{
  FILE *fileHandle;

    fileHandle = fopen(SaveName,"w");
    switch (OpenInputFile)
	{
	case MAINFILE:
	    mainHandle = fileHandle;
	    break;

	case LIBFILE:
	    libHandle = fileHandle;
	    break;

	case SCRATCHFILE:
	    scratchHandle = fileHandle;
	    break;
	}
   
}

GetFileLength() { return(37); }


GetStorageChunk(size)
	/*
	 * All calls to malloc are done through this routine,
	 * so we can experiment with tuning various parameters.
	 */
  { return malloc(size); }

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
# ifdef VAX
     ResetTTY();
     exit();
# else VAX
     DestroyProcess(0);
# endif VAX
  }

manager()
  {
    printf("Not implemented in Vax version!\r\n");
  }

InitTtyVGT()
  {
    AltSDF = CreateSDF();
  }

TtyPutString(s)
 char *s;
   {
     printf(s);
   }

TtyCRLF()
  {
    printf("\r\n");
  }

char *TtyGetPromptedString(s, echo)
 char *s;
  {
    static char buf[256];

    ResetTTY();
    printf(s);
    fflush(stdout);
    gets(buf);
    GetTTY();
    return(buf);
  }


TtyGetNumber(s)
 char *s;
  {
    int num;

    ResetTTY();
    printf("%s ",s);
    scanf( "%d", &num);
    GetTTY();
    return(num);
  }

TtyMessage(s)
  {
    printf(s);
  }

TtyBlinkError(s)
  char *s;
    {
      TtyBlinkHelper(s,2);  
    }

static TtyBlinkHelper(s,i)
  char *s;
  int i;
    {
      while (i-- > 0)
        {
	  printf("\033[0m%s\r", s);
	  fflush(stdout);
	  sleep(1);
	  printf("\033[7m%s\r", s);
	  fflush(stdout);
	  sleep(1);
	}
      printf("\033[0m%s\r\n", s);
    }


main()
  {
    extern main1();

# ifdef VAX
    GetTTY();
    signal(SIGINT, Quit);
    signal(SIGTERM, Quit);
    signal(SIGHUP, Quit);
    main1(0);
# else VAX
    ProcessId pid;
    Message msg;
    extern short Debug;
    
    Debug = 1;
    GetTTY();
    pid = Create(10, main1, 9000);
    if (pid==0)
      printf("Not enough memory to run Yale\n");
    else 
      {
        Ready(pid,1,0);
	ReceiveSpecific(msg,pid);
      }
# endif VAX
  }

