/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/*
 * FILE copycelldef.c 
 *
 * Routines to copy an entire cell definition, including everything
 * within it.
 *
 * For now (and probably forever), this will be solved by means of an
 * incredible crock -- a library file will be opened on the vax, the cell
 * description will be written to it with a phony name, and then it will
 * be read back.  This way, as features are added to siltprint and
 * parsefile, all of them will automatically be incorporated into the copy
 * symbol routines.
 */

#include "aledefs.h"

extern short OpenInputFile;

XCopyCellDef(oldName, newName)
char *oldName, *newName;
{
  S_ENTRY_PTR sEntryOld, LookupSTableEntry();

    if ((!(sEntryOld = LookupSTableEntry (oldName, 0)))
	|| (sEntryOld -> symbolType != SYMBOL_ENTRY))
      {
	TtyBlinkError("No such cell");
	return;
      }
    if (LookupSTableEntry (newName, 0))
      {
	TtyBlinkError("New name in use");
	return;
      }

    /* OK, the new and old cell names are valid -- go ahead */

    CopyCellGuts(sEntryOld, newName);
}

/* CopyCellGuts: assumes that both the new and old cell names are
 * valid, and that the copy should proceed.  It does the copy by writing
 * the old cell out using the new cell name, and then re-reads it.
 */

CopyCellGuts(oldCellPtr, newCellName)
  S_ENTRY_PTR oldCellPtr;
  char *newCellName;
{
  if (!ResetScratchFile())
      return;
  OutputString("file scratch__;\n", SCRATCHFILE);
  CPrintCell(oldCellPtr, SCRATCHFILE, newCellName);
  OutputString("begin\nend.\n", SCRATCHFILE);
  OutputString(NIL, SCRATCHFILE);
  ResetOutputFile(SCRATCHFILE);
  OpenInputFile = SCRATCHFILE;
  LexSource = (char *) -1;
  ParseFile();
  LexSource = NIL;
  return;
}


