/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: /vlsi/davis/yale/alerecs.h */

/* This file contains the definitions of the records which are used
 * to store the actual cell descriptions, instance descriptions,
 * and so on.
 */



typedef struct cons
    {
    struct cons *next;
    struct cons *value;
    } CONS, *CONS_PTR;        /* a general cons to simplify allocation */

typedef struct varCons
    {
    struct varCons *next;
    S_ENTRY_PTR value;
    } VARIABLE_CONS, *VARIABLE_CONS_PTR;

typedef struct expCons
    {
    struct expCons *next;
    EXPRESSION value;
    } EXPRESSION_CONS, *EXPRESSION_CONS_PTR;

typedef struct transMatrix
    {
    short x11,x12,x21, x22;
    EXPRESSION x31, x32;	/* for translations only */
    /* TRANSFORMATION_PTR t_ptr; -- not needed for now */
    } TRANS_MATRIX;

typedef struct cell_inst
    {
    struct cell_inst *next;	/* must be first entry */
    TRANS_MATRIX trans;
    EXPRESSION_CONS_PTR parameterList;
    struct cell_def *instanceOf;
    struct cell_def *containingCell;
    S_ENTRY_PTR symTblPtr;
    struct ref_point *selected_ref;
    EXPRESSION l,r,t,b;  /* for outline */
    short sunInstanceNumber;
    BOOLEAN selected, expand;
    } CELL_INSTANCE, *CELL_INSTANCE_PTR;

typedef struct rect
    {
    struct rect *next;
    struct cell_def *containingCell;
    short sunInstanceNumber, selectedEdgeset;     /* stub, maybe? */
    EXPRESSION l,r,t,b;  /* usually ref-pt + displacement */
    PROCESS_LAYER layer;
    } RECTANGLE, *RECTANGLE_PTR;

typedef struct rect_cons
    {
    struct rect_cons *next;
    RECTANGLE_PTR value;
    } RECTANGLE_CONS, *RECTANGLE_CONS_PTR;

typedef struct inst_cons
    {
    struct inst_cons *next;
    CELL_INSTANCE_PTR value;
    } INSTANCE_CONS, *INSTANCE_CONS_PTR;

typedef struct ref_pt
    {
    struct ref_pt *next,
		  *son;
    S_ENTRY_PTR symTblPtr;
    struct cell_def *containingCell;
    RECTANGLE_CONS_PTR dependentRectangles;
    INSTANCE_CONS_PTR dependentInstances;
    struct conn_cons  *dependentConnPts;
    short sunInstanceNumber;
    BOOLEAN isXvar;
    } REFERENCE_POINT, *REFERENCE_POINT_ER;

typedef struct conn_point
    {
    short next;
    short x,y;
    PROCESS_LAYER layer;
    } CONNECTION_POINT, *CONNECTION_POINT_ER;

typedef struct cellDefCons
    {
    struct cellDefCons *next;
    struct cell_def *value;
    } CELL_DEFINITION_CONS, *CELL_DEFINITION_CONS_PTR;

typedef struct cell_def
    {
    struct cell_def *next;
    S_ENTRY_PTR symTblPtr;
    REFERENCE_POINT_ER xOriginRef, yOriginRef;
    VARIABLE_CONS_PTR	localList,
			parameterList,
			exportList;
    EXPRESSION_CONS_PTR	constraint_list,
			defaultList,
			assignment_list;
    CELL_INSTANCE_PTR	masterInstance,
			cells;		/* included cell calls */
    INSTANCE_CONS_PTR	instance_list;	/* list of all instances */
    RECTANGLE_PTR rectangles;
    CELL_DEFINITION_CONS_PTR dependentCells;
    REFERENCE_POINT_ER	xSelectedRef,
			ySelectedRef;
    RECTANGLE_CONS_PTR selectedRectangleList;
    INSTANCE_CONS_PTR selectedSubcellList;
    short exportEnd, param_end, frameEnd,
    		sunInstanceNumber;
    short expandedSunIds[8];
    } CELL_DEFINITION, *CELL_DEFINITION_PTR;

typedef unsigned char SUN_INSTANCE_TYPE;

#define SCellDefinition 0
#define SCellInstance 1
#define SRectangle 2
#define SReferencePoint 3
#define SConnPoint 4
#define SFreeInstance 5

typedef struct
	{
	SUN_INSTANCE_TYPE type;
	union
	    {
	    CELL_DEFINITION_PTR def_ptr;   /* for SCellDefinition */
	    CELL_INSTANCE_PTR	instPtr;  /* for SCellInstance */
	    RECTANGLE_PTR	rect_ptr;  /* for SRectangle */
	    REFERENCE_POINT_ER	refPtr;   /* for SReferencePoint */
	    CONNECTION_POINT_ER conn_ptr;  /* for SConnPoint */
	    int			free_slot; /* for SFreeInstance */
	    } ptr;
	} SUN_INSTANCE_RECORD;
