#include <Venviron.h>
#include <Vteams.h>
#include <Vgroupids.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <Vdirectory.h>
#include <Vquerykernel.h>

#define LINE_SIZE 80

HostStatusRecord hoststat;

struct table {
    char entry[LINE_SIZE] ;
    ProcessId pid ;
} *table ;

int lFlag = 0;


main(argc, argv)
    int argc ;
    char **argv ;
  {
    Message msg ;
    UpdateHostStatusRequest * updaterequest = (UpdateHostStatusRequest *) msg;
    int i, count = 0 ;
    char * processor(), *machine() ;
    struct hostStatMsg *hsmtable ;
    int entcmp();
    int teamsize ;
    ProcessId teamserver ;
    SystemCode rc ;

    printf ("%17s     user teamname                teamroot teamsize proc.usage\n", "") ;

    /* Check for flags. */
    if ((argc > 1) && Equal(argv[1], "-l"))
      {
	lFlag = 1;
	argc--;
	argv++;
      }

    if( argc > 1 )	/* we want team info of specific hosts */
      {

        table = (struct table *) calloc (1, sizeof (struct table) ) ;
	if (! table)
	  {
	    fprintf( stderr, "malloc (%d) failed\n", LINE_SIZE ) ;
	    exit(1) ;
          }

        for( i= 1; i<argc; i++ )
	  {
	    if( (! strcmp(argv[i],"0")) || (! strcmp(argv[i],"0x0") ) )
	        teamserver = GetPid( TEAM_SERVER, LOCAL_PID ) ;
	    else if( (argv[i][0]=='0') && (argv[i][1]=='x') )
	        sscanf( argv[i],"0x%x", &teamserver ) ;
	    else 
	        teamserver = MapRemoteHost( argv[i] ) ;
	    if( teamserver == 0 )
	        fprintf( stderr, "%s: unknown host\n", argv[i] ) ;
	    else
	      {
                rc = Gethoststatus( teamserver, &hoststat ) ;
	        if ( rc != OK)
	          {
	            fprintf( stderr, "Message to team server %x returns %s\n", 
		        teamserver, ErrorString(rc) ) ;
	          }
	        else
	          {
                    sprintf (table->entry, 
		       "%-17.17s %8s", hoststat.hostName, 
	               hoststat.userName) ;
 	            printTeamInfo( table->entry, teamserver ) ;
	            printf("\n") ;
	          }
	      }
          }
	exit( 0 ) ;
      }

    if ((hsmtable = (struct hostStatMsg *) malloc (100 * sizeof (struct hostStatMsg))) == 0)
	  fprintf( stderr, "malloc returns 0\n") ;
    resetStatusMsg( &(hsmtable[0]) ); 

    count = getHostDescriptors (100, hsmtable, hsmtable) ;

    if (count)
      {
        table = (struct table *) calloc (count, sizeof (struct table) ) ;
	if (! table)
	  {
	    fprintf( stderr, "malloc (%d) failed\n", LINE_SIZE*count ) ;
	    exit(1) ;
          }
        for (i=0; i < count; i++)
          {
	    rc = Gethoststatus( hsmtable[i].pid, &hoststat);
	    if ( rc != OK)
	      {
	        fprintf( stderr, "Message to team server %x returns %s\n", 
		    teamserver, ErrorString(rc) ) ;
	        continue ;
	      }
            sprintf ((table+i)->entry, "%-17.17s %8s", hoststat.hostName,
	        hoststat.userName) ;
	    (table+i)->pid = hsmtable[i].pid ;
          }
	qsort (table, count, sizeof (struct table), entcmp);
	for (i=0; i<count; i++ )
	  {
 	    printTeamInfo((table+i)->entry, (table+i)->pid) ;
	  }
      } 
    free (table) ;
    free(hsmtable) ;
  }

entcmp(c1, c2)
	char *c1, *c2;
{
	return (strcmp(c1, c2));
}


printTeamInfo(str, tServer)
    char *str;
    ProcessId tServer ;
  {
    Message msg ;
    CreateInstanceRequest *reqMsg = (CreateInstanceRequest *) msg; 
    CreateInstanceReply *repMsg = (CreateInstanceReply *) msg; 
    IoRequest *ioReqMsg = (IoRequest *) msg ;
    IoReply *ioRepMsg = (IoReply *) msg ;
    static TeamDescriptor *tDesc = 0 ;
    static int tDescSize = 0;
    InstanceId fileId ;
    ProcessId fileServer, pid ;
    unsigned blockSize ;
    unsigned short fileType ;
    unsigned lastBlock ;
    unsigned nextBlk ;
    unsigned pusage, tusage ;
    int offset, len, teamsize ;
    char *conv() ;

    reqMsg->requestcode = CREATE_INSTANCE ;
    reqMsg->filenameindex = 0 ;
    reqMsg->type = 0 ;
    reqMsg->filemode = FREAD | FDIRECTORY ;
    reqMsg->filenamelen = 0 ;
    reqMsg->contextid = 0 ;
    
    Send(msg, tServer);
    if (reqMsg->requestcode != OK)
      {	
	fprintf (stderr, "Create instance request to team server %x failed: %s\n",
		tServer, ErrorString(reqMsg->requestcode)) ;
	return ;
      }

    pid = (tServer&0xFFFF0000)|1 ; /* get first team first */
    QueryProcessorUsage ( pid, &pusage, &tusage) ;
    printf("%s", str);
    printf (" %-23s %08x %8s %10d\n",
	        "First Team", pid, conv( (int)GetTeamSize(pid) ), tusage) ;


    /*
     *
     * Request one team directory entry after another and display
     *
     */

    /* first save some info and then set up new requestmsg  */
    fileId = repMsg->fileid ;
    fileServer = repMsg->fileserver ;
    blockSize = repMsg->blocksize ;
    fileType = repMsg->filetype ;
    lastBlock = repMsg->filelastblock ;
    nextBlk = repMsg->filenextblock ;
    if (tDescSize < blockSize)
      {
	if (tDesc) free(tDesc);
        if ((tDesc = (TeamDescriptor *) malloc(blockSize)) == 0)
          {
            fprintf (stderr, "Cannot allocate enough memory (%d)\n", blockSize) ;
	    exit(1) ;
          }
	tDescSize = blockSize;
      }
    ioReqMsg->fileid = fileId ;
    ioReqMsg->bufferptr = (char *) tDesc ;
    ioReqMsg->bytecount = blockSize ;
    for (nextBlk = 0 ; nextBlk <= lastBlock ; nextBlk++)
      {
        ioReqMsg->requestcode = READ_INSTANCE ;
        ioReqMsg->blocknumber = nextBlk ;

	Send (msg, fileServer);
	if (ioRepMsg->replycode != OK)
	  {
	    if (ioRepMsg->replycode != END_OF_FILE) 
	      {
	        fprintf (stderr, "Message to team server %x returns: %s\n",
		    fileServer,
		    ErrorString (ioRepMsg->replycode) ) ;
		return ;
	      }
	  }
	else
	  {
            QueryProcessorUsage (tDesc->rootPid, &pusage, &tusage) ;
	    teamsize = (int) GetTeamSize( tDesc->rootPid ) ;
	    /* go print out  descriptor */
	    if ((len = strlen(tDesc->fileName)) > 23)
	      {
	        *((tDesc->fileName) + len-23+1) = '*' ;
		offset = len-23+1 ;
	      }
	    else
	      offset = 0 ;
	    if (lFlag)
		printf("%s", str);
	    else
                printf ("                          ") ;
            printf (" %-23s %08x %8s %10d\n",
	        tDesc->fileName + offset,
	        tDesc->rootPid,
	        conv( teamsize ),
	        tusage) ;
	  }
	if (ioRepMsg->replycode == END_OF_FILE)
	    return ;
     }
  }  
static char istring[20] ;

char *conv(i)
    int i ;
  {
    static char kilopart[5] ;

    if (i==0)
        return("0") ;

    /* 'Mega'bytes */
    istring[0] = '\0' ;
    if (i >= 0x100000)
        sprintf(istring, "%dM ", i>>20);

    /* 'Kilo'bytes */
    sprintf(kilopart,"%3dK", (i&0xfffff)>>10);

    strcat(istring, kilopart) ;
    return(istring) ;
  }
  

