#include <Venviron.h>
#include <Vteams.h>
#include <Vgroupids.h>
#include <Vdirectory.h>
#include <Vquerykernel.h>

#define LINE_SIZE 80

HostStatusRecord hoststat;

main()
  {
    Message msg ;
    UpdateHostStatusRequest * updaterequest = (UpdateHostStatusRequest *) msg;
    int i, count = 0 ;
    char *processor(), *machine(), *conv() ;
    struct hostStatMsg *hsmtable ;
    int entcmp() ;
    SystemCode rc ;

    if ((hsmtable = (struct hostStatMsg *) malloc (100 * sizeof (struct hostStatMsg))) ==0)
	  printf("malloc returns 0\n") ;

    resetStatusMsg( &(hsmtable[0]) ) ;

    count = getHostDescriptors (100, hsmtable, hsmtable) ;

    if (count)
      {
        char *table, tmpstr[80] ;

        table = (char *) calloc (count, LINE_SIZE) ;
	if (! table)
	  {
	    fprintf(stderr, "malloc (%d) failed\n", LINE_SIZE*count) ;
	    exit(1) ;
          }
       printf ("%10s    LHN teams  procs    memory  idle  avail  %s\n\n",
	    "", "processor machine") ;
        for (i=0; i < count; i++)
          {
	    rc = Gethoststatus( hsmtable[i].pid, &hoststat ) ;
	    if ( rc != OK )
	      {
	        printf("updaterequest to %x failed: %s\n",
			hsmtable[i].pid,
			ErrorString(rc)) ;
	      }
	    else 
	      {
                sprintf (table+LINE_SIZE*i, "%-12.12s %4x  %4d  %5d   %7s ",
                    hoststat.hostName, 
	            (hsmtable[i].pid>>16) & 0xFFFF, 
	            hsmtable[i].freeTeams,
	            hsmtable[i].freeProcs,
	            conv(hsmtable[i].minFreeMem) ) ;
                sprintf (tmpstr, "%4d  %5s %10s %7s",
	            hsmtable[i].minIdleTime,
	            (hsmtable[i].avail == 0) ? "no" : "yes"   ,
	            processor(hsmtable[i].procMachType),
	            machine(hsmtable[i].procMachType)) ;
	        strcat (table + LINE_SIZE * i, tmpstr) ;
	      }
          }
	qsort (table, count, LINE_SIZE, entcmp);
	for (i=0; i<count; i++ )
	  printf("%s\n",table+i*LINE_SIZE) ;
        free (table) ;
       } 
    free(hsmtable) ;
  }

entcmp(c1, c2)
	char *c1, *c2;
{
	return (strcmp(c1, c2));
}


char *
processor (pmtype)
short pmtype ;
  {
    switch ( (pmtype & PROC_TYPE_FIELD) >> PROC_TYPE_SHIFT )
      {
        case PROC_MC68000: return ( "68000" ) ;
        case PROC_MC68008: return ( "68008" ) ;
        case PROC_MC68010: return ( "68010" ) ;
        case PROC_MC68012: return ( "68012" ) ;
        case PROC_MC68020: return ( "68020" ) ;
        case PROC_MC68030: return ( "68030" ) ;
        case PROC_VAX11_725: return ( "Vax725" ) ;
        case PROC_VAX11_730: return ( "Vax730" ) ;
        case PROC_VAX11_750: return ( "Vax750" ) ;
        case PROC_VAX11_780: return ( "Vax780" ) ;
        case PROC_VAX11_782: return ( "Vax782" ) ;
        case PROC_UVAX2: return ( "uVaxII" ) ;
        case PROC_UVAX1: return ( "uVaxI" ) ;
        default: return ( "??????" ) ;
      }
  }

char *
machine (pmtype)
short pmtype ;
  {
    if (strcmp(hoststat.userName, "gert")==0)
      return("NEBULA -1") ;
    
    switch ( (pmtype & MACH_TYPE_FIELD) >> MACH_TYPE_SHIFT ) {
    case MACH_STANFORD_SUN: return ( "STAN" ) ;
    case MACH_CADLINC_SUN:  return ( "CADL" ) ;
    case MACH_SMI_SUN1:     return ( "SUN1" ) ;
    case MACH_SMI_SUN15:    return ( "SUN15" ) ;
    case MACH_SMI_SUN2:     return ( "SUN2" ) ;
    case MACH_SMI_SUN3:	    return ( "SUN3" ) ;
    case MACH_FORWARD_SUN:  return ( "FORW" ) ;
    case MACH_IRIS:         return ( "IRIS" ) ;
    case MACH_VAX:          return ( "VAX" ) ;
    default:                return ( "????" ) ;
    }
  }

static char istring[20] ;

char *conv(i)
    int i ;
  {
    static char kilopart[5] ;

    if (i==0)
        return("0") ;

    /* 'Mega'bytes */
    istring[0] = '\0' ;
    if (i >= 0x100000)
        sprintf(istring, "%dM ", i>>20);

    /* 'Kilo'bytes */
    sprintf(kilopart,"%3dK", (i&0xfffff)>>10);

    strcat(istring, kilopart) ;
    return(istring) ;
  }
